/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.kds.impl.facade;

import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.extcommon.digitalstyle.Format;
import com.kingdee.bos.ctrl.extcommon.variant.SyntaxErrorException;
import com.kingdee.bos.ctrl.extcommon.variant.Variant;
import com.kingdee.bos.ctrl.kds.impl.facade.FilterDialogCallBack;
import com.kingdee.bos.ctrl.kds.model.struct.filter.AlgorithmUtil;
import com.kingdee.bos.ctrl.kds.model.struct.filter.AutoFilterConstants;
import com.kingdee.bos.ctrl.kds.model.struct.filter.CellValueModel;
import com.kingdee.bos.ctrl.kds.model.struct.filter.SheetCustomAutoFilter;
import com.kingdee.bos.ctrl.swing.KDButton;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDDatePicker;
import com.kingdee.bos.ctrl.swing.KDDialog;
import com.kingdee.bos.ctrl.swing.KDLabel;
import com.kingdee.bos.ctrl.swing.KDRadioButton;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JSeparator;

public class CustomFilterConfigDialog
extends KDDialog {
    private KDLabel label1;
    private KDLabel label2;
    private JSeparator separator;
    private KDComboBox condition1;
    private KDComboBox items1;
    private KDDatePicker datePicker1;
    private KDDatePicker datePicker2;
    private ButtonGroup bg;
    private KDRadioButton and;
    private KDRadioButton or;
    private KDComboBox condition2;
    private KDComboBox items2;
    private KDLabel label3;
    private KDButton submit;
    private KDButton cancel;
    private List<Byte> operatorValueList = new ArrayList<Byte>();
    private List<String> operatorTextList = new ArrayList<String>();
    private FilterDialogCallBack callBack;
    private int customType;
    private String labeltitle;

    public CustomFilterConfigDialog(Frame parent, int customType, String labeltitle) {
        super(parent);
        this.customType = customType;
        this.labeltitle = labeltitle;
        this.initData();
        this.initComps();
        this.layoutComps();
    }

    public CustomFilterConfigDialog(Dialog parent, int customType, String labeltitle) {
        super(parent);
        this.customType = customType;
        this.labeltitle = labeltitle;
        this.initData();
        this.initComps();
        this.layoutComps();
    }

    private void initData() {
        this.operatorValueList.clear();
        this.operatorTextList.clear();
        this.operatorValueList.add((byte)-1);
        this.operatorTextList.add("");
        this.operatorValueList.add(AutoFilterConstants.O_EQUAL);
        this.operatorTextList.add("\u7b49\u4e8e");
        this.operatorValueList.add(AutoFilterConstants.O_NOT_EQUAL);
        this.operatorTextList.add("\u4e0d\u7b49\u4e8e");
        this.operatorValueList.add(AutoFilterConstants.O_GREATER_THAN);
        this.operatorTextList.add(this.customType > 2 ? "\u5927\u4e8e" : "\u5728\u4ee5\u4e0b\u65e5\u671f\u4e4b\u540e");
        this.operatorValueList.add(AutoFilterConstants.O_GREATER_THAN_OR_EQUAL);
        this.operatorTextList.add(this.customType > 2 ? "\u5927\u4e8e\u6216\u7b49\u4e8e" : "\u5728\u4ee5\u4e0b\u65e5\u671f\u4e4b\u540e\u6216\u4e0e\u4e4b\u76f8\u540c");
        this.operatorValueList.add(AutoFilterConstants.O_LESS_THAN);
        this.operatorTextList.add(this.customType > 2 ? "\u5c0f\u4e8e" : "\u5728\u4ee5\u4e0b\u65e5\u671f\u4e4b\u524d");
        this.operatorValueList.add(AutoFilterConstants.O_LESS_THAN_OR_EQUAL);
        this.operatorTextList.add(this.customType > 2 ? "\u5c0f\u4e8e\u6216\u7b49\u4e8e" : "\u5728\u4ee5\u4e0b\u65e5\u671f\u4e4b\u524d\u6216\u4e0e\u4e4b\u76f8\u540c");
        this.operatorValueList.add(AutoFilterConstants.O_START_WITH);
        this.operatorTextList.add("\u59cb\u4e8e");
        this.operatorValueList.add(AutoFilterConstants.O_NOT_START_WITH);
        this.operatorTextList.add("\u5e76\u975e\u5f00\u59cb\u4e8e");
        this.operatorValueList.add(AutoFilterConstants.O_END_WITH);
        this.operatorTextList.add("\u6b62\u4e8e");
        this.operatorValueList.add(AutoFilterConstants.O_NOT_END_WITH);
        this.operatorTextList.add("\u5e76\u975e\u7ed3\u675f\u4e8e");
        this.operatorValueList.add(AutoFilterConstants.O_CONTAIN);
        this.operatorTextList.add("\u5305\u542b");
        this.operatorValueList.add(AutoFilterConstants.O_NOT_CONTAIN);
        this.operatorTextList.add("\u4e0d\u5305\u542b");
    }

    private void initComps() {
        this.setTitle("\u81ea\u5b9a\u4e49\u81ea\u52a8\u7b5b\u9009\u65b9\u5f0f");
        this.setModal(true);
        this.setDefaultCloseOperation(2);
        this.label1 = new KDLabel("\u663e\u793a\u884c");
        this.label2 = new KDLabel("\u6807\u9898");
        this.separator = new JSeparator(0);
        this.condition1 = new KDComboBox(this.operatorTextList.toArray());
        this.items1 = new KDComboBox();
        this.items1.setEditable(true);
        this.datePicker1 = new KDDatePicker();
        this.datePicker1.setPreferredSize(new Dimension(20, 20));
        this.datePicker1.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent eventObj) {
                Date value = (Date)CustomFilterConfigDialog.this.datePicker1.getValue();
                String dateString = AlgorithmUtil.sd_yyyy_MM_dd.format(value);
                CustomFilterConfigDialog.this.items1.getEditor().setItem(dateString);
            }
        });
        this.bg = new ButtonGroup();
        this.and = new KDRadioButton("\u4e0e");
        this.or = new KDRadioButton("\u6216");
        this.and.setSelected(true);
        this.bg.add((AbstractButton)this.and);
        this.bg.add((AbstractButton)this.or);
        this.condition2 = new KDComboBox(this.operatorTextList.toArray());
        this.items2 = new KDComboBox();
        this.items2.setEditable(true);
        this.datePicker2 = new KDDatePicker();
        this.datePicker2.setPreferredSize(new Dimension(20, 20));
        this.datePicker2.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent eventObj) {
                Date value = (Date)CustomFilterConfigDialog.this.datePicker2.getValue();
                String dateString = AlgorithmUtil.sd_yyyy_MM_dd.format(value);
                CustomFilterConfigDialog.this.items2.getEditor().setItem(dateString);
            }
        });
        this.label3 = new KDLabel("\u53ef\u7528 ? \u4ee3\u8868\u5355\u4e2a\u5b57\u7b26      \u7528 * \u4ee3\u8868\u4efb\u610f\u591a\u4e2a\u5b57\u7b26");
        this.label2.setText(this.labeltitle);
        switch (this.customType) {
            case 1: 
            case 2: {
                this.datePicker1.setVisible(true);
                this.datePicker2.setVisible(true);
                this.datePicker1.setTimeEnabled(false);
                this.datePicker2.setTimeEnabled(false);
                break;
            }
            default: {
                this.datePicker1.setVisible(false);
                this.datePicker2.setVisible(false);
            }
        }
        this.submit = new KDButton("\u786e\u5b9a");
        this.submit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Object[] params;
                byte link;
                int operator1 = CustomFilterConfigDialog.this.condition1.getSelectedIndex();
                String value1 = String.valueOf(CustomFilterConfigDialog.this.items1.getEditor().getItem());
                int operator2 = CustomFilterConfigDialog.this.condition2.getSelectedIndex();
                String value2 = String.valueOf(CustomFilterConfigDialog.this.items2.getEditor().getItem());
                byte by = link = CustomFilterConfigDialog.this.and.isSelected() ? (byte)1 : 0;
                if (operator1 < 1 && operator2 < 1) {
                    CustomFilterConfigDialog.this.closeDialog();
                    return;
                }
                if (operator1 < 1 && operator2 > 0) {
                    operator1 = operator2;
                    value1 = value2;
                    params = new Object[]{CustomFilterConfigDialog.this.operatorValueList.get(operator1), value1};
                } else {
                    params = operator1 > 0 && operator2 < 1 ? new Object[]{CustomFilterConfigDialog.this.operatorValueList.get(operator1), value1} : new Object[]{CustomFilterConfigDialog.this.operatorValueList.get(operator1), value1, link, CustomFilterConfigDialog.this.operatorValueList.get(operator2), value2};
                }
                if (CustomFilterConfigDialog.this.callBack != null) {
                    CustomFilterConfigDialog.this.callBack.doAfterConfirm(params);
                }
                CustomFilterConfigDialog.this.closeDialog();
            }
        });
        this.cancel = new KDButton("\u53d6\u6d88");
        this.cancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CustomFilterConfigDialog.this.closeDialog();
            }
        });
    }

    public void closeDialog() {
        if (this.callBack != null) {
            this.callBack.doAftercloseDialog();
        }
        this.setVisible(false);
        this.dispose();
    }

    private void layoutComps() {
        Container c = this.getContentPane();
        c.setLayout(null);
        if (this.customType == 1 || this.customType == 2) {
            this.setSize(490, 220);
        } else {
            this.setSize(465, 220);
        }
        this.label1.setBounds(10, 10, 40, 15);
        this.label2.setBounds(10, 35, 50, 15);
        this.separator.setBounds(55, 40, 380, 10);
        this.condition1.setBounds(10, 55, 210, 20);
        this.items1.setBounds(230, 55, 210, 20);
        this.datePicker1.setBounds(445, 55, 20, 20);
        this.and.setBounds(60, 80, 50, 20);
        this.or.setBounds(120, 80, 50, 20);
        this.condition2.setBounds(10, 100, 210, 20);
        this.items2.setBounds(230, 100, 210, 20);
        this.datePicker2.setBounds(445, 100, 20, 20);
        this.label3.setBounds(10, 130, 300, 20);
        this.submit.setBounds(270, 160, 75, 20);
        this.cancel.setBounds(365, 160, 75, 20);
        c.add((Component)this.label1);
        c.add((Component)this.label2);
        c.add(this.separator);
        c.add((Component)this.condition1);
        c.add((Component)this.items1);
        c.add((Component)this.datePicker1);
        c.add((Component)this.and);
        c.add((Component)this.or);
        c.add((Component)this.condition2);
        c.add((Component)this.items2);
        c.add((Component)this.datePicker2);
        c.add((Component)this.label3);
        c.add((Component)this.submit);
        c.add((Component)this.cancel);
    }

    public void setFilterDialogCallBack(FilterDialogCallBack callBack) {
        this.callBack = callBack;
    }

    public void setValue(SheetCustomAutoFilter filter) {
        String valueString;
        Date date;
        Object value;
        Variant variant;
        this.condition1.setSelectedIndex(this.operatorValueList.indexOf(filter.getOperator1()));
        this.condition2.setSelectedIndex(this.operatorValueList.indexOf(filter.getOperator2()));
        if (filter.getLink() == 1) {
            this.and.setSelected(true);
        } else {
            this.or.setSelected(true);
        }
        if (filter.getValue1() != null && !StringUtil.isEmptyString((String)filter.getValue1())) {
            variant = Format.parseData(filter.getValue1(), true);
            if (this.customType == 1 || this.customType == 2) {
                try {
                    variant = new Variant(variant.toDate());
                }
                catch (SyntaxErrorException e) {
                    e.printStackTrace();
                }
            }
            if (variant.isDate()) {
                value = variant.getValue();
                date = null;
                if (value instanceof Date) {
                    date = (Date)value;
                } else if (value instanceof Calendar) {
                    date = Variant.calendarToGMTDate((Calendar)value);
                }
                valueString = filter.getValue1();
                if (this.customType == 2) {
                    valueString = AlgorithmUtil.sd_yyyy_MM_dd_HH_mm_ss.format(date);
                } else if (this.customType == 1) {
                    valueString = AlgorithmUtil.sd_yyyy_MM_dd.format(date);
                }
                this.items1.getEditor().setItem(valueString);
            } else {
                this.items1.getEditor().setItem(filter.getValue1());
            }
        }
        if (filter.getValue2() != null && !StringUtil.isEmptyString((String)filter.getValue2())) {
            variant = Format.parseData(filter.getValue2(), true);
            if (variant.isDate()) {
                value = variant.getValue();
                date = null;
                if (value instanceof Date) {
                    date = (Date)value;
                } else if (value instanceof Calendar) {
                    date = Variant.calendarToGMTDate((Calendar)value);
                }
                valueString = filter.getValue2();
                if (this.customType == 2) {
                    valueString = AlgorithmUtil.sd_yyyy_MM_dd_HH_mm_ss.format(date);
                } else if (this.customType == 1) {
                    valueString = AlgorithmUtil.sd_yyyy_MM_dd.format(date);
                }
                this.items2.getEditor().setItem(valueString);
            } else {
                this.items2.getEditor().setItem(filter.getValue2());
            }
        }
    }

    public void setInitDataItems(Object[] autoFilteDataItem) {
        this.items1.removeAllItems();
        this.items2.removeAllItems();
        this.items1.addItem((Object)"");
        this.items2.addItem((Object)"");
        if (autoFilteDataItem == null) {
            return;
        }
        for (int index = 0; index < autoFilteDataItem.length; ++index) {
            CellValueModel model = (CellValueModel)autoFilteDataItem[index];
            if (model.getValue().isDate()) {
                Object value = model.getValue().getValue();
                Date date = null;
                if (value instanceof Date) {
                    date = (Date)value;
                } else if (value instanceof Calendar) {
                    date = Variant.calendarToGMTDate((Calendar)value);
                }
                String valueString = model.getText();
                if (this.customType == 2) {
                    valueString = AlgorithmUtil.sd_yyyy_MM_dd_HH_mm_ss.format(date);
                } else if (this.customType == 1) {
                    valueString = AlgorithmUtil.sd_yyyy_MM_dd.format(date);
                }
                this.items1.addItem((Object)valueString);
                this.items2.addItem((Object)valueString);
                continue;
            }
            String valueString = model.getText();
            this.items1.addItem((Object)valueString);
            this.items2.addItem((Object)valueString);
        }
    }

    public void setOperator1(byte operator) {
        this.condition1.setSelectedIndex(this.operatorValueList.indexOf(operator));
    }

    public void setOperator2(byte operator) {
        this.condition2.setSelectedIndex(this.operatorValueList.indexOf(operator));
    }

    public void setLink(boolean isAnd) {
        this.and.setSelected(isAnd);
    }

    public void clearValue() {
        this.items1.setSelectedIndex(0);
        this.items2.setSelectedIndex(0);
    }
}

