/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.kds.impl.facade;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;

public class SplitPanel
extends JComponent {
    public static final int VERTICAL_SPLIT = 0;
    public static final int HORIZONTAL_SPLIT = 1;
    protected int orientation;
    protected Component leftComponent;
    protected Component rightComponent;
    protected PlaceholderLayout layout;
    protected Divider divider = new Divider();
    protected int dividerLocation = 0;
    private boolean isShowLinely = false;
    private static final Color spliterColor1 = Color.decode("#c0c0c0");
    private static final Color spliterColor2 = Color.decode("#ffffff");
    private static final Color spliterColor3 = Color.decode("#e4e4e4");
    private static final Color spliterColor4 = Color.decode("#dfdfdf");
    private static final Color spliterColor5 = Color.decode("#dadada");
    private static final Color spliterColor6 = Color.decode("#cdcdcd");
    private static final Color spliterColor7 = Color.decode("#c0c0c0");

    public SplitPanel() {
        this.add(this.divider);
        this.layout = new PlaceholderLayout();
        this.setLayout(this.layout);
    }

    public void setDividerSize(int size) {
        this.layout.setDividerSize(size);
        this.rerangeOffsprings();
    }

    public void setShowLinely(boolean isShowLinely) {
        this.isShowLinely = isShowLinely;
    }

    public Component getLeftComponent() {
        return this.leftComponent;
    }

    public Component getRightComponent() {
        return this.rightComponent;
    }

    public void setLeftComponent(Component leftComponent) {
        if (this.leftComponent != null) {
            this.remove(this.leftComponent);
        }
        this.leftComponent = leftComponent;
        this.add(leftComponent);
        this.rerangeOffsprings();
    }

    public void setRightComponent(Component rightComponent) {
        if (this.rightComponent != null) {
            this.remove(this.rightComponent);
        }
        this.rightComponent = rightComponent;
        this.add(rightComponent);
        this.rerangeOffsprings();
    }

    public double getDividerLocation() {
        return this.dividerLocation;
    }

    public void setDividerLocation(int dividerLocation) {
        this.dividerLocation = dividerLocation;
        this.rerangeOffsprings();
    }

    public int getOrientation() {
        return this.orientation;
    }

    public void setOrientation(int orientation) {
        this.orientation = orientation;
        if (orientation == 0) {
            this.divider.setCursor(Cursor.getPredefinedCursor(11));
        } else {
            this.divider.setCursor(Cursor.getPredefinedCursor(8));
        }
        this.rerangeOffsprings();
    }

    private void rerangeOffsprings() {
        this.revalidate();
        this.repaint();
    }

    private class Divider
    extends JComponent {
        public Divider() {
            this.setCursor(Cursor.getPredefinedCursor(8));
            this.addMouseMotionListener(new DividerResizer());
        }

        @Override
        protected void paintComponent(Graphics g) {
            Color oldcolor = g.getColor();
            int width = this.getWidth();
            int height = this.getHeight();
            if (SplitPanel.this.orientation == 0) {
                g.setColor(spliterColor1);
                g.drawLine(0, 0, 0, height);
                g.setColor(spliterColor2);
                g.drawLine(1, 0, 1, height);
                g.setColor(spliterColor3);
                g.drawLine(2, 0, 2, height);
                g.setColor(spliterColor4);
                g.drawLine(3, 0, 3, height);
                g.setColor(spliterColor5);
                g.drawLine(4, 0, 4, height);
                g.setColor(spliterColor6);
                g.drawLine(5, 0, 5, height);
                g.setColor(spliterColor7);
                g.drawLine(6, 0, 6, height);
            } else {
                g.setColor(spliterColor1);
                g.drawLine(0, 0, width, 0);
                g.setColor(spliterColor2);
                g.drawLine(0, 1, width, 1);
                g.setColor(spliterColor3);
                g.drawLine(0, 2, width, 2);
                g.setColor(spliterColor4);
                g.drawLine(0, 3, width, 3);
                g.setColor(spliterColor5);
                g.drawLine(0, 4, width, 4);
                g.setColor(spliterColor6);
                g.drawLine(0, 5, width, 5);
                g.setColor(spliterColor7);
                g.drawLine(0, 6, width, 6);
            }
            g.setColor(oldcolor);
        }

        private class DividerResizer
        implements MouseMotionListener {
            private DividerResizer() {
            }

            @Override
            public void mouseDragged(MouseEvent e) {
                if (SplitPanel.this.orientation == 0) {
                    int containerW = SplitPanel.this.getWidth();
                    if (containerW <= 0) {
                        return;
                    }
                    Point dragTo = SwingUtilities.convertPoint((Divider)e.getSource(), e.getPoint(), SplitPanel.this);
                    Dimension lMin = SplitPanel.this.getLeftComponent().getMinimumSize();
                    Dimension lMax = SplitPanel.this.getLeftComponent().getMaximumSize();
                    if (dragTo.getX() <= lMin.getWidth() || dragTo.getX() >= lMax.getWidth() || dragTo.getX() >= (double)containerW) {
                        return;
                    }
                    Dimension rMin = SplitPanel.this.getRightComponent().getMinimumSize();
                    Dimension rMax = SplitPanel.this.getRightComponent().getMaximumSize();
                    if (dragTo.getX() <= rMin.getWidth() || dragTo.getX() >= rMax.getWidth()) {
                        return;
                    }
                    if (dragTo.x <= 0 || dragTo.x >= containerW) {
                        return;
                    }
                    SplitPanel.this.dividerLocation = dragTo.x;
                    SplitPanel.this.rerangeOffsprings();
                } else {
                    int containerH = SplitPanel.this.getHeight();
                    if (containerH <= 0) {
                        return;
                    }
                    Point dragTo = SwingUtilities.convertPoint((Divider)e.getSource(), e.getPoint(), SplitPanel.this);
                    if (SplitPanel.this.isShowLinely && (dragTo.getY() - 1.0) % 18.0 != 0.0) {
                        return;
                    }
                    Dimension lMin = SplitPanel.this.getLeftComponent().getMinimumSize();
                    Dimension lMax = SplitPanel.this.getLeftComponent().getMaximumSize();
                    if (dragTo.getY() <= lMin.getHeight() || dragTo.getY() >= lMax.getHeight() || dragTo.getY() >= (double)containerH) {
                        return;
                    }
                    Dimension rMin = SplitPanel.this.getRightComponent().getMinimumSize();
                    Dimension rMax = SplitPanel.this.getRightComponent().getMaximumSize();
                    if (dragTo.getY() <= rMin.getHeight() || dragTo.getY() >= rMax.getHeight()) {
                        return;
                    }
                    if (dragTo.y <= 0 || dragTo.y >= containerH) {
                        return;
                    }
                    SplitPanel.this.dividerLocation = dragTo.y;
                    SplitPanel.this.rerangeOffsprings();
                }
            }

            @Override
            public void mouseMoved(MouseEvent e) {
            }
        }
    }

    private class PlaceholderLayout
    implements LayoutManager {
        private int dividerSize = 7;

        private PlaceholderLayout() {
        }

        @Override
        public void addLayoutComponent(String name, Component comp) {
        }

        public void setDividerSize(int dividerSize) {
            this.dividerSize = dividerSize;
        }

        @Override
        public void layoutContainer(Container parent) {
            if (SplitPanel.this.leftComponent == null || SplitPanel.this.rightComponent == null) {
                return;
            }
            if (SplitPanel.this.orientation == 0) {
                int height = parent.getHeight();
                int x = 0;
                int displacement = SplitPanel.this.dividerLocation;
                SplitPanel.this.leftComponent.setBounds(x, 0, displacement, height);
                SplitPanel.this.divider.setBounds(x += displacement, 0, this.dividerSize, height);
                SplitPanel.this.rightComponent.setBounds(x += this.dividerSize, 0, parent.getWidth() - x, height);
            } else {
                int width = parent.getWidth();
                int y = 0;
                int displacement = SplitPanel.this.dividerLocation;
                SplitPanel.this.leftComponent.setBounds(0, y, width, displacement);
                SplitPanel.this.divider.setBounds(0, y += displacement, width, this.dividerSize);
                SplitPanel.this.rightComponent.setBounds(0, y += this.dividerSize, width, parent.getHeight() - y);
            }
        }

        @Override
        public Dimension minimumLayoutSize(Container parent) {
            return new Dimension(0, 0);
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            return new Dimension(0, 0);
        }

        @Override
        public void removeLayoutComponent(Component comp) {
        }
    }
}

