/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.kds.impl.facade.wizzard;

import com.kingdee.bos.ctrl.ext.util.MessageUtil;
import com.kingdee.bos.ctrl.extcommon.variant.Variant;
import com.kingdee.bos.ctrl.kds.impl.SpreadContext;
import com.kingdee.bos.ctrl.kds.impl.facade.MultiLanguageKeys;
import com.kingdee.bos.ctrl.kds.impl.facade.wizzard.ISpreadWizzard;
import com.kingdee.bos.ctrl.kds.model.struct.Cell;
import com.kingdee.bos.ctrl.kds.model.struct.CellBlock;
import com.kingdee.bos.ctrl.kds.model.struct.Range;
import com.kingdee.bos.ctrl.kds.model.struct.Sheet;
import com.kingdee.bos.ctrl.kds.model.util.SortedCellBlockArray;
import com.kingdee.bos.ctrl.swing.KDButton;
import com.kingdee.bos.ctrl.swing.KDButtonGroup;
import com.kingdee.bos.ctrl.swing.KDCheckBox;
import com.kingdee.bos.ctrl.swing.KDDialog;
import com.kingdee.bos.ctrl.swing.KDLabel;
import com.kingdee.bos.ctrl.swing.KDRadioButton;
import com.kingdee.bos.ctrl.swing.KDTextField;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.AbstractButton;

public final class WizzardLocalize
extends KDDialog
implements ISpreadWizzard {
    private KDButtonGroup _btnGroup;
    private KDRadioButton _formulaBtn;
    private KDRadioButton _valueBtn;
    private KDRadioButton _referBtn;
    private KDLabel _referLabel;
    private KDTextField _referField;
    private KDCheckBox _numItem;
    private KDCheckBox _textItem;
    private KDCheckBox _errorItem;
    private KDButton _okBtn;
    private KDButton _cancelBtn;
    private boolean _isChanged;
    private SpreadContext _context;

    public WizzardLocalize(Frame f, SpreadContext context) {
        super(f, true);
        this._context = context;
        this.initDialog();
        this.initComponents();
        this.initPanel();
    }

    public WizzardLocalize(Dialog d, SpreadContext context) {
        super(d, true);
        this._context = context;
        this.initDialog();
        this.initComponents();
        this.initPanel();
    }

    @Override
    public void commit() {
        if (this.isChanged()) {
            if (this.isRefer()) {
                Range r = this._context.getRangeManager().findRangeInBook(this.getStringRange(), true);
                if (r != null) {
                    r.select();
                }
            } else {
                Range r;
                SortedCellBlockArray sa = new SortedCellBlockArray();
                Sheet sheet = this._context.getBook().getActiveSheet();
                Sheet.ICellsIterator iter = sheet.getCellsIterator(null, false, true);
                while (iter.hasNext()) {
                    Cell cell = iter.next();
                    if (this.isLocaledCell(cell)) continue;
                    boolean isFormula = cell.getFormula().startsWith("=");
                    Variant vt = cell.getValue();
                    if (!(this.isFormula() && isFormula || this.isValue() && !isFormula && this.hasNumber() && vt.isNumber() || this.isValue() && !isFormula && this.hasText() && vt.isString()) && (!this.isValue() || isFormula || !this.hasError() || !vt.isError())) continue;
                    sa.insert(CellBlock.getCellBlock(cell.getRow(), cell.getCol()));
                }
                if (!sa.isEmpty() && (r = this._context.getRangeManager().getRange(sa)) != null) {
                    r.select();
                }
            }
        }
    }

    @Override
    public boolean prepare() {
        this._isChanged = false;
        return true;
    }

    private boolean isChanged() {
        return this._isChanged;
    }

    private boolean isRefer() {
        return this._referBtn.isSelected();
    }

    private boolean isFormula() {
        return this._formulaBtn.isSelected();
    }

    private boolean isValue() {
        return this._valueBtn.isSelected();
    }

    private boolean hasNumber() {
        return this._numItem.isSelected();
    }

    private boolean hasText() {
        return this._textItem.isSelected();
    }

    private boolean hasError() {
        return this._errorItem.isSelected();
    }

    private String getStringRange() {
        return this._referField.getText();
    }

    private boolean isLocaledCell(Cell cell) {
        return cell.getFormula().length() == 0;
    }

    private void initDialog() {
        this.setSize(300, 180);
        this.setTitle(MultiLanguageKeys.getLocalText("KEY_LOCALIZE"));
        this.setResizable(false);
    }

    private void initComponents() {
        ItemChangeHandler il = new ItemChangeHandler();
        ActionHandler al = new ActionHandler();
        this._referBtn = new KDRadioButton(MultiLanguageKeys.getLocalText("KEY_REFCELL"));
        this._formulaBtn = new KDRadioButton(MultiLanguageKeys.getLocalText("KEY_FORMULA"));
        this._valueBtn = new KDRadioButton(MultiLanguageKeys.getLocalText("KEY_VALUE"));
        this._btnGroup = new KDButtonGroup();
        this._btnGroup.add((AbstractButton)this._referBtn);
        this._btnGroup.add((AbstractButton)this._formulaBtn);
        this._btnGroup.add((AbstractButton)this._valueBtn);
        this._referBtn.setSelected(true);
        this._referBtn.addItemListener((ItemListener)il);
        this._formulaBtn.addItemListener((ItemListener)il);
        this._valueBtn.addItemListener((ItemListener)il);
        this._referLabel = new KDLabel(MultiLanguageKeys.getLocalText("KEY_REFPOSITION"));
        this._referField = new KDTextField();
        this._numItem = new KDCheckBox(MultiLanguageKeys.getLocalText("KEY_NUMBER"));
        this._textItem = new KDCheckBox(MultiLanguageKeys.getLocalText("KEY_TEXT"));
        this._errorItem = new KDCheckBox(MultiLanguageKeys.getLocalText("KEY_ERROR"));
        this._numItem.setSelected(true);
        this._textItem.setSelected(true);
        this._errorItem.setSelected(true);
        this._numItem.setVisible(false);
        this._textItem.setVisible(false);
        this._errorItem.setVisible(false);
        this._okBtn = new KDButton(MultiLanguageKeys.getLocalText("KEY_OK"));
        this._cancelBtn = new KDButton(MultiLanguageKeys.getLocalText("KEY_CANCEL"));
        this._okBtn.setLimitedSize(false);
        this._cancelBtn.setLimitedSize(false);
        this._okBtn.addActionListener((ActionListener)al);
        this._cancelBtn.addActionListener((ActionListener)al);
    }

    private void initPanel() {
        Container cp = this.getContentPane();
        cp.setLayout(null);
        cp.add((Component)this._referBtn);
        cp.add((Component)this._referLabel);
        cp.add((Component)this._referField);
        cp.add((Component)this._formulaBtn);
        cp.add((Component)this._valueBtn);
        cp.add((Component)this._okBtn);
        cp.add((Component)this._cancelBtn);
        cp.add((Component)this._numItem);
        cp.add((Component)this._textItem);
        cp.add((Component)this._errorItem);
        this._referBtn.setBounds(5, 5, 90, 30);
        this._formulaBtn.setBounds(140, 5, 70, 30);
        this._valueBtn.setBounds(210, 5, 70, 30);
        this._referLabel.setBounds(5, 40, 290, 20);
        this._referField.setBounds(5, 70, 290, 20);
        this._numItem.setBounds(20, 60, 75, 40);
        this._textItem.setBounds(125, 60, 60, 40);
        this._errorItem.setBounds(215, 60, 60, 40);
        this._okBtn.setBounds(40, 110, 80, 20);
        this._cancelBtn.setBounds(200, 110, 80, 20);
    }

    private class ItemChangeHandler
    implements ItemListener {
        private ItemChangeHandler() {
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            if (e.getSource() == WizzardLocalize.this._referBtn && e.getStateChange() == 1) {
                WizzardLocalize.this._referLabel.setVisible(true);
                WizzardLocalize.this._referField.setVisible(true);
                WizzardLocalize.this._numItem.setVisible(false);
                WizzardLocalize.this._textItem.setVisible(false);
                WizzardLocalize.this._errorItem.setVisible(false);
            } else if ((e.getSource() == WizzardLocalize.this._formulaBtn || e.getSource() == WizzardLocalize.this._valueBtn) && e.getStateChange() == 1) {
                WizzardLocalize.this._referLabel.setVisible(false);
                WizzardLocalize.this._referField.setVisible(false);
                WizzardLocalize.this._numItem.setVisible(true);
                WizzardLocalize.this._textItem.setVisible(true);
                WizzardLocalize.this._errorItem.setVisible(true);
            }
        }
    }

    private class ActionHandler
    implements ActionListener {
        private ActionHandler() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String strRange;
            if (WizzardLocalize.this.isRefer() && e.getSource() == WizzardLocalize.this._okBtn && ((strRange = WizzardLocalize.this.getStringRange()) == null || "".equals(strRange.trim()))) {
                MessageUtil.msgboxWarning(null, "\u65e0\u6548\u7a7a\u503c");
                return;
            }
            WizzardLocalize.this._isChanged = e.getSource() == WizzardLocalize.this._okBtn;
            WizzardLocalize.this.dispose();
        }
    }
}

