/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.kds.impl.state;

import com.kingdee.bos.ctrl.kds.core.SpreadView;
import com.kingdee.bos.ctrl.kds.impl.SpreadContext;
import com.kingdee.bos.ctrl.kds.impl.facade.fairy.FairyButton;
import com.kingdee.bos.ctrl.kds.impl.state.DefaultState;
import com.kingdee.bos.ctrl.kds.impl.state.SpreadStateManager;
import com.kingdee.bos.ctrl.kds.model.struct.CellBlock;
import com.kingdee.bos.ctrl.kds.model.struct.FillType;
import com.kingdee.bos.ctrl.kds.model.struct.Range;
import com.kingdee.bos.ctrl.kds.model.struct.Sheet;
import com.kingdee.bos.ctrl.kds.model.struct.event.BookChangeEvent;
import com.kingdee.bos.ctrl.kds.model.struct.event.SheetChangeEvent;
import java.awt.Component;

public class FilledState
extends DefaultState {
    private SpreadView _dstView;
    private CellBlock _dstBlock;
    private Sheet _dstSheet;
    private Range _srcRange;
    private FillType _resultType;

    FilledState(SpreadContext context, CellBlock dstBlock, Range srcRange, FillType resultType) {
        super(context);
        this.init(dstBlock, srcRange, resultType);
    }

    void init(CellBlock dstBlock, Range srcRange, FillType resultType) {
        this._dstBlock = dstBlock;
        this._srcRange = srcRange;
        this._resultType = resultType;
    }

    public void setDstBlock(CellBlock cb) {
        this._dstBlock = cb;
    }

    @Override
    public int getKey() {
        return SpreadStateManager.Key_Filled;
    }

    @Override
    public boolean start(int preKey) {
        this._context.getSelection().changeSelection(this._dstBlock, 2);
        this._dstView = this._context.getSpread().getActiveView();
        this._context.getFacadeManager().showFilledOption(this._dstView, this._srcRange, this._dstBlock, this._resultType);
        this._dstSheet = this._context.getBook().getActiveSheet();
        return true;
    }

    @Override
    public boolean stop(int forceKey) {
        FairyButton fb = this._context.getFacadeManager().getFilledOptionButton();
        this._dstView.remove((Component)((Object)fb));
        this._dstView.repaint(fb.getBounds());
        return true;
    }

    @Override
    public boolean cancel(int forceKey) {
        return this.stop(forceKey);
    }

    @Override
    public void changed(BookChangeEvent e) {
        if (e.isSheetActive() || e.isSheetInsert()) {
            FairyButton fb = this._context.getFacadeManager().getFilledOptionButton();
            fb.setVisible(this._dstSheet == this._context.getSpread().getBook().getActiveSheet());
        }
    }

    @Override
    public void changed(SheetChangeEvent e) {
        if (e.hasState(SheetChangeEvent.Changed_UndoRedo)) {
            FairyButton fb = this._context.getFacadeManager().getFilledOptionButton();
            fb.setVisible(false);
        }
    }
}

