/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.kds.io.kds.archives.kds10;

import com.kingdee.bos.ctrl.common.CtrlUtil;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.extcommon.variant.SyntaxErrorException;
import com.kingdee.bos.ctrl.extcommon.variant.Variant;
import com.kingdee.bos.ctrl.kdf.util.CloseUtil;
import com.kingdee.bos.ctrl.kdf.util.Tools;
import com.kingdee.bos.ctrl.kds.io.kds.SectionJarInputStream;
import com.kingdee.bos.ctrl.kds.io.kds.SectionJarUtil;
import com.kingdee.bos.ctrl.kds.io.kds.archives.kds10.KDSConstants10;
import com.kingdee.bos.ctrl.kds.util.KDSDataInputStream;
import java.io.Closeable;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.HashSet;

public class KDSAreaReader10
extends KDSConstants10 {
    private int fileVersion;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadValues(String file, HashMap cells) throws Exception {
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(file);
            this.loadValues(fis, cells);
        }
        catch (Throwable throwable) {
            CloseUtil.close((Closeable[])new Closeable[]{fis});
            throw throwable;
        }
        CloseUtil.close((Closeable[])new Closeable[]{fis});
    }

    public void loadValues(InputStream is, HashMap cells) {
        this.loadValuesImpl(new KDSDataInputStream(is), cells);
    }

    private void loadValuesImpl(KDSDataInputStream is, HashMap cells) {
        HashSet outputSheet = this.getOutputSheetNames(cells);
        if (outputSheet.size() <= 0) {
            return;
        }
        try {
            byte[] sections = CtrlUtil.Stream.readInputStream((InputStream)is);
            SectionJarInputStream sis = new SectionJarInputStream(sections);
            this.loadValuesImpl(sis, cells, outputSheet);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void loadValuesImpl(SectionJarInputStream sis, HashMap cells, HashSet outputSheet) {
        this.fileVersion = sis.getFileVersion();
        if (this.isHigherVersion(this.fileVersion)) {
            throw new IllegalArgumentException("Attempt to read kds files with a higher version ID.");
        }
        try {
            String[] sheetNames = this.getSheetNames(new KDSDataInputStream(sis.getSection(0)));
            int size = sis.size();
            if (size < 1) {
                throw new IllegalArgumentException("bytes is illegal");
            }
            for (int i = 1; i < size; ++i) {
                if (!outputSheet.contains(sheetNames[i - 1].toUpperCase())) continue;
                this.readSheet(sheetNames[i - 1], cells, new KDSDataInputStream((InputStream)SectionJarUtil.unzip(sis.getByteSection(i))));
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private HashSet getOutputSheetNames(HashMap cells) {
        HashSet<String> set = new HashSet<String>();
        for (String cell : cells.keySet()) {
            int pos = cell.indexOf(33);
            if (pos <= 0) continue;
            set.add(cell.substring(0, pos).toUpperCase());
        }
        return set;
    }

    private String[] getSheetNames(KDSDataInputStream is) throws IOException {
        is.readString();
        int count = is.readInt();
        is.readInt();
        ArrayList<String> sheetNames = new ArrayList<String>(count);
        for (int i = 0; i < count; ++i) {
            is.readString();
            String sheetName = is.readString();
            sheetNames.add(sheetName);
            is.readByte();
            is.readInt();
        }
        return sheetNames.toArray(new String[0]);
    }

    private void readSheet(String sheetName, HashMap cells, KDSDataInputStream is) throws IOException {
        is.readByte();
        byte id = is.readByte();
        if (id == ID_SH_Style) {
            this.readStyles(is);
        }
        is.readInt();
        is.readInt();
        while ((id = is.readByte()) == ID_SH_Row) {
            this.readRow(sheetName, cells, is);
        }
    }

    private void readRow(String sheetName, HashMap cells, KDSDataInputStream is) throws IOException {
        int rowIndex = is.readInt();
        int maxRowIndex = -1;
        while (true) {
            byte id;
            if ((id = is.readByte()) == ID_Row_UserObject) {
                is.readString();
                is.readString();
                continue;
            }
            if (id != ID_Cell) break;
            maxRowIndex = this.readCell(sheetName, cells, is, rowIndex, maxRowIndex);
        }
    }

    private int readCell(String sheetName, HashMap cells, KDSDataInputStream is, int rowIndex, int maxRowIndex) throws IOException {
        block21: {
            int cIndex = -1;
            while (true) {
                byte id;
                if ((id = is.readByte()) == ID_Cell_Index) {
                    maxRowIndex = cIndex = is.readInt();
                    continue;
                }
                if (id == ID_Cell_StyleID) {
                    is.readInt();
                    continue;
                }
                if (id == ID_Cell_Formula) {
                    is.readString();
                    continue;
                }
                if (id == ID_Cell_Value) {
                    String position;
                    Variant var;
                    String valueString;
                    byte type = is.readByte();
                    if (1 == type) {
                        valueString = is.readString();
                        var = new Variant(valueString, 11);
                    } else if (4 == type) {
                        valueString = is.readString();
                        var = new Variant(new BigDecimal(valueString), 10);
                    } else if (8 == type) {
                        if (this.fileVersion < 10101) {
                            valueString = is.readString();
                            var = new Variant(new BigDecimal(valueString), 10);
                            try {
                                var.setObject(var.toCalendar(), 13);
                            }
                            catch (SyntaxErrorException syntaxErrorException) {}
                        } else {
                            long lTime;
                            valueString = is.readString();
                            try {
                                lTime = Long.parseLong(valueString);
                            }
                            catch (NumberFormatException e) {
                                lTime = 0L;
                            }
                            Calendar cal = Calendar.getInstance();
                            cal.setTimeInMillis(lTime);
                            var = new Variant(cal, 13);
                        }
                    } else {
                        var = 2 == type ? new Variant(is.readBoolean(), 8) : Variant.nullVariant;
                    }
                    if (cIndex < 0) {
                        maxRowIndex = cIndex = maxRowIndex + 1;
                    }
                    if (!cells.containsKey(position = sheetName.toUpperCase() + "!" + Tools.getCharacterFromIndex((int)cIndex) + (rowIndex + 1)) && !cells.containsKey(position = sheetName.toLowerCase() + "!" + Tools.getCharacterFromIndex((int)cIndex, (char)'a') + (rowIndex + 1))) continue;
                    cells.put(position, var.getValue());
                    continue;
                }
                if (id == ID_Cell_HyperLink) {
                    is.readString();
                    continue;
                }
                if (id == ID_Cell_UserObject) {
                    is.readString();
                    is.readString();
                    continue;
                }
                if (id == ID_Cell_Comment) {
                    is.readString();
                    is.readString();
                    continue;
                }
                if (id != ID_Cell_Diagonal) break;
                this.readDiagonal(is);
            }
            if (cIndex >= 0) break block21;
            ++maxRowIndex;
        }
        return maxRowIndex;
    }

    private void readDiagonal(KDSDataInputStream is) throws IOException {
        int i;
        is.readByte();
        is.readInt();
        is.readInt();
        is.readInt();
        is.readInt();
        String srowoffs = is.readString();
        String scoloffs = is.readString();
        int[] rowOffs = null;
        if (!StringUtil.isEmptyString((String)srowoffs)) {
            String[] strs = srowoffs.split(",");
            rowOffs = new int[strs.length];
            for (int i2 = strs.length - 1; i2 >= 0; --i2) {
                rowOffs[i2] = Integer.parseInt(strs[i2]);
            }
        }
        int[] colOffs = null;
        if (!StringUtil.isEmptyString((String)scoloffs)) {
            String[] strs = scoloffs.split(",");
            colOffs = new int[strs.length];
            for (i = strs.length - 1; i >= 0; --i) {
                colOffs[i] = Integer.parseInt(strs[i]);
            }
        }
        int size = (rowOffs == null ? 0 : rowOffs.length) + (colOffs == null ? 0 : colOffs.length) + 2;
        for (i = 0; i < size; ++i) {
            is.readByte();
            is.readInt();
            is.readString();
        }
    }

    private void readStyles(KDSDataInputStream is) throws IOException {
        byte id;
        while ((id = is.readByte()) == ID_ST_BEGIN) {
            this.readStyle(is);
        }
    }

    private void readStyle(KDSDataInputStream is) throws IOException {
        is.readInt();
        while (true) {
            byte id;
            if ((id = is.readByte()) == ID_ST_Font) {
                is.readString();
                is.readInt();
                is.readInt();
                is.readByte();
                continue;
            }
            if (id == ID_ST_Align) {
                is.readInt();
                is.readInt();
                is.readInt();
                is.readByte();
                continue;
            }
            if (id == ID_ST_TopBorder) {
                is.readInt();
                is.readInt();
                is.readString();
                continue;
            }
            if (id == ID_ST_BottomBorder) {
                is.readInt();
                is.readInt();
                is.readString();
                continue;
            }
            if (id == ID_ST_LeftBorder) {
                is.readInt();
                is.readInt();
                is.readString();
                continue;
            }
            if (id == ID_ST_RightBorder) {
                is.readInt();
                is.readInt();
                is.readString();
                continue;
            }
            if (id == ID_ST_LeftDiaBorder) {
                is.readInt();
                is.readInt();
                is.readString();
                continue;
            }
            if (id == ID_ST_RightDiaBorder) {
                is.readInt();
                is.readInt();
                is.readString();
                continue;
            }
            if (id == ID_ST_Background) {
                is.readInt();
                is.readInt();
                is.readInt();
                continue;
            }
            if (id == ID_ST_NumberFormat) {
                is.readString();
                continue;
            }
            if (id != ID_ST_Protection) break;
            is.readByte();
        }
    }
}

