/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.kds.model.expr;

import com.kingdee.bos.ctrl.common.KDToolkit;
import com.kingdee.bos.ctrl.extcommon.digitalstyle.Formats;
import com.kingdee.bos.ctrl.extcommon.util.ObjectArray;
import com.kingdee.bos.ctrl.extcommon.util.ObjectCache;
import com.kingdee.bos.ctrl.extcommon.variant.SyntaxErrorException;
import com.kingdee.bos.ctrl.extcommon.variant.Variant;
import com.kingdee.bos.ctrl.extcommon.variant.WeakHashSet;
import com.kingdee.bos.ctrl.kds.expans.model.data.ExtGroup;
import com.kingdee.bos.ctrl.kds.expans.model.data.ExtRow;
import com.kingdee.bos.ctrl.kds.model.expr.ExprConst;
import com.kingdee.bos.ctrl.kds.model.expr.ExprContext;
import com.kingdee.bos.ctrl.kds.model.expr.ExprExpressionMark;
import com.kingdee.bos.ctrl.kds.model.expr.ExprMethod;
import com.kingdee.bos.ctrl.kds.model.expr.ExprOperator;
import com.kingdee.bos.ctrl.kds.model.expr.ExprOps;
import com.kingdee.bos.ctrl.kds.model.expr.ExprParamPos;
import com.kingdee.bos.ctrl.kds.model.expr.ExprParams;
import com.kingdee.bos.ctrl.kds.model.expr.IExprBuffer;
import com.kingdee.bos.ctrl.kds.model.expr.IExprNode;
import com.kingdee.bos.ctrl.kds.model.expr.TraceVariant;
import com.kingdee.bos.ctrl.kds.model.struct.ICalculable;
import com.kingdee.bos.ctrl.kds.model.struct.node.CellBlockNode;
import com.kingdee.bos.ctrl.kds.model.struct.node.NamedObjectNode;
import com.kingdee.bos.ctrl.kds.model.util.ObjectStack;
import java.util.Calendar;
import java.util.Date;

public class Expr
implements Cloneable,
Comparable,
IExprNode {
    private ExprOps _ops;
    private ExprParams _params;
    private int _nodesState;
    private int _hashCode;
    private Variant _varThis;

    public static Expr getExpr(IExprBuffer buffer, IExprNode[] nodes, int nodesState, int start, int end) {
        boolean hasParam = (nodesState & 0x22020E) != 0;
        ObjectArray aOps = new ObjectArray();
        ObjectArray aParams = hasParam ? new ObjectArray() : null;
        int param = 0;
        block4: for (int i = start; i < end; ++i) {
            IExprNode node = nodes[i];
            switch (node.getExprType()) {
                case 2: 
                case 4: 
                case 8: {
                    if (null != aParams) {
                        aParams.append(node);
                    }
                    aOps.append(ExprParamPos.getExprParamPos(param++));
                    continue block4;
                }
                case 131072: {
                    ExprExpressionMark mark = (ExprExpressionMark)node;
                    int count = mark.getCount();
                    Expr subExpr = Expr.getExpr(buffer, nodes, mark.getNodesState(), i + 1, i + 1 + count);
                    if (null != aParams) {
                        aParams.append(subExpr);
                    }
                    aOps.append(ExprParamPos.getExprParamPos(param++));
                    i += count;
                    continue block4;
                }
                default: {
                    aOps.append(node);
                }
            }
        }
        ExprOps eo = ExprOps.getExprOps(buffer == null ? null : buffer.getExprOpsBuffer(), aOps);
        ExprParams ep = ExprParams.getExprParams(buffer == null ? null : buffer.getExprParamsBuffer(), aParams);
        return Expr.getExpr(buffer == null ? null : buffer.getExprBuffer(), eo, ep, nodesState);
    }

    public static Expr getExpr(WeakHashSet buffer, ExprOps eo, ExprParams ep, int nodesState) {
        Expr expr = new Expr(eo, ep, nodesState);
        return buffer == null ? expr : (Expr)buffer.add(expr);
    }

    public static Expr getExpr(IExprBuffer buffer, Expr srcExpr, IExprNode[] params, int nodesState) {
        ExprParams ep = ExprParams.getExprParams(buffer == null ? null : buffer.getExprParamsBuffer(), params);
        return Expr.getExpr(buffer == null ? null : buffer.getExprBuffer(), srcExpr.getExprOps(), ep, nodesState);
    }

    private Expr(ExprOps ops, ExprParams params, int nodesState) {
        this._ops = ops;
        this._params = params;
        this._nodesState = nodesState;
    }

    public Expr getDeepClone(WeakHashSet buffer) {
        Expr expr = (Expr)this.clone();
        if (this._params != null) {
            Object[] src = this._params.getNodes();
            Object[] dst = new IExprNode[src.length];
            KDToolkit.arraycopy((Object[])src, (int)0, (Object[])dst, (int)0, (int)src.length);
            if (this.hasExprParam()) {
                for (int i = 0; i < src.length; ++i) {
                    Object node = src[i];
                    if (node.getExprType() != 131072) continue;
                    Expr subExpr = ((Expr)node).getDeepClone(buffer);
                    dst[i] = subExpr;
                }
            }
            expr._params = ExprParams.getExprParams(buffer, (IExprNode[])dst);
        }
        return expr;
    }

    public Object clone() {
        Expr expr = null;
        try {
            expr = (Expr)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        return expr;
    }

    public int hashCode() {
        if (this._hashCode == 0) {
            this._hashCode = this._ops.hashCode();
            if (this._params != null) {
                this._hashCode ^= this._params.hashCode();
            }
        }
        return this._hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof Expr) {
            Expr cmp = (Expr)obj;
            return this._ops == cmp._ops && this._params == cmp._params;
        }
        return false;
    }

    public int compareTo(Object obj) {
        if (this == obj) {
            return 0;
        }
        int cmp = 1;
        if (obj instanceof Expr) {
            Expr c = (Expr)obj;
            cmp = this.hashCode() - c.hashCode();
        }
        return cmp;
    }

    public String toString() {
        return "Expr " + this._ops.getNodes()[0];
    }

    public int getExprNodeState() {
        return this._nodesState;
    }

    private boolean touchState(int state) {
        return (this._nodesState & state) != 0;
    }

    public boolean isSyntaxError() {
        return this.touchState(1);
    }

    public boolean isExtFamily() {
        return this.touchState(0x1000000);
    }

    public boolean hasMacro() {
        return this.touchState(0x2000000);
    }

    public boolean isExtensible() {
        return this.touchState(8192);
    }

    public boolean isNeedContext() {
        return this.touchState(32768);
    }

    public boolean isDynamicDataset() {
        return this.touchState(0x400000);
    }

    public boolean hasUndefinedNamedObject() {
        return this.touchState(0x800000);
    }

    public boolean isNamedObject() {
        return this._ops.getNodes().length == 1 && this._params != null && this._params.getNodes()[0] instanceof NamedObjectNode;
    }

    public boolean isArray() {
        if (this.touchState(16384)) {
            IExprNode[] nodes = this._ops.getNodes();
            return nodes[0] == ExprOperator.LARRAY && nodes[nodes.length - 1] == ExprOperator.RARRAY;
        }
        return false;
    }

    public boolean isSingleCellBlock() {
        return this._ops.getNodes().length == 1 && this._params != null && this._params.getNodes()[0] instanceof CellBlockNode;
    }

    public boolean isSingleCell() {
        if (this.isSingleCellBlock()) {
            CellBlockNode cb = (CellBlockNode)this._params.getNodes()[0];
            return cb.isSingleCell();
        }
        return false;
    }

    public boolean isSingleNamedObject() {
        return this._ops.getNodes().length == 1 && this._params != null && this._params.getNodes()[0] instanceof NamedObjectNode;
    }

    public boolean hasMethod() {
        return this.touchState(2432);
    }

    public boolean hasExternMethod() {
        return this.touchState(2176);
    }

    public boolean hasExcelMethod() {
        return this.touchState(1024);
    }

    public boolean hasSubTotalMethod() {
        return this.touchState(4096);
    }

    public boolean hasUnknownMethod() {
        return this.touchState(2048);
    }

    public boolean hasCellBlock() {
        return this.touchState(4);
    }

    public boolean hasArray() {
        return this.touchState(16384);
    }

    public boolean hasNamedObject() {
        return this.touchState(8);
    }

    public boolean hasExtPos() {
        return this.touchState(0x200000);
    }

    public boolean hasExtField() {
        return this.touchState(0x100000);
    }

    public boolean hasExprParam() {
        return this.touchState(131072);
    }

    public IExprNode[] getAllNodes() {
        ObjectArray al = new ObjectArray(this._ops.getNodes().length + (this._params == null ? 0 : this._params.getNodes().length));
        this.addAllNodes(al);
        Object[] nodes = new IExprNode[al.size()];
        al.toArray(nodes, 0);
        return nodes;
    }

    private void addAllNodes(ObjectArray al) {
        IExprNode[] ops = this._ops.getNodes();
        IExprNode[] params = this._params == null ? null : this._params.getNodes();
        for (int i = 0; i < ops.length; ++i) {
            IExprNode node = ops[i];
            if (null != params && node.getExprType() == 262144) {
                if ((node = params[((ExprParamPos)node).getPos()]).getExprType() == 131072) {
                    ((Expr)node).addAllNodes(al);
                    continue;
                }
                al.append(node);
                continue;
            }
            al.append(node);
        }
    }

    public int getAllExprOps(ObjectArray array) {
        int count = 1;
        array.append(this._ops);
        if (this.hasExprParam()) {
            IExprNode[] params = this._params.getNodes();
            for (int i = 0; i < params.length; ++i) {
                IExprNode node = params[i];
                if (node.getExprType() != 131072) continue;
                count += ((Expr)node).getAllExprOps(array);
            }
        }
        return count;
    }

    public int getParamExprs(ObjectArray array, boolean allParam) {
        int count = 0;
        if (this._params != null && (allParam || this.hasCellBlock())) {
            array.append(this);
            ++count;
        }
        if (this.hasExprParam()) {
            IExprNode[] nodes = this._params.getNodes();
            for (int i = 0; i < nodes.length; ++i) {
                IExprNode node = nodes[i];
                if (node.getExprType() != 131072) continue;
                count += ((Expr)node).getParamExprs(array, allParam);
            }
        }
        return count;
    }

    public IExprNode[] getAllExprExtPosNodes() {
        Object[] nodes = null;
        if (this.hasExtPos()) {
            ObjectArray array = new ObjectArray();
            this.getAllExprExtPosNodes(array);
            nodes = new IExprNode[array.size()];
            array.toArray(nodes, 0);
        }
        return nodes;
    }

    private void getAllExprExtPosNodes(ObjectArray array) {
        if (this._params != null) {
            IExprNode[] nodes = this._params.getNodes();
            for (int i = 0; i < nodes.length; ++i) {
                IExprNode node = nodes[i];
                int nodeType = node.getExprType();
                if (nodeType == 0x200000) {
                    array.append(node);
                    continue;
                }
                if (nodeType != 131072) continue;
                ((Expr)node).getAllExprExtPosNodes(array);
            }
        }
    }

    public ExprOps getExprOps() {
        return this._ops;
    }

    public ExprParams getExprParams() {
        return this._params;
    }

    public void setExprParams(ExprParams params) {
        this._params = params;
        this._hashCode = 0;
    }

    private Expr _getPureExcelExpr(ExprContext ctx, ICalculable exprOwner, ObjectArray extFuncs) {
        int functionCount;
        Expr expr = this;
        if (extFuncs != null && (functionCount = extFuncs.size()) > 0) {
            TraceVariant funcRet;
            TraceVariant larger = (TraceVariant)extFuncs.get(functionCount - 1);
            int largerStart = larger.getTracePos() - 1;
            for (int i = functionCount - 3; i > -1; i -= 2) {
                funcRet = (TraceVariant)extFuncs.get(i);
                if (funcRet.getTracePos() > largerStart) {
                    extFuncs.removeByPos(i - 1, i, false);
                    continue;
                }
                larger = funcRet;
                largerStart = larger.getTracePos() - 1;
            }
            functionCount = extFuncs.size();
            int deleteNodeCount = 0;
            for (int i = functionCount - 1; i > -1; i -= 2) {
                funcRet = (TraceVariant)extFuncs.get(i);
                Integer thisMethodPos = (Integer)extFuncs.get(i - 1);
                deleteNodeCount += thisMethodPos - funcRet.getTracePos();
            }
            Object[] src = this._ops.getNodes();
            Object[] dst = new IExprNode[src.length - deleteNodeCount];
            int[] varPower = new int[]{0};
            StringBuffer exprBuffer = new StringBuffer();
            StringBuffer varBuffer = new StringBuffer();
            int srcPos = 0;
            int dstPos = 0;
            for (int i = 1; i < functionCount; i += 2) {
                TraceVariant funcRet2 = (TraceVariant)extFuncs.get(i);
                int skipFrom = funcRet2.getTracePos();
                if (srcPos > skipFrom) continue;
                int keeps = skipFrom - srcPos;
                if (keeps > 0) {
                    KDToolkit.arraycopy((Object[])src, (int)srcPos, (Object[])dst, (int)dstPos, (int)keeps);
                    dstPos += keeps;
                }
                dst[dstPos++] = this._getExprConstString(exprBuffer, varBuffer, varPower, ctx, exprOwner, funcRet2);
                Integer thisMethodPos = (Integer)extFuncs.get(i - 1);
                srcPos += keeps + (thisMethodPos - skipFrom + 1);
            }
            if (srcPos < src.length) {
                KDToolkit.arraycopy((Object[])src, (int)srcPos, (Object[])dst, (int)dstPos, (int)(src.length - srcPos));
            }
            expr = varPower[0] < 0 || dst.length == 1 && !ctx.isSubExecute() && varPower[0] < 2 ? null : Expr.getExpr(null, ExprOps.getExprOps(null, (IExprNode[])dst), this._params, this._nodesState);
        }
        if (expr != null && expr != this) {
            String newFormula = expr.decode(ctx, exprOwner);
            expr = exprOwner.getSheet().getExpr(exprOwner, newFormula);
        }
        return expr;
    }

    private ExprConst _getExprConstString(StringBuffer exprBuffer, StringBuffer varBuffer, int[] varPower, ExprContext ctx, ICalculable exprOwner, Variant var) {
        if (var.isArray()) {
            Variant[] vars = (Variant[])var.getValue();
            int count = vars.length;
            if (count < 1) {
                varPower[0] = varPower[0] + Short.MIN_VALUE;
            } else {
                int powner = varPower[0];
                for (int i = 0; i < count && (powner += this._appendVarString(exprBuffer, varBuffer, ctx, exprOwner, vars[i])) >= 0; ++i) {
                    exprBuffer.append(',');
                }
                exprBuffer.setLength(Math.max(0, exprBuffer.length() - 1));
                varPower[0] = varPower[0] + powner;
            }
        } else {
            varPower[0] = varPower[0] + this._appendVarString(exprBuffer, varBuffer, ctx, exprOwner, var);
        }
        ExprConst ret = new ExprConst(new Variant(exprBuffer.toString(), 16395));
        exprBuffer.setLength(0);
        return ret;
    }

    private int _appendVarString(StringBuffer exprBuffer, StringBuffer varBuffer, ExprContext ctx, ICalculable exprOwner, Variant var) {
        String str;
        int power = 1;
        Object obj = var.getValue();
        if (var.isReferences()) {
            if (obj instanceof CellBlockNode) {
                str = ((CellBlockNode)obj).getFullBlockName(varBuffer, exprOwner);
                varBuffer.setLength(0);
                power = 2;
            } else {
                str = obj instanceof ExtRow ? ((ExtRow)obj).getActualValue().toString() : obj.toString();
            }
        } else if (obj instanceof Expr) {
            str = ((Expr)obj).decode(ctx, exprOwner);
            power = 2;
        } else {
            if (obj instanceof ExtGroup) {
                return Short.MIN_VALUE;
            }
            if (obj instanceof String) {
                str = "\"" + obj + '\"';
            } else if (obj instanceof SyntaxErrorException) {
                SyntaxErrorException e = (SyntaxErrorException)obj;
                Object extData = e.getExtData();
                varBuffer.append("ERROR(");
                varBuffer.append(e.getErrorCode()).append(',');
                if (extData == null) {
                    varBuffer.append("null");
                } else {
                    varBuffer.append('\"').append(extData.toString()).append('\"');
                }
                varBuffer.append(")");
                str = varBuffer.toString();
                varBuffer.setLength(0);
            } else {
                str = obj == null ? "null" : var.toString();
            }
        }
        exprBuffer.append(str);
        return power;
    }

    public Variant execute(ExprContext ctx, ICalculable exprOwner) {
        Variant ret;
        ObjectArray extFuncs;
        ObjectStack oldStack;
        ObjectStack exprStack;
        IExprBuffer buffer;
        block22: {
            boolean needContext;
            IExprNode[] ops = this._ops.getNodes();
            if (ops == null || ops.length == 0) {
                return Variant.nullVariant;
            }
            if (exprOwner == null) {
                exprOwner = ctx.getExprOwner();
            }
            int ownerStackSize = (needContext = this.isNeedContext()) ? ctx.getOwnerStackSize() : 0;
            boolean traceMode = ctx.isTraceMode();
            buffer = ctx.getBuffer();
            exprStack = buffer.getStack();
            oldStack = ctx.setCurrentExprStack(exprStack);
            extFuncs = null;
            try {
                IExprNode[] params;
                IExprNode[] iExprNodeArray = params = this._params == null ? null : this._params.getNodes();
                if (traceMode) {
                    ctx.setTempRet(null);
                    ObjectStack subs = ctx.getSubExprStack();
                    extFuncs = buffer.getObjectArray(-1);
                    int subStart = subs.size();
                    for (int i = 0; i < ops.length; ++i) {
                        Variant var;
                        ctx.setTracePos(i);
                        IExprNode node = ops[i];
                        int nodeType = node.getExprType();
                        if (nodeType == 262144) {
                            int paramPos = ((ExprParamPos)node).getPos();
                            if (null != params) {
                                node = params[paramPos];
                            }
                            node.action(ctx, exprOwner);
                            if (node.getExprType() != 0x200000) continue;
                            extFuncs.append(ObjectCache.getInteger(i));
                            extFuncs.append(exprStack.getTop());
                            continue;
                        }
                        node.action(ctx, exprOwner);
                        if (nodeType != 256 || (var = (Variant)exprStack.getTop()).isPending()) continue;
                        if (((ExprMethod)node).isExtFamilyMethod()) {
                            extFuncs.append(ObjectCache.getInteger(i));
                            extFuncs.append(exprStack.getTop());
                            continue;
                        }
                        if (!ctx.hasSubExpr()) continue;
                        int sEnd = subs.size();
                        for (int s = subStart; s < sEnd; ++s) {
                            TraceVariant newSubExpr = (TraceVariant)subs.getAt(s);
                            extFuncs.append(ObjectCache.getInteger(newSubExpr.getTracePos()));
                            extFuncs.append(newSubExpr);
                        }
                        if (subStart == 0) {
                            subs.clear();
                            continue;
                        }
                        subs.popN(sEnd - subStart);
                    }
                    if (extFuncs.isEmpty()) {
                        ctx.setTempRet(this);
                    } else {
                        ctx.setTempRet(this._getPureExcelExpr(ctx, exprOwner, extFuncs));
                    }
                } else {
                    for (int i = 0; i < ops.length; ++i) {
                        IExprNode node = ops[i];
                        if (node.getExprType() == 262144 && null != params) {
                            int paramPos = ((ExprParamPos)node).getPos();
                            params[paramPos].action(ctx, exprOwner);
                            continue;
                        }
                        node.action(ctx, exprOwner);
                    }
                }
                ret = (Variant)exprStack.pop();
            }
            catch (SyntaxErrorException e) {
                if (needContext) {
                    ctx.popExprOwnerN(ctx.getOwnerStackSize() - ownerStackSize);
                }
                exprStack.clear();
                if (e.getErrorCode() == 64L) {
                    e.setExtData("\u516c\u5f0f\u4e2d\u6240\u7528\u7684\u67d0\u4e2a\u503c\u662f\u9519\u8bef\u7684\u6570\u636e\u7c7b\u578b\u3002(" + (String)e.getExtData() + ")");
                }
                ret = new Variant(e, 16);
                if (traceMode) {
                    ret = new TraceVariant(ret, ctx);
                }
            }
            catch (Exception e) {
                if (needContext) {
                    ctx.popExprOwnerN(ctx.getOwnerStackSize() - ownerStackSize);
                }
                exprStack.clear();
                ret = new Variant(e, 16);
                if (!traceMode) break block22;
                ret = new TraceVariant(ret, ctx);
            }
        }
        ctx.setCurrentExprStack(oldStack);
        buffer.recycleStack(exprStack);
        if (extFuncs != null) {
            buffer.recycleArray(extFuncs);
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Variant execute(ExprContext ctx, Variant var) throws SyntaxErrorException {
        Object value = var.getValue();
        if (value instanceof Expr) {
            boolean traceMode = ctx.isTraceMode();
            boolean isSubExecute = ctx.isSubExecute();
            try {
                Object obj;
                int tracePos = 0;
                if (traceMode) {
                    tracePos = var instanceof TraceVariant ? ((TraceVariant)var).getTracePos() : 0;
                    ctx.setSubExecute(true);
                }
                if ((var = ((Expr)value).execute(ctx, ctx.getExprOwner())).isPureCalcLast()) {
                    throw (SyntaxErrorException)var.getValue();
                }
                if (traceMode && (obj = ctx.getTempRet()) != null) {
                    ctx.pushSubExpr(new TraceVariant(new Variant(obj, 17), tracePos));
                    ctx.setTempRet(null);
                }
            }
            finally {
                if (traceMode) {
                    ctx.setSubExecute(isSubExecute);
                }
            }
        }
        return var;
    }

    public static Variant pureExecute(ExprContext ctx, Variant var, ICalculable exprOwner) throws SyntaxErrorException {
        Object value = var.getValue();
        if (value instanceof Expr && (var = ((Expr)value).execute(ctx, ctx.getExprOwner())).isPureCalcLast()) {
            throw (SyntaxErrorException)var.getValue();
        }
        return var;
    }

    public ObjectArray getDecodeList(ExprContext ctx) {
        ObjectArray current;
        int i;
        IExprBuffer buffer = ctx.getBuffer();
        ObjectStack stack = buffer.getStack();
        ObjectStack parameters = buffer.getStack();
        IExprNode[] ops = this._ops.getNodes();
        IExprNode[] params = this._params == null ? null : this._params.getNodes();
        for (i = 0; i < ops.length; ++i) {
            current = null;
            IExprNode node = ops[i];
            if (node.getExprType() == 262144 && null != params) {
                node = params[((ExprParamPos)node).getPos()];
            }
            switch (node.getExprType()) {
                case 2: 
                case 4: 
                case 8: 
                case 131072: 
                case 524288: 
                case 0x100000: 
                case 0x200000: {
                    current = buffer.getObjectArray(0);
                    current.append(node);
                    break;
                }
                case 16: 
                case 128: 
                case 256: 
                case 2048: {
                    current = (ObjectArray)stack.pop();
                    current.insert(0, node);
                    if (!(node instanceof ExprOperator) || ((ExprOperator)node).parameterCount() != 2) break;
                    current.insertAll(0, (ObjectArray)stack.pop());
                    break;
                }
                case 64: {
                    int j;
                    Object obj;
                    if (node == ExprOperator.LP || node == ExprOperator.LARRAY) {
                        stack.push(node);
                        break;
                    }
                    int count = 0;
                    while (!stack.isEmpty()) {
                        obj = stack.pop();
                        if (obj instanceof ObjectArray) {
                            if (count > 0) {
                                parameters.push(ExprOperator.COMMA);
                            }
                            ObjectArray array = (ObjectArray)obj;
                            for (j = array.size() - 1; j >= 0; --j) {
                                parameters.push(array.get(j));
                            }
                        } else {
                            boolean leftBound;
                            boolean bl = leftBound = obj == ExprOperator.LP || obj == ExprOperator.LARRAY;
                            if (count > 0 && !leftBound) {
                                parameters.push(ExprOperator.COMMA);
                            }
                            parameters.push(obj);
                            if (leftBound) break;
                        }
                        if (obj == ExprOperator.RARRAY) continue;
                        ++count;
                    }
                    current = buffer.getObjectArray(0);
                    while (!parameters.isEmpty()) {
                        current.append(parameters.pop());
                    }
                    current.append(node);
                    break;
                }
                case 32: {
                    Object obj = stack.getTop();
                    current = obj instanceof ObjectArray ? (ObjectArray)stack.pop() : buffer.getObjectArray(0);
                    current.append(node);
                    break;
                }
                case 16384: {
                    int j;
                    Object obj;
                    if (i != ops.length - 1) break;
                    int count = 0;
                    parameters.push(ExprOperator.RARRAY);
                    while (!stack.isEmpty()) {
                        obj = stack.pop();
                        if (!(obj instanceof ObjectArray)) continue;
                        if (count > 0) {
                            parameters.push(ExprOperator.COMMA);
                        }
                        ObjectArray array = (ObjectArray)obj;
                        for (j = array.size() - 1; j >= 0; --j) {
                            parameters.push(array.get(j));
                        }
                        ++count;
                    }
                    parameters.push(ExprOperator.LARRAY);
                    current = buffer.getObjectArray(0);
                    while (!parameters.isEmpty()) {
                        current.append(parameters.pop());
                    }
                    break;
                }
            }
            if (current == null) continue;
            stack.push(current);
        }
        current = null;
        if (stack.size() > 0) {
            current = buffer.getObjectArray(ops.length);
            int stackSize = stack.size();
            for (i = 0; i < stackSize; ++i) {
                Object obj = stack.getAt(i);
                if (obj instanceof IExprNode) {
                    current.append(obj);
                    continue;
                }
                ObjectArray array = (ObjectArray)obj;
                int arraySize = array.size();
                for (int j = 0; j < arraySize; ++j) {
                    current.append(array.get(j));
                }
                buffer.recycleArray(array);
            }
        }
        buffer.recycleStack(stack);
        buffer.recycleStack(parameters);
        return current;
    }

    public String decode(ObjectArray array, ExprContext ctx, ICalculable exprOwner, boolean withPrefix) {
        int size = array.size();
        if (size > 0) {
            StringBuffer sb = new StringBuffer(size << 2);
            if (withPrefix) {
                sb.append('=');
            }
            for (int i = 0; i < size; ++i) {
                sb.append(((IExprNode)array.get(i)).decode(ctx, exprOwner));
            }
            return sb.toString();
        }
        return "";
    }

    public static String getDateString(Variant var) {
        String dateFormula = "";
        if (var.isDate()) {
            Calendar cal = null;
            if (var.getVt() == 13) {
                cal = (Calendar)var.getValue();
            } else {
                cal = Calendar.getInstance();
                cal.setTime((Date)var.getValue());
            }
            dateFormula = cal.get(11) != 0 || cal.get(12) != 0 || cal.get(13) != 0 ? Formats.getFormat("yyyy-m-d h:mm:ss").format(var, false).toString() : Formats.getFormat("yyyy-m-d").format(var, false).toString();
        }
        return dateFormula;
    }

    public Variant getVarThis() {
        if (this._varThis == null) {
            this._varThis = new Variant(this, 17);
        }
        return this._varThis;
    }

    @Override
    public void action(ExprContext ctx, ICalculable exprOwner) throws SyntaxErrorException {
        Variant var = this.getVarThis();
        if (ctx.isTraceMode()) {
            var = new TraceVariant(var, ctx);
        }
        ctx.getCurrentExprStack().push(var);
    }

    @Override
    public String decode(ExprContext ctx, ICalculable owner) {
        return this.decode(this.getDecodeList(ctx), ctx, owner, false);
    }

    @Override
    public int getExprType() {
        return 131072;
    }
}

