/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.kds.model.struct;

import com.kingdee.bos.ctrl.common.hyperlink.HyperLink;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.ext.subrpt.SubReportInfo;
import com.kingdee.bos.ctrl.extcommon.digitalstyle.Format;
import com.kingdee.bos.ctrl.extcommon.variant.IVarReferences;
import com.kingdee.bos.ctrl.extcommon.variant.SyntaxErrorException;
import com.kingdee.bos.ctrl.extcommon.variant.Util;
import com.kingdee.bos.ctrl.extcommon.variant.Variant;
import com.kingdee.bos.ctrl.kdf.util.style.Pattern;
import com.kingdee.bos.ctrl.kdf.util.style.ShareStyleAttributes;
import com.kingdee.bos.ctrl.kdf.util.style.Style;
import com.kingdee.bos.ctrl.kdf.util.style.StyleAttributes;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.kds.expans.model.ExtConst;
import com.kingdee.bos.ctrl.kds.expans.model.ExtProps;
import com.kingdee.bos.ctrl.kds.expans.model.collection.SortedExtPropFormulasArray;
import com.kingdee.bos.ctrl.kds.expans.model.collection.SortedExtPropsArray;
import com.kingdee.bos.ctrl.kds.expans.model.data.DataConvert;
import com.kingdee.bos.ctrl.kds.expans.model.data.ETTargets;
import com.kingdee.bos.ctrl.kds.expans.model.data.ExtDataSetManager;
import com.kingdee.bos.ctrl.kds.expans.model.data.ExtGroup;
import com.kingdee.bos.ctrl.kds.expans.model.data.ExtRow;
import com.kingdee.bos.ctrl.kds.expans.model.data.ExtTransitionTarget;
import com.kingdee.bos.ctrl.kds.expans.model.data.HyperlinkCalculableProps;
import com.kingdee.bos.ctrl.kds.expans.model.data.ICalculableProps;
import com.kingdee.bos.ctrl.kds.expans.model.data.IParameter;
import com.kingdee.bos.ctrl.kds.expans.model.data.ParameterImpl;
import com.kingdee.bos.ctrl.kds.expans.model.innerlink.model.InnerLinkTargetProperties;
import com.kingdee.bos.ctrl.kds.expans.model.innerlink.model.InnerLinkTargets;
import com.kingdee.bos.ctrl.kds.expans.model.innerlink.model.InnerLinkTransitionTarget;
import com.kingdee.bos.ctrl.kds.model.expr.Expr;
import com.kingdee.bos.ctrl.kds.model.expr.ExprContext;
import com.kingdee.bos.ctrl.kds.model.expr.ExprUID;
import com.kingdee.bos.ctrl.kds.model.expr.ExprUnknownMethod;
import com.kingdee.bos.ctrl.kds.model.expr.IErrorResultProvider;
import com.kingdee.bos.ctrl.kds.model.expr.IExprNode;
import com.kingdee.bos.ctrl.kds.model.expr.Parser;
import com.kingdee.bos.ctrl.kds.model.struct.Book;
import com.kingdee.bos.ctrl.kds.model.struct.CellBlock;
import com.kingdee.bos.ctrl.kds.model.struct.Column;
import com.kingdee.bos.ctrl.kds.model.struct.Comment;
import com.kingdee.bos.ctrl.kds.model.struct.Dependents;
import com.kingdee.bos.ctrl.kds.model.struct.DiagonalHeader;
import com.kingdee.bos.ctrl.kds.model.struct.ICalculable;
import com.kingdee.bos.ctrl.kds.model.struct.MergeBlocks;
import com.kingdee.bos.ctrl.kds.model.struct.PasteMode;
import com.kingdee.bos.ctrl.kds.model.struct.Protection;
import com.kingdee.bos.ctrl.kds.model.struct.Row;
import com.kingdee.bos.ctrl.kds.model.struct.Sheet;
import com.kingdee.bos.ctrl.kds.model.struct.SheetBaseMath;
import com.kingdee.bos.ctrl.kds.model.struct.SortedUserObjectArray;
import com.kingdee.bos.ctrl.kds.model.struct.Span;
import com.kingdee.bos.ctrl.kds.model.struct.UserObject;
import com.kingdee.bos.ctrl.kds.model.struct.borders.Borders;
import com.kingdee.bos.ctrl.kds.model.struct.cformat.ConditionalFormat;
import com.kingdee.bos.ctrl.kds.model.struct.node.CellBlock3DNode;
import com.kingdee.bos.ctrl.kds.model.struct.node.CellBlockNode;
import com.kingdee.bos.ctrl.kds.model.struct.validate.util.MessagedValidate;
import com.kingdee.bos.ctrl.kds.model.util.IntMarkEntry;
import com.kingdee.bos.ctrl.kds.model.util.SortedCellBlockArray;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Cell
implements Comparable,
Cloneable,
IntMarkEntry,
ICalculable {
    public static final String KEY_DIAGONAL = "inner_diagonal";
    public static final String KEY_HYPERLINK = "inner_hyperlink";
    public static final String KEY_COMMENT = "inner_comment";
    public static final String KEY_SUBRPT = "inner_report";
    static final ContentType FORMULA = new ContentType();
    static final ContentType VALUE = new ContentType();
    static final ContentType DIAGONAL = new ContentType();
    static final ContentType HYPERLINK = new ContentType();
    static final ContentType COMMENT = new ContentType();
    static final ContentType USEROBJECT = new ContentType();
    static final ContentType SUBRPT = new ContentType();
    static final int Flag_HasValue = 1;
    static final int Flag_Formated = 2;
    static final int Flag_NeedCalc = 4;
    static final int Flag_Calculating = 8;
    static final int Flag_Queued = 16;
    static final int Flag_Deleted = 32;
    static final int Flag_Merge = 64;
    static final int Flag_QueueLast = 128;
    static final int Flag_ExternText = 256;
    static final int Flag_Iterate = 512;
    static final int Flag_ExtendMerge = 1024;
    static final java.util.regex.Pattern _pattern = java.util.regex.Pattern.compile("\n");
    public static boolean SHOW_EmptyCellObj = false;
    private static String[] WRONG_NUMBERFORMATS = new String[]{"\uffe5* #,###.00;\uffe5* -#,###.00", "#,###.00;-#,###.00"};
    private static String[] REPLACEMENT_NUMBERFORMATS = new String[]{"\uffe5* #,##0.00;\uffe5* -#,##0.00", "#,##0.00;-#,##0.00"};
    private Row _row;
    private Column _col;
    private int _flags;
    private Object _formula;
    private Variant _value;
    private int _calcUID;
    private String _text;
    private ShareStyleAttributes _ssa;
    private Style _style;
    private ExtData _extData;
    private ExtProps _extProps;

    static boolean isEmptyCell(Cell cll) {
        return cll == null || cll.getValue2().isNull();
    }

    static String getCellName(Sheet sheet, int row, int col, boolean bAbs, boolean withSheetName) {
        return withSheetName ? sheet.getSyntaxName() + "!" + SheetBaseMath.getBlockA1Name(row, col, bAbs, bAbs) : SheetBaseMath.getBlockA1Name(row, col, bAbs, bAbs);
    }

    static StyleAttributes getBubbleSA(ShareStyleAttributes thisSSA, Sheet sheet, int row, int col, CellBlock mergeBlock) {
        StyleAttributes sa;
        block3: {
            block4: {
                Cell cllFirst;
                sa = Styles.getSA((ShareStyleAttributes)thisSSA);
                if (sa.isFull()) break block3;
                if (mergeBlock == null || (cllFirst = sheet.getFirstCell(mergeBlock, false)).getRow() == row && cllFirst.getCol() == col) break block4;
                sa.append(cllFirst.getSSA(), false, ShareStyleAttributes.BEFORE_BORDER);
                if (sa.isFull()) break block3;
            }
            sheet.getBorders().getCellBorders(row, col, mergeBlock, sa);
            if (!sa.isFull()) {
                int bitCount = ShareStyleAttributes.ATTRS_COUNT;
                sa.append(sheet.getRowSSA(row), false, bitCount);
                if (!sa.isFull()) {
                    sa.append(sheet.getColSSA(col), false, bitCount);
                    if (!sa.isFull()) {
                        sa.append(sheet.getSSA(), false, bitCount);
                    }
                }
            }
        }
        return sa;
    }

    public static Cell getNewCell(Row row, Column col) {
        return new Cell(row, col);
    }

    public static Variant parseValue(String value, String fmt, boolean parseDate) {
        Variant var;
        if (!StringUtil.isEmptyString((String)fmt) && fmt.startsWith("@")) {
            var = new Variant(value, 11);
        } else {
            var = Format.parseData(value, parseDate);
            Cell.reduceScale(var);
        }
        return var;
    }

    private static void reduceScale(Variant var) {
        if (var.getVt() == 10) {
            BigDecimal bd = (BigDecimal)var.getValue();
            if (bd.scale() > 16) {
                bd = bd.setScale(16, 4);
                var.setObject(bd, 10);
            }
            Util.reduceScale(var);
        }
    }

    private Cell(Row row, Column col) {
        this._row = row;
        this._col = col;
        this._ssa = Styles.getEmptySSA();
    }

    public HyperLink getHyperLink() {
        Object o = this.getExtObject(KEY_HYPERLINK);
        if (o instanceof HyperLink) {
            return (HyperLink)o;
        }
        return null;
    }

    public DiagonalHeader getDiagonalHeader() {
        Object o = this.getExtObject(KEY_DIAGONAL);
        if (o instanceof DiagonalHeader) {
            return (DiagonalHeader)((Object)o);
        }
        return null;
    }

    public Comment getComment() {
        Object o = this.getExtObject(KEY_COMMENT);
        if (o instanceof Comment) {
            return (Comment)o;
        }
        return null;
    }

    public void setHyperLink(HyperLink link) {
        if (link != null && StringUtil.isEmptyString((String)link.getText())) {
            link.setText(this.getText());
        }
        this.setExtObject(KEY_HYPERLINK, link);
    }

    public void setDiagonalHeader(DiagonalHeader header) {
        this.setExtObject(KEY_DIAGONAL, (Object)header);
    }

    public void setComment(Comment comment) {
        this.setExtObject(KEY_COMMENT, comment);
    }

    public Object getUserObjectValue(String key) {
        UserObject uo;
        if (this._extData != null && this._extData._userObjects != null && (uo = this._extData._userObjects.getUserObject(key)) != null) {
            return uo.getValue();
        }
        return null;
    }

    public UserObject getUserObject(String key) {
        if (this._extData != null && this._extData._userObjects != null) {
            return this._extData._userObjects.getUserObject(key);
        }
        return null;
    }

    public UserObject setUserObject(String key, Object obj) {
        UserObject uo = new UserObject(key, obj);
        if (this._extData == null) {
            this._extData = new ExtData();
        }
        if (this._extData._userObjects == null) {
            this._extData._userObjects = new SortedUserObjectArray();
        }
        return this._extData._userObjects.insertByKey(uo);
    }

    public UserObject removeUserObject(String key) {
        if (this._extData != null && this._extData._userObjects != null) {
            return this._extData._userObjects.removeByKey(key);
        }
        return null;
    }

    public boolean isLocked() {
        return this.getStyle().isLocked();
    }

    public boolean isHidden() {
        Sheet sheet = this.getSheet();
        return SheetBaseMath.isHideRow(sheet, this.getRow()) || SheetBaseMath.isHideCol(sheet, this.getCol());
    }

    public boolean hasSubTotalMethod() {
        Expr expr = this.getExpr();
        return expr == null ? false : expr.hasSubTotalMethod();
    }

    public boolean isEmpty() {
        return this.isEmptyContent() && this.isEmptyAttribute();
    }

    public boolean isEmptyContent() {
        return this._value == null && this._formula == null && (this._extData == null || this._extData.isEmptyContent()) && this._extProps == null;
    }

    public boolean isEmptyContent2() {
        return this._value == null && this._formula == null && (this._extData == null || this._extData.isEmptyContent());
    }

    private boolean isEmptyAttribute() {
        return ShareStyleAttributes.isEmptySSA((ShareStyleAttributes)this._ssa) && this.getMerge(false) == null;
    }

    public boolean hasUnknownMethod() {
        return this._formula instanceof Expr ? ((Expr)this._formula).hasUnknownMethod() : false;
    }

    public int getMethodState() {
        return this._formula instanceof Expr ? ((Expr)this._formula).getExprNodeState() : 2;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(this.getName(false, true) + "[");
        if (this.touchFlag(1)) {
            sb.append("V");
        }
        if (this.touchFlag(2)) {
            sb.append(",F[" + this.getText() + "]");
        }
        if (this.touchFlag(4)) {
            sb.append(",NC");
        }
        if (this.touchFlag(16)) {
            sb.append(",Q");
        }
        if (this.touchFlag(32)) {
            sb.append(",D");
        }
        if (this.touchFlag(64)) {
            sb.append(",M");
        }
        if (this.touchFlag(8)) {
            sb.append(",Cing");
        }
        sb.append("]");
        return sb.toString() + " = " + this.getFormula();
    }

    protected Object clone() {
        Object cll;
        try {
            cll = super.clone();
        }
        catch (CloneNotSupportedException e) {
            cll = null;
        }
        return cll;
    }

    public int compareTo(Object obj) {
        return this.hashCode() - obj.hashCode();
    }

    public void copyCalculableFrom(Cell cll) {
        this._flags = cll._flags;
        this._formula = cll._formula;
        this._value = cll._value;
        this.setFlag(128, this._value != null ? this._value.isCalcLast() : false);
        this.setFlag(16, false);
        this._calcUID = cll._calcUID - 1;
    }

    public int getCalcUID() {
        return this._calcUID;
    }

    public void setCalcUID(int uid) {
        this._calcUID = uid;
    }

    public Style getStyle() {
        if (this._style == null) {
            Sheet sheet = this._row.getSheet();
            CellBlock mergeBlock = this.getMerge(true);
            this._style = this.getSheet().getBook().getStyle((ShareStyleAttributes)Cell.getBubbleSA(this._ssa, sheet, this._row.getRow(), this._col.getCol(), mergeBlock));
        }
        return this._style;
    }

    public Style getDisplayStyle() {
        Style extStyle;
        if (!this.touchFlag(2)) {
            this.getText();
        }
        return (extStyle = this.getExtStyle()) != null ? extStyle : this.getStyle();
    }

    public ShareStyleAttributes getSSA() {
        return this._ssa;
    }

    public boolean setSSA(ShareStyleAttributes ssa) {
        boolean bRet = false;
        if (this._ssa != ssa) {
            if (this._ssa == null) {
                if (!StringUtil.isEmptyString((String)ssa.getNumberFormat())) {
                    this.setFlag(2, false);
                }
            } else if (ssa == null) {
                if (!StringUtil.isEmptyString((String)this._ssa.getNumberFormat())) {
                    this.setFlag(2, false);
                }
            } else if (!StringUtil.equals((String)this._ssa.getNumberFormat(), (String)ssa.getNumberFormat())) {
                this.setFlag(2, false);
            }
            this._ssa = ssa instanceof StyleAttributes ? Styles.getSSA((StyleAttributes)((StyleAttributes)ssa)) : ssa;
            if (this._ssa.hasBordersAttributes()) {
                Span spMaster = new Span(0, 0);
                Span spMinor = new Span(0, 0);
                this.getSheet().getBorders().buildCellBorderFromSSA(this, spMaster, spMinor);
            }
            bRet = true;
        } else if (ssa != null && this._ssa == ssa && ssa.hasBordersAttributes()) {
            Span spMaster = new Span(0, 0);
            Span spMinor = new Span(0, 0);
            this.getSheet().getBorders().buildCellBorderFromSSA(this, spMaster, spMinor);
        }
        this.updateStyle();
        return bRet;
    }

    @Override
    public int getIntMark() {
        return this._col.getIntMark();
    }

    @Override
    public void setIntMark(int col) {
        this._col = this._row.getSheet().getColumn(col, true);
    }

    public int getRow() {
        return this._row.getIntMark();
    }

    public int getCol() {
        return this._col.getIntMark();
    }

    public CellBlock getMerge(boolean search) {
        MergeBlocks merger;
        CellBlock mergeBlock = null;
        if ((search || this.touchFlag(64)) && (merger = this.getSheet().getMerger(false)) != null) {
            mergeBlock = merger.searchBlock(this.getRow(), this.getCol());
        }
        return mergeBlock;
    }

    public String getName(boolean bAbs, boolean withSheetName) {
        return Cell.getCellName(this.getSheet(), this.getRow(), this.getCol(), bAbs, withSheetName);
    }

    public boolean hasFormula() {
        return this._formula instanceof Expr;
    }

    public boolean isTickFormula() {
        return this._formula instanceof String && ((String)this._formula).charAt(0) == '\'';
    }

    public boolean isBadFormula() {
        return this._formula instanceof String;
    }

    public String getDisplayFormula() {
        Protection pro = this.getSheet().getSheetOption().getProtection(false);
        if (pro != null && pro.isProtected() && this.getStyle().isHided()) {
            return "";
        }
        String formula = this.getFormula();
        if (this.hasFormula()) {
            formula = _pattern.matcher(formula).replaceAll("\\\\n");
        }
        return formula;
    }

    public String getFormula() {
        String formula;
        block15: {
            if (this._formula != null) {
                if (this._formula instanceof Expr) {
                    ExprContext ctx = this.getDeps().getExprContext();
                    Expr expr = (Expr)this._formula;
                    formula = expr.decode(expr.getDecodeList(ctx), ctx, this, true);
                } else {
                    formula = (String)this._formula;
                }
            } else if (this._value == null) {
                formula = "";
                if (SHOW_EmptyCellObj && this.isEmptyContent()) {
                    formula = "\u00a4";
                }
            } else if (this._value.isInvalid()) {
                formula = (String)this._value.getValue();
            } else {
                Variant var = this.getValue(true);
                if (var.isDate()) {
                    try {
                        Date date = var.toDate();
                        if (DataConvert.isZeroTime(date)) {
                            formula = DataConvert.getDateString(date);
                            break block15;
                        }
                        if (DataConvert.isZeroSecond(date)) {
                            formula = DataConvert.getShortDateTimeString(date);
                            break block15;
                        }
                        formula = DataConvert.getDateTimeString(date);
                    }
                    catch (SyntaxErrorException e) {
                        formula = var.toString();
                    }
                } else {
                    formula = var.toString();
                }
            }
        }
        return formula;
    }

    public String getText() {
        if (this.touchFlag(2)) {
            return this._text;
        }
        if (!this.touchFlag(1)) {
            this._text = "";
        } else {
            String numberformat = this.getStyle().getNumberFormat();
            String replacementFormat = this.getReplacementNumberfromat(numberformat);
            if (null != replacementFormat) {
                this.format(this.getValue(), replacementFormat);
            } else {
                this.format(this.getValue(), numberformat);
            }
        }
        this.setFlag(2, true);
        return this._text;
    }

    void format(Variant value, String format) {
        ShareStyleAttributes styleAttributes;
        Sheet sheet;
        ConditionalFormat cf;
        IErrorResultProvider pvd;
        Object o;
        Style style;
        boolean setted = false;
        if (value.isNull() && this._formula != null) {
            this._text = "";
            return;
        }
        StyleAttributes sa = Styles.getEmptySA();
        Format formatObj = this.getSheet().getBook().getFormat(format);
        if (formatObj != null) {
            formatObj.formatStyle(value, sa, false);
        }
        if (!(style = this.getStyle()).hasHorizontalAlign()) {
            if (this.getSheet().getSheetOption().getCellDisplayMode() != 0) {
                sa.setHorizontalAlign(Styles.HorizontalAlignment.LEFT);
            } else if (value.isNumber() || value.isDate()) {
                sa.setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
            } else if (value.getVt() == 8) {
                sa.setHorizontalAlign(Styles.HorizontalAlignment.CENTER);
            } else {
                sa.setHorizontalAlign(Styles.HorizontalAlignment.LEFT);
            }
        }
        if (this.getMerge(false) != null && !style.isWrapText() && value.isString() && StringUtil.isWrapString((String)((String)value.getValue()))) {
            sa.setWrapText(true);
        }
        if (value.isError() && (o = value.getValue()) instanceof SyntaxErrorException && (pvd = this.getDeps().getFunctionManager().getErrorResultProvider()) != null) {
            setted = true;
            this._text = pvd.getText(((SyntaxErrorException)o).getErrorCode());
        }
        if (!setted) {
            this._text = this.getMutableFormat(format).format(value, false).toString();
        }
        if ((cf = (sheet = this.getSheet()).getConditionalFormats().getConditionalFormat(this.getRow(), this.getCol())) != null && (styleAttributes = cf.getShareStyleAttributes(cf.isMatched(sheet, value))) != null) {
            sa.replace(styleAttributes);
            if (sa.getPattern() == Pattern.None) {
                sa.setBackground(null);
                sa.setPattern(null);
            }
        }
        if (!sa.isEmpty()) {
            StyleAttributes newSA = Styles.getSA((ShareStyleAttributes)this.getStyle());
            newSA.replace((ShareStyleAttributes)sa);
            this.setExtStyle(sheet.getBook().getStyle((ShareStyleAttributes)newSA));
        } else {
            this.setExtStyle(null);
        }
        sheet.removeStyleCache(this.getRow(), this.getCol());
    }

    public static boolean isReadOnlyForHyperlink(Cell cell) {
        Variant var = cell.getValue();
        return cell.hasFormula() || !var.isNull() && (var.getVt() == 8 || var.isNumber() || var.isDate());
    }

    public boolean setFormula(String formula) {
        Sheet sheet = this.getSheet();
        if (sheet.isDisposed()) {
            return false;
        }
        this._value = null;
        Book book = sheet.getBook();
        boolean bChanged = false;
        if (StringUtil.isEmptyString((String)formula)) {
            if (this._formula != null) {
                bChanged = true;
                this._formula = null;
            } else if (this._value != null) {
                bChanged = true;
            }
            this._value = null;
            this.setTextEmpty();
            this.setFlag(3, true);
        } else if (!this.hasFormula() || !StringUtil.equals((String)this.getFormula(), (String)formula)) {
            bChanged = true;
            this.setTextEmpty();
            this.setFlag(3, false);
            if (formula.length() > 1 || formula.equals("'")) {
                char firstChar = formula.charAt(0);
                if (firstChar == '\'') {
                    Variant value = new Variant(formula.length() == 1 ? "" : formula.substring(1), 11);
                    this._value = book.getBufferedVariant(value);
                    this._formula = formula;
                    this.setFlag(1, true);
                    this.setFlag(4, false);
                } else if (firstChar == '=') {
                    this.setFlag(4, true);
                    this.parseFormula(formula);
                } else {
                    this.setFlag(1, true);
                    this.setFlag(4, false);
                    this._formula = null;
                    this._value = new Variant(formula, 16384);
                }
            } else {
                this.setFlag(1, true);
                this.setFlag(4, false);
                this._formula = null;
                this._value = new Variant(formula, 16384);
            }
        }
        if (bChanged && book.isCalcCurrentCell() && this.queue(book.getDeps(), book.isAutoCalculate()) > 0) {
            book.calcQueue();
        }
        return bChanged;
    }

    @Override
    public Sheet getSheet() {
        return this._row.getSheet();
    }

    @Override
    public boolean isNeedRecalc() {
        return this.touchFlag(4);
    }

    @Override
    public void setNeedRecalc(boolean bRecalc) {
        this.setFlag(4, bRecalc);
    }

    @Override
    public boolean isCalculating() {
        return this.touchFlag(8);
    }

    @Override
    public void setCalculating(boolean bCalculating) {
        this.setFlag(8, bCalculating);
    }

    public boolean isHasValue() {
        return this.touchFlag(1);
    }

    @Override
    public boolean isQueued() {
        return this.touchFlag(16);
    }

    @Override
    public void setQueued(boolean bQueued) {
        this.setFlag(16, bQueued);
    }

    @Override
    public boolean isIterate() {
        return this.touchFlag(512);
    }

    @Override
    public void setIterate(boolean bIterate) {
        this.setFlag(512, bIterate);
    }

    public boolean isExtendMerge() {
        return this.touchFlag(1024);
    }

    public void setExtendMerge(boolean bExtendMerge) {
        this.setFlag(1024, bExtendMerge);
    }

    public boolean isQueueLast() {
        return this.touchFlag(128);
    }

    @Override
    public void updateExpr(boolean queue) {
        if (this._formula != null) {
            this.parseFormula(this.getFormula());
            if (queue) {
                this.queue();
            }
        }
    }

    @Override
    public Variant getValue() {
        return this.getValue(true);
    }

    public Variant getValue2() {
        return this.getValue(false);
    }

    private Variant getValue(boolean parseDate) {
        Variant var;
        if (this.touchFlag(32)) {
            var = Variant.badReference;
        } else {
            if (!this.touchFlag(1)) {
                if (this._formula instanceof Expr) {
                    Sheet sheet = this.getSheet();
                    if (this.touchFlag(4) && !this.touchFlag(8) && sheet.isEnableCalculation() && sheet.getBook().isAutoCalculate()) {
                        this.setCalculating(true);
                        this.calc(sheet.getDeps().getExprContext());
                        this.setCalculating(false);
                    } else if (!this.touchFlag(520)) {
                        this._value = Variant.calcLast;
                        this.setFlag(128, true);
                    }
                }
            } else if (this._value != null && this._value.isInvalid()) {
                String str = (String)this._value.getValue();
                this._value = var = this.getSheet().getBook().getBufferedVariant(Cell.parseValue(str, this.getStyle().getNumberFormat(), parseDate));
            }
            if ((var = this._value) == null) {
                var = Variant.nullVariant;
            }
        }
        return var;
    }

    public void setValue(Variant value) {
        Cell.reduceScale(value);
        this._value = this.getSheet().getBook().getBufferedVariant(value);
        this.setFlag(1, true);
        this.setFlag(2, false);
        Book book = this.getSheet().getBook();
        if (book.isAutoCalculate() && this.queue(book.getDeps(), book.isAutoCalculate()) > 0) {
            book.calcQueue();
        }
    }

    @Override
    public boolean calc(ExprContext ctx) {
        if (!(this._formula instanceof Expr) || this.touchFlag(32)) {
            this.setFlag(20, false);
            return true;
        }
        if (this._calcUID == ctx.getCalcUID()) {
            return true;
        }
        boolean extensible = ctx.isTraceMode();
        ExtProps thisProps = null;
        if (extensible && (thisProps = this.getExtProps(false)) != null) {
            Sheet sheet = this.getSheet();
            Dependents deps = sheet.getDeps();
            try {
                ExtProps head = thisProps.getHead(true, false);
                if (head != null && !head.isCell00()) {
                    deps.calcReferTo(this, head.getCell());
                }
                if ((head = thisProps.getHead(false, false)) != null && !head.isCell00()) {
                    deps.calcReferTo(this, head.getCell());
                }
            }
            catch (SyntaxErrorException e) {
                return false;
            }
            ExtDataSetManager dm = sheet.getBook().getDataSetManager();
            dm.resetCurrent();
            thisProps.setCurrentGroup();
            dm.resumeCurrent();
        }
        this.setFlag(3, false);
        this.setTextEmpty();
        Variant value = ((Expr)this._formula).execute(ctx, this);
        this._calcUID = ctx.getCalcUID();
        ctx.clearExprUid();
        if (this.isIterate()) {
            if (this._value == null) {
                this._value = value;
                return false;
            }
            if (value.isNumeric()) {
                try {
                    double ori = this._value.doubleValue();
                    double newValue = value.doubleValue();
                    this._value = value;
                    if (Math.abs(newValue - ori) > this.getSheet().getDeps().getMaxChange()) {
                        return false;
                    }
                    this.setIterate(false);
                }
                catch (SyntaxErrorException e) {
                    return false;
                }
            }
        }
        boolean isCalcLast = this.touchFlag(16) || value.isCalcLast();
        this.setFlag(128, isCalcLast);
        if (isCalcLast) {
            return false;
        }
        this.setFlag(1, true);
        boolean pending = value.isPending();
        this.setFlag(4, pending);
        if (!extensible) {
            Cell.reduceScale(value);
            this._value = this.getSheet().getBook().getBufferedVariant(value);
        } else {
            this._value = new Variant(value);
            Cell.reduceScale(this._value);
            this._formula = ctx.getTempRet();
        }
        if (extensible && !pending && thisProps != null) {
            boolean doExtend = thisProps.getExtensible(false) != 0;
            int resultCount = 0;
            extensible = this._value.isArray();
            if (extensible) {
                if (doExtend) {
                    resultCount = ((Object[])this._value.getValue()).length;
                    boolean bl = extensible = resultCount > 0;
                    if (!extensible) {
                        this.setValue(Variant.nullVariant);
                    }
                }
            } else {
                Object var = this._value.getValue();
                if (var instanceof ExtGroup) {
                    ExtGroup grp = (ExtGroup)var;
                    thisProps.setGroup(grp);
                    resultCount = grp.size();
                    boolean bl = extensible = resultCount > 1;
                    if (!extensible) {
                        this.setFormula(null);
                        if (!grp.isNullGroup()) {
                            thisProps.setExtRow(grp.getFirstRow());
                            if (doExtend) {
                                this.setValue(grp.getFirstValue());
                            }
                        } else {
                            ExtRow nullRow = grp.getDataSet().getNullRow();
                            thisProps.setExtRow(nullRow);
                            if (doExtend) {
                                this.setValue(nullRow.getActualValue());
                            }
                        }
                    }
                } else if (var instanceof ExtRow) {
                    this.setFormula(null);
                    ExtRow row = (ExtRow)var;
                    thisProps.setExtRow(row);
                    this.setValue(row.getActualValue());
                    if (row.isNullRow()) {
                        thisProps.setGroup(row.getDataSet().getNullGroup());
                    }
                } else if (this._value.isReferences() && var instanceof CellBlockNode) {
                    this._value = ((IVarReferences)var).getActualValue();
                }
            }
            if (extensible && doExtend) {
                boolean yDir = thisProps.getExtensible(true) == 2;
                thisProps.extend(yDir, resultCount);
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void calcFormulaProps(ExprContext ctx) {
        SortedExtPropFormulasArray formulas;
        if (this._extProps == null || (formulas = this._extProps.getFormulas(false)) == null) {
            return;
        }
        ExtDataSetManager dm = this.getSheet().getBook().getDataSetManager();
        dm.resetCurrent();
        this._extProps.setCurrentGroup();
        dm.resumeCurrent();
        ctx.pushExprOwner(this);
        try {
            int size = formulas.size();
            for (int i = 0; i < size; ++i) {
                ICalculableProps node = (ICalculableProps)formulas.get(i);
                Variant value = node.calc(ctx, this);
                node.getAction().action(this, value);
            }
        }
        finally {
            ctx.popExprOwner();
        }
    }

    @Override
    public Expr getExpr() {
        return this._formula instanceof Expr ? (Expr)this._formula : null;
    }

    @Override
    public void setExpr(Expr expr) {
        if (expr != null && !expr.isSyntaxError()) {
            this._formula = expr;
            this._value = null;
            this.setFlag(3, false);
            this.setFlag(4, true);
        }
    }

    public boolean isFirstMergedCell() {
        return this.touchFlag(64);
    }

    public void setMerged(boolean merged) {
        this.setFlag(64, merged);
    }

    public SortedUserObjectArray getUserObjects(boolean bCreate) {
        if (this._extData == null) {
            if (!bCreate) {
                return null;
            }
            this._extData = new ExtData();
            this._extData._userObjects = new SortedUserObjectArray();
        }
        if (this._extData._userObjects == null && bCreate) {
            this._extData._userObjects = new SortedUserObjectArray();
        }
        return this._extData._userObjects;
    }

    void setUserObjects(SortedUserObjectArray userObjects) {
        if (userObjects != null) {
            if (this._extData == null) {
                this._extData = new ExtData();
            }
            this._extData._userObjects = userObjects;
        } else if (this._extData != null) {
            this._extData._userObjects = null;
            if (this._extData._extStyle == null && this._extData.isEmptyContent()) {
                this._extData = null;
            }
        }
    }

    SortedUserObjectArray getExtObjects(boolean bCreate) {
        if (this._extData == null) {
            if (!bCreate) {
                return null;
            }
            this._extData = new ExtData();
            this._extData._extObjects = new SortedUserObjectArray();
        }
        if (this._extData._extObjects == null && bCreate) {
            this._extData._extObjects = new SortedUserObjectArray();
        }
        return this._extData._extObjects;
    }

    void setExtObjects(SortedUserObjectArray extObjects) {
        if (extObjects != null) {
            if (this._extData == null) {
                this._extData = new ExtData();
            }
            this._extData._extObjects = extObjects;
        } else if (this._extData != null) {
            this._extData._extObjects = null;
            if (this._extData._extStyle == null && this._extData.isEmptyContent()) {
                this._extData = null;
            }
        }
    }

    public int queue(Dependents deps, boolean queueRefer) {
        return deps.queue(this, queueRefer);
    }

    public int queue() {
        if (this.touchFlag(16)) {
            return 0;
        }
        Book book = this.getSheet().getBook();
        return this.queue(book.getDeps(), book.isAutoCalculate());
    }

    void setExtObject(String key, Object value) {
        this.getExtObjects(true).insertByKey(new UserObject(key, value));
    }

    Object getExtObject(String key) {
        int index;
        SortedUserObjectArray extObjects = this.getExtObjects(false);
        if (extObjects != null && (index = extObjects.searchByKey(key)) >= 0) {
            return extObjects.getUserObject(index).getValue();
        }
        return null;
    }

    public void clearExtObject(String key) {
        int index;
        SortedUserObjectArray extObjects = this.getExtObjects(false);
        if (extObjects != null && (index = extObjects.searchByKey(key)) >= 0) {
            extObjects.removeByPos(index);
            if (extObjects.isEmpty()) {
                this.setExtObjects(null);
            }
        }
    }

    UserObject setUserObject(UserObject uo) {
        return this.getUserObjects(true).insertByKey(uo);
    }

    private String[] getKeepKeys() {
        String[] keepKeys = null;
        Book.IUserObjectProvider provider = this.getSheet().getBook().getUserObjectsProvider();
        if (provider != null) {
            keepKeys = provider.getKeepKeys();
        }
        return keepKeys;
    }

    private SortedUserObjectArray getNewUserObjects(SortedUserObjectArray oldUserObjects, String[] userKeys, boolean forclear) {
        String[] keepKeys;
        if (!(oldUserObjects == null || oldUserObjects.isEmpty() || (keepKeys = this.getKeepKeys()) != null && keepKeys.length == 0)) {
            int i;
            SortedUserObjectArray newUserObjects = null;
            if (userKeys.length == 0) {
                if (keepKeys != null) {
                    int size = keepKeys.length;
                    for (i = 0; i < size; ++i) {
                        UserObject uo = oldUserObjects.getUserObject(keepKeys[i]);
                        if (uo == null) continue;
                        if (newUserObjects == null) {
                            newUserObjects = new SortedUserObjectArray();
                        }
                        newUserObjects.insert(uo);
                    }
                }
            } else {
                newUserObjects = this.getCopyUserObjects(oldUserObjects);
                if (keepKeys == null) {
                    for (i = 0; i < userKeys.length; ++i) {
                        newUserObjects.removeByKey(userKeys[i]);
                    }
                } else {
                    for (i = 0; i < userKeys.length; ++i) {
                        int j;
                        for (j = 0; !(j >= keepKeys.length || keepKeys[j] != null && keepKeys[j].equals(userKeys[i])); ++j) {
                        }
                        if (j != keepKeys.length) continue;
                        newUserObjects.removeByKey(userKeys[i]);
                    }
                }
            }
            if (forclear) {
                return newUserObjects;
            }
            if (newUserObjects != null && newUserObjects.size() == oldUserObjects.size()) {
                return null;
            }
            if (newUserObjects == null) {
                return this.getCopyUserObjects(oldUserObjects);
            }
            SortedUserObjectArray newUserObjects2 = this.getCopyUserObjects(oldUserObjects);
            int size = newUserObjects.size();
            for (int i2 = 0; i2 < size; ++i2) {
                newUserObjects2.removeByKey(newUserObjects.getUserObject(i2).getKey());
            }
            return newUserObjects2;
        }
        return null;
    }

    Cell clear(boolean formula, boolean value, boolean style, boolean comment, String[] userKeys) {
        SortedUserObjectArray extObjects;
        SortedUserObjectArray newUserObjects;
        SortedUserObjectArray oldUserObjects;
        Cell changedProps = new Cell(this._row, this._col);
        boolean changed = false;
        if (!(userKeys == null || (oldUserObjects = this.getUserObjects(false)) == null || oldUserObjects.isEmpty() || (newUserObjects = this.getNewUserObjects(oldUserObjects, userKeys, true)) != null && newUserObjects.size() == oldUserObjects.size())) {
            changedProps.setUserObjects(oldUserObjects);
            this.setUserObjects(newUserObjects);
            changed = true;
        }
        boolean isNewExtProps = false;
        if (style) {
            if (this.clearFormatsExtProps(changedProps, isNewExtProps)) {
                changed = true;
                isNewExtProps = true;
            }
            if (!this._ssa.isEmpty()) {
                changedProps._ssa = this._ssa;
                this._ssa = Styles.getEmptySSA();
                this._style = null;
                this.setFlag(2, false);
                changed = true;
            }
            this._ssa.setDirty(Style.getAllBorderBits());
            Borders bdrs = this.getSheet().getBorders().setBySA(CellBlock.getCellBlock(this.getRow(), this.getCol()), Styles.getSA((ShareStyleAttributes)this._ssa), Styles.getEmptySA(), true);
            changedProps.setUserObject("BDR", bdrs);
        }
        if ((formula || value) && (this._formula != null || this._value != null)) {
            changedProps._formula = this._formula;
            changedProps._value = this._value;
            changedProps._flags = this._flags;
            changedProps._text = this._text;
            if (formula && value) {
                this._formula = null;
                this._value = null;
                this._text = "";
                this.setFlag(1, false);
                this.setFlag(2, false);
            } else if (formula) {
                this._formula = null;
            } else if (value && this._formula == null) {
                this._value = null;
                this._text = "";
                this.setFlag(1, false);
                this.setFlag(2, false);
            }
            this.queue();
            changed = true;
        }
        if (comment && value) {
            extObjects = this.getExtObjects(false);
            if (extObjects != null) {
                changedProps.setExtObjects(extObjects);
                this.setExtObjects(null);
                changed = true;
            }
            this._extProps = this.getExtProps(false);
            if (this._extProps != null) {
                if (!isNewExtProps) {
                    changedProps._extProps = this._extProps;
                    isNewExtProps = true;
                }
                this._extProps = null;
                changed = true;
            }
        } else if (comment) {
            if (this.getComment() != null) {
                changedProps.getExtObjects(true).insert(this.getExtObjects(false).removeByKey(KEY_COMMENT));
                changed = true;
            }
        } else if (value && (extObjects = this.getExtObjects(false)) != null) {
            UserObject sr;
            UserObject dh;
            SortedUserObjectArray propsExtObjects = changedProps.getExtObjects(true);
            UserObject hl = extObjects.removeByKey(KEY_HYPERLINK);
            if (hl != null) {
                propsExtObjects.insertByKey(hl);
            }
            this._extProps = this.getExtProps(false);
            if (this._extProps != null) {
                if (!isNewExtProps) {
                    changedProps._extProps = this._extProps;
                    isNewExtProps = true;
                }
                this._extProps = null;
            }
            if ((dh = extObjects.removeByKey(KEY_DIAGONAL)) != null) {
                propsExtObjects.insertByKey(dh);
            }
            if ((sr = extObjects.removeByKey(KEY_SUBRPT)) != null) {
                propsExtObjects.insertByKey(sr);
            }
            changed = true;
        }
        return changed ? changedProps : null;
    }

    void resumeClear(Cell changedProps, boolean formula, boolean value, boolean style, boolean comment, String[] userKeys) {
        SortedUserObjectArray propsExtObjects;
        if (changedProps.getUserObjects(false) != null) {
            this.setUserObjects(changedProps.getUserObjects(false));
        }
        if (style) {
            if (changedProps._ssa != null) {
                this.setSSA(changedProps._ssa);
            }
            this.resumeBorders(changedProps);
        }
        if (formula || value) {
            this._formula = changedProps._formula;
            this._value = changedProps._value;
            this._text = changedProps._text;
            this._flags = changedProps._flags;
        }
        if (comment && value) {
            this.setExtObjects(changedProps.getExtObjects(false));
            this._extProps = changedProps._extProps;
        } else if (comment) {
            UserObject uo;
            SortedUserObjectArray propsExtObjects2 = changedProps.getExtObjects(false);
            if (propsExtObjects2 != null && (uo = propsExtObjects2.getUserObject(KEY_COMMENT)) != null) {
                this.getExtObjects(true).insert(uo);
            }
        } else if (value && (propsExtObjects = changedProps.getExtObjects(false)) != null) {
            UserObject sr;
            SortedUserObjectArray extObjects = this.getExtObjects(true);
            UserObject hl = propsExtObjects.getUserObject(KEY_HYPERLINK);
            this._extProps = changedProps._extProps;
            UserObject dh = propsExtObjects.getUserObject(KEY_DIAGONAL);
            if (hl != null) {
                extObjects.insertByKey(hl);
            }
            if (dh != null) {
                extObjects.insertByKey(dh);
            }
            if ((sr = propsExtObjects.getUserObject(KEY_SUBRPT)) != null) {
                extObjects.insertByKey(sr);
            }
        }
        if (value && (this._ssa == null || this._ssa.isEmpty() || this._ssa.getHorizontalAlign() == Styles.HorizontalAlignment.NORMAL)) {
            this.setFlag(2, false);
        }
    }

    private SortedUserObjectArray getCopyUserObjects(SortedUserObjectArray userObjects, boolean bExt) {
        Book.IUserObjectProvider pd = this.getSheet().getBook().getUserObjectsProvider();
        SortedUserObjectArray so = new SortedUserObjectArray();
        int size = userObjects.size();
        for (int i = 0; i < size; ++i) {
            UserObject uo = userObjects.getUserObject(i);
            UserObject nuo = new UserObject(uo.getKey());
            if (bExt || pd == null) {
                nuo.setValue(uo.getValue());
            } else {
                nuo.setValue(pd.getObject(uo.getKey(), pd.getString(uo.getKey(), uo.getValue())));
            }
            so.insert(nuo);
        }
        return so;
    }

    private SortedUserObjectArray getCopyUserObjects(SortedUserObjectArray userObjects) {
        return this.getCopyUserObjects(userObjects, false);
    }

    Cell copyFrom(Cell src, PasteMode mode, boolean needCalc, String[] userKeys, boolean bProtected) {
        Object v;
        Cell changedProps = new Cell(this._row, this._col);
        boolean changed = false;
        this.setExtStyle(null);
        if (userKeys != null) {
            SortedUserObjectArray userObjects = this.getUserObjects(false);
            changedProps.setUserObjects(userObjects);
            SortedUserObjectArray newUserObjects = this.getNewUserObjects(src.getUserObjects(false), userKeys, false);
            if (newUserObjects != null && newUserObjects.size() != 0) {
                if (userObjects != null && userObjects.size() != 0) {
                    SortedUserObjectArray newUserObjets2 = this.getCopyUserObjects(userObjects);
                    newUserObjets2.insertAll(newUserObjects);
                    this.setUserObjects(newUserObjets2);
                } else {
                    this.setUserObjects(newUserObjects);
                }
            }
        }
        boolean bFormats = mode.touchFlag(PasteMode.Formats);
        boolean bFormula = mode.touchFlag(PasteMode.Formulas);
        boolean bValue = mode.touchFlag(PasteMode.Values);
        boolean bComment = mode.touchFlag(PasteMode.Comments);
        boolean bExt = mode.touchFlag(PasteMode.ExtObjectsExceptComments);
        if (bComment && bExt) {
            SortedUserObjectArray extObjects = this.getExtObjects(false);
            SortedUserObjectArray srcExtObjects = src.getExtObjects(false);
            if (extObjects != null || srcExtObjects != null) {
                changedProps.setExtObjects(extObjects);
                this.setExtObjects(srcExtObjects != null ? this.getCopyUserObjects(srcExtObjects, true) : null);
                changed = true;
            }
        } else if (bComment) {
            Comment comment = this.getComment();
            Comment newcomment = src.getComment();
            if (comment != null || newcomment != null) {
                changedProps.setComment(comment);
                this.setComment(newcomment != null ? newcomment.getCopy() : null);
                changed = true;
            }
        } else if (bExt) {
            // empty if block
        }
        boolean isNewExtProps = false;
        Object srcFormula = src._formula;
        if (bFormula || bValue) {
            changedProps._formula = this._formula instanceof Expr ? ((Expr)this._formula).clone() : this._formula;
            changedProps._value = this._value;
            changedProps._text = this._text;
            changedProps._flags = this._flags;
            changed = true;
            if (bFormula) {
                if (!isNewExtProps) {
                    changedProps._extProps = this._extProps;
                    isNewExtProps = true;
                }
                this._extProps = this.copyExtProps(src._extProps);
                if (srcFormula instanceof Expr) {
                    if (needCalc) {
                        this.setFlag(1, false);
                    }
                    Sheet thisSheet = this.getSheet();
                    Expr srcExpr = (Expr)srcFormula;
                    if (srcExpr != null) {
                        boolean bOffset = !mode.touchFlag(PasteMode.NoOffset);
                        IExprNode[] nodes = srcExpr.getAllNodes();
                        for (int i = nodes.length - 1; i >= 0; --i) {
                            IExprNode node = nodes[i];
                            if (node instanceof CellBlockNode) {
                                int offsetY;
                                int offsetX;
                                CellBlockNode newNode;
                                if (node instanceof CellBlock3DNode) {
                                    CellBlock3DNode cb3 = (CellBlock3DNode)node;
                                    newNode = (CellBlock3DNode)cb3.clone();
                                    if (bOffset) {
                                        offsetX = cb3.isRow() ? 0 : this.getCol() - src.getCol();
                                        offsetY = cb3.isCol() ? 0 : this.getRow() - src.getRow();
                                        newNode.offset(offsetY, offsetX);
                                    }
                                    newNode.setRefs(null);
                                    nodes[i] = newNode.getSheet().setDependent(this, newNode);
                                    continue;
                                }
                                CellBlockNode cb = (CellBlockNode)node;
                                newNode = (CellBlockNode)cb.clone();
                                if (bOffset) {
                                    offsetX = cb.isRow() ? 0 : this.getCol() - src.getCol();
                                    offsetY = cb.isCol() ? 0 : this.getRow() - src.getRow();
                                    newNode.offset(offsetY, offsetX);
                                }
                                if (cb.getSheet() == src.getSheet()) {
                                    newNode.setSheet(thisSheet);
                                }
                                newNode.setRefs(null);
                                nodes[i] = newNode.getSheet().setDependent(this, newNode);
                                continue;
                            }
                            if (node instanceof ExprUID) {
                                nodes[i] = ExprUID.getNewInstance();
                                continue;
                            }
                            if (node instanceof ExprUnknownMethod) {
                                ExprUnknownMethod unknown = (ExprUnknownMethod)node;
                                this.getDeps().getUnknownMethodManager().getUnknownFunction(unknown.getMethodName(), unknown.getParamCount());
                                continue;
                            }
                            if (!(node instanceof ExprContext)) continue;
                            nodes[i] = this.getDeps().getExprContext();
                        }
                        Expr newExpr = Expr.getExpr(this.getDeps(), nodes, srcExpr.getExprNodeState(), 0, nodes.length);
                        this._formula = newExpr;
                    }
                    if (bValue) {
                        Variant srcValue;
                        Variant variant = srcValue = src._value == null ? null : src._value.getCopy();
                        if (srcValue != null && !srcValue.isError() && !srcValue.isNull()) {
                            this._value = srcValue;
                            this.setFlag(1, true);
                        }
                    }
                } else {
                    this._formula = src._formula;
                    this._value = src._value == null ? null : src._value.getCopy();
                    this._text = src._text;
                    this._flags = src._flags;
                }
                if (needCalc) {
                    this.setFlag(4, true);
                    this.setFlag(2, false);
                    this.queue();
                }
            } else {
                v = src.getValue();
                if (null != v && ((Variant)v).isCalcLast()) {
                    v = Variant.nullVariant;
                }
                this.setValue((Variant)v);
            }
        }
        if (bFormats) {
            Style srcStyle = src.getMerge(false) == null ? src.getStyle() : this.getSheet().getBook().getStyle((ShareStyleAttributes)Cell.getBubbleSA(src._ssa, src.getSheet(), src.getRow(), src.getCol(), null));
            this.setFlag(2, false);
            changed |= this.copyExtPropsOfFormats(changedProps, src._extProps, isNewExtProps);
            changed |= this.copyStyle(srcStyle, null, mode, changedProps, bProtected) != null;
        }
        if ((v = src.getSheet().getValidations().getValidate(src.getSheet(), src.getRow(), src.getCol())) != null) {
            SortedCellBlockArray sa = new SortedCellBlockArray();
            sa.insert(new CellBlock(this.getRow(), this.getCol(), this.getRow(), this.getCol()));
            this.getSheet().getValidations().insertValidation(this.getSheet(), (MessagedValidate)v, sa);
        }
        return changed ? changedProps : null;
    }

    void resumeCopyFrom(Cell src, PasteMode mode, String[] userKeys) {
        this.setExtStyle(null);
        if (src.getUserObjects(false) != null) {
            this.setUserObjects(src.getUserObjects(false));
        }
        boolean bFormula = mode.touchFlag(PasteMode.Formulas);
        boolean bValue = mode.touchFlag(PasteMode.Values);
        boolean bComment = mode.touchFlag(PasteMode.Comments);
        boolean bExt = mode.touchFlag(PasteMode.ExtObjectsExceptComments);
        if (bComment && bExt) {
            this.setExtObjects(src.getExtObjects(false));
        } else if (bComment) {
            this.setComment(src.getComment());
        } else if (bExt) {
            // empty if block
        }
        if (bFormula || bValue) {
            this._formula = src._formula;
            this._value = src._value;
            this._text = src._text;
            this._flags = src._flags;
        }
        if (mode.touchFlag(PasteMode.Formats)) {
            if (src._ssa != null) {
                this.setSSA(src._ssa);
                this.setFlag(2, false);
            }
            this.resumeBorders(src);
            this._extProps = src._extProps;
        }
    }

    private void resumeBorders(Cell src) {
        Borders bdrs = (Borders)src.getUserObjectValue("BDR");
        if (bdrs != null) {
            src.removeUserObject("BDR");
            this.getSheet().getBorders().set(bdrs);
        }
    }

    ShareStyleAttributes copyStyle(Style srcStyle, CellBlock srcMergeBlock, PasteMode mode, Cell changedProps, boolean bProtected) {
        ShareStyleAttributes old = this._ssa;
        StyleAttributes sa = null;
        StyleAttributes saBubble = null;
        if (mode.touchFlag(PasteMode.Style)) {
            sa = Styles.getSA((ShareStyleAttributes)srcStyle);
            saBubble = Cell.getBubbleSA(Styles.getEmptySSA(), this.getSheet(), this.getRow(), this.getCol(), srcMergeBlock);
            if (bProtected) {
                sa.setLocked(false);
            }
            sa.clearAttributes(sa.sameBits((ShareStyleAttributes)saBubble, 0, ShareStyleAttributes.ATTRS_COUNT));
            if (!mode.touchFlag(PasteMode.Borders)) {
                sa.clearBorderAttribures();
            } else {
                if (!sa.hasBorder(Styles.Position.LEFT)) {
                    sa.clearBorderAttribures(Styles.Position.LEFT, true);
                }
                if (!sa.hasBorder(Styles.Position.TOP)) {
                    sa.clearBorderAttribures(Styles.Position.TOP, true);
                }
                if (!sa.hasBorder(Styles.Position.RIGHT)) {
                    sa.clearBorderAttribures(Styles.Position.RIGHT, true);
                }
                if (!sa.hasBorder(Styles.Position.BOTTOM)) {
                    sa.clearBorderAttribures(Styles.Position.BOTTOM, true);
                }
            }
        } else if (mode.touchFlag(PasteMode.NumberFormats) && !mode.touchFlag(PasteMode.Borders) && !srcStyle.getNumberFormat().equals(this._ssa.getNumberFormat())) {
            sa = Styles.getSA((ShareStyleAttributes)this._ssa);
            sa.setNumberFormat(srcStyle.getNumberFormat());
        }
        boolean changed = false;
        if (sa != null) {
            ShareStyleAttributes ssa;
            if (changedProps != null) {
                changedProps._ssa = this._ssa;
            }
            if (this._ssa != (ssa = Styles.getSSA((StyleAttributes)sa))) {
                changed = true;
                this.setSSA(ssa);
            }
        }
        return changed ? old : null;
    }

    private Borders getBorders(StyleAttributes saBubble, Style srcStyle) {
        StyleAttributes srcSA = Styles.getSA((ShareStyleAttributes)srcStyle);
        srcSA.setDirty(StyleAttributes.getAllBorderBits());
        Borders bdrs = this.getSheet().getBorders();
        return bdrs.setBySA(CellBlock.getCellBlock(this.getRow(), this.getCol()), srcSA, Styles.getEmptySA(), true);
    }

    public ExtProps copyExtProps(ExtProps srcProps) {
        if (srcProps == null) {
            return null;
        }
        ExtProps dstProps = (ExtProps)srcProps.clone();
        Cell cell = srcProps.getSheet().getCell(this.getRow(), this.getCol(), false);
        if (cell != null && cell.getExtProps(false) != null && cell.getExtProps(false).getSubs() != null) {
            Object clone = cell.getExtProps(false).getSubs().clone();
            dstProps.setSubs((SortedExtPropsArray)clone);
        }
        dstProps.setCell(this);
        SortedExtPropFormulasArray formulas = srcProps.getFormulas(false);
        if (formulas == null) {
            return dstProps;
        }
        dstProps.setFormulas((SortedExtPropFormulasArray)formulas.clone());
        formulas = dstProps.getFormulas(false);
        ICalculableProps prop = formulas.get(ExtConst.FORMULA_HYPERLINK);
        if (prop != null) {
            InnerLinkTargets innerTars;
            ArrayList<InnerLinkTransitionTarget> cTargets;
            prop = (ICalculableProps)prop.clone();
            formulas.set(formulas.search(ExtConst.FORMULA_HYPERLINK), prop);
            HyperlinkCalculableProps hyperLinkCalProps = (HyperlinkCalculableProps)prop;
            HashMap tars = hyperLinkCalProps.getTargets();
            tars = (HashMap)tars.clone();
            hyperLinkCalProps.setTargets(tars);
            ETTargets repTars = (ETTargets)tars.get("EXTRPT");
            if (repTars != null) {
                repTars = (ETTargets)repTars.clone();
                tars.put("EXTRPT", repTars);
                List targets = repTars.getTargets();
                cTargets = new ArrayList<InnerLinkTransitionTarget>();
                repTars.setTargets(cTargets);
                for (ExtTransitionTarget target : targets) {
                    ExtTransitionTarget targetCopy = target.getDeepCopy();
                    if (target == repTars.getDefaultTarget()) {
                        repTars.setDefaultTarget(targetCopy);
                    }
                    Map params = targetCopy.getParameters();
                    this.fixParams(params);
                    cTargets.add((InnerLinkTransitionTarget)((Object)targetCopy));
                }
            }
            if (null != (innerTars = (InnerLinkTargets)tars.get("EXT_INNER"))) {
                innerTars = (InnerLinkTargets)innerTars.clone();
                tars.put("EXT_INNER", innerTars);
                cTargets = new ArrayList();
                List<InnerLinkTransitionTarget> targets = innerTars.getTargets();
                for (InnerLinkTransitionTarget target : targets) {
                    InnerLinkTransitionTarget targetCopy = target.getDeepCopy();
                    Map<String, IParameter> params = targetCopy.getParams();
                    this.fixParams(params);
                    InnerLinkTargetProperties props = targetCopy.getTargetProps();
                    props = (InnerLinkTargetProperties)props.clone();
                    Expr oldExpr = props.getExpr();
                    if (null != oldExpr && null != cell) {
                        this.buildInnerLinkExtProps(oldExpr, cell, props);
                    }
                    Expr fixExpr = this.fixExpr(oldExpr);
                    props.setExpr(fixExpr);
                    targetCopy.setTargetProps(props);
                    cTargets.add(targetCopy);
                    if (target != innerTars.getDefaultTarget()) continue;
                    innerTars.setDefaultTarget(targetCopy);
                }
                innerTars.setTargets(cTargets);
            }
        }
        return dstProps;
    }

    private void fixParams(Map params) {
        for (Map.Entry entry : params.entrySet()) {
            ICalculableProps p = (ICalculableProps)entry.getValue();
            if (!(p instanceof ParameterImpl)) continue;
            ParameterImpl pi = (ParameterImpl)p;
            Expr oldExpr = (pi = (ParameterImpl)pi.clone()).getExpr();
            if (null == oldExpr) continue;
            Expr fixExpr = this.fixExpr(oldExpr);
            pi.setExpr(fixExpr);
            entry.setValue(pi);
        }
    }

    private void buildInnerLinkExtProps(Expr oldExpr, Cell cell, InnerLinkTargetProperties props) {
        String cellName = oldExpr.decode(cell.getSheet().getDeps().getExprContext(), cell);
        if (!StringUtil.isEmptyString((String)cellName) && cellName.indexOf("!") < 0) {
            cellName = this.getSheet().getSyntaxName() + "!" + cellName;
        }
        props.setId(cell, cellName);
        String name = props.getName();
        if (!StringUtil.isEmptyString((String)name) && name.indexOf("]") > -1) {
            int index = name.indexOf("]");
            name = name.substring(index + 1);
            StringBuilder sb = new StringBuilder();
            sb.append("[").append(cellName).append("]").append(name);
            props.setName(sb.toString());
        }
    }

    private Expr fixExpr(Expr oldExpr) {
        Expr dstExpr = null;
        if (null == oldExpr) {
            return null;
        }
        IExprNode[] nodes = oldExpr.getAllNodes();
        for (int j = nodes.length - 1; j >= 0; --j) {
            IExprNode node = nodes[j];
            if (node.getExprType() != 4) continue;
            CellBlockNode newNode = (CellBlockNode)((CellBlockNode)node).clone();
            newNode.setSheet(this.getSheet());
            newNode.setRefs(null);
            nodes[j] = newNode.getSheet().setDependent(this, newNode);
        }
        dstExpr = Expr.getExpr(this.getDeps(), nodes, oldExpr.getExprNodeState(), 0, nodes.length);
        return dstExpr;
    }

    private boolean copyExtPropsOfFormats(Cell changedProps, ExtProps srcProps, boolean isNewExtProps) {
        SortedExtPropFormulasArray dstFormulas;
        SortedExtPropFormulasArray formulas;
        if (srcProps == null && this._extProps == null) {
            return false;
        }
        SortedExtPropFormulasArray array = null;
        if (srcProps == null && this._extProps != null) {
            return this.clearFormatsExtProps(changedProps, isNewExtProps);
        }
        boolean isChange = false;
        ExtProps cpySrcProps = (ExtProps)srcProps.clone();
        ExtProps extProps = this.getExtProps(false);
        if (extProps != null && extProps.getSubs() != null) {
            Object clone = extProps.getSubs().clone();
            cpySrcProps.setSubs((SortedExtPropsArray)clone);
        }
        if ((formulas = cpySrcProps.getFormulas(true)) != null) {
            array = (SortedExtPropFormulasArray)formulas.cloneSuper();
            for (int i = array.size() - 1; i >= 0; --i) {
                ICalculableProps calcProps = (ICalculableProps)array.getArray()[i];
                if (calcProps != null && calcProps.getAction() != null && calcProps.getAction().isFormatAction()) {
                    array.getArray()[i] = ((ICalculableProps)array.getArray()[i]).clone();
                    isChange = true;
                    continue;
                }
                array.removeByPos(i);
            }
        }
        if (this._extProps != null && (dstFormulas = this._extProps.getFormulas(false)) != null) {
            for (int j = dstFormulas.size() - 1; j >= 0; --j) {
                ICalculableProps calcProps = (ICalculableProps)dstFormulas.getArray()[j];
                if (calcProps == null || calcProps.getAction() == null || calcProps.getAction().isFormatAction()) continue;
                array.append(calcProps);
            }
        }
        cpySrcProps.setFormulas(array);
        if (!isNewExtProps) {
            changedProps._extProps = this._extProps;
        }
        this._extProps = cpySrcProps;
        this._extProps.setCell(this);
        return isChange;
    }

    private boolean clearFormatsExtProps(Cell changedProps, boolean isNewExtProps) {
        boolean isChange = false;
        if (this._extProps == null) {
            return isChange;
        }
        SortedExtPropFormulasArray array = this._extProps.getFormulas(false);
        if (array == null) {
            return isChange;
        }
        ExtProps cpySrcProps = (ExtProps)this._extProps.clone();
        SortedExtPropFormulasArray formulas = cpySrcProps.getFormulas(false);
        if (formulas != null) {
            array = (SortedExtPropFormulasArray)formulas.cloneSuper();
            for (int i = array.size() - 1; i >= 0; --i) {
                ICalculableProps calcProps = (ICalculableProps)array.getArray()[i];
                if (calcProps == null || calcProps.getAction() == null || !calcProps.getAction().isFormatAction()) continue;
                array.removeByPos(i);
                isChange = true;
            }
            cpySrcProps.setFormulas(array);
        }
        if (!isNewExtProps) {
            changedProps._extProps = this._extProps;
        }
        if (isChange) {
            this._extProps = cpySrcProps;
        }
        return isChange;
    }

    public void updateStyle() {
        this._style = null;
        if (this._extData != null && this._extData._extStyle != null) {
            if (!this.touchFlag(256)) {
                this.setFlag(2, false);
            }
            this._extData._extStyle = null;
        }
        if (!this.touchFlag(256)) {
            this.setFlag(2, false);
        }
    }

    public Row getRowObject() {
        return this._row;
    }

    void setRowObject(Row row) {
        this._row = row;
    }

    Column getColObject() {
        return this._col;
    }

    void setColObject(Column col) {
        this._col = col;
    }

    void setVar(Object var) {
        this._formula = var;
        this.setFlag(2, false);
    }

    int getFlags() {
        return this._flags;
    }

    void setFlags(int flags) {
        this._flags = flags;
    }

    private boolean touchFlag(int flag) {
        return (this._flags & flag) != 0;
    }

    void setFlag(int flag, boolean set) {
        this._flags = set ? (this._flags |= flag) : (this._flags &= ~flag);
    }

    public void setFormatted(boolean formatted) {
        this.setFlag(2, formatted);
    }

    void setDeleted(boolean bDelete) {
        this.setFlag(32, bDelete);
    }

    private Style getExtStyle() {
        return this._extData == null ? null : this._extData._extStyle;
    }

    private void setExtStyle(Style style) {
        if (style != null) {
            if (this._extData == null) {
                this._extData = new ExtData();
            }
            this._extData._extStyle = style;
        } else if (this._extData != null) {
            this._extData._extStyle = null;
            if (this._extData.isEmptyContent()) {
                this._extData = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parseFormula(String formula) {
        Dependents deps = this.getSheet().getDeps();
        Parser psr = deps.getParser();
        try {
            psr.parse(this, formula);
            Expr expr = psr.getExpr();
            this._formula = expr.isSyntaxError() ? formula : expr;
        }
        finally {
            deps.recycleParser(psr);
        }
    }

    private void setTextEmpty() {
        this._text = "";
    }

    private Format getMutableFormat(String fmt) {
        Variant value;
        Book book = this.getSheet().getBook();
        if (StringUtil.isEmptyString((String)fmt) && (value = this.getValue()).isDate()) {
            Calendar cal = null;
            try {
                cal = value.toCalendar();
                long curMillis = cal.getTimeInMillis();
                long v = curMillis % 86400000L;
                if (v == 0L) {
                    return book.getFormat("yyyy-m-d");
                }
                if (v == curMillis) {
                    return book.getFormat("h:mm");
                }
                return book.getFormat("yyyy-m-d h:mm");
            }
            catch (SyntaxErrorException syntaxErrorException) {
                // empty catch block
            }
        }
        return book.getFormat(fmt);
    }

    private Dependents getDeps() {
        return this.getSheet().getDeps();
    }

    public ExtProps getExtProps(boolean bCreate) {
        if (this._extProps == null && bCreate) {
            this._extProps = new ExtProps(this);
        }
        return this._extProps;
    }

    public void setExtProps(ExtProps props) {
        this._extProps = props;
    }

    public ExtProps getExtProps(ExtProps src) {
        if (this._extProps == null) {
            this._extProps = (ExtProps)src.clone();
            this._extProps.setCell(this);
        }
        return this._extProps;
    }

    @Override
    public int getCalculableType() {
        return 4;
    }

    public boolean isUnknownMethod() {
        if (this._formula instanceof Expr) {
            return ((Expr)this._formula).hasUnknownMethod();
        }
        return false;
    }

    public SubReportInfo getSubReportInfo() {
        Object o = this.getExtObject(KEY_SUBRPT);
        if (o instanceof SubReportInfo) {
            return (SubReportInfo)o;
        }
        return null;
    }

    public void setSubReportInfo(SubReportInfo reportInfo) {
        this.setExtObject(KEY_SUBRPT, reportInfo);
    }

    public void updateValueType() {
        Variant var = this.getValue();
        if (var == null || var.getValue() == null) {
            return;
        }
        if (var.getVt() == 13) {
            return;
        }
        this._value = var = Cell.parseValue(String.valueOf(var.getValue()), this.getStyle().getNumberFormat(), true);
    }

    private String getReplacementNumberfromat(String plainNumberformat) {
        if (StringUtil.isEmptyString((String)plainNumberformat)) {
            return null;
        }
        for (int i = 0; i < WRONG_NUMBERFORMATS.length; ++i) {
            if (!WRONG_NUMBERFORMATS[i].equals(plainNumberformat)) continue;
            return REPLACEMENT_NUMBERFORMATS[i];
        }
        return null;
    }

    static class ExtData {
        public Style _extStyle;
        public SortedUserObjectArray _extObjects;
        public SortedUserObjectArray _userObjects;

        ExtData() {
        }

        public boolean isEmptyContent() {
            return !(this._extObjects != null && !this._extObjects.isEmpty() || this._userObjects != null && !this._userObjects.isEmpty());
        }
    }

    static class ContentType {
        ContentType() {
        }
    }
}

