/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.kds.model.struct;

import com.kingdee.bos.ctrl.kds.model.struct.Book;
import com.kingdee.bos.ctrl.kds.model.struct.CellBlock;
import com.kingdee.bos.ctrl.kds.model.struct.Sheet;
import com.kingdee.bos.ctrl.kds.model.util.SortedCellBlockArray;
import com.kingdee.bos.ctrl.kds.model.util.SortedSheetArray;

public class KDClipboard {
    private static Book _clipBook = new Book("copy");
    private static SortedSheetArray _srcSheets;
    private static SortedCellBlockArray _sel;
    private static boolean _bSpreadSheet;
    private static boolean _bOffset;
    private static boolean _bCut;
    private static byte[] _uuid;

    public static boolean isEnableSpreadSheet() {
        return _bSpreadSheet;
    }

    public static void enableSpreadSheet(boolean enable) {
        _bSpreadSheet = enable;
    }

    public static boolean canPaste() {
        return _sel.size() > 0;
    }

    public static void clear() {
        _clipBook.clear();
        _sel.clear();
        _srcSheets = null;
    }

    public static SortedSheetArray getSourceSheets() {
        return _srcSheets;
    }

    public static SortedCellBlockArray getSourceSelection() {
        return _sel;
    }

    public static void setSourceSelection(SortedSheetArray sheets, SortedCellBlockArray srcSel) {
        _sel.clear();
        if (srcSel != null) {
            _srcSheets = sheets;
            int size = srcSel.size();
            for (int i = 0; i < size; ++i) {
                _sel.insert(CellBlock.getCellBlock(srcSel.getBlock(i)));
            }
        }
    }

    public static Sheet getNewSheet(String sheetName) {
        Sheet desSheet = new Sheet(_clipBook, sheetName);
        _clipBook.insertSheet(_clipBook.getSheetCount(), desSheet);
        return desSheet;
    }

    public static Book getClipboardBook() {
        return KDClipboard.canPaste() ? _clipBook : null;
    }

    public static boolean sameUUID(byte[] uuid) {
        if (uuid != null && uuid.length == _uuid.length) {
            for (int i = 0; i < _uuid.length; ++i) {
                if (_uuid[i] == uuid[i]) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public static byte[] createUUID() {
        long t = System.currentTimeMillis();
        for (int i = 0; i < 8; ++i) {
            KDClipboard._uuid[i] = (byte)(t & 0xFFL);
            t >>= 8;
        }
        return _uuid;
    }

    public static boolean isOffset() {
        return _bOffset;
    }

    public static void setOffset(boolean offset) {
        _bOffset = offset;
    }

    public static boolean isCut() {
        return _bCut;
    }

    public static void setCut(boolean cut) {
        _bCut = cut;
    }

    static {
        _clipBook.setAutoCalculate(false);
        _clipBook.getDeps().setA1Style(false);
        _clipBook.getUndoManager().enable(false);
        _sel = new SortedCellBlockArray();
        _bSpreadSheet = true;
        _bOffset = true;
        _bCut = false;
        _uuid = new byte[8];
    }
}

