/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.kds.model.struct;

import com.kingdee.bos.ctrl.extcommon.util.ObjectArray;
import com.kingdee.bos.ctrl.kdf.util.style.ShareStyleAttributes;
import com.kingdee.bos.ctrl.kdf.util.style.StyleAttributes;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.kds.model.struct.Cell;
import com.kingdee.bos.ctrl.kds.model.struct.CellBlock;
import com.kingdee.bos.ctrl.kds.model.struct.Range;
import com.kingdee.bos.ctrl.kds.model.struct.Row;
import com.kingdee.bos.ctrl.kds.model.struct.Sheet;
import com.kingdee.bos.ctrl.kds.model.struct.SheetAction;
import com.kingdee.bos.ctrl.kds.model.struct.SortedAttributeSpanArray;
import com.kingdee.bos.ctrl.kds.model.struct.SortedColumnArray;
import com.kingdee.bos.ctrl.kds.model.struct.SortedSpanArray;
import com.kingdee.bos.ctrl.kds.model.struct.Span;
import com.kingdee.bos.ctrl.kds.model.struct.URState;
import com.kingdee.bos.ctrl.kds.model.struct.borders.Borders;
import com.kingdee.bos.ctrl.kds.model.struct.event.SheetChangeEvent;
import com.kingdee.bos.ctrl.kds.model.util.SortedCellBlockArray;

public class SheetAction_Style
extends SheetAction {
    private StyleAttributes _sa;
    private StyleAttributes _saInnerBorder;

    public SheetAction_Style(Range rg, StyleAttributes sa, StyleAttributes saInnerBorder) {
        super(rg, SheetChangeEvent.Changed_Style);
        if (sa != null) {
            this._sa = Styles.getSA((StyleAttributes)sa);
            this._saInnerBorder = Styles.getSA((StyleAttributes)saInnerBorder);
        }
    }

    @Override
    public void actionBlock(URState state, Sheet sheet, CellBlock cb) {
        Borders bdrs;
        boolean bState = state != null;
        StyleAttributes sa = this._sa;
        StyleAttributes saInnerBorder = this._saInnerBorder;
        if (sa == null) {
            sa = Styles.getSA((ShareStyleAttributes)sheet.getSSA());
            sa.setDirty(ShareStyleAttributes.getAllBits());
            saInnerBorder = sa;
        }
        if (!sa.isDirty() && !saInnerBorder.isDirty()) {
            return;
        }
        StyleAttributes saNoBorder = Styles.getSA((StyleAttributes)sa);
        SortedCellBlockArray mergeBlocks = sheet.getTouchedMergeBlocks(cb);
        if (saNoBorder.isDirty()) {
            boolean bRow = cb.isRow();
            if (bRow || cb.isCol()) {
                if (cb.isWholeSheet()) {
                    this.setSheetStyle(state, sheet, cb, saNoBorder, mergeBlocks);
                } else {
                    this.setRowColStyle(state, sheet, cb, bRow, saNoBorder, mergeBlocks, true);
                }
            } else {
                this.createStyleCells(state, sheet, cb, cb.getRow(), cb.getCol(), cb.getRow2(), cb.getCol2(), mergeBlocks);
            }
            Sheet.ICellsIterator ci = sheet.getCellsIterator(cb, true, false);
            if (ci.hasNext()) {
                ObjectArray clls = null;
                ObjectArray SSAs = null;
                if (bState) {
                    clls = new ObjectArray();
                    SSAs = new ObjectArray();
                }
                while (ci.hasNext()) {
                    Cell cll = ci.next();
                    int r = cll.getRow();
                    int c = cll.getCol();
                    this.setCellStyle(state, sheet, r, c, cll, (ShareStyleAttributes)saNoBorder, clls, SSAs);
                }
                if (bState && !clls.isEmpty()) {
                    ObjectArray oldSSAs;
                    ObjectArray oldClls = (ObjectArray)state.getData("CELL_OBJ", ObjectArray.class, clls);
                    if (clls != oldClls) {
                        oldClls.appendAll(clls);
                    }
                    if ((oldSSAs = (ObjectArray)state.getData("CELL_SSA", ObjectArray.class, SSAs)) != SSAs) {
                        oldSSAs.appendAll(SSAs);
                    }
                }
            }
        }
        boolean borderChanged = false;
        if ((sa.isDirtyBorder() || saInnerBorder.isDirtyBorder()) && (borderChanged = this.URStore(state, "BDR", (bdrs = sheet.getBorders()).setBySA(cb, sa, saInnerBorder, bState)))) {
            if (cb.isWholeSheet()) {
                this.setSheetBorder(state, sheet, saInnerBorder);
            }
            if (mergeBlocks != null) {
                for (int i = mergeBlocks.size() - 1; i >= 0; --i) {
                    bdrs.clearInner(mergeBlocks.getBlock(i), null);
                }
            }
        }
    }

    @Override
    public void resumeBlock(URState state, Sheet sheet, CellBlock cb) {
        ObjectArray SSAs;
        ShareStyleAttributes sheetSSA;
        if (cb.isWholeSheet() && (sheetSSA = (ShareStyleAttributes)state.get("SHEET_SSA")) != null) {
            sheet.setSSA(sheetSSA);
        }
        if ((SSAs = (ObjectArray)state.get("CELL_SSA")) != null) {
            ObjectArray clls = (ObjectArray)state.get("CELL_OBJ");
            for (int i = clls.size() - 1; i >= 0; --i) {
                ((Cell)clls.get(i)).setSSA((ShareStyleAttributes)SSAs.get(i));
            }
        }
        sheet.getRowSpans().setSpans((SortedSpanArray)state.get("ROW_SSA"));
        sheet.getColSpans().setSpans((SortedSpanArray)state.get("COL_SSA"));
        Borders bdrs = (Borders)state.get("BDR");
        if (bdrs != null) {
            sheet.getBorders().set(bdrs);
        }
    }

    private void setSheetStyle(URState state, Sheet sheet, CellBlock cb, StyleAttributes saNoBorder, SortedCellBlockArray mergeBlocks) {
        long crashBits;
        StyleAttributes thisSA = Styles.getSA((ShareStyleAttributes)sheet.getStyle());
        if (thisSA.replace((ShareStyleAttributes)saNoBorder, crashBits = thisSA.crashBits((ShareStyleAttributes)saNoBorder, false)) > 0) {
            this.URStore(state, "SHEET_SSA", sheet.getSSA());
            sheet.setSSA(sheet.getBook().getSSA(thisSA));
        }
        this.setRowColStyle(state, sheet, cb, true, saNoBorder, mergeBlocks, false);
        this.setRowColStyle(state, sheet, cb, false, saNoBorder, mergeBlocks, false);
    }

    private void setRowColStyle(URState state, Sheet sheet, CellBlock cb, boolean bRow, StyleAttributes saNoBorder, SortedCellBlockArray mergeBlocks, boolean cross) {
        block10: {
            int col2;
            int col;
            int row2;
            int row;
            boolean bState;
            block9: {
                Span[] spans;
                bState = state != null;
                row = cb.getRow();
                row2 = cb.getRow2();
                col = cb.getCol();
                col2 = cb.getCol2();
                if (!bRow) break block9;
                SortedSpanArray oldSpans = sheet.getRowSpans().setSpanAttribute(cb.getRowSpan(), (ShareStyleAttributes)saNoBorder, null, null, null, null, bState);
                if (!bState || oldSpans == null) break block10;
                SortedSpanArray keepSpans = (SortedSpanArray)state.get("ROW_SSA");
                if (keepSpans == null) {
                    state.setData("ROW_SSA", oldSpans);
                } else {
                    keepSpans.appendAll(oldSpans);
                }
                if (cross && (col != 0 || col2 != 65535) && (spans = sheet.getColSpans().getSpecifiedSpans(col, col2)) != null) {
                    for (int i = 0; i < spans.length; ++i) {
                        SortedAttributeSpanArray.AttributeSpan asp = (SortedAttributeSpanArray.AttributeSpan)spans[i];
                        if (asp.getSSA().crashBits((ShareStyleAttributes)saNoBorder, true) == 0L) continue;
                        this.createStyleCells(state, sheet, cb, row, asp.getStart(), row2, asp.getEnd(), mergeBlocks);
                    }
                }
                break block10;
            }
            SortedSpanArray oldSpans = sheet.getColSpans().setSpanAttribute(cb.getColSpan(), (ShareStyleAttributes)saNoBorder, null, null, null, null, bState);
            if (bState && oldSpans != null) {
                Span[] spans;
                SortedSpanArray keepSpans = (SortedSpanArray)state.get("COL_SSA");
                if (keepSpans == null) {
                    state.setData("COL_SSA", oldSpans);
                } else {
                    keepSpans.appendAll(oldSpans);
                }
                if (cross && (row != 0 || row2 != 1048575) && (spans = sheet.getRowSpans().getSpecifiedSpans(row, row2)) != null) {
                    for (int i = 0; i < spans.length; ++i) {
                        SortedAttributeSpanArray.AttributeSpan asp = (SortedAttributeSpanArray.AttributeSpan)spans[i];
                        if (asp.getSSA().crashBits((ShareStyleAttributes)saNoBorder, true) == 0L) continue;
                        this.createStyleCells(state, sheet, cb, asp.getStart(), col, asp.getEnd(), col2, mergeBlocks);
                    }
                }
            }
        }
    }

    private void setSheetBorder(URState state, Sheet sheet, StyleAttributes saInnerBorder) {
        StyleAttributes thisSA = Styles.getSA((ShareStyleAttributes)sheet.getStyle());
        boolean changed = false;
        if (saInnerBorder.isDirtyBorder(Styles.Position.INNER_H)) {
            changed |= thisSA.replaceDirtyBorder((ShareStyleAttributes)saInnerBorder, Styles.Position.INNER_H, Styles.Position.TOP) > 0;
            changed |= thisSA.replaceDirtyBorder((ShareStyleAttributes)saInnerBorder, Styles.Position.INNER_H, Styles.Position.BOTTOM) > 0;
        }
        if (saInnerBorder.isDirtyBorder(Styles.Position.INNER_V)) {
            changed |= thisSA.replaceDirtyBorder((ShareStyleAttributes)saInnerBorder, Styles.Position.INNER_V, Styles.Position.LEFT) > 0;
            changed |= thisSA.replaceDirtyBorder((ShareStyleAttributes)saInnerBorder, Styles.Position.INNER_V, Styles.Position.RIGHT) > 0;
        }
        if (changed) {
            sheet.setSSA(sheet.getBook().getSSA(thisSA));
        }
    }

    private void createStyleCells(URState state, Sheet sheet, CellBlock cb, int row, int col, int row2, int col2, SortedCellBlockArray mergeBlocks) {
        CellBlock mergeBlock;
        int c;
        boolean bFull = false;
        SortedColumnArray cols = sheet.getCols();
        int pos = cols.search(col);
        if (pos >= 0 && cols.search(col2) - pos == col2 - col) {
            bFull = true;
        }
        if (!bFull) {
            int height = cb.getHeight();
            for (c = col; c <= col2; ++c) {
                if (mergeBlocks != null && (mergeBlock = mergeBlocks.searchBlock(row, c)) != null && mergeBlock.getHeight() >= height) {
                    c = mergeBlock.getCol2();
                    continue;
                }
                this.getStateCol(state, sheet, c);
            }
        }
        int width = cb.getWidth();
        for (int r = row; r <= row2; ++r) {
            CellBlock mergeBlock2;
            if (mergeBlocks != null && (mergeBlock2 = mergeBlocks.searchBlock(r, col)) != null && mergeBlock2.getWidth() >= width) {
                r = mergeBlock2.getRow2();
                continue;
            }
            Row rowObj = this.getStateRow(state, sheet, r);
            int pos2 = rowObj.search(col);
            if (pos2 >= 0 && rowObj.search(col2) - pos2 == col2 - col) continue;
            for (c = col; c <= col2; ++c) {
                if (mergeBlocks != null && (mergeBlock = mergeBlocks.searchBlock(r, c)) != null) {
                    c = mergeBlock.getCol2();
                    continue;
                }
                this.getStateCell(state, sheet, rowObj, c);
            }
        }
    }

    @Override
    public String getPresentationName() {
        return "\u8bbe\u7f6e\u5c5e\u6027" + super.getPresentationName();
    }
}

