/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.kds.model.struct.embed.echarts.transfer.impls;

import com.github.abel533.echarts.Option;
import com.github.abel533.echarts.json.GsonOption;
import com.kingdee.bos.ctrl.common.util.ColorUtil;
import com.kingdee.bos.ctrl.ext.ui.wizards.chart.extend.pattern.NumberFormatTemplateEditor;
import com.kingdee.bos.ctrl.ext.ui.wizards.chart.extend.pattern.PatternNode;
import com.kingdee.bos.ctrl.ext.ui.wizards.chart.model.beans.AbstractFusionBean;
import com.kingdee.bos.ctrl.kds.model.struct.embed.echarts.constants.EChartsType;
import com.kingdee.bos.ctrl.kds.model.struct.embed.echarts.transfer.IModelTransfer;
import com.kingdee.bos.ctrl.kds.model.struct.embed.echarts.transfer.TransferUtils;
import com.kingdee.bos.ctrl.kds.model.struct.embed.echarts.transfer.script.JSUtils;
import com.kingdee.bos.ctrl.kds.model.struct.embed.flashchart.FlashChartType;
import com.kingdee.bos.ctrl.kds.model.struct.embed.flashchart.FusionChartDataNode;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;

public abstract class AbstractTransferImpl<B extends AbstractFusionBean>
implements IModelTransfer<B, FusionChartDataNode> {
    private EChartsType type;
    private String desc;
    private List<Color> colorList = new ArrayList<Color>();

    public AbstractTransferImpl(EChartsType type, String desc) {
        this.type = type;
        this.desc = desc;
    }

    public EChartsType getType() {
        return this.type;
    }

    public void setType(EChartsType type) {
        this.type = type;
    }

    public String getDesc() {
        return this.desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }

    @Override
    public Option mockOption(B bean) {
        return new GsonOption();
    }

    @Override
    public String initMockScript(B bean) {
        StringBuilder builder = new StringBuilder();
        builder.append(this.buildColors(bean));
        builder.append(this.build95PecentColors(bean));
        builder.append(this.build75PecentColors(bean));
        return builder.toString();
    }

    @Override
    public String initScript(B bean, FusionChartDataNode data) {
        ((AbstractFusionBean)bean).toXML(data);
        StringBuilder builder = new StringBuilder();
        builder.append(this.buildColors(bean)).append(this.build95PecentColors(bean)).append(this.build75PecentColors(bean)).append(this.setBorderAlphaJS(Integer.parseInt(((AbstractFusionBean)bean).getChart().borderAlpha)));
        PatternNode node = NumberFormatTemplateEditor.parsePattern(data.getNumberFormatXML(), null, null);
        builder.append(this.initNumberFormatVar(node));
        String optionJS = String.format("var formatterOption ={format:'%s',overrideGroupSep:'%s',overrideDecSep:'%s',overrideNegSign:'%s',isPercentage:%b,locale:'cn'};", node.getPatternWithoutPS(), Character.valueOf(node.getThousandSeparator()), Character.valueOf(node.getDecimalSeparator()), Character.valueOf('-'), node.isPercentNumber());
        builder.append(optionJS);
        builder.append(JSUtils.NUMBERFORMATFUNCTION_TEMPLATE);
        builder.append(JSUtils.VALUEAXIS_NUMBERFORMATFUNCTION);
        builder.append(JSUtils.SERIES_NUMBERFORMATFUNCTION);
        builder.append(JSUtils.TOOLTIPS_NUMBERFORMATFUNCTION);
        if (((AbstractFusionBean)bean).getChartType() == FlashChartType.FLASH_CT_RADAR) {
            builder.append(JSUtils.RADARTOOLTIP_NUMBERFORMATFUNCTION);
        }
        return builder.toString();
    }

    private String initNumberFormatVar(PatternNode node) {
        StringBuilder sb = new StringBuilder();
        String prefixJS = String.format("var prefix = '%s';", node.getPrefix());
        String suffixJS = String.format("var suffix = '%s';", node.getSuffix());
        String rSuffixJS = String.format("var rSuffix = '%s';", node.getrSuffix());
        sb.append(prefixJS).append(suffixJS).append(rSuffixJS);
        return sb.toString();
    }

    private String setBorderAlphaJS(int alpha) {
        return String.format("$(chartDiv).css('border','1px solid');$(chartDiv).css('border-color','%s');", String.format("rgba(0,0,0,%f)", (double)alpha / 100.0));
    }

    public String buildColors(B bean) {
        StringBuilder builder = new StringBuilder("var colors=[");
        List colors = ((AbstractFusionBean)bean).initColors();
        this.colorList.clear();
        for (String color : colors) {
            builder.append("'");
            Color c = ColorUtil.parseColor((String)('#' + color.substring(0, color.length() - 3)));
            this.colorList.add(c);
            builder.append(TransferUtils.toCSSRGBAString(c));
            builder.append("'");
            builder.append(",");
        }
        builder.append("];");
        return builder.toString();
    }

    public String buildColorStops(int count, int right, int down, int left, int up) {
        return TransferUtils.buildColorStops("", count, right, down, left, up);
    }

    public String buildColorStopsLeft(int count) {
        return this.buildColorStops(count, 0, 0, 1, 0);
    }

    public String buildColorStopsUp(int count) {
        return this.buildColorStops(count, 0, 0, 0, 1);
    }

    private String build95PecentColors(B bean) {
        StringBuilder builder = new StringBuilder("var colors7c=[");
        List colors = ((AbstractFusionBean)bean).initColors();
        for (String color : colors) {
            builder.append("'");
            Color c = ColorUtil.parseColor((String)('#' + color.substring(0, color.length() - 3)));
            c = new Color(c.getRed(), c.getGreen(), c.getBlue(), 242);
            builder.append(TransferUtils.toCSSRGBAString(c));
            builder.append("'");
            builder.append(",");
        }
        builder.append("];");
        return builder.toString();
    }

    private String build75PecentColors(B bean) {
        StringBuilder builder = new StringBuilder("var colors75c=[");
        List colors = ((AbstractFusionBean)bean).initColors();
        for (String color : colors) {
            builder.append("'");
            Color c = ColorUtil.parseColor((String)('#' + color.substring(0, color.length() - 3)));
            c = new Color(c.getRed(), c.getGreen(), c.getBlue(), 191);
            builder.append(TransferUtils.toCSSRGBAString(c));
            builder.append("'");
            builder.append(",");
        }
        builder.append("];");
        return builder.toString();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("echart type:").append(this.type.name()).append("\n").append("desc :").append(this.desc);
        return builder.toString();
    }

    public Option getDefaultOption() {
        return new GsonOption();
    }

    public String resizeScript(int width, int height) {
        return String.format("var div=chartDiv; div.style.width=%d+\"px\"; div.style.height=%d+\"px\";myChart.resize();", width, height);
    }

    @Override
    public String afterScript(B bean, FusionChartDataNode data, Option p) {
        return "myChart.setOption(option, true);";
    }

    @Override
    public Option transfer2Opiton(B b, FusionChartDataNode d) {
        return this.getDefaultOption();
    }

    public List<Color> getColorList() {
        return this.colorList;
    }

    @Override
    public String afterMockScript(B bean) {
        return "myChart.setOption(option, true);";
    }
}

