/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.kds.model.struct.embed.echarts.transfer.impls.gantt;

import com.github.abel533.echarts.AbstractData;
import com.github.abel533.echarts.Option;
import com.github.abel533.echarts.axis.Axis;
import com.github.abel533.echarts.axis.CategoryAxis;
import com.github.abel533.echarts.axis.ValueAxis;
import com.github.abel533.echarts.code.LineType;
import com.github.abel533.echarts.code.Position;
import com.github.abel533.echarts.code.SeriesType;
import com.github.abel533.echarts.code.Trigger;
import com.github.abel533.echarts.json.Var;
import com.github.abel533.echarts.series.Bar;
import com.github.abel533.echarts.series.Series;
import com.kingdee.bos.ctrl.ext.ui.wizards.chart.model.beans.gantt.GanttBean;
import com.kingdee.bos.ctrl.extcommon.variant.Variant;
import com.kingdee.bos.ctrl.kds.model.struct.embed.echarts.constants.EChartConstants;
import com.kingdee.bos.ctrl.kds.model.struct.embed.echarts.constants.EChartsType;
import com.kingdee.bos.ctrl.kds.model.struct.embed.echarts.transfer.TransferUtils;
import com.kingdee.bos.ctrl.kds.model.struct.embed.echarts.transfer.impls.AbstractBarTransfer;
import com.kingdee.bos.ctrl.kds.model.struct.embed.flashchart.FusionChartDataNode;
import com.kingdee.bos.ctrl.swing.util.CtrlFormatUtilities;
import java.lang.reflect.Array;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;

public class GanttBeanTransferImpl
extends AbstractBarTransfer<GanttBean> {
    private Calendar cal = Calendar.getInstance(CtrlFormatUtilities.getTimeZone());
    private SimpleDateFormat dateFormat;
    private static final String STACKKEY = "plan";

    public GanttBeanTransferImpl() {
        super(EChartsType.BAR, "\u7518\u7279\u56fe");
    }

    @Override
    public Option transfer2Opiton(GanttBean bean, FusionChartDataNode dataNode) {
        Bar b;
        String[] captions = bean.buildChartCaptions1(dataNode);
        Option p = super.transfer2Opiton(bean, dataNode);
        Object val = dataNode.getData(FusionChartDataNode.GANTT_TASK_START);
        boolean isHour = dataNode.getDateFormat();
        this.dateFormat = isHour ? new SimpleDateFormat("yyyy/M/dd HH:mm:ss") : new SimpleDateFormat("yyyy/M/dd");
        String[] startDate = null;
        if (val != null) {
            try {
                startDate = bean.parseDate((Variant[][])Array.get(val, 0));
            }
            catch (Exception e) {
                throw new IllegalArgumentException("\u5f00\u59cb\u65f6\u95f4\u8bbe\u7f6e\u9519\u8bef");
            }
        }
        String[] endDate = null;
        val = dataNode.getData(FusionChartDataNode.GANTT_TASK_END);
        if (val != null) {
            try {
                endDate = bean.parseDate((Variant[][])Array.get(val, 0));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if ((endDate == null || endDate.length == 0) && null != startDate) {
            val = dataNode.getData(FusionChartDataNode.GANTT_TASK_WORKLOAD);
            Object[][] workload = (Object[][])Array.get(val, 0);
            endDate = new String[startDate.length];
            try {
                for (int i = 0; i < startDate.length; ++i) {
                    this.cal.setTime(bean.parse(startDate[i]));
                    if (isHour) {
                        this.cal.add(11, ((Variant)workload[0][i]).intValue());
                    } else {
                        this.cal.add(5, ((Variant)workload[0][i]).intValue());
                    }
                    endDate[i] = this.dateFormat.format(this.cal.getTime());
                }
            }
            catch (Exception e) {
                throw new IllegalArgumentException("\u8f6c\u6362\u5de5\u4f5c\u8d1f\u8f7d\u51fa\u9519\uff1a", e);
            }
        }
        String[] startDateAC = null;
        val = dataNode.getData(FusionChartDataNode.GANTT_TASK_START_PLAN);
        if (val != null) {
            try {
                startDateAC = bean.parseDate((Variant[][])Array.get(val, 0));
            }
            catch (Exception e) {
                throw new IllegalArgumentException("\u5b9e\u9645\u5f00\u59cb\u65f6\u95f4\u8bbe\u7f6e\u9519\u8bef");
            }
        }
        String[] endDateAC = null;
        val = dataNode.getData(FusionChartDataNode.GANTT_TASK_END_PLAN);
        if (val != null) {
            try {
                endDateAC = bean.parseDate((Variant[][])Array.get(val, 0));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (startDateAC != null && (endDateAC == null || endDateAC.length == 0)) {
            val = dataNode.getData(FusionChartDataNode.GANTT_TASK_WORKLOAD);
            Object[][] workload = (Object[][])Array.get(val, 0);
            endDateAC = new String[startDateAC.length];
            try {
                for (int i = 0; i < startDateAC.length; ++i) {
                    this.cal.setTime(bean.parse(startDateAC[i]));
                    if (isHour) {
                        this.cal.add(11, ((Variant)workload[0][i]).intValue());
                    } else {
                        this.cal.add(5, ((Variant)workload[0][i]).intValue());
                    }
                    endDateAC[i] = this.dateFormat.format(this.cal.getTime());
                }
            }
            catch (Exception e) {
                throw new IllegalArgumentException("\u8f6c\u6362\u5b9e\u9645\u5de5\u4f5c\u8d1f\u8f7d\u51fa\u9519\uff1a", e);
            }
        }
        String[] ganttID = null;
        val = dataNode.getData(FusionChartDataNode.GANTT_TASK_ID);
        if (val != null) {
            ganttID = bean.parse(Array.get(val, 0));
        }
        if (null == ganttID) {
            return null;
        }
        ValueAxis valueAxis = new ValueAxis();
        valueAxis.position((Object)"top");
        p.xAxis().add(valueAxis);
        CategoryAxis caxis = new CategoryAxis();
        String[] names = null;
        val = dataNode.getData(FusionChartDataNode.GANTT_TASK_NAME);
        if (val != null) {
            names = bean.parse(Array.get(val, 0));
            int maxLableLength = 0;
            for (String label : names) {
                maxLableLength = Math.max(maxLableLength, label.length());
                caxis.data().add(label);
            }
        }
        p.tooltip().trigger(Trigger.axis);
        p.tooltip().formatter((Object)new Var("function(params){var res = params[0].name + '</br>';var time = 0;for(var n = 0; n < params.length; n++){time = params[n].data; var d = new Date(time);var dateStr = d.getFullYear() + '-' + (d.getMonth() + 1) + '-' + d.getDate() + '</br>';res = res + params[n].seriesName + ':' + dateStr;}return res;}"));
        long min = 0L;
        try {
            min = this.dateFormat.parse(startDate[0]).getTime();
        }
        catch (ParseException e) {
            throw new IllegalArgumentException("\u89e3\u6790\u65f6\u95f4\u51fa\u9519\uff1a", e);
        }
        long max = 0L;
        Bar startDateBar = new Bar();
        startDateBar.name("\u8ba1\u5212\u5f00\u59cb\u65f6\u95f4");
        startDateBar.itemStyle().color((Object)"rgba(255,255,255,0)");
        for (int i = 0; i < startDate.length; ++i) {
            try {
                long startDateTime = this.dateFormat.parse(startDate[i]).getTime();
                min = Math.min(startDateTime, min);
                startDateBar.data().add(startDateTime);
                continue;
            }
            catch (Exception e) {
                throw new IllegalArgumentException("\u89e3\u6790\u65f6\u95f4\u51fa\u9519\uff1a", e);
            }
        }
        p.series().add(startDateBar);
        Bar endDateBar = new Bar();
        endDateBar.name("\u8ba1\u5212\u7ed3\u675f\u65f6\u95f4");
        endDateBar.itemStyle().color((Object)"rgba(255,255,255,0)");
        for (int i = 0; i < endDate.length; ++i) {
            try {
                long endTime = this.dateFormat.parse(endDate[i]).getTime();
                max = Math.max(endTime, max);
                endDateBar.data().add(endTime);
                continue;
            }
            catch (Exception e) {
                throw new IllegalArgumentException("\u89e3\u6790\u65f6\u95f4\u51fa\u9519\uff1a", e);
            }
        }
        p.series().add(endDateBar);
        Bar startDateACBar = null;
        if (null != startDateAC) {
            startDateACBar = new Bar();
            startDateACBar.name("\u5b9e\u9645\u5f00\u59cb\u65f6\u95f4");
            startDateACBar.itemStyle().color((Object)"rgba(255,255,255,0)");
            for (int i = 0; i < startDateAC.length; ++i) {
                try {
                    long startDateACTime = this.dateFormat.parse(startDateAC[i]).getTime();
                    startDateACBar.data().add(startDateACTime);
                    continue;
                }
                catch (Exception e) {
                    throw new IllegalArgumentException("\u89e3\u6790\u65f6\u95f4\u51fa\u9519\uff1a", e);
                }
            }
            p.series().add(startDateACBar);
        }
        Bar endDateACBar = null;
        if (null != endDateAC) {
            endDateACBar = new Bar();
            endDateACBar.name("\u5b9e\u9645\u7ed3\u675f\u65f6\u95f4");
            endDateACBar.itemStyle().color((Object)"rgba(255,255,255,0)");
            for (int i = 0; i < endDateAC.length; ++i) {
                try {
                    long endACTime = this.dateFormat.parse(endDateAC[i]).getTime();
                    max = Math.max(endACTime, max);
                    endDateACBar.data().add(endACTime);
                    continue;
                }
                catch (ParseException e) {
                    throw new IllegalArgumentException("\u89e3\u6790\u65f6\u95f4\u51fa\u9519\uff1a", e);
                }
            }
            p.series().add(endDateACBar);
        }
        for (int i = 0; i < p.getSeries().size(); ++i) {
            Series s = (Series)p.series().get(i);
            if (s.getType() != SeriesType.bar) continue;
            b = (Bar)s;
            for (int j = 0; j < b.data().size(); ++j) {
                String timePlan = "";
                if (null != captions && captions.length > 11 && captions[11].equalsIgnoreCase("true")) {
                    b.markLine().label().show(Boolean.valueOf(true));
                    b.markLine().label().position((Object)"insideMiddle");
                    b.markLine().label().textStyle().fontSize(Integer.valueOf(12));
                    b.markLine().label().color("#000");
                    timePlan = names[j];
                }
                if ((b.name().equals("\u8ba1\u5212\u5f00\u59cb\u65f6\u95f4") || b.name().equals("\u8ba1\u5212\u7ed3\u675f\u65f6\u95f4")) && null != startDate && null != endDate) {
                    b.markLine().lineStyle().color((Object)new Var("colors[0]"));
                    if (b.name().equals("\u8ba1\u5212\u5f00\u59cb\u65f6\u95f4")) {
                        b.markLine().lineStyle().color((Object)"rgba(255,255,255,0)");
                        b.markPoint().label().color("rgba(255,255,255,0)");
                    }
                    if (timePlan.length() < 1) {
                        b.markLine().label().show(Boolean.valueOf(false));
                    }
                    if (!b.name().equals("\u8ba1\u5212\u7ed3\u675f\u65f6\u95f4")) continue;
                    this.configureDisplayBar((Series)b, startDateBar, endDateBar, timePlan, j);
                    if (null != captions && captions.length > 24 && captions[24].equalsIgnoreCase("true")) {
                        this.configureTimePoint((Series)b, startDateBar.data().get(j).toString(), j);
                        b.markPoint().label().position(Position.insideLeft);
                    }
                    if (null == captions || captions.length <= 25 || !captions[25].equalsIgnoreCase("true")) continue;
                    this.configureTimePoint((Series)b, endDateBar.data().get(j).toString(), j);
                    b.markPoint().label().position(Position.insideRight);
                    continue;
                }
                if (!b.name().equals("\u5b9e\u9645\u5f00\u59cb\u65f6\u95f4") && !b.name().equals("\u5b9e\u9645\u7ed3\u675f\u65f6\u95f4") || null == startDateAC || null == endDateAC) continue;
                b.markLine().lineStyle().color((Object)new Var("colors[1]"));
                if (b.name().equals("\u5b9e\u9645\u5f00\u59cb\u65f6\u95f4")) {
                    b.markLine().lineStyle().color((Object)"rgba(255,255,255,0)");
                    b.markPoint().label().color("rgba(255,255,255,0)");
                }
                if (!b.name().equals("\u5b9e\u9645\u7ed3\u675f\u65f6\u95f4")) continue;
                this.configureDisplayBar((Series)b, startDateACBar, endDateACBar, "", j);
                if (null != captions && captions.length > 12 && captions[12].equalsIgnoreCase("true")) {
                    this.configureTimePoint((Series)b, startDateACBar.data().get(j).toString(), j);
                    b.markPoint().label().position(Position.insideLeft);
                }
                if (null == captions || captions.length <= 13 || !captions[13].equalsIgnoreCase("true")) continue;
                this.configureTimePoint((Series)b, endDateACBar.data().get(j).toString(), j);
                b.markPoint().label().position(Position.insideRight);
            }
        }
        valueAxis.axisLabel().formatter((Object)new Var("function (value, index) { var date = new Date(value);if(value.value){date = new Date(value.value);}var texts = [(date.getFullYear()),(date.getMonth() + 1), date.getDate()];return texts.join('/');}"));
        valueAxis.setMin((Object)min);
        valueAxis.setMax((Object)max);
        p.yAxis().add(caxis);
        p.legend().show(Boolean.valueOf(false));
        if (null != captions && captions.length > 14) {
            for (Series s : p.getSeries()) {
                if (s.getType() != SeriesType.bar) continue;
                b = (Bar)s;
                b.markLine().lineStyle().width(Integer.valueOf(captions[14]));
            }
        }
        return p;
    }

    private void configureDisplayBar(Series s, Bar startBarData, Bar endBarData, String name, int index) {
        if (s instanceof Bar) {
            Bar b = (Bar)s;
            b.markLine().symbol((Object)"none");
            b.markLine().lineStyle().type(LineType.solid);
            b.markLine().tooltip().show(Boolean.valueOf(false));
            TransferUtils.setTrendLineValue((AbstractData)b.markLine(), "[{name:'%s', coord:[%s,%s]},{coord:[%s,%s]}]", name, startBarData.data().get(index).toString(), index + "", endBarData.data().get(index).toString(), index + "");
        }
    }

    private void configureTimePoint(Series s, String name, int index) {
        if (s instanceof Bar) {
            Bar b = (Bar)s;
            b.markPoint().symbolSize((Object)1);
            b.markPoint().label().color("#000");
            b.markPoint().label().textStyle().fontSize(Integer.valueOf(12));
            b.markPoint().label().formatter((Object)new Var("function (params) { var v = 0;if(params.data && params.data.coord){v =  params.data.coord[0];} var d = new Date(v);var dateStr = d.getFullYear() + '-' + (d.getMonth() + 1) + '-' + d.getDate();return dateStr;}"));
            TransferUtils.setTrendLineValue((AbstractData)b.markPoint(), "{value:'%s', coord:[%s,%s]}", name, name, index + "");
        }
    }

    @Override
    public String initMockScript(GanttBean b) {
        return super.initMockScript(b) + TransferUtils.getResourceAsString(this.getClass(), "GanttBeanTransferImpl.json", EChartConstants.DEMOFILE_ENCODING);
    }

    @Override
    public Option mockOption(GanttBean b) {
        return null;
    }

    @Override
    protected void configureAxisFont(GanttBean b, Option p, FusionChartDataNode data) {
        String[] captions = b.buildChartCaptions1(data);
        p.textStyle().fontSize(Integer.valueOf(captions.length >= 7 ? Integer.parseInt(captions[6]) : 24));
        p.title().textStyle().setFontSize(Integer.valueOf(captions.length > 19 ? Integer.parseInt(captions[19]) : 24));
        p.title().subtextStyle().setFontSize(Integer.valueOf(captions.length > 20 ? Integer.parseInt(captions[20]) : 16));
        String fontName = captions.length > 18 ? captions[18] : "\u5b8b\u4f53";
        p.textStyle().fontFamily(TransferUtils.getENFontName(fontName));
        this.configureAxisLabel(p, captions, fontName);
    }

    private void configureAxisLabel(Option p, String[] captions, String fontName) {
        if (null != p.getxAxis()) {
            for (Axis s : p.getxAxis()) {
                s.axisLabel().textStyle().fontFamily(TransferUtils.getENFontName(fontName));
                s.axisLabel().textStyle().fontSize(Integer.valueOf(captions.length > 8 ? Integer.parseInt(captions[8]) : 12));
            }
        }
        if (null != p.getyAxis()) {
            for (Axis s : p.getyAxis()) {
                s.axisLabel().textStyle().fontFamily(TransferUtils.getENFontName(fontName));
                s.axisLabel().textStyle().fontSize(Integer.valueOf(captions.length > 7 ? Integer.parseInt(captions[7]) : 12));
            }
        }
    }

    @Override
    protected void configureScaleMark(Option p, String[] chartCaptions) {
        List axis = new ArrayList();
        if (super.isyValueAxis()) {
            axis = p.getyAxis();
        } else if (super.isxValueAxis()) {
            axis = p.getxAxis();
        }
        if (null != axis && !axis.isEmpty()) {
            Axis y = (Axis)axis.get(0);
            y.splitArea().show(Boolean.valueOf(true));
            y.splitLine().lineStyle().opacity(Double.valueOf(chartCaptions.length > 21 ? Double.valueOf(chartCaptions[21]) / 100.0 : 0.5));
            y.splitArea().areaStyle().opacity(Double.valueOf(chartCaptions.length > 22 ? Double.valueOf(chartCaptions[22]) / 100.0 : 0.5));
        }
    }

    @Override
    public String afterScript(GanttBean b, FusionChartDataNode data, Option p) {
        for (Series s : p.getSeries()) {
            if (s.getType() != SeriesType.bar) continue;
            Bar bar = (Bar)s;
            bar.label().normal().show(Boolean.valueOf(false));
        }
        return super.afterScript(b, data, p);
    }
}

