/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.kds.model.util;

import com.kingdee.bos.ctrl.extcommon.util.SortedObjectArray;
import com.kingdee.bos.ctrl.kds.model.struct.CellBlock;
import com.kingdee.bos.ctrl.kds.model.util.SortedSpanArray;

public class SortedCellBlockArray
extends SortedObjectArray {
    private static final long serialVersionUID = 3280377425815741246L;
    private static final SortedCellBlockArray bufResult = new SortedCellBlockArray();
    private static final SortedCellBlockArray compResult = new SortedCellBlockArray();
    private static final SortedCellBlockArray remainResult = new SortedCellBlockArray();
    protected CellBlock _bounds = null;
    protected boolean _overlapped;
    protected int _rowCount;
    protected int _colCount;
    protected int _cellCount;

    public void copyFrom(SortedCellBlockArray sa) {
        if (sa._array != null && sa._array.length > 0) {
            this._array = new Object[sa._array.length];
            for (int i = 0; i < sa._count; ++i) {
                this._array[i] = CellBlock.getCellBlock((CellBlock)sa._array[i]);
            }
        }
        if (sa._bounds != null) {
            this._bounds = CellBlock.getCellBlock(sa._bounds);
        }
        this._cellCount = sa._cellCount;
        this._colCount = sa._colCount;
        this._count = sa._count;
        this._overlapped = sa._overlapped;
        this._rowCount = sa._rowCount;
    }

    public void offset(int deltRow, int deltCol) {
        if (this._count > 0) {
            for (int i = 0; i < this._count; ++i) {
                this.getBlock(i).offset(deltRow, deltCol);
            }
            this._bounds.offset(deltRow, deltCol);
        }
    }

    public synchronized void mergeSelf() {
        if (this.isOverlapped()) {
            bufResult.clear();
            bufResult.insert(this.getBlock(0));
            for (int index = 1; index < this._count; ++index) {
                compResult.clear();
                compResult.insert(this.getBlock(index));
                int resCount = SortedCellBlockArray.bufResult._count;
                for (int resIndex = 0; resIndex < resCount; ++resIndex) {
                    remainResult.clear();
                    CellBlock rb = bufResult.getBlock(resIndex);
                    int tCount = SortedCellBlockArray.compResult._count;
                    for (int compIndex = 0; compIndex < tCount; ++compIndex) {
                        CellBlock dst = compResult.getBlock(compIndex);
                        rb.split(dst, remainResult);
                    }
                    compResult.clear();
                    if (remainResult.isEmpty()) break;
                    compResult.copyFrom(remainResult);
                }
                if (compResult.isEmpty()) continue;
                bufResult.addAll(compResult);
            }
            this.copyFrom(bufResult);
        }
    }

    public synchronized boolean split(SortedCellBlockArray dst, SortedCellBlockArray result) {
        boolean isSplit = false;
        compResult.copyFrom(dst);
        for (int index = 0; index < this._count; ++index) {
            remainResult.clear();
            CellBlock cb = this.getBlock(index);
            int compCount = SortedCellBlockArray.compResult._count;
            for (int compIndex = 0; compIndex < compCount; ++compIndex) {
                boolean b2 = cb.split(compResult.getBlock(compIndex), remainResult);
                if (isSplit) continue;
                isSplit = b2;
            }
            compResult.clear();
            if (remainResult.isEmpty()) break;
            compResult.copyFrom(remainResult);
        }
        result.addAll(compResult);
        return isSplit;
    }

    public synchronized boolean split(CellBlock block, SortedCellBlockArray result) {
        SortedCellBlockArray sa = new SortedCellBlockArray();
        sa.insert(block);
        return this.split(sa, result);
    }

    public CellBlock getBounds() {
        return this._bounds == null ? CellBlock.getCellBlock(0, 0) : CellBlock.getCellBlock(this._bounds);
    }

    public SortedCellBlockArray getContainedBlocks(CellBlock block) {
        SortedCellBlockArray sa = null;
        for (int i = 0; i < this._count; ++i) {
            CellBlock cb = (CellBlock)this._array[i];
            if (!block.contains(cb)) continue;
            if (sa == null) {
                sa = new SortedCellBlockArray();
            }
            sa.insert(cb);
        }
        return sa;
    }

    public SortedCellBlockArray getContainedBlocks(int row, int col, int row2, int col2) {
        return this.getContainedBlocks(CellBlock.getCellBlock(row, col, row2, col2));
    }

    public SortedCellBlockArray getTouchedBlocks(CellBlock block) {
        SortedCellBlockArray mergeBlocks = null;
        for (int i = 0; i < this._count; ++i) {
            CellBlock cb = (CellBlock)this._array[i];
            if (!cb.isIntersect(block)) continue;
            if (mergeBlocks == null) {
                mergeBlocks = new SortedCellBlockArray();
            }
            mergeBlocks.insert(cb);
        }
        return mergeBlocks;
    }

    public SortedCellBlockArray getTouchedBlocks(int row, int col, int row2, int col2) {
        return this.getTouchedBlocks(CellBlock.getCellBlock(row, col, row2, col2));
    }

    public int getBlocksColumnNum() {
        if (this.isEmpty()) {
            return 0;
        }
        CellBlock cb = this.getBlock(0);
        int blockColNum = 1;
        int size = this.size();
        for (int i = 1; i < size && cb.equalsRow(this.getBlock(i)); ++i) {
            ++blockColNum;
        }
        return blockColNum;
    }

    public SortedSpanArray toRowSpans() {
        return this.toRowSpans(true);
    }

    public SortedSpanArray toRowSpans(boolean mergeTouched) {
        SortedSpanArray rowSpans = new SortedSpanArray(mergeTouched);
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            CellBlock block = this.getBlock(i);
            rowSpans.restruct(block.getRow(), block.getRow2());
        }
        return rowSpans;
    }

    public SortedSpanArray toColumnSpans() {
        return this.toColumnSpans(true);
    }

    public SortedSpanArray toColumnSpans(boolean mergeTouched) {
        SortedSpanArray colSpans = new SortedSpanArray(mergeTouched);
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            CellBlock block = this.getBlock(i);
            colSpans.restruct(block.getCol(), block.getCol2());
        }
        return colSpans;
    }

    public CellBlock getBlock(int index) {
        return (CellBlock)this.get(index);
    }

    public CellBlock getLastBlock() {
        return (CellBlock)this.getLast();
    }

    public boolean contains(CellBlock block) {
        if (this._bounds != null && this._bounds.contains(block)) {
            for (int i = 0; i < this._count; ++i) {
                if (!this.getBlock(i).contains(block)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isTouched(SortedCellBlockArray blocks) {
        int size = blocks.size();
        for (int i = 0; i < size; ++i) {
            CellBlock cb = blocks.getBlock(i);
            if (!this.isTouched(cb)) continue;
            return true;
        }
        return false;
    }

    public boolean isTouched(CellBlock block) {
        for (int i = 0; i < this._count; ++i) {
            CellBlock cb = (CellBlock)this._array[i];
            if (!cb.isIntersect(block)) continue;
            return true;
        }
        return false;
    }

    public boolean isOverlapped() {
        return this._overlapped;
    }

    public boolean isMixedBlocks() {
        return this._cellCount > 0 && (this._rowCount > 0 || this._colCount > 0);
    }

    public boolean isRowBlocks() {
        return this._rowCount > 0 && this._colCount == 0 && this._cellCount == 0;
    }

    public boolean isColBlocks() {
        return this._colCount > 0 && this._rowCount == 0 && this._cellCount == 0;
    }

    public boolean isCellBlocks() {
        return this._cellCount > 0 && this._rowCount == 0 && this._colCount == 0;
    }

    public boolean isSingleBlock() {
        return this._count == 1;
    }

    public boolean isSingleCell() {
        return this._count == 1 && this.getBlock(0).isSingleCell();
    }

    public int addAll(SortedCellBlockArray sa) {
        if (sa == null || sa._count == 0) {
            return 0;
        }
        int count = 0;
        for (int i = sa._count - 1; i >= 0; --i) {
            CellBlock cb = sa.getBlock(i);
            if (this.insert(cb) != null) continue;
            ++count;
        }
        return count;
    }

    public int addAll(Object[] array) {
        if (array == null) {
            return 0;
        }
        int count = 0;
        for (int i = array.length - 1; i >= 0; --i) {
            CellBlock cb = (CellBlock)array[i];
            if (this.insert(cb) != null) continue;
            ++count;
        }
        return count;
    }

    @Override
    public Object insert(Object obj) {
        CellBlock cb = (CellBlock)obj;
        boolean old = this._overlapped;
        if (!this._overlapped) {
            for (int i = this._count - 1; i >= 0; --i) {
                if (!this.getBlock(i).isIntersect(cb)) continue;
                this._overlapped = true;
                break;
            }
        }
        if ((obj = super.insert(cb)) != null) {
            this._overlapped = old;
            return obj;
        }
        if (this._bounds == null) {
            this._bounds = CellBlock.getCellBlock(cb);
        } else {
            this._bounds.union(cb);
        }
        boolean bRow = cb.isRow();
        boolean bCol = cb.isCol();
        if (bRow || bCol) {
            if (bRow) {
                ++this._rowCount;
            }
            if (bCol) {
                ++this._colCount;
            }
        } else {
            ++this._cellCount;
        }
        return obj;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof SortedCellBlockArray) {
            SortedCellBlockArray sa = (SortedCellBlockArray)obj;
            if (this._count != sa._count) {
                return false;
            }
            boolean b = true;
            for (int i = 0; i < this._count; ++i) {
                b = this.getBlock(i).equals(sa.getBlock(i));
                if (b) continue;
                return false;
            }
            return b;
        }
        return false;
    }

    @Override
    public Object removeByPos(int pos) {
        CellBlock cb = (CellBlock)super.removeByPos(pos);
        if (cb != null && this._bounds != null) {
            int i;
            boolean bRow = cb.isRow();
            boolean bCol = cb.isCol();
            if (bRow || bCol) {
                if (bRow) {
                    --this._rowCount;
                }
                if (bCol) {
                    --this._colCount;
                }
            } else {
                --this._cellCount;
            }
            if (cb.getRow() == this._bounds.getRow() || cb.getCol() == this._bounds.getCol() || cb.getRow2() == this._bounds.getRow2() || cb.getCol2() == this._bounds.getCol2()) {
                if (this._count == 0) {
                    this._bounds = null;
                } else {
                    this._bounds.setRowCol(this.getBlock(0));
                    for (i = 1; i < this._count; ++i) {
                        this._bounds.union(this.getBlock(i));
                    }
                }
            }
            if (this._overlapped) {
                this._overlapped = false;
                int end = this._count - 1;
                block1: for (i = 0; i < end; ++i) {
                    cb = this.getBlock(i);
                    for (int j = i + 1; j < this._count; ++j) {
                        if (!this.getBlock(j).isIntersect(cb)) continue;
                        this._overlapped = true;
                        break block1;
                    }
                }
            }
        }
        return cb;
    }

    public CellBlock remove(CellBlock cb) {
        return (CellBlock)this.removeByPos(this.search(cb));
    }

    public int searchBlockIndex(int row, int col) {
        if (this.isEmpty()) {
            return -1;
        }
        for (int i = 0; i < this._count; ++i) {
            CellBlock cb = this.getBlock(i);
            if (!cb.contains(row, col)) continue;
            return i;
        }
        return -1;
    }

    public CellBlock searchBlock(int row, int col) {
        if (this.isEmpty()) {
            return null;
        }
        for (int i = 0; i < this._count; ++i) {
            CellBlock cb = this.getBlock(i);
            if (!cb.contains(row, col)) continue;
            return cb;
        }
        return null;
    }
}

