/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.kds.model.util.profile;

import com.kingdee.bos.ctrl.common.util.ReflectUtil;
import com.kingdee.bos.ctrl.kds.model.util.profile.AbstractShellProfileNode;
import com.kingdee.bos.ctrl.kds.model.util.profile.ArrayIndexLink;
import com.kingdee.bos.ctrl.kds.model.util.profile.ArrayShellProfileNode;
import com.kingdee.bos.ctrl.kds.model.util.profile.ClassFieldLink;
import com.kingdee.bos.ctrl.kds.model.util.profile.IObjectProfileNode;
import com.kingdee.bos.ctrl.kds.model.util.profile.ObjectProfileNode;
import com.kingdee.bos.ctrl.kds.model.util.profile.ObjectShellProfileNode;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Arrays;
import java.util.IdentityHashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.WeakHashMap;

public abstract class ObjectProfiler {
    public static final int OBJECT_SHELL_SIZE = 8;
    public static final int OBJREF_SIZE = 4;
    public static final int LONG_FIELD_SIZE = 8;
    public static final int INT_FIELD_SIZE = 4;
    public static final int SHORT_FIELD_SIZE = 2;
    public static final int CHAR_FIELD_SIZE = 2;
    public static final int BYTE_FIELD_SIZE = 1;
    public static final int BOOLEAN_FIELD_SIZE = 1;
    public static final int DOUBLE_FIELD_SIZE = 8;
    public static final int FLOAT_FIELD_SIZE = 4;
    public static final boolean SHORT_TYPE_NAMES = false;
    public static final boolean SHORT_COMMON_TYPE_NAMES = true;
    static final String INPUT_OBJECT_NAME = "<INPUT>";
    private static final Map CLASS_METADATA_CACHE = new WeakHashMap(101);

    public static int sizeof(Object obj) {
        if (obj == null) {
            return 0;
        }
        IdentityHashMap visited = new IdentityHashMap();
        return ObjectProfiler.computeSizeof(obj, visited, CLASS_METADATA_CACHE);
    }

    public static int sizedelta(Object base, Object obj) {
        if (obj == null) {
            return 0;
        }
        if (base == null) {
            throw new IllegalArgumentException("null input: base");
        }
        IdentityHashMap visited = new IdentityHashMap();
        ObjectProfiler.computeSizeof(base, visited, CLASS_METADATA_CACHE);
        return visited.containsKey(obj) ? 0 : ObjectProfiler.computeSizeof(obj, visited, CLASS_METADATA_CACHE);
    }

    public static IObjectProfileNode profile(Object obj) {
        if (obj == null) {
            throw new IllegalArgumentException("null input: obj");
        }
        IdentityHashMap visited = new IdentityHashMap();
        ObjectProfileNode root = ObjectProfiler.createProfileTree(obj, visited, CLASS_METADATA_CACHE);
        ObjectProfiler.finishProfileTree(root);
        return root;
    }

    public static IObjectProfileNode profile(Object obj, IdentityHashMap visited) {
        if (obj == null) {
            throw new IllegalArgumentException("null input: obj");
        }
        ObjectProfileNode root = ObjectProfiler.createProfileTree(obj, visited, CLASS_METADATA_CACHE);
        ObjectProfiler.finishProfileTree(root);
        return root;
    }

    public static String pathName(IObjectProfileNode[] path) {
        StringBuffer s = new StringBuffer();
        for (int i = 0; i < path.length; ++i) {
            if (i != 0) {
                s.append('/');
            }
            s.append(path[i].name());
        }
        return s.toString();
    }

    public static String fieldName(Field field, boolean shortClassNames) {
        return ObjectProfiler.typeName(field.getDeclaringClass(), shortClassNames).concat("#").concat(field.getName());
    }

    public static String typeName(Class cls, boolean shortClassNames) {
        int dims = 0;
        while (cls.isArray()) {
            cls = cls.getComponentType();
            ++dims;
        }
        String clsName = cls.getName();
        if (shortClassNames) {
            int lastDot = clsName.lastIndexOf(46);
            if (lastDot >= 0) {
                clsName = clsName.substring(lastDot + 1);
            }
        } else if (clsName.startsWith("java.lang.")) {
            clsName = clsName.substring(10);
        } else if (clsName.startsWith("java.util.")) {
            clsName = clsName.substring(10);
        }
        for (int i = 0; i < dims; ++i) {
            clsName = clsName.concat("[]");
        }
        return clsName;
    }

    private ObjectProfiler() {
    }

    private static int computeSizeof(Object obj, IdentityHashMap visited, Map metadataMap) {
        if (obj == null) {
            return 0;
        }
        LinkedList<Object> queue = new LinkedList<Object>();
        visited.put(obj, obj);
        queue.add(obj);
        int result = 0;
        ClassAccessPrivilegedAction caAction = new ClassAccessPrivilegedAction();
        FieldAccessPrivilegedAction faAction = new FieldAccessPrivilegedAction();
        while (!queue.isEmpty()) {
            obj = queue.removeFirst();
            Class<?> objClass = obj.getClass();
            if (objClass.isArray()) {
                int arrayLength = Array.getLength(obj);
                Class<?> componentType = objClass.getComponentType();
                result += ObjectProfiler.sizeofArrayShell(arrayLength, componentType);
                if (componentType.isPrimitive()) continue;
                for (int i = 0; i < arrayLength; ++i) {
                    Object ref = Array.get(obj, i);
                    if (ref == null || visited.containsKey(ref)) continue;
                    visited.put(ref, ref);
                    queue.addFirst(ref);
                }
                continue;
            }
            ClassMetadata metadata = ObjectProfiler.getClassMetadata(objClass, metadataMap, caAction, faAction);
            Field[] fields = metadata.m_refFields;
            result += metadata.m_shellSize;
            for (Field field : fields) {
                Object ref;
                try {
                    ref = field.get(obj);
                }
                catch (Exception e) {
                    throw new RuntimeException("cannot get field [" + field.getName() + "] of class [" + field.getDeclaringClass().getName() + "]: " + e.toString());
                }
                if (ref == null || visited.containsKey(ref)) continue;
                visited.put(ref, ref);
                queue.addFirst(ref);
            }
        }
        return result;
    }

    private static ObjectProfileNode createProfileTree(Object obj, IdentityHashMap visited, Map metadataMap) {
        ObjectProfileNode root = new ObjectProfileNode(null, obj, null);
        LinkedList<ObjectProfileNode> queue = new LinkedList<ObjectProfileNode>();
        queue.addFirst(root);
        visited.put(obj, root);
        ClassAccessPrivilegedAction caAction = new ClassAccessPrivilegedAction();
        FieldAccessPrivilegedAction faAction = new FieldAccessPrivilegedAction();
        while (!queue.isEmpty()) {
            AbstractShellProfileNode shell;
            ObjectProfileNode node = (ObjectProfileNode)queue.removeFirst();
            obj = node.m_obj;
            Class<?> objClass = obj.getClass();
            if (objClass.isArray()) {
                int arrayLength = Array.getLength(obj);
                Class<?> componentType = objClass.getComponentType();
                shell = new ArrayShellProfileNode(node, objClass, arrayLength);
                shell.m_size = ObjectProfiler.sizeofArrayShell(arrayLength, componentType);
                node.m_shell = shell;
                node.addFieldRef(shell);
                if (componentType.isPrimitive()) continue;
                for (int i = 0; i < arrayLength; ++i) {
                    Object ref = Array.get(obj, i);
                    if (ref == null) continue;
                    ObjectProfileNode child = (ObjectProfileNode)visited.get(ref);
                    if (child != null) {
                        ++child.m_refcount;
                        continue;
                    }
                    child = new ObjectProfileNode(node, ref, new ArrayIndexLink(node.m_link, i));
                    node.addFieldRef(child);
                    queue.addLast(child);
                    visited.put(ref, child);
                }
                continue;
            }
            ClassMetadata metadata = ObjectProfiler.getClassMetadata(objClass, metadataMap, caAction, faAction);
            Field[] fields = metadata.m_refFields;
            shell = new ObjectShellProfileNode(node, metadata.m_primitiveFieldCount, metadata.m_refFields.length);
            shell.m_size = metadata.m_shellSize;
            node.m_shell = shell;
            node.addFieldRef(shell);
            for (Field field : fields) {
                Object ref;
                try {
                    ref = field.get(obj);
                }
                catch (Exception e) {
                    throw new RuntimeException("cannot get field [" + field.getName() + "] of class [" + field.getDeclaringClass().getName() + "]: " + e.toString());
                }
                if (ref == null) continue;
                ObjectProfileNode child = (ObjectProfileNode)visited.get(ref);
                if (child != null) {
                    ++child.m_refcount;
                    continue;
                }
                child = new ObjectProfileNode(node, ref, new ClassFieldLink(field));
                node.addFieldRef(child);
                queue.addLast(child);
                visited.put(ref, child);
            }
        }
        return root;
    }

    private static void finishProfileTree(ObjectProfileNode node) {
        LinkedList<IObjectProfileNode> queue = new LinkedList<IObjectProfileNode>();
        ObjectProfileNode lastFinished = null;
        while (node != null) {
            if (node.m_size == 1 || lastFinished == node.m_children[1]) {
                node.finish();
                lastFinished = node;
            } else {
                queue.addFirst(node);
                for (int i = 1; i < node.m_size; ++i) {
                    IObjectProfileNode child = node.m_children[i];
                    queue.addFirst(child);
                }
            }
            if (queue.isEmpty()) {
                return;
            }
            node = (ObjectProfileNode)queue.removeFirst();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ClassMetadata getClassMetadata(Class cls, Map metadataMap, ClassAccessPrivilegedAction caAction, FieldAccessPrivilegedAction faAction) {
        Field[] declaredFields;
        ClassMetadata result;
        if (cls == null) {
            return null;
        }
        Map map = metadataMap;
        synchronized (map) {
            result = (ClassMetadata)metadataMap.get(cls);
        }
        if (result != null) {
            return result;
        }
        int primitiveFieldCount = 0;
        int shellSize = 8;
        LinkedList<Field> refFields = new LinkedList<Field>();
        try {
            caAction.setContext(cls);
            declaredFields = (Field[])AccessController.doPrivileged(caAction);
        }
        catch (PrivilegedActionException pae) {
            throw new RuntimeException("could not access declared fields of class " + cls.getName() + ": " + pae.getException());
        }
        for (int f = 0; f < declaredFields.length; ++f) {
            Field field = declaredFields[f];
            if ((8 & field.getModifiers()) != 0) continue;
            Class<?> fieldType = field.getType();
            if (fieldType.isPrimitive()) {
                shellSize += ObjectProfiler.sizeofPrimitiveType(fieldType);
                ++primitiveFieldCount;
                continue;
            }
            if (!field.isAccessible()) {
                try {
                    faAction.setContext(field);
                    AccessController.doPrivileged(faAction);
                }
                catch (PrivilegedActionException pae) {
                    throw new RuntimeException("could not make field " + field + " accessible: " + pae.getException());
                }
            }
            shellSize += 4;
            refFields.add(field);
        }
        ClassMetadata superMetadata = ObjectProfiler.getClassMetadata(cls.getSuperclass(), metadataMap, caAction, faAction);
        if (superMetadata != null) {
            primitiveFieldCount += superMetadata.m_primitiveFieldCount;
            shellSize += superMetadata.m_shellSize - 8;
            refFields.addAll(Arrays.asList(superMetadata.m_refFields));
        }
        Field[] _refFields = new Field[refFields.size()];
        refFields.toArray(_refFields);
        result = new ClassMetadata(primitiveFieldCount, shellSize, _refFields);
        Map map2 = metadataMap;
        synchronized (map2) {
            metadataMap.put(cls, result);
        }
        return result;
    }

    private static int sizeofArrayShell(int length, Class componentType) {
        int slotSize = componentType.isPrimitive() ? ObjectProfiler.sizeofPrimitiveType(componentType) : 4;
        return 16 + length * slotSize;
    }

    private static int sizeofPrimitiveType(Class type) {
        if (type == Integer.TYPE) {
            return 4;
        }
        if (type == Long.TYPE) {
            return 8;
        }
        if (type == Short.TYPE) {
            return 2;
        }
        if (type == Byte.TYPE) {
            return 1;
        }
        if (type == Boolean.TYPE) {
            return 1;
        }
        if (type == Character.TYPE) {
            return 2;
        }
        if (type == Double.TYPE) {
            return 8;
        }
        if (type == Float.TYPE) {
            return 4;
        }
        throw new IllegalArgumentException("not primitive: " + type);
    }

    private static final class FieldAccessPrivilegedAction
    implements PrivilegedExceptionAction {
        private Field m_field;

        private FieldAccessPrivilegedAction() {
        }

        public Object run() throws Exception {
            ReflectUtil.makeAccessible((Field)this.m_field);
            return null;
        }

        void setContext(Field field) {
            this.m_field = field;
        }
    }

    private static final class ClassAccessPrivilegedAction
    implements PrivilegedExceptionAction {
        private Class m_cls;

        private ClassAccessPrivilegedAction() {
        }

        public Object run() throws Exception {
            return this.m_cls.getDeclaredFields();
        }

        void setContext(Class cls) {
            this.m_cls = cls;
        }
    }

    private static final class ClassMetadata {
        final int m_primitiveFieldCount;
        final int m_shellSize;
        final Field[] m_refFields;

        ClassMetadata(int primitiveFieldCount, int shellSize, Field[] refFields) {
            this.m_primitiveFieldCount = primitiveFieldCount;
            this.m_shellSize = shellSize;
            this.m_refFields = refFields;
        }
    }
}

