/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.lfm;

import com.kingdee.bos.ctrl.kdf.util.CloseUtil;
import com.kingdee.bos.ctrl.lfm.IExtThemeConfiguration;
import java.awt.Color;
import java.io.Closeable;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class StaticColorContainer
implements IExtThemeConfiguration {
    private static String _colorSpaceName = "\u7cfb\u7edf\u65b9\u6848(\u5546\u4e1a\u7a33\u91cd)";
    private static HashMap _colorMaps = new HashMap();

    @Override
    public void setContainerColorSpace(String colorSpaceName) {
        _colorSpaceName = colorSpaceName;
        _colorMaps.clear();
    }

    private static void initColors() {
        DefaultHandler dh = new DefaultHandler(){
            private String currentTemplateName;
            private String currentModelName;
            private ArrayList currentColors;

            @Override
            public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
                if (qName.equals("template")) {
                    this.currentTemplateName = attributes.getValue("type");
                    _colorMaps.put(this.currentTemplateName, new HashMap());
                } else if (qName.equals("colors")) {
                    this.currentModelName = attributes.getValue("name");
                    HashMap map = (HashMap)_colorMaps.get(this.currentTemplateName);
                    map.put(this.currentModelName, new ArrayList());
                } else if (qName.equals("value")) {
                    HashMap map = (HashMap)_colorMaps.get(this.currentTemplateName);
                    this.currentColors = (ArrayList)map.get(this.currentModelName);
                    String color = attributes.getValue("color");
                    String alpha = attributes.getValue("alpha");
                    this.currentColors.add(new Color(Integer.parseInt(color.substring(0, 2), 16), Integer.parseInt(color.substring(2, 4), 16), Integer.parseInt(color.substring(4), 16), Integer.parseInt(alpha)));
                }
            }
        };
        InputStream stream = null;
        try {
            stream = StaticColorContainer.class.getResourceAsStream("template.xml");
            SAXParserFactory factory = SAXParserFactory.newInstance();
            factory.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
            factory.newSAXParser().parse(stream, dh);
        }
        catch (Exception e) {
            try {
                System.out.println("------------------------------\u521d\u59cb\u5316\u914d\u8272\u65b9\u6848\u5931\u8d25-------------------------------");
                e.printStackTrace();
                System.out.println("------------------------------------------------------------------------------");
            }
            catch (Throwable throwable) {
                CloseUtil.close((Closeable[])new Closeable[]{stream});
                throw throwable;
            }
            CloseUtil.close((Closeable[])new Closeable[]{stream});
        }
        CloseUtil.close((Closeable[])new Closeable[]{stream});
    }

    @Override
    public Object getColors(String templateName, String typeName) {
        HashMap templateMap;
        if (_colorMaps.isEmpty()) {
            StaticColorContainer.initColors();
        }
        if ((templateMap = (HashMap)_colorMaps.get(templateName)) == null) {
            templateMap = (HashMap)_colorMaps.get(_colorSpaceName);
        }
        ArrayList set = (ArrayList)templateMap.get(typeName);
        Color[] ret = new Color[set.size()];
        set.toArray(ret);
        return ret;
    }
}

