/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.kdf.fd2.gui;

import com.kingdee.bos.ctrl.common.LanguageManager;
import com.kingdee.bos.ctrl.common.util.CtrlClassUtil;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.kdf.fd2.IFileSaver;
import com.kingdee.bos.ctrl.kdf.fd2.KDF;
import com.kingdee.bos.ctrl.kdf.fd2.Location;
import com.kingdee.bos.ctrl.kdf.fd2.SideLocation;
import com.kingdee.bos.ctrl.kdf.fd2.TableLocation;
import com.kingdee.bos.ctrl.kdf.fd2.TransType;
import com.kingdee.bos.ctrl.kdf.fd2.UndoOperation;
import com.kingdee.bos.ctrl.kdf.fd2.gui.FormDesigner;
import com.kingdee.bos.ctrl.kdf.fd2.gui.PageContainer;
import com.kingdee.bos.ctrl.kdf.fd2.gui.RulePanel;
import com.kingdee.bos.ctrl.kdf.fd2.gui.event.ReportElementChangedEvent;
import com.kingdee.bos.ctrl.kdf.fd2.gui.event.ReportElementsSelectionEvent;
import com.kingdee.bos.ctrl.kdf.fd2.gui.event.ReportListener;
import com.kingdee.bos.ctrl.kdf.fd2.gui.stick.MaxMinPair;
import com.kingdee.bos.ctrl.kdf.fd2.gui.stick.StickUtil;
import com.kingdee.bos.ctrl.kdf.fd2.gui.util.Line;
import com.kingdee.bos.ctrl.kdf.fd2.gui.util.MDIDesktopPane;
import com.kingdee.bos.ctrl.kdf.fd2.gui.util.MDIFrame;
import com.kingdee.bos.ctrl.kdf.fd2.gui.util.MenuItemFactory;
import com.kingdee.bos.ctrl.kdf.fd2.gui.util.MsgBox;
import com.kingdee.bos.ctrl.kdf.fd2.icons.Icons;
import com.kingdee.bos.ctrl.kdf.fd2.reportelement.AbstractContainer;
import com.kingdee.bos.ctrl.kdf.fd2.reportelement.FieldElement;
import com.kingdee.bos.ctrl.kdf.fd2.reportelement.Group;
import com.kingdee.bos.ctrl.kdf.fd2.reportelement.HeadFooter;
import com.kingdee.bos.ctrl.kdf.fd2.reportelement.IContainer;
import com.kingdee.bos.ctrl.kdf.fd2.reportelement.IElement;
import com.kingdee.bos.ctrl.kdf.fd2.reportelement.LineElement;
import com.kingdee.bos.ctrl.kdf.fd2.reportelement.LoopArea;
import com.kingdee.bos.ctrl.kdf.fd2.reportelement.Page;
import com.kingdee.bos.ctrl.kdf.fd2.reportelement.ReportElement;
import com.kingdee.bos.ctrl.kdf.fd2.reportelement.ReportElementFactory;
import com.kingdee.bos.ctrl.kdf.fd2.reportelement.ReportElementType;
import com.kingdee.bos.ctrl.kdf.fd2.reportelement.Table;
import com.kingdee.bos.ctrl.kdf.fd2.undo.DeleteElementsOperation;
import com.kingdee.bos.ctrl.kdf.fd2.undo.InsertElementOperation;
import com.kingdee.bos.ctrl.kdf.fd2.undo.TransformElementsOperation;
import com.kingdee.bos.ctrl.kdf.fd2.util.Misc;
import com.kingdee.bos.ctrl.kdf.util.style.PenStyle;
import com.kingdee.bos.ctrl.kdf.util.style.StyleUtil;
import com.kingdee.bos.ctrl.swing.KDCheckBoxMenuItem;
import com.kingdee.bos.ctrl.swing.KDFileChooser;
import com.kingdee.bos.ctrl.swing.KDMenu;
import com.kingdee.bos.ctrl.swing.KDMenuItem;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.KDPopupMenu;
import com.kingdee.bos.ctrl.swing.KDScrollBar;
import com.kingdee.bos.ctrl.swing.KDSeparator;
import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.image.BufferedImage;
import java.awt.image.ImageObserver;
import java.beans.PropertyVetoException;
import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JMenuItem;
import javax.swing.KeyStroke;
import javax.swing.event.AncestorEvent;
import javax.swing.event.EventListenerList;
import javax.swing.event.InternalFrameAdapter;
import javax.swing.event.InternalFrameEvent;
import javax.swing.filechooser.FileFilter;

public class KDFFrame
extends MDIFrame {
    private KDFFListener action;
    static int id = 0;
    static Cursor hsplit = null;
    static Cursor vsplit = null;
    static Cursor locked = null;
    private Graphics2D offscreen = null;
    private Graphics2D offscreenDoc = null;
    private BufferedImage offscreenImage = null;
    private BufferedImage offscreenImageDoc = null;
    private Dimension offscreenDimension = null;
    private boolean isShowDirty = true;
    private boolean isShowRule = false;
    private FormDesigner mf = null;
    boolean firstXORDraw = false;
    boolean firstXORDrawTransforming = false;
    Point newObjectOrigin = null;
    boolean trasforming = false;
    int transformation_type = -1;
    Point transformation_origin = null;
    Point transformation_origin_end = null;
    private static BasicStroke m_Dashed3 = null;
    private static BasicStroke m_SelectedDash = null;
    private static BasicStroke m_DragDash = null;
    private boolean drag_selection_mode = false;
    private boolean table_adjusting = false;
    private int table_adjustedGrid = 0;
    private boolean first_draw_tableadjust = true;
    private boolean isMutilCreate = false;
    private KDPopupMenu popupMenu;
    private KDMenuItem popupItemCopy;
    private KDMenuItem popupItemDelete;
    private KDMenuItem popupItemCut;
    private KDMenuItem popupItemPaste;
    private KDMenuItem popupItemProperties;
    private KDMenuItem popupItemCopyStyle;
    private KDMenuItem popupItemPasteStyle;
    private KDCheckBoxMenuItem popupChkItemLock;
    private KDMenu popupMenuAlign;
    private KDMenuItem popupItemAlignLeft;
    private KDMenuItem popupItemAlignCenter;
    private KDMenuItem popupItemAlignRight;
    private KDMenuItem popupItemAlignHArray;
    private KDMenuItem popupItemAlignTop;
    private KDMenuItem popupItemAlignMiddle;
    private KDMenuItem popupItemAlignBottom;
    private KDMenuItem popupItemAlignVArray;
    private KDMenu popupMenuSize;
    private KDMenuItem popupItemSameHeight;
    private KDMenuItem popupItemSameWidth;
    private KDMenuItem popupItemSameSize;
    private KDMenu popupMenuPosition;
    private KDMenuItem popupItemPositionCenter;
    private KDMenuItem popupItemPositionMiddle;
    private KDMenu popupMenuInsert;
    private KDMenuItem popupItemInsertLoopArea;
    private KDMenuItem popupItemInsertGroup;
    private KDMenuItem popupItemInsertTable;
    private KDMenuItem popupItemInsertText;
    private KDMenuItem popupItemInsertFiled;
    private KDMenuItem popupItemInsertVariant;
    private KDMenuItem popupItemInsertFormula;
    private KDMenuItem popupItemInsertLine;
    private KDMenuItem popupItemInsertImage;
    private KDMenuItem popupItemInsertChart;
    private KDPanel reportContainerPanel;
    private KDPanel superContainerPanel;
    private PageContainer pageContainerPanel;
    private KDScrollBar horizontalScrollBar;
    private KDPanel hScrollPane;
    private KDScrollBar verticalScrollBar;
    private KDPanel scrollCornerPanel;
    private RulePanel horizontalRule;
    private KDPanel hRulePanel;
    private KDPanel vRulePanel;
    private KDPanel rulelCornerPanel;
    private KDF report;
    private int undoIndex = -1;
    private ArrayList undoOperations;
    private ArrayList clipboardObjects;
    private double zoomFactor;
    private Point mouse = new Point();
    private int newObjectType;
    private boolean showGrid;
    int gridSize;
    private int transformationMinSize;
    private boolean snapToGrid;
    private int windowID;
    private EventListenerList listenerList = null;
    private String name4Title;
    private Page currentpage = null;
    private ReportElement findEle;
    private boolean isNewSelected;
    private boolean isDragEndAtRelease = false;
    private IContainer defaultContainer = null;
    private Point originMouse = null;
    private boolean bCreating = false;
    private static String res;
    private static final int SHOW_XY = 0;
    private static final int SHOW_DELTA_XY = 1;
    private IFileSaver fileSaver;
    private KDPopupMenu mnuSelectParent;
    private SelectParentHandler selectParentHandler;

    public KDFFrame(KDF report) {
        this.initComponents();
        this.installListener();
        this.installKeyListener();
        this.windowID = id++;
        this.setPreferredSize(new Dimension(350, 400));
        this.setDefaultCloseOperation(0);
        if (hsplit == null) {
            Image img1 = Icons.createImage("cursors/cursor_hsplit.gif");
            hsplit = Toolkit.getDefaultToolkit().createCustomCursor(img1, new Point(16, 16), "HSPLIT");
        }
        if (vsplit == null) {
            Image img2 = Icons.createImage("cursors/cursor_vsplit.gif");
            vsplit = Toolkit.getDefaultToolkit().createCustomCursor(img2, new Point(16, 16), "VSPLIT");
        }
        if (locked == null) {
            Image img3 = Icons.createImage("cursors/cursor_lock.gif");
            locked = Toolkit.getDefaultToolkit().createCustomCursor(img3, new Point(16, 16), "LOCKED");
        }
        this.pageContainerPanel.setKDFFrame(this);
        this.newObjectType = -1;
        this.report = report;
        this.report.setKDFFrame(this);
        this.updateTitle();
        ArrayList pages = report.getPages();
        if (pages.size() > 0) {
            this.currentpage = (Page)pages.get(0);
        }
        this.undoOperations = new ArrayList();
        this.clipboardObjects = new ArrayList();
        this.zoomFactor = 1.0;
        this.gridSize = 10;
        this.transformationMinSize = 5;
        this.undoIndex = -1;
        this.offscreenDimension = Toolkit.getDefaultToolkit().getScreenSize();
        this.offscreenImage = new BufferedImage(this.offscreenDimension.width, this.offscreenDimension.height, 7);
        this.offscreenImageDoc = new BufferedImage(this.offscreenDimension.width, this.offscreenDimension.height, 7);
        this.offscreen = GraphicsEnvironment.getLocalGraphicsEnvironment().createGraphics(this.offscreenImage);
        this.offscreen.setBackground(Misc.KDFFRAME_BACKGROUND);
        this.offscreen.clearRect(0, 0, this.offscreenDimension.width, this.offscreenDimension.height);
        this.offscreen.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        this.offscreen.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
        this.offscreen.setRenderingHint(RenderingHints.KEY_DITHERING, RenderingHints.VALUE_DITHER_DISABLE);
        this.offscreenDoc = GraphicsEnvironment.getLocalGraphicsEnvironment().createGraphics(this.offscreenImageDoc);
        this.offscreenDoc.setBackground(new Color(144, 242, 242));
        this.offscreenDoc.clearRect(0, 0, this.offscreenDimension.width, this.offscreenDimension.height);
        this.offscreenDoc.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        this.offscreenDoc.setRenderingHint(RenderingHints.KEY_DITHERING, RenderingHints.VALUE_DITHER_DISABLE);
        this.horizontalScrollBar.setValue(0);
        this.verticalScrollBar.setValue(0);
        this.originMouse = new Point(0, 0);
    }

    private void initComponents() {
        this.action = new KDFFListener();
        this.superContainerPanel = new KDPanel();
        this.reportContainerPanel = new KDPanel();
        this.hRulePanel = new KDPanel();
        this.horizontalRule = new RulePanel(0);
        this.rulelCornerPanel = new KDPanel();
        this.vRulePanel = new KDPanel();
        this.pageContainerPanel = new PageContainer();
        this.hScrollPane = new KDPanel();
        this.verticalScrollBar = new KDScrollBar();
        this.horizontalScrollBar = new KDScrollBar(0);
        this.scrollCornerPanel = new KDPanel();
        this.popupMenu = new KDPopupMenu();
        this.popupChkItemLock = new KDCheckBoxMenuItem(KDFFrame.getMLS("lock", "\u9501\u5b9a"));
        this.popupChkItemLock.addActionListener((ActionListener)this.action);
        this.popupItemCut = MenuItemFactory.create((short)203);
        this.popupItemCopy = MenuItemFactory.create((short)204);
        this.popupItemPaste = MenuItemFactory.create((short)205);
        this.popupItemDelete = MenuItemFactory.create((short)206);
        this.popupItemCopyStyle = MenuItemFactory.create((short)207);
        this.popupItemPasteStyle = MenuItemFactory.create((short)208);
        this.popupMenuInsert = MenuItemFactory.createMenu((short)300);
        this.popupItemInsertLoopArea = MenuItemFactory.create((short)302);
        this.popupItemInsertGroup = MenuItemFactory.create((short)303);
        this.popupItemInsertTable = MenuItemFactory.create((short)304);
        this.popupItemInsertText = MenuItemFactory.create((short)305);
        this.popupItemInsertFiled = MenuItemFactory.create((short)306);
        this.popupItemInsertVariant = MenuItemFactory.create((short)307);
        this.popupItemInsertFormula = MenuItemFactory.create((short)308);
        this.popupItemInsertLine = MenuItemFactory.create((short)309);
        this.popupItemInsertImage = MenuItemFactory.create((short)310);
        this.popupItemInsertChart = MenuItemFactory.create((short)311);
        this.popupMenuAlign = MenuItemFactory.createMenu((short)420);
        this.popupItemAlignLeft = MenuItemFactory.create((short)421);
        this.popupItemAlignCenter = MenuItemFactory.create((short)422);
        this.popupItemAlignRight = MenuItemFactory.create((short)423);
        this.popupItemAlignHArray = MenuItemFactory.create((short)424);
        this.popupItemAlignTop = MenuItemFactory.create((short)425);
        this.popupItemAlignMiddle = MenuItemFactory.create((short)426);
        this.popupItemAlignBottom = MenuItemFactory.create((short)427);
        this.popupItemAlignVArray = MenuItemFactory.create((short)428);
        this.popupMenuSize = MenuItemFactory.createMenu((short)430);
        this.popupItemSameHeight = MenuItemFactory.create((short)431);
        this.popupItemSameWidth = MenuItemFactory.create((short)432);
        this.popupItemSameSize = MenuItemFactory.create((short)433);
        this.popupMenuPosition = MenuItemFactory.createMenu((short)440);
        this.popupItemPositionCenter = MenuItemFactory.create((short)441);
        this.popupItemPositionMiddle = MenuItemFactory.create((short)442);
        this.popupItemProperties = MenuItemFactory.create((short)402);
        this.popupMenu.add((JMenuItem)this.popupChkItemLock);
        this.popupMenu.add((Component)new KDSeparator());
        this.addMenuItem(this.popupMenu, this.popupItemCut);
        this.addMenuItem(this.popupMenu, this.popupItemCopy);
        this.addMenuItem(this.popupMenu, this.popupItemPaste);
        this.addMenuItem(this.popupMenu, this.popupItemDelete);
        this.popupMenu.add((Component)new KDSeparator());
        this.popupMenu.add((JMenuItem)this.popupMenuInsert);
        this.popupMenu.add((Component)new KDSeparator());
        this.addMenuItem(this.popupMenu, this.popupItemCopyStyle);
        this.addMenuItem(this.popupMenu, this.popupItemPasteStyle);
        this.popupMenu.add((Component)new KDSeparator());
        this.popupMenu.add((JMenuItem)this.popupMenuAlign);
        this.popupMenu.add((JMenuItem)this.popupMenuSize);
        this.popupMenu.add((JMenuItem)this.popupMenuPosition);
        this.popupMenu.add((Component)new KDSeparator());
        this.addMenuItem(this.popupMenu, this.popupItemProperties);
        this.addMenuItem(this.popupMenuInsert, this.popupItemInsertLoopArea);
        this.addMenuItem(this.popupMenuInsert, this.popupItemInsertGroup);
        this.addMenuItem(this.popupMenuInsert, this.popupItemInsertTable);
        this.addMenuItem(this.popupMenuInsert, this.popupItemInsertText);
        this.addMenuItem(this.popupMenuInsert, this.popupItemInsertFiled);
        this.addMenuItem(this.popupMenuInsert, this.popupItemInsertVariant);
        this.addMenuItem(this.popupMenuInsert, this.popupItemInsertFormula);
        this.addMenuItem(this.popupMenuInsert, this.popupItemInsertLine);
        this.addMenuItem(this.popupMenuInsert, this.popupItemInsertImage);
        this.addMenuItem(this.popupMenuInsert, this.popupItemInsertChart);
        this.addMenuItem(this.popupMenuAlign, this.popupItemAlignLeft);
        this.addMenuItem(this.popupMenuAlign, this.popupItemAlignCenter);
        this.addMenuItem(this.popupMenuAlign, this.popupItemAlignRight);
        this.addMenuItem(this.popupMenuAlign, this.popupItemAlignHArray);
        this.popupMenuAlign.add((Component)new KDSeparator());
        this.addMenuItem(this.popupMenuAlign, this.popupItemAlignTop);
        this.addMenuItem(this.popupMenuAlign, this.popupItemAlignMiddle);
        this.addMenuItem(this.popupMenuAlign, this.popupItemAlignBottom);
        this.addMenuItem(this.popupMenuAlign, this.popupItemAlignVArray);
        this.addMenuItem(this.popupMenuSize, this.popupItemSameHeight);
        this.addMenuItem(this.popupMenuSize, this.popupItemSameWidth);
        this.popupMenuSize.add((Component)new KDSeparator());
        this.addMenuItem(this.popupMenuSize, this.popupItemSameSize);
        this.addMenuItem(this.popupMenuPosition, this.popupItemPositionCenter);
        this.addMenuItem(this.popupMenuPosition, this.popupItemPositionMiddle);
        this.popupItemProperties.setEnabled(true);
        this.verticalScrollBar.setMaximum(0);
        this.horizontalScrollBar.setMaximum(0);
        this.horizontalScrollBar.setOrientation(0);
        this.scrollCornerPanel.setMaximumSize(new Dimension(17, 17));
        this.scrollCornerPanel.setMinimumSize(new Dimension(17, 17));
        this.scrollCornerPanel.setPreferredSize(new Dimension(17, 17));
        this.hScrollPane.setLayout((LayoutManager)new BorderLayout());
        this.hScrollPane.add((Component)this.horizontalScrollBar, (Object)"Center");
        this.hScrollPane.add((Component)this.scrollCornerPanel, (Object)"East");
        this.reportContainerPanel.setLayout((LayoutManager)new BorderLayout());
        this.reportContainerPanel.add((Component)this.pageContainerPanel, (Object)"Center");
        this.superContainerPanel.setLayout((LayoutManager)new BorderLayout());
        this.superContainerPanel.add((Component)this.reportContainerPanel, (Object)"Center");
        this.superContainerPanel.add((Component)this.verticalScrollBar, (Object)"East");
        this.superContainerPanel.add((Component)this.hScrollPane, (Object)"South");
        this.getContentPane().add((Component)this.superContainerPanel, "Center");
        try {
            this.setSelected(true);
        }
        catch (PropertyVetoException e1) {
            e1.printStackTrace();
        }
    }

    private void addMenuItem(KDPopupMenu mnu, KDMenuItem mni) {
        mnu.add((JMenuItem)mni);
        mni.addActionListener((ActionListener)this.action);
    }

    private void addMenuItem(KDMenu mnu, KDMenuItem mni) {
        mnu.add((JMenuItem)mni);
        mni.addActionListener((ActionListener)this.action);
    }

    private void installKeyListener() {
        InputMap inputMap = this.getInputMap(1);
        ActionMap actionMap = this.getActionMap();
        KeyStroke ks_ctrlF4 = KeyStroke.getKeyStroke(115, 128);
        inputMap.put(ks_ctrlF4, "Along_Ctrl_F4");
        actionMap.put(inputMap.get(ks_ctrlF4), new CtrlF4CloseHandler());
        ArrowPressHandler handler = new ArrowPressHandler(40);
        KeyStroke keyStroke = KeyStroke.getKeyStroke(40, 0);
        inputMap.put(keyStroke, "Along_Down");
        actionMap.put(inputMap.get(keyStroke), handler);
        keyStroke = KeyStroke.getKeyStroke(40, 64);
        inputMap.put(keyStroke, "Along_Down_Shift");
        actionMap.put(inputMap.get(keyStroke), handler);
        handler = new ArrowPressHandler(38);
        keyStroke = KeyStroke.getKeyStroke(38, 0);
        inputMap.put(keyStroke, "Along_Up");
        actionMap.put(inputMap.get(keyStroke), handler);
        keyStroke = KeyStroke.getKeyStroke(38, 64);
        inputMap.put(keyStroke, "Along_Up_Shift");
        actionMap.put(inputMap.get(keyStroke), handler);
        handler = new ArrowPressHandler(37);
        keyStroke = KeyStroke.getKeyStroke(37, 0);
        inputMap.put(keyStroke, "Along_Left");
        actionMap.put(inputMap.get(keyStroke), handler);
        keyStroke = KeyStroke.getKeyStroke(37, 64);
        inputMap.put(keyStroke, "Along_Left_Shift");
        actionMap.put(inputMap.get(keyStroke), handler);
        handler = new ArrowPressHandler(39);
        keyStroke = KeyStroke.getKeyStroke(39, 0);
        inputMap.put(keyStroke, "Along_Right");
        actionMap.put(inputMap.get(keyStroke), handler);
        keyStroke = KeyStroke.getKeyStroke(39, 64);
        inputMap.put(keyStroke, "Along_Right_Shift");
        actionMap.put(inputMap.get(keyStroke), handler);
    }

    private void installListener() {
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseExited(MouseEvent e) {
                KDFFrame.this.getMainFrame().showStatusElementName("");
                KDFFrame.this.getMainFrame().showStatusMousePosition("");
                KDFFrame.this.getMainFrame().showStatusDeltaMouse("");
            }
        });
        this.addInternalFrameListener(new InternalFrameHandler());
        this.pageContainerPanel.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent evt) {
                KDFFrame.this.reportResized(evt);
            }
        });
        this.pageContainerPanel.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent evt) {
                KDFFrame.this.actionMousePressed(evt);
            }

            @Override
            public void mouseReleased(MouseEvent evt) {
                KDFFrame.this.actionMouseReleased(evt);
            }
        });
        this.pageContainerPanel.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent evt) {
                KDFFrame.this.actionMouseMoved(evt);
            }

            @Override
            public void mouseDragged(MouseEvent evt) {
                KDFFrame.this.actionMouseDragged(evt);
            }
        });
        this.verticalScrollBar.addAdjustmentListener(new AdjustmentListener(){

            @Override
            public void adjustmentValueChanged(AdjustmentEvent evt) {
                KDFFrame.this.vScrollBarAdjustmentValueChanged(evt);
            }
        });
        this.horizontalScrollBar.addAdjustmentListener(new AdjustmentListener(){

            @Override
            public void adjustmentValueChanged(AdjustmentEvent evt) {
                KDFFrame.this.hScrollBarAdjustmentValueChanged(evt);
            }
        });
    }

    public FormDesigner getMainFrame() {
        Container parent;
        if (this.mf != null) {
            return this.mf;
        }
        for (parent = this.getDesktopPane().getParent(); parent != null && !(parent instanceof FormDesigner); parent = parent.getParent()) {
        }
        if (parent != null) {
            this.mf = (FormDesigner)((Object)parent);
            return this.mf;
        }
        return null;
    }

    private void hScrollBarAdjustmentValueChanged(AdjustmentEvent evt) {
        this.isShowDirty = true;
        this.pageContainerPanel.repaint();
    }

    private void reportResized(ComponentEvent evt) {
        int rulesize = 19;
        if (this.currentpage != null) {
            if (this.pageContainerPanel.getWidth() >= this.getZoomedDim(this.currentpage.getWidth()) + rulesize) {
                this.horizontalScrollBar.setMaximum(this.currentpage.getWidth());
                this.horizontalScrollBar.setVisibleAmount(this.horizontalScrollBar.getMaximum());
                this.horizontalScrollBar.setValue(0);
                this.horizontalScrollBar.setEnabled(false);
            } else {
                this.horizontalScrollBar.setMaximum(this.getZoomedDim(this.currentpage.getWidth()) + rulesize);
                this.horizontalScrollBar.setVisibleAmount(this.pageContainerPanel.getWidth());
                this.horizontalScrollBar.setEnabled(true);
            }
            if (this.pageContainerPanel.getHeight() >= this.getZoomedDim(this.currentpage.getHeight()) + rulesize) {
                this.verticalScrollBar.setMaximum(this.currentpage.getHeight());
                this.verticalScrollBar.setVisibleAmount(this.verticalScrollBar.getMaximum());
                this.verticalScrollBar.setValue(0);
                this.verticalScrollBar.setEnabled(false);
            } else {
                this.verticalScrollBar.setMaximum(this.getZoomedDim(this.currentpage.getHeight()) + rulesize);
                this.verticalScrollBar.setVisibleAmount(this.pageContainerPanel.getHeight());
                this.verticalScrollBar.setEnabled(true);
            }
        } else {
            this.horizontalScrollBar.setMaximum(0);
            this.horizontalScrollBar.setVisibleAmount(0);
            this.horizontalScrollBar.setValue(0);
            this.horizontalScrollBar.setEnabled(false);
            this.verticalScrollBar.setMaximum(0);
            this.verticalScrollBar.setVisibleAmount(0);
            this.verticalScrollBar.setValue(0);
            this.verticalScrollBar.setEnabled(false);
        }
    }

    private void vScrollBarAdjustmentValueChanged(AdjustmentEvent evt) {
        this.isShowDirty = true;
        this.pageContainerPanel.repaint();
    }

    private void reportPanelAncestorAdded(AncestorEvent evt) {
    }

    public KDF getReport() {
        return this.report;
    }

    public void setSelectedElements(Vector selectedElements) {
        if (this.currentpage != null) {
            this.currentpage.setSelectedElements(selectedElements);
        }
    }

    public ArrayList getClipboardObjects() {
        return this.clipboardObjects;
    }

    public void setClipboardObjects(ArrayList clipboardObjects) {
        this.clipboardObjects = clipboardObjects;
    }

    public PageContainer getReportPanel() {
        return this.pageContainerPanel;
    }

    private void drawVoidDoc(Graphics2D g) {
        if (this.currentpage != null) {
            g.setColor(Color.CYAN);
            int horizontal_scroll = this.horizontalScrollBar.getValue();
            int vertical_scroll = this.verticalScrollBar.getValue();
            int zoomed_width = this.getZoomedDim(this.currentpage.getWidth());
            int design_height = this.currentpage.getHeight();
            int zoomed_height = this.getZoomedDim(design_height);
            this.currentpage.drawPage(g, this.getZoomFactor(), this.horizontalScrollBar.getValue(), this.verticalScrollBar.getValue());
            this.drawGrid(g, horizontal_scroll, vertical_scroll, zoomed_width, design_height, zoomed_height);
            if (this.getSelectedElements().size() == 0) {
                this.currentpage.drawCorona(g, this.getZoomFactor(), this.getPageOffsetX(), this.getPageOffsetY(), true);
            }
        }
    }

    private void drawGrid(Graphics2D g, int horizontal_scroll, int vertical_scroll, int zoomed_width, int design_height, int zoomed_height) {
        g.setColor(new Color(230, 230, 230));
        if (this.isShowGrid()) {
            Stroke defaultStroke = g.getStroke();
            g.setStroke(m_Dashed3);
            int zoomed_grid_size = this.getZoomedDim(this.gridSize);
            int grid_left = 10 + zoomed_grid_size - horizontal_scroll;
            int line_top = 10 - vertical_scroll + 1;
            int line_bottom = this.getZoomedDim(design_height) + 10 - vertical_scroll - 2;
            if (zoomed_grid_size > 2) {
                int i = 1;
                grid_left = 10 - horizontal_scroll + this.getZoomedDim(i * this.gridSize);
                while (grid_left < zoomed_width + (int)((double)zoomed_width * 0.1) - horizontal_scroll) {
                    g.drawLine(grid_left, line_top, grid_left, line_bottom);
                    grid_left = 10 - horizontal_scroll + this.getZoomedDim(++i * this.gridSize);
                }
            }
            int grid_top = 10 - vertical_scroll;
            int line_left = 10 - horizontal_scroll + 1;
            int line_right = zoomed_width + 10 - horizontal_scroll - 1;
            if (zoomed_grid_size > 2) {
                int i = 1;
                grid_top = 10 - vertical_scroll + this.getZoomedDim(i * this.gridSize);
                while (grid_top < line_bottom) {
                    g.drawLine(line_left, grid_top, line_right, grid_top);
                    grid_top = 10 - vertical_scroll + this.getZoomedDim(++i * this.gridSize);
                }
            }
            g.setStroke(defaultStroke);
        }
    }

    public int getZoomedDim(double dim) {
        return (int)dim;
    }

    public int getLogicalDim(int dim) {
        return dim;
    }

    public double getZoomFactor() {
        return this.zoomFactor;
    }

    public void setZoomFactor(double zoomFactor) {
        if (this.zoomFactor != zoomFactor) {
            this.zoomFactor = zoomFactor;
            this.reportResized(new ComponentEvent(this.pageContainerPanel, 0));
            this.isShowDirty = true;
            this.repaint();
        }
    }

    public void paintReportPanel(Graphics g) {
        this.redrawAll(this.offscreen, null, 0);
        g.drawImage(this.offscreenImage, 0, 0, this.offscreenImage.getWidth(), this.offscreenImage.getHeight(), (ImageObserver)((Object)this));
    }

    private void redrawAll(Graphics2D g, Rectangle clipRect, int margin) {
        g.clearRect(0, 0, this.offscreenImage.getWidth(), this.offscreenImage.getHeight());
        if (clipRect == null) {
            clipRect = new Rectangle(0, 0, this.report.getPureWidth(), this.report.getPureHeight());
        }
        this.drawVoidDoc(g);
        if (this.currentpage == null) {
            return;
        }
        this.drawElement(this.currentpage, g, clipRect, margin);
        if (this.getSelectedElements().size() > 0) {
            boolean master = true;
            for (int i = 0; i < this.getSelectedElements().size(); ++i) {
                ReportElement re = (ReportElement)this.getSelectedElements().get(i);
                if (!re.intersects(clipRect)) continue;
                re.drawCorona(g, this.getZoomFactor(), this.getPageOffsetX(), this.getPageOffsetY(), master);
                master = false;
            }
        }
    }

    private void drawElement(IElement ele, Graphics2D g, Rectangle clipRect, int margin) {
        if (this.currentpage != null) {
            this.currentpage.drawAllObject(g, this.getZoomFactor(), this.horizontalScrollBar.getValue(), this.verticalScrollBar.getValue());
        }
    }

    public int getNewObjectType() {
        return this.newObjectType;
    }

    public void setNewObjectType(int newObjectType, boolean isMultiCreate) {
        this.isMutilCreate = isMultiCreate;
        if (this.newObjectType == newObjectType) {
            return;
        }
        if (newObjectType == -1) {
            this.pageContainerPanel.setCursor(Cursor.getDefaultCursor());
        } else {
            this.pageContainerPanel.setCursor(Cursor.getPredefinedCursor(1));
        }
        this.newObjectType = newObjectType;
    }

    public PageContainer getPageContainerPanel() {
        return this.pageContainerPanel;
    }

    public void setPageContainerPanel(PageContainer jPanelReport) {
        this.pageContainerPanel = jPanelReport;
    }

    public boolean isShowGrid() {
        return this.showGrid;
    }

    public void setShowGrid(boolean showGrid) {
        if (this.showGrid == showGrid) {
            return;
        }
        this.showGrid = showGrid;
        this.isShowDirty = true;
        this.pageContainerPanel.repaint();
    }

    public int getGridSize() {
        return this.gridSize;
    }

    public void setGridSize(int gridSize) {
        this.gridSize = gridSize;
    }

    public int getTransformationMinSize() {
        return this.transformationMinSize;
    }

    public void setTransformationMinSize(int transformationMinSize) {
        this.transformationMinSize = transformationMinSize;
    }

    public int snapToGridVertically(int scaledYPoint) {
        if (!this.isSnapToGrid()) {
            return scaledYPoint;
        }
        int vertical_scroll = this.verticalScrollBar.getValue();
        int zoomed_grid_size = this.getZoomedDim(this.gridSize);
        int grid_top = 10 + zoomed_grid_size - vertical_scroll;
        int design_height = this.report.getHeight();
        int line_bottom = this.getZoomedDim(design_height) + 10 - vertical_scroll - 2;
        if (zoomed_grid_size > 2) {
            int i = 1;
            while (grid_top < line_bottom) {
                if (Math.abs(grid_top - scaledYPoint) <= zoomed_grid_size / 2) {
                    return grid_top;
                }
                grid_top = 10 - vertical_scroll + this.getZoomedDim(++i * this.gridSize);
            }
        }
        return scaledYPoint;
    }

    public int snapToGridOrizzontally(int scaledXPoint) {
        if (!this.isSnapToGrid()) {
            return scaledXPoint;
        }
        int horizontal_scroll = this.horizontalScrollBar.getValue();
        int zoomed_width = this.getZoomedDim(this.report.getPureWidth());
        int zoomed_grid_size = this.getZoomedDim(this.gridSize);
        int grid_left = 10 + zoomed_grid_size - horizontal_scroll;
        if (zoomed_grid_size > 2) {
            int i = 1;
            while (grid_left < zoomed_width + 10 - horizontal_scroll) {
                if (Math.abs(grid_left - scaledXPoint) <= zoomed_grid_size / 2) {
                    return grid_left;
                }
                grid_left = 10 - horizontal_scroll + this.getZoomedDim(++i * this.gridSize);
            }
        }
        return scaledXPoint;
    }

    public int gridMultiple(int zoomedDim) {
        if (!this.isSnapToGrid()) {
            return zoomedDim;
        }
        int zoomed_grid_size = this.getZoomedDim(this.gridSize);
        int val = Math.abs(zoomedDim);
        while (val % zoomed_grid_size != 0) {
            ++val;
        }
        return zoomedDim >= 0 ? val : -val;
    }

    public int gridMultipleMinus(int zoomedDim) {
        if (!this.isSnapToGrid()) {
            return zoomedDim;
        }
        int zoomed_grid_size = this.getZoomedDim(this.gridSize);
        int val = Math.abs(zoomedDim);
        if (val % zoomed_grid_size == 0) {
            return zoomedDim;
        }
        if (val % zoomed_grid_size <= zoomed_grid_size / 2) {
            while (val % zoomed_grid_size != 0) {
                --val;
            }
        } else {
            while (val % zoomed_grid_size != 0) {
                ++val;
            }
        }
        return zoomedDim >= 0 ? val : -val;
    }

    public boolean isSnapToGrid() {
        return this.snapToGrid;
    }

    public void setSnapToGrid(boolean snapToGrid) {
        this.snapToGrid = snapToGrid;
    }

    public boolean isIsDocDirty() {
        return this.isShowDirty;
    }

    public void setIsDocDirty(boolean isDocDirty) {
        this.isShowDirty = isDocDirty;
    }

    public void checkSelection(boolean repaint) {
        if (this.currentpage == null) {
            return;
        }
        boolean needRepaint = false;
        for (int i = 0; i < this.getSelectedElements().size(); ++i) {
            ReportElement selected = (ReportElement)this.getSelectedElements().get(i);
            if (this.currentpage.isSelectedElement(selected)) continue;
            this.getSelectedElements().clear();
            --i;
            needRepaint = true;
        }
        if (repaint && needRepaint) {
            this.pageContainerPanel.repaint();
        }
    }

    public int getWindowID() {
        return this.windowID;
    }

    public void setWindowID(int windowID) {
        this.windowID = windowID;
    }

    public synchronized void addReportListener(ReportListener listener) {
        if (this.listenerList == null) {
            this.listenerList = new EventListenerList();
        }
        this.listenerList.add(ReportListener.class, listener);
    }

    synchronized void removeReportListener(ReportListener listener) {
        this.listenerList.remove(ReportListener.class, listener);
    }

    public void fireReportListenerReportElementsSelectionChanged(ReportElementsSelectionEvent event) {
        if (this.listenerList == null) {
            return;
        }
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != ReportListener.class) continue;
            ((ReportListener)listeners[i + 1]).reportElementsSelectionChanged(event);
        }
    }

    public void fireReportListenerReportElementsChanged(ReportElementChangedEvent event) {
        if (this.listenerList == null) {
            return;
        }
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != ReportListener.class) continue;
            ((ReportListener)listeners[i + 1]).reportElementsChanged(event);
        }
    }

    public UndoOperation getUndoOperation() {
        if (this.undoOperations.size() > 0 && this.undoIndex >= 0) {
            return (UndoOperation)this.undoOperations.get(this.undoIndex);
        }
        return null;
    }

    public void undo() {
        if (this.getUndoOperation() != null) {
            this.getUndoOperation().undo();
            --this.undoIndex;
            this.getReport().decrementDirty();
        }
    }

    public void redo() {
        if (this.getRedoOperation() != null) {
            this.getRedoOperation().redo();
            ++this.undoIndex;
            this.getReport().incrementDirty();
        }
    }

    public UndoOperation getRedoOperation() {
        if (this.undoOperations.size() > this.undoIndex + 1) {
            return (UndoOperation)this.undoOperations.get(this.undoIndex + 1);
        }
        return null;
    }

    public void addUndoOperation(UndoOperation undo) {
        while (this.undoOperations.size() > this.undoIndex + 1) {
            this.undoOperations.remove(this.undoIndex + 1);
        }
        this.undoOperations.add(undo);
        ++this.undoIndex;
        this.getReport().incrementDirty();
        this.getMainFrame().updateUndoMenu(this);
    }

    public void setName4Title(String name) {
        this.name4Title = name;
        this.updateTitle();
    }

    public void updateTitle() {
        String title = StringUtil.isEmptyString((String)this.name4Title) ? this.report.getFilename4Title() : this.name4Title;
        title = title + (this.report.isDirty() ? " *" : "");
        this.setTitle(title);
        if (this.mf != null) {
            this.mf.getOwner().setTitle(this.getMainFrame().getTitle() + " - " + title);
            this.mf.updateMenuWindowList();
        }
    }

    public void setCurrentpage(Page currentpage) {
        if (this.currentpage != currentpage) {
            this.currentpage = currentpage;
            this.pageContainerPanel.repaint();
        }
        this.getMainFrame().setHeadFooter(this.isHeadFooter());
        this.reportResized(null);
    }

    public Page getCurrentPage() {
        return this.currentpage;
    }

    public void setShowRule(boolean isShowRule) {
        if (isShowRule != this.isShowRule) {
            this.refreshRule(isShowRule);
            this.isShowRule = isShowRule;
        }
    }

    private void refreshRule(boolean isShowRule) {
        if (isShowRule) {
            this.vRulePanel.setMinimumSize(new Dimension(16, 16));
            this.vRulePanel.setPreferredSize(new Dimension(16, Short.MAX_VALUE));
            this.hRulePanel.setMinimumSize(new Dimension(16, 16));
            this.hRulePanel.setPreferredSize(new Dimension(Short.MAX_VALUE, 16));
            this.rulelCornerPanel.setMinimumSize(new Dimension(16, 16));
            this.rulelCornerPanel.setPreferredSize(new Dimension(16, 16));
        } else {
            this.vRulePanel.setMinimumSize(new Dimension(0, 0));
            this.vRulePanel.setPreferredSize(new Dimension(0, 0));
            this.hRulePanel.setMinimumSize(new Dimension(0, 0));
            this.hRulePanel.setPreferredSize(new Dimension(0, 0));
            this.rulelCornerPanel.setMinimumSize(new Dimension(0, 0));
            this.rulelCornerPanel.setPreferredSize(new Dimension(0, 0));
        }
        this.pack();
        this.invalidate();
        this.repaint();
    }

    public boolean isShowRule() {
        return this.isShowRule;
    }

    public boolean isCanPaste() {
        if (this.getSelectedElements().size() > 1) {
            return false;
        }
        ReportElement re = null;
        re = this.getSelectedElements().size() == 0 ? this.currentpage : (ReportElement)this.getSelectedElements().get(0);
        if (this.getMainFrame().getClipBoard().size() > 0 && re instanceof AbstractContainer) {
            if (re instanceof LoopArea) {
                Object clipObj = this.getMainFrame().getClipBoard().get(0);
                if (this.getMainFrame().getClipBoard().size() > 1 || ((LoopArea)re).getChildren().size() > 0 || !(clipObj instanceof Group) && !(clipObj instanceof Table)) {
                    return false;
                }
            }
            if (re instanceof HeadFooter) {
                Iterator it = this.getMainFrame().getClipBoard().iterator();
                while (it.hasNext()) {
                    if (!this.hasCertainElement((ReportElement)it.next())) continue;
                    return false;
                }
            }
            return true;
        }
        return false;
    }

    private boolean hasCertainElement(ReportElement re) {
        if (re instanceof LoopArea || re instanceof FieldElement) {
            return true;
        }
        if (re instanceof AbstractContainer) {
            AbstractContainer c = (AbstractContainer)re;
            Iterator it = c.getChildren().iterator();
            while (it.hasNext()) {
                if (!this.hasCertainElement((ReportElement)it.next())) continue;
                return true;
            }
        }
        return false;
    }

    public void paste() {
        if (!this.isCanPaste()) {
            return;
        }
        Iterator it = this.getMainFrame().getClipBoard().iterator();
        if (this.getSelectedElements().size() == 1 && this.getSelectedElements().get(0) instanceof AbstractContainer) {
            this.defaultContainer = (AbstractContainer)this.getSelectedElements().get(0);
        }
        Page topPage = ((ReportElement)((Object)this.defaultContainer)).getTopContainer();
        this.setSelectedElement(null);
        while (it.hasNext()) {
            ReportElement reOld = (ReportElement)it.next();
            ReportElement re = null;
            re = reOld instanceof AbstractContainer ? ((AbstractContainer)reOld).cloneMeWidthAllChildren() : reOld.cloneMe();
            this.defaultContainer.addElement(re);
            re.setParent(this.defaultContainer);
            this.fireReportListenerReportElementsChanged(new ReportElementChangedEvent(this, re, 2));
            re.setName(this.getReport().getUniqueName(re.getEleType()));
            this.getReport().getElementsNameMap().put(re.getName(), re);
            re.setAliasName(this.getReport().getUniqueAliasName(re.getEleType()), true);
            if (re instanceof AbstractContainer) {
                for (ReportElement reChild : ((AbstractContainer)re).getChildren()) {
                    this.pastedAction(reChild, topPage);
                    for (int i = 0; i < 4; ++i) {
                        SideLocation sl = reChild.getLocation().getSideLocation(i);
                        if (!sl.getRelativeObjectID().equals(reOld.getName())) continue;
                        sl.setRelativeObjectID(re.getName());
                    }
                }
            }
            if (this.defaultContainer instanceof Table) {
                TableLocation tbloc = new TableLocation((Table)this.defaultContainer);
                re.setTableLocation(tbloc);
                ((Table)this.defaultContainer).refreshChildPos();
            } else {
                re.getLocation().createDefaultLocation();
                re.setLocation(re.getLocation());
            }
            this.addUndoOperation(new InsertElementOperation(this, re, KDFFrame.getMLS("paste", "_\u7c98\u8d34")));
            this.addSelectedElement(re);
            FormDesigner.initReportElementListener(this.getMainFrame(), this.getReport(), re);
        }
    }

    private void pastedAction(ReportElement re, Page topPage) {
        re.setTopContainer(topPage);
        String reOldName = re.getName();
        this.fireReportListenerReportElementsChanged(new ReportElementChangedEvent(this, re, 2));
        re.setName(this.getReport().getUniqueName(re.getEleType()));
        this.getReport().getElementsNameMap().put(re.getName(), re);
        re.setAliasName(this.getReport().getUniqueAliasName(re.getEleType()), true);
        if (re instanceof AbstractContainer) {
            this.pastedChangeRelativeID((AbstractContainer)re, reOldName, re.getName());
        }
        if (!(re instanceof Page)) {
            this.pastedChangeRelativeID((AbstractContainer)re.getParent(), reOldName, re.getName());
        }
        if (re instanceof AbstractContainer) {
            Iterator it = ((AbstractContainer)re).getChildren().iterator();
            while (it.hasNext()) {
                this.pastedAction((ReportElement)it.next(), topPage);
            }
        }
    }

    private void pastedChangeRelativeID(AbstractContainer ac, String oldID, String newID) {
        for (ReportElement re : ac.getChildren()) {
            for (int i = 0; i < 4; ++i) {
                SideLocation sl = re.getLocation().getSideLocation(i);
                if (!sl.getRelativeObjectID().equals(oldID)) continue;
                sl.setRelativeObjectID(newID);
            }
        }
    }

    public void copy() {
        ArrayList<ReportElement> copiedElements = new ArrayList<ReportElement>();
        for (ReportElement er : this.getSelectedElements()) {
            if (er instanceof AbstractContainer) {
                copiedElements.add(((AbstractContainer)er).cloneMeWidthAllChildren());
                continue;
            }
            copiedElements.add(er.cloneMe());
        }
        if (copiedElements.size() > 0) {
            this.getMainFrame().setClipBoardContent(copiedElements);
        }
        this.getMainFrame().setPasteEnebled(this.isCanPaste());
    }

    public void cut() {
        ArrayList<ReportElement> copiedElements = new ArrayList<ReportElement>();
        for (ReportElement er : this.getSelectedElements()) {
            if (er instanceof AbstractContainer) {
                copiedElements.add(((AbstractContainer)er).cloneMeWidthAllChildren());
                continue;
            }
            copiedElements.add(er.cloneMe());
        }
        if (copiedElements.size() > 0) {
            this.getMainFrame().setClipBoardContent(copiedElements);
        }
        this.deleteSelectedElements();
        this.getMainFrame().setPasteEnebled(this.isCanPaste());
    }

    public void deleteSelectedElements() {
        if (this.getSelectedElements().size() == 0 && this.getReport().getPages().size() > 1 && this.getCurrentPage() != null) {
            this.getReport().getPages().remove(this.getCurrentPage());
            this.fireReportListenerReportElementsChanged(new ReportElementChangedEvent(this, this.getCurrentPage(), 1));
            this.setCurrentpage((Page)this.getReport().getPages().get(0));
            this.getReport().setDirty(true);
            return;
        }
        Iterator it = this.getSelectedElements().iterator();
        DeleteElementsOperation undoOp = new DeleteElementsOperation(this);
        undoOp.setElements(this.getSelectedElements());
        IContainer parent = null;
        while (it.hasNext()) {
            ReportElement re = (ReportElement)it.next();
            if (parent == null) {
                parent = re.getParent();
            }
            re.delete();
            this.fireReportListenerReportElementsChanged(new ReportElementChangedEvent(this, re, 1));
        }
        this.addUndoOperation(undoOp);
        this.getSelectedElements().clear();
        ReportElement newSelectRe = null;
        if (parent != null) {
            newSelectRe = parent.getChildren().size() == 0 ? (parent instanceof Page ? null : (ReportElement)((Object)parent)) : (ReportElement)parent.getChildren().get(parent.getChildren().size() - 1);
        }
        this.setSelectedElement(newSelectRe);
        this.pageContainerPanel.repaint();
    }

    private void actionMousePressed(MouseEvent evt) {
        this.drag_selection_mode = false;
        if (this.currentpage == null) {
            return;
        }
        if (!this.currentpage.intersects(new Point(this.getLogicalDim(evt.getX() + this.horizontalScrollBar.getValue()) - 10, this.getLogicalDim(evt.getY() + this.verticalScrollBar.getValue()) - 10))) {
            return;
        }
        if (evt.getButton() == 1 && (this.pageContainerPanel.getCursor() == hsplit || this.pageContainerPanel.getCursor() == vsplit)) {
            this.first_draw_tableadjust = true;
            Table table = (Table)this.getSelectedElements().get(0);
            this.table_adjusting = true;
            this.table_adjustedGrid = this.pageContainerPanel.getCursor() == hsplit ? table.getDragColRowNo(evt.getX() - this.getPageOffsetX(), evt.getY() - this.getPageOffsetY(), evt.getY() - this.originMouse.y > 0) : table.getDragColRowNo(evt.getX() - this.getPageOffsetX(), evt.getY() - this.getPageOffsetY(), evt.getX() - this.originMouse.x > 0);
            return;
        }
        if (evt.getButton() == 1 && evt.getClickCount() < 2) {
            ReportElement re2;
            this.newObjectOrigin = new Point(this.snapToGridOrizzontally(evt.getX()), this.snapToGridVertically(evt.getY()));
            this.mouse.x = this.newObjectOrigin.x;
            this.mouse.y = this.newObjectOrigin.y;
            this.defaultContainer = this.currentpage;
            if (this.newObjectType != -1 && this.pageContainerPanel.getCursor() != locked) {
                this.defaultContainer = this.searchContainer(evt.getX(), evt.getY());
                if (this.defaultContainer instanceof Table) {
                    this.newObjectOrigin = ((Table)this.defaultContainer).getStartColRowPoint(evt.getX() - this.getPageOffsetX(), evt.getY() - this.getPageOffsetY());
                    this.mouse.x = this.newObjectOrigin.x;
                    this.mouse.y = this.newObjectOrigin.y;
                } else {
                    this.newObjectOrigin = new Point(this.snapToGridOrizzontally(evt.getX()), this.snapToGridVertically(evt.getY()));
                    this.mouse.x = this.newObjectOrigin.x;
                    this.mouse.y = this.newObjectOrigin.y;
                }
                this.firstXORDraw = false;
                this.bCreating = true;
                return;
            }
            this.bCreating = false;
            if (this.getSelectedElements().size() > 0 && (evt.getModifiers() & 1) == 0 && (evt.getModifiers() & 2) == 0 && this.transformation_type >= 0) {
                if (this.getSelectedElements().size() > 1) {
                    re2 = null;
                    for (ReportElement re2 : this.getSelectedElements()) {
                        Point pt;
                        if (!re2.intersects2(pt = new Point(evt.getX() - this.getPageOffsetX(), evt.getY() - this.getPageOffsetY()))) continue;
                        this.getSelectedElements().remove(re2);
                        this.getSelectedElements().add(0, re2);
                        this.repaint();
                        break;
                    }
                }
                if (((ReportElement)this.getSelectedElements().get(0)).getParent() instanceof Table) {
                    Table tb = (Table)((ReportElement)this.getSelectedElements().get(0)).getParent();
                    this.trasforming = true;
                    this.firstXORDrawTransforming = true;
                    this.transformation_origin = this.transformation_type == 0 ? tb.getNearColRowCell(evt.getX() - this.getPageOffsetX(), evt.getY() - this.getPageOffsetY()) : tb.getNearColRowCross(evt.getX() - this.getPageOffsetX(), evt.getY() - this.getPageOffsetY());
                    this.mouse = new Point(this.transformation_origin.x, this.transformation_origin.y);
                    this.transformation_origin_end = new Point(this.transformation_origin.x, this.transformation_origin.y);
                } else {
                    this.trasforming = true;
                    this.firstXORDrawTransforming = true;
                    this.transformation_origin = new Point(evt.getX(), evt.getY());
                    this.transformation_origin_end = new Point(evt.getX(), evt.getY());
                }
                re2 = this.searchSelectElement(evt.getX(), evt.getY());
                if (re2 == this.getSelectedElements().get(0) || this.transformation_type >= 0) {
                    return;
                }
            }
            this.isNewSelected = true;
            re2 = this.searchSelectElement(evt.getX(), evt.getY());
            if (re2 != null && re2 != this.currentpage) {
                ReportElement firstSelect;
                if (this.getSelectedElements().size() == 1 && re2 == (ReportElement)this.getSelectedElements().get(0)) {
                    return;
                }
                if ((evt.getModifiers() & 1) != 0) {
                    if (this.getSelectedElements().size() == 0) {
                        Toolkit.getDefaultToolkit().beep();
                        return;
                    }
                    firstSelect = (ReportElement)this.getSelectedElements().get(0);
                    if (re2.getParent() != firstSelect.getParent()) {
                        Toolkit.getDefaultToolkit().beep();
                        return;
                    }
                    if (this.getSelectedElements().contains(re2)) {
                        this.removeSelectedElement(re2);
                    }
                    this.addSelectedElement(re2);
                } else if ((evt.getModifiers() & 2) != 0) {
                    if (this.getSelectedElements().size() == 0) {
                        Toolkit.getDefaultToolkit().beep();
                        return;
                    }
                    firstSelect = (ReportElement)this.getSelectedElements().get(0);
                    if (re2.getParent() != firstSelect.getParent()) {
                        Toolkit.getDefaultToolkit().beep();
                        return;
                    }
                    if (this.getSelectedElements().contains(re2)) {
                        this.removeSelectedElement(re2);
                    } else {
                        this.addSelectedElement(re2);
                    }
                } else {
                    this.setSelectedElement(re2);
                }
                this.pageContainerPanel.repaint();
                this.trasforming = true;
                this.firstXORDrawTransforming = true;
                if (((ReportElement)this.getSelectedElements().get(0)).getParent() instanceof Table) {
                    Table tb = (Table)((ReportElement)this.getSelectedElements().get(0)).getParent();
                    this.transformation_origin = tb.getNearColRowCell(evt.getX() - 10 + this.horizontalScrollBar.getValue(), evt.getY() - 10 + this.verticalScrollBar.getValue());
                    this.mouse = new Point(this.transformation_origin.x, this.transformation_origin.y);
                    this.transformation_origin_end = new Point(this.transformation_origin.x, this.transformation_origin.y);
                } else {
                    this.transformation_origin = new Point(evt.getX(), evt.getY());
                    this.transformation_origin_end = new Point(evt.getX(), evt.getY());
                }
                if (re2.isLocked()) {
                    this.transformation_type = -1;
                    this.pageContainerPanel.setCursor(locked);
                } else {
                    this.transformation_type = 0;
                    this.pageContainerPanel.setCursor(Cursor.getPredefinedCursor(13));
                }
                return;
            }
            this.defaultContainer = this.currentpage;
            this.transformation_origin = new Point(this.getLimitValue(true, evt.getX()), this.getLimitValue(false, evt.getY()));
            this.transformation_origin_end = new Point(this.getLimitValue(true, evt.getX()), this.getLimitValue(false, evt.getY()));
            if (this.getSelectedElements().size() > 0) {
                if ((evt.getModifiers() & 1) != 0 || (evt.getModifiers() & 2) != 0) {
                    Toolkit.getDefaultToolkit().beep();
                } else {
                    this.setSelectedElement(null);
                }
            }
            this.drag_selection_mode = true;
        } else if (evt.getButton() == 3) {
            if (this.bCreating || this.trasforming || this.table_adjusting) {
                return;
            }
            ReportElement re = null;
            re = this.getSelectedElements().size() == 0 ? this.currentpage : (ReportElement)this.getSelectedElements().get(0);
            this.defaultContainer = re instanceof AbstractContainer ? (AbstractContainer)re : re.getParent();
            this.showPopup(re, evt);
            return;
        }
    }

    private void showPopup(ReportElement re, MouseEvent evt) {
        if (re != null) {
            if (re instanceof Page) {
                this.popupChkItemLock.setSelected(true);
                this.popupChkItemLock.setEnabled(false);
                this.popupItemCut.setEnabled(false);
                this.popupItemCopy.setEnabled(false);
                if (re instanceof HeadFooter || this.getReport().getPages().size() < 2) {
                    this.popupItemDelete.setEnabled(false);
                } else {
                    this.popupItemDelete.setEnabled(true);
                }
            } else {
                this.popupChkItemLock.setSelected(re.isLocked());
                this.popupChkItemLock.setEnabled(true);
                this.popupItemCut.setEnabled(true);
                this.popupItemCopy.setEnabled(true);
                this.popupItemDelete.setEnabled(true);
            }
            this.popupItemPaste.setEnabled(this.isCanPaste());
        }
        if (this.getSelectedElements().size() > 1) {
            this.popupItemCopyStyle.setEnabled(false);
        } else {
            this.popupItemCopyStyle.setEnabled(true);
        }
        if (this.getMainFrame().getStyleClipboard().isClipboardEmpty()) {
            this.popupItemPasteStyle.setEnabled(false);
        } else {
            this.popupItemPasteStyle.setEnabled(true);
        }
        if (this.isAssEditAlignEnabled()) {
            this.popupMenuAlign.setEnabled(true);
        } else {
            this.popupMenuAlign.setEnabled(false);
        }
        if (this.isAssEditSizeEnabled()) {
            this.popupMenuSize.setEnabled(true);
        } else {
            this.popupMenuSize.setEnabled(false);
        }
        if (this.isAssEditPositionEnabled()) {
            this.popupMenuPosition.setEnabled(true);
        } else {
            this.popupMenuPosition.setEnabled(false);
        }
        this.popupItemInsertLoopArea.setEnabled(this.isCanInsertElement(11));
        this.popupItemInsertGroup.setEnabled(this.isCanInsertElement(12));
        this.popupItemInsertTable.setEnabled(this.isCanInsertElement(10));
        this.popupItemInsertText.setEnabled(this.isCanInsertElement(3));
        this.popupItemInsertFiled.setEnabled(this.isCanInsertElement(4));
        this.popupItemInsertVariant.setEnabled(this.isCanInsertElement(14));
        this.popupItemInsertFormula.setEnabled(this.isCanInsertElement(13));
        this.popupItemInsertLine.setEnabled(this.isCanInsertElement(5));
        this.popupItemInsertImage.setEnabled(this.isCanInsertElement(2));
        this.popupItemInsertChart.setEnabled(this.isCanInsertElement(9));
        this.popupMenu.show((Component)((Object)this), evt.getX() + 3, evt.getY() + 3);
    }

    public ReportElement searchSelectElement(int x, int y) {
        if (this.currentpage == null) {
            return null;
        }
        this.findEle = null;
        return this.postorder(x, y, this.currentpage, false);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private ReportElement postorder(int x, int y, ReportElement element, boolean bcontainer) {
        if (this.findEle != null) {
            return this.findEle;
        }
        if (element instanceof IContainer) {
            IContainer container = (IContainer)((Object)element);
            if (container.getChildren().size() > 0) {
                ListIterator listit = container.getChildren().listIterator(container.getChildren().size());
                while (listit.hasPrevious()) {
                    this.findEle = this.postorder(x, y, (ReportElement)listit.previous(), bcontainer);
                    if (!(bcontainer ? this.findEle != null && this.findEle instanceof IContainer : this.findEle != null)) continue;
                    return this.findEle;
                }
                ReportElement re = element;
                if (!re.intersects(new Point(this.getLogicalDim(x + this.horizontalScrollBar.getValue()) - 10, this.getLogicalDim(y + this.verticalScrollBar.getValue()) - 10))) return null;
                this.findEle = re;
                if (bcontainer) {
                    if (!(this.findEle instanceof IContainer)) return null;
                    return this.findEle;
                }
                this.findEle = re;
                return this.findEle;
            }
            ReportElement re = element;
            if (!re.intersects(new Point(this.getLogicalDim(x + this.horizontalScrollBar.getValue()) - 10, this.getLogicalDim(y + this.verticalScrollBar.getValue()) - 10))) return null;
            this.findEle = re;
            if (!bcontainer) return this.findEle;
            if (!(this.findEle instanceof IContainer)) return null;
            return this.findEle;
        }
        ReportElement re = element;
        if (!re.intersects(new Point(this.getLogicalDim(x + this.horizontalScrollBar.getValue() - 10), this.getLogicalDim(y + this.verticalScrollBar.getValue() - 10)))) return null;
        this.findEle = re;
        if (!bcontainer) return this.findEle;
        if (!(this.findEle instanceof IContainer)) return null;
        return this.findEle;
    }

    private IContainer searchContainer(int x, int y) {
        IContainer ret = this.currentpage;
        this.findEle = null;
        ret = (IContainer)((Object)this.postorder(x, y, this.currentpage, true));
        if (ret != null) {
            return ret;
        }
        return this.currentpage;
    }

    private void actionMouseReleased(MouseEvent evt) {
        if (this.currentpage == null) {
            return;
        }
        if (evt.getButton() == 1) {
            ReportElement re;
            if (this.isDragEndAtRelease) {
                if (this.table_adjusting) {
                    this.adjustTableColRowEnd();
                } else if (this.bCreating) {
                    this.createNewReportElement(evt);
                } else if (this.trasforming) {
                    if (this.getSelectedElements().size() == 0) {
                        return;
                    }
                    if (((ReportElement)this.getSelectedElements().get(0)).getParent() instanceof Table) {
                        this.adjustTableChildElementEnd(evt);
                    } else {
                        Point maxMove = new Point(this.transformation_origin_end.x - this.transformation_origin.x, this.transformation_origin_end.y - this.transformation_origin.y);
                        this.adjustElementEnd(maxMove, true);
                    }
                } else if (this.drag_selection_mode) {
                    this.dragSelectEnd(evt);
                }
                this.getMainFrame().showStatusDeltaMouse("");
            } else if (!this.isNewSelected && (re = this.searchSelectElement(evt.getX(), evt.getY())) != null && re != this.currentpage) {
                this.setSelectedElement(null);
                this.setSelectedElement(re);
                this.pageContainerPanel.repaint();
            }
            this.isNewSelected = false;
            this.isDragEndAtRelease = false;
            this.table_adjusting = false;
            this.trasforming = false;
            this.drag_selection_mode = false;
        }
        if (evt.getButton() == 1 && evt.getClickCount() == 2) {
            this.openElementPropertiesDialog();
            return;
        }
        if (this.getMainFrame().getElementPropertiesDialog().isVisible()) {
            if (this.getMainFrame().getElementPropertiesDialog().isTile()) {
                this.requestFocus();
            }
        } else {
            this.requestFocus();
        }
    }

    private int ensureTableLineInRange(MaxMinPair range, int value) {
        if (value < range.getMin() + 3) {
            return range.getMin() + 3;
        }
        if (value > range.getMax() - 3) {
            return range.getMax() - 3;
        }
        return value;
    }

    private int adjustingTableColRow(Table tb, Point pt, boolean isCol) {
        int value;
        Graphics2D g2d = (Graphics2D)this.pageContainerPanel.getGraphics();
        g2d.setXORMode(Color.WHITE);
        Point ptNew = (Point)pt.clone();
        ptNew.translate(-this.getPageOffsetX(), -this.getPageOffsetY());
        MaxMinPair range = tb.getTableLineRange(isCol, this.table_adjustedGrid);
        if (isCol) {
            int top = tb.getPosition().y + tb.getCorrespondTopPos().y;
            int bottom = top + tb.getHeight();
            this.drawLines(g2d, new Line[]{StickUtil.tableLineStickTo(tb, isCol, ptNew, range)});
            value = this.ensureTableLineInRange(range, ptNew.x);
            this.drawLine(g2d, value, top, value, bottom);
        } else {
            int left = tb.getPosition().x + tb.getCorrespondTopPos().x;
            int right = left + tb.getWidth();
            this.drawLines(g2d, new Line[]{StickUtil.tableLineStickTo(tb, isCol, ptNew, range)});
            value = this.ensureTableLineInRange(range, ptNew.y);
            this.drawLine(g2d, left, value, right, value);
        }
        g2d.setPaintMode();
        return value;
    }

    private void adjustingTableColRow(MouseEvent evt) {
        boolean isCol;
        Table tb = (Table)this.getSelectedElements().get(0);
        boolean bl = isCol = this.pageContainerPanel.getCursor() == vsplit;
        if (!this.first_draw_tableadjust) {
            this.adjustingTableColRow(tb, this.mouse, isCol);
        }
        this.adjustingTableColRow(tb, evt.getPoint(), isCol);
        this.first_draw_tableadjust = false;
        this.showStatusMouse(0, evt.getX() - this.getPageOffsetX(), evt.getY() - this.getPageOffsetY(), true);
    }

    private void adjustTableColRowEnd() {
        Table tb = (Table)this.getSelectedElements().get(0);
        boolean isCol = this.pageContainerPanel.getCursor() == vsplit;
        int value = this.adjustingTableColRow(tb, this.mouse, isCol);
        int tableLineOriValue = isCol ? tb.getPointbyColRow((int)this.table_adjustedGrid, (int)0).x : tb.getPointbyColRow((int)0, (int)this.table_adjustedGrid).y;
        int delta = 0;
        delta = this.getLogicalDim(value - tableLineOriValue);
        if (delta != 0) {
            tb.adjustColRow(isCol, this.table_adjustedGrid, delta);
        }
        this.pageContainerPanel.repaint();
        this.pageContainerPanel.setCursor(Cursor.getPredefinedCursor(0));
        if (this.getMainFrame().getElementPropertiesDialog().isVisible()) {
            this.getMainFrame().getElementPropertiesDialog().updateSelection(this.isHeadFooter());
        }
    }

    public boolean isCanInsertElement(int insertElementType) {
        if (this.getSelectedElements().size() > 1) {
            return false;
        }
        if (this.getSelectedElements().size() == 0) {
            return true;
        }
        ReportElement parent = (ReportElement)this.getSelectedElements().get(0);
        if (!(parent instanceof IContainer)) {
            return false;
        }
        if (parent instanceof LoopArea) {
            return ((LoopArea)parent).isCanAddElement(insertElementType);
        }
        return true;
    }

    public ReportElement insertReportElement(IContainer oriParent, int elementType, int oriX, int oriY) {
        if (oriParent == null && !this.isCanInsertElement(elementType)) {
            return null;
        }
        IContainer parent = oriParent == null ? (this.getSelectedElements().size() == 0 ? this.getCurrentPage() : (IContainer)this.getSelectedElements().get(0)) : oriParent;
        int x = oriX < 0 ? 0 : oriX - 10 + this.horizontalScrollBar.getValue();
        int y = oriY < 0 ? 0 : oriY - 10 + this.verticalScrollBar.getValue();
        int width = 100;
        int height = 100;
        Point grid = null;
        if (parent instanceof Table) {
            if (oriX < 0 && oriY < 0) {
                grid = ((Table)parent).getEmptyGrid(true);
                if (grid == null) {
                    grid = new Point(1, 1);
                }
            } else {
                grid = ((Table)parent).getNearColRowCell(x, y);
                ++grid.x;
                ++grid.y;
            }
            Point pt1 = ((Table)parent).getPointInTableByColRow(grid.x - 1, grid.y - 1);
            x = pt1.x;
            y = pt1.y;
            Point pt2 = ((Table)parent).getPointInTableByColRow(grid.x, grid.y);
            width = pt2.x - pt1.x;
            height = pt2.y - pt1.y;
        } else {
            if (oriX >= 0 || oriY >= 0) {
                Point parentPos = ((ReportElement)((Object)parent)).getRelativePagePosition();
                x -= parentPos.x;
                y -= parentPos.y;
            }
            width = (int)((double)parent.getWidth() * 0.618);
            height = (int)((double)parent.getHeight() * 0.382);
            if (elementType == 3 || elementType == 4 || elementType == 14 || elementType == 13 || elementType == 5) {
                if (width > 120) {
                    width = 120;
                }
                if (height > 40) {
                    height = 40;
                }
            } else {
                if (width > 400) {
                    width = 400;
                }
                if (height > 300) {
                    height = 300;
                }
            }
        }
        ReportElement re = ReportElementFactory.createElement(elementType, this.report.getUniqueName(elementType), x, y, width, height);
        re.setAliasName(this.report.getUniqueAliasName(elementType));
        if (parent instanceof Table) {
            re.getTableLocation().setStartRow(grid.y - 1);
            re.getTableLocation().setStartCol(grid.x - 1);
            re.getTableLocation().setEndRow(grid.y);
            re.getTableLocation().setEndCol(grid.x);
        }
        re.setParent(parent);
        parent.addElement(re);
        re.setLocation(re.getLocation());
        FormDesigner.initReportElementListener(this.getMainFrame(), this.getReport(), re);
        this.report.getElementsNameMap().put(re.getName(), re);
        this.report.getElementsAliasNameMap().put(re.getAliasName(), re);
        this.addUndoOperation(new InsertElementOperation(this, re, KDFFrame.getMLS("createElement", "_\u65b0\u589e")));
        this.fireReportListenerReportElementsChanged(new ReportElementChangedEvent(this, re, 2));
        this.setSelectedElement(re);
        Point reRelativeTop = re.getRelativePagePosition();
        this.scrollRectToVisible(reRelativeTop.x, reRelativeTop.y, re.getWidth(), re.getHeight());
        return re;
    }

    private void createNewReportElement(MouseEvent evt) {
        this.firstXORDraw = true;
        int delta_w = 0;
        int delta_h = 0;
        delta_w = this.gridMultiple(evt.getX() - this.newObjectOrigin.x);
        delta_h = this.gridMultiple(evt.getY() - this.newObjectOrigin.y);
        int delta_x = delta_w < 0 ? delta_w : 0;
        int delta_y = delta_h < 0 ? delta_h : 0;
        int originX = this.getLogicalDim(Math.min(this.newObjectOrigin.x + this.horizontalScrollBar.getValue(), this.newObjectOrigin.x + delta_x + this.horizontalScrollBar.getValue())) - 10;
        int originY = this.getLogicalDim(Math.min(this.newObjectOrigin.y + this.verticalScrollBar.getValue(), this.newObjectOrigin.y + delta_y + this.verticalScrollBar.getValue())) - 10;
        int width = this.getLogicalDim(Math.abs(delta_w));
        int height = this.getLogicalDim(Math.abs(delta_h));
        ReportElement re = ReportElementFactory.createElement(this.newObjectType, this.report.getUniqueName(this.newObjectType), originX, originY, width, height);
        if (this.newObjectType == 5) {
            int direction = 1;
            if (this.newObjectOrigin.x <= evt.getX() && this.newObjectOrigin.y <= evt.getY()) {
                direction = 0;
            } else if (this.newObjectOrigin.x <= evt.getX() && this.newObjectOrigin.y > evt.getY()) {
                direction = 1;
            } else if (this.newObjectOrigin.x > evt.getX() && this.newObjectOrigin.y > evt.getY()) {
                direction = 0;
            } else if (this.newObjectOrigin.x > evt.getX() && this.newObjectOrigin.y <= evt.getY()) {
                direction = 1;
            }
            ((LineElement)re).setDirection(direction);
        }
        re.setAliasName(this.report.getUniqueAliasName(this.newObjectType));
        if (this.defaultContainer instanceof Table) {
            Table tb = (Table)this.defaultContainer;
            Point ptCurrentCol = ((Table)this.defaultContainer).getNearColRowCross(evt.getX() - 10 + this.horizontalScrollBar.getValue(), evt.getY() - 10 + this.verticalScrollBar.getValue());
            if (ptCurrentCol.x <= this.newObjectOrigin.x) {
                ptCurrentCol.x = this.newObjectOrigin.x + 1;
            }
            if (ptCurrentCol.y <= this.newObjectOrigin.y) {
                ptCurrentCol.y = this.newObjectOrigin.y + 1;
            }
            re.getTableLocation().setEndCol(ptCurrentCol.x);
            re.getTableLocation().setEndRow(ptCurrentCol.y);
            re.getTableLocation().setStartCol(this.newObjectOrigin.x);
            re.getTableLocation().setStartRow(this.newObjectOrigin.y);
            re.setParent(this.defaultContainer);
            this.defaultContainer.addElement(re);
            tb.refreshGridPos();
            if (this.getMainFrame().getElementPropertiesDialog().isVisible()) {
                this.getMainFrame().getElementPropertiesDialog().updateSelection(this.isHeadFooter());
            }
        } else {
            re.setParent(this.defaultContainer);
            this.defaultContainer.addElement(re);
            Point pt = re.getCorrespondTopPos();
            re.translate(-pt.x, -pt.y);
        }
        FormDesigner.initReportElementListener(this.getMainFrame(), this.getReport(), re);
        this.report.getElementsNameMap().put(re.getName(), re);
        this.report.getElementsAliasNameMap().put(re.getAliasName(), re);
        this.addUndoOperation(new InsertElementOperation(this, re, KDFFrame.getMLS("createElement", "_\u65b0\u589e")));
        this.fireReportListenerReportElementsChanged(new ReportElementChangedEvent(this, re, 2));
        this.setSelectedElement(re);
        this.newObjectOrigin = null;
        if (!this.isMutilCreate) {
            this.newObjectType = -1;
            this.pageContainerPanel.setCursor(Cursor.getDefaultCursor());
            this.getMainFrame().setActiveToolIsPointer();
        }
        this.bCreating = false;
    }

    private void dragSelectEnd(MouseEvent evt) {
        if (this.drag_selection_mode && evt.getButton() == 1) {
            this.getSelectedElements().clear();
            Graphics2D gg = (Graphics2D)this.pageContainerPanel.getGraphics();
            gg.setXORMode(Color.WHITE);
            Stroke oldstroke = gg.getStroke();
            gg.setStroke(m_SelectedDash);
            Rectangle bounds = this.getNormalRectangle(this.transformation_origin_end, this.transformation_origin);
            Rectangle boundsInPage = (Rectangle)bounds.clone();
            boundsInPage.x -= 10;
            boundsInPage.y -= 10;
            gg.drawRect(bounds.x, bounds.y, bounds.width, bounds.height);
            this.firstXORDrawTransforming = false;
            gg.setPaintMode();
            gg.setStroke(oldstroke);
            this.setSelectedElement(null);
            for (ReportElement re : (ArrayList)this.currentpage.getChildren().clone()) {
                Rectangle elerc = new Rectangle(this.getZoomedDim(re.getPosition().x - 10) + 10 - this.horizontalScrollBar.getValue(), this.getZoomedDim(re.getPosition().y - 10) + 10 - this.verticalScrollBar.getValue(), this.getZoomedDim(re.getWidth()), this.getZoomedDim(re.getHeight()));
                if (!boundsInPage.contains(elerc)) continue;
                this.addSelectedElement(re);
            }
        }
    }

    private void adjustTableChildElementEnd(MouseEvent evt) {
        if (this.transformation_type >= 0 && this.trasforming) {
            ReportElement re = (ReportElement)this.getSelectedElements().get(0);
            this.defaultContainer = ((ReportElement)this.getSelectedElements().get(0)).getParent();
            TransformElementsOperation undoOp = new TransformElementsOperation(this);
            TableLocation loc = re.getTableLocation().cloneMe();
            this.transformation_origin_end = ((Table)this.defaultContainer).getNearColRowCross(evt.getX() - this.getPageOffsetX(), evt.getY() - this.getPageOffsetY());
            Rectangle rc = new Rectangle(0, 0, 0, 0);
            if (this.transformation_type == 0) {
                this.transformation_origin_end = ((Table)this.defaultContainer).getNearColRowCell(evt.getX() - this.getPageOffsetX(), evt.getY() - this.getPageOffsetY());
                this.transformation_origin_end = this.calculateTranslateValue(re, this.transformation_origin, this.transformation_origin_end);
                rc = re.getTableLocation().getBounds();
                rc.translate(this.transformation_origin_end.x - this.transformation_origin.x, this.transformation_origin_end.y - this.transformation_origin.y);
            } else {
                int x_delta = this.transformation_origin_end.x - this.transformation_origin.x;
                int y_delta = this.transformation_origin_end.y - this.transformation_origin.y;
                rc = re.getTableLocation().getBounds();
                int newWidth = rc.width;
                int newHeight = rc.height;
                if (TransType.containsEast(this.transformation_type)) {
                    newWidth = rc.width + x_delta;
                }
                if (TransType.containsWest(this.transformation_type)) {
                    newWidth = rc.width - x_delta;
                    rc.x += x_delta;
                }
                if (TransType.containsSouth(this.transformation_type)) {
                    newHeight = rc.height + y_delta;
                }
                if (TransType.containsNorth(this.transformation_type)) {
                    newHeight = rc.height - y_delta;
                    rc.y += y_delta;
                }
                newWidth = newWidth < 1 ? 1 : newWidth;
                newHeight = newHeight < 1 ? 1 : newHeight;
                rc.setSize(newWidth, newHeight);
                if (rc.x >= ((Table)this.defaultContainer).getColumnCount()) {
                    rc.x = ((Table)this.defaultContainer).getColumnCount() - 1;
                }
                if (rc.y >= ((Table)this.defaultContainer).getRowCount()) {
                    rc.y = ((Table)this.defaultContainer).getRowCount() - 1;
                }
            }
            Graphics gg = this.pageContainerPanel.getGraphics();
            gg.setXORMode(new Color(171, 175, 183));
            ((Graphics2D)gg).setStroke(m_DragDash);
            Rectangle rangrc = ((Table)this.defaultContainer).getRangle(rc.x, rc.y, rc.x + rc.width, rc.y + rc.height);
            rangrc.translate(this.getPageOffsetX(), this.getPageOffsetY());
            gg.drawRect(rangrc.x, rangrc.y, rangrc.width, rangrc.height);
            gg.setPaintMode();
            if (!this.transformation_origin_end.equals(this.transformation_origin)) {
                re.setEndCol(rc.x + rc.width);
                re.setStartCol(rc.x);
                re.setEndRow(rc.y + rc.height);
                re.setStartRow(rc.y);
                ((Table)re.getParent()).refreshGridPos();
            }
            TableLocation newloc = re.getTableLocation();
            undoOp.addElement(re, loc, newloc);
            this.fireReportListenerReportElementsChanged(new ReportElementChangedEvent(this, re, 3));
            this.addUndoOperation(undoOp);
        }
        this.pageContainerPanel.setCursor(Cursor.getDefaultCursor());
        this.pageContainerPanel.repaint();
        this.transformation_type = -1;
        this.getMainFrame().getElementPropertiesDialog().updateSelection(this.isHeadFooter());
    }

    private void adjustElementEnd(Point maxMove, boolean isStick) {
        this.pageContainerPanel.setCursor(Cursor.getDefaultCursor());
        if (this.getSelectedElements().size() > 0) {
            if (this.transformation_type == 0) {
                Iterator it = this.getSelectedElements().iterator();
                TransformElementsOperation undoOp = new TransformElementsOperation(this);
                if (isStick) {
                    StickUtil.moveStickTo((IElement)this.getSelectedElements().get(0), maxMove);
                }
                for (ReportElement re : this.getSelectedElements()) {
                    Location loc = re.getLocation();
                    re.trasform(maxMove, this.transformation_type);
                    Location newloc = re.getLocation();
                    undoOp.addElement(re, loc, newloc);
                    this.fireReportListenerReportElementsChanged(new ReportElementChangedEvent(this, re, 3));
                }
                this.addUndoOperation(undoOp);
            } else {
                TransformElementsOperation undoOp = new TransformElementsOperation(this);
                ReportElement re = (ReportElement)this.getSelectedElements().get(0);
                Location loc = re.getLocation();
                re.trasform(maxMove, this.transformation_type);
                Location newloc = re.getLocation();
                undoOp.addElement(re, loc, newloc);
                this.addUndoOperation(undoOp);
                this.fireReportListenerReportElementsChanged(new ReportElementChangedEvent(this, re, 3));
            }
        }
        this.pageContainerPanel.repaint();
        this.transformation_type = -1;
        if (this.getMainFrame().getElementPropertiesDialog().isVisible()) {
            this.getMainFrame().getElementPropertiesDialog().updateSelection(this.isHeadFooter());
        }
    }

    private void actionMouseMoved(MouseEvent evt) {
        if (this.isShowRule) {
            this.horizontalRule.setCursorPosition(evt.getX());
        }
        if (this.mouse == null) {
            this.mouse = new Point();
        }
        if (this.getSelectedElements().size() > 0 && this.newObjectType == -1) {
            boolean found = false;
            Iterator it = this.getSelectedElements().iterator();
            while (!found && it.hasNext()) {
                ReportElement selectedRe = (ReportElement)it.next();
                Rectangle grip = new Rectangle(this.getZoomedDim(selectedRe.getPosition().x) - 3 + this.getPageOffsetX(), this.getZoomedDim(selectedRe.getPosition().y) - 3 + this.getPageOffsetY(), this.getZoomedDim(selectedRe.getWidth()) + 6, this.getZoomedDim(selectedRe.getHeight()) + 6);
                Point pt = selectedRe.getCorrespondTopPos();
                grip.translate(pt.x, pt.y);
                Rectangle cursor = new Rectangle(evt.getX(), evt.getY(), 1, 1);
                if (!cursor.intersects(grip)) continue;
                int[] flags = this.getPriorityFlags(evt.getX() >= this.mouse.x, evt.getY() >= this.mouse.y);
                if (this.getSelectedElements().get(0) == selectedRe && this.isMouseInLeftTopBlock(cursor, selectedRe)) {
                    this.showSelectParentMenu(true, evt.getPoint(), selectedRe);
                    found = true;
                }
                if (this.isMouseInBlock(cursor, selectedRe, evt, flags)) {
                    found = true;
                    break;
                }
                grip = new Rectangle(this.getZoomedDim(selectedRe.getPosition().x) + this.getPageOffsetX(), this.getZoomedDim(selectedRe.getPosition().y) + this.getPageOffsetY(), this.getZoomedDim(selectedRe.getWidth()), this.getZoomedDim(selectedRe.getHeight()));
                grip.translate(pt.x, pt.y);
                if (!cursor.intersects(grip)) {
                    if (selectedRe instanceof Page || selectedRe.isLocked()) break;
                    this.transformation_type = 0;
                    this.pageContainerPanel.setCursor(Cursor.getPredefinedCursor(13));
                    found = true;
                    break;
                }
                if (this.isMouseAtTableAdjust(selectedRe, evt)) {
                    found = true;
                    break;
                }
                if (this.searchSelectElement(evt.getX(), evt.getY()) == selectedRe) {
                    if (selectedRe.isLocked()) {
                        this.pageContainerPanel.setCursor(locked);
                        this.transformation_type = -1;
                    } else {
                        this.transformation_type = 0;
                        this.pageContainerPanel.setCursor(Cursor.getPredefinedCursor(13));
                    }
                    found = true;
                    break;
                }
                found = false;
                break;
            }
            if (!found) {
                this.pageContainerPanel.setCursor(Cursor.getDefaultCursor());
                this.transformation_type = -1;
                this.showSelectParentMenu(false, null, null);
            }
        }
        if (this.newObjectType != -1) {
            boolean bCanAdd = true;
            this.defaultContainer = this.searchContainer(evt.getX(), evt.getY());
            if (this.defaultContainer instanceof LoopArea && !((LoopArea)this.defaultContainer).isCanAddElement(this.newObjectType)) {
                bCanAdd = false;
            }
            if (bCanAdd) {
                if (this.pageContainerPanel.getCursor() != Cursor.getPredefinedCursor(1)) {
                    this.pageContainerPanel.setCursor(Cursor.getPredefinedCursor(1));
                }
            } else if (this.pageContainerPanel.getCursor() != locked) {
                this.pageContainerPanel.setCursor(locked);
            }
        }
        this.mouse.x = evt.getX();
        this.mouse.y = evt.getY();
        this.showStatusAtMove(this.mouse.x, this.mouse.y);
    }

    public void showStatusAtMove(int x, int y) {
        ReportElement re = this.searchSelectElement(x, y);
        if (re == null) {
            this.getMainFrame().showStatusElementName("");
            this.getMainFrame().showStatusMousePosition("");
        } else {
            re.getEleType();
            this.getMainFrame().showStatusElementName(ReportElementType.toString(re.getEleType()) + ": " + re.getAliasName());
            this.showStatusMouse(0, x - 10 + this.horizontalScrollBar.getValue(), y - 10 + this.verticalScrollBar.getValue(), true);
        }
    }

    private int[] getPriorityFlags(boolean xOrg, boolean yOrg) {
        int[] flags = new int[8];
        if (xOrg && yOrg) {
            flags[0] = 0;
            flags[1] = 1;
            flags[2] = 3;
            flags[3] = 2;
            flags[4] = 5;
            flags[5] = 4;
            flags[6] = 6;
            flags[7] = 7;
        } else if (xOrg && !yOrg) {
            flags[0] = 5;
            flags[1] = 6;
            flags[2] = 3;
            flags[3] = 7;
            flags[4] = 0;
            flags[5] = 4;
            flags[6] = 1;
            flags[7] = 2;
        } else if (!xOrg && yOrg) {
            flags[0] = 2;
            flags[1] = 1;
            flags[2] = 4;
            flags[3] = 0;
            flags[4] = 7;
            flags[5] = 3;
            flags[6] = 6;
            flags[7] = 5;
        } else {
            flags[0] = 7;
            flags[1] = 6;
            flags[2] = 4;
            flags[3] = 5;
            flags[4] = 2;
            flags[5] = 3;
            flags[6] = 1;
            flags[7] = 0;
        }
        return flags;
    }

    private boolean findCursor(Rectangle cursor, Rectangle grip, int resizePoint, ReportElement selectedRe) {
        boolean found = false;
        Point pt = selectedRe.getCorrespondTopPos();
        switch (resizePoint) {
            case 0: {
                grip.x = this.getZoomedDim(selectedRe.getPosition().x);
                grip.y = this.getZoomedDim(selectedRe.getPosition().y);
                break;
            }
            case 2: {
                grip.x = this.getZoomedDim(selectedRe.getPosition().x + selectedRe.getWidth());
                grip.y = this.getZoomedDim(selectedRe.getPosition().y);
                break;
            }
            case 3: {
                grip.x = this.getZoomedDim(selectedRe.getPosition().x);
                grip.y = this.getZoomedDim(selectedRe.getPosition().y + selectedRe.getHeight() / 2);
                break;
            }
            case 5: {
                grip.x = this.getZoomedDim(selectedRe.getPosition().x);
                grip.y = this.getZoomedDim(selectedRe.getPosition().y + selectedRe.getHeight());
                break;
            }
            case 1: {
                grip.x = this.getZoomedDim(selectedRe.getPosition().x + selectedRe.getWidth() / 2);
                grip.y = this.getZoomedDim(selectedRe.getPosition().y);
                break;
            }
            case 6: {
                grip.x = this.getZoomedDim(selectedRe.getPosition().x + selectedRe.getWidth() / 2);
                grip.y = this.getZoomedDim(selectedRe.getPosition().y + selectedRe.getHeight());
                break;
            }
            case 7: {
                grip.x = this.getZoomedDim(selectedRe.getPosition().x + selectedRe.getWidth());
                grip.y = this.getZoomedDim(selectedRe.getPosition().y + selectedRe.getHeight());
                break;
            }
            case 4: {
                grip.x = this.getZoomedDim(selectedRe.getPosition().x + selectedRe.getWidth());
                grip.y = this.getZoomedDim(selectedRe.getPosition().y + selectedRe.getHeight() / 2);
            }
        }
        grip.translate(pt.x + this.getPageOffsetX() - 3, pt.y + this.getPageOffsetY() - 3);
        if (cursor.intersects(grip)) {
            switch (resizePoint) {
                case 0: {
                    this.pageContainerPanel.setCursor(Cursor.getPredefinedCursor(13));
                    this.transformation_type = 0;
                    break;
                }
                case 2: {
                    this.pageContainerPanel.setCursor(Cursor.getPredefinedCursor(7));
                    this.transformation_type = 3;
                    break;
                }
                case 3: {
                    this.pageContainerPanel.setCursor(Cursor.getPredefinedCursor(10));
                    this.transformation_type = 8;
                    break;
                }
                case 5: {
                    this.pageContainerPanel.setCursor(Cursor.getPredefinedCursor(4));
                    this.transformation_type = 12;
                    break;
                }
                case 1: {
                    this.pageContainerPanel.setCursor(Cursor.getPredefinedCursor(8));
                    this.transformation_type = 1;
                    break;
                }
                case 6: {
                    this.pageContainerPanel.setCursor(Cursor.getPredefinedCursor(9));
                    this.transformation_type = 4;
                    break;
                }
                case 7: {
                    this.pageContainerPanel.setCursor(Cursor.getPredefinedCursor(5));
                    this.transformation_type = 6;
                    break;
                }
                case 4: {
                    this.pageContainerPanel.setCursor(Cursor.getPredefinedCursor(11));
                    this.transformation_type = 2;
                }
            }
            found = true;
        }
        return found;
    }

    private boolean isMouseInBlock(Rectangle cursor, ReportElement selectedRe, MouseEvent evt, int[] flags) {
        if (selectedRe.isLocked()) {
            return false;
        }
        Rectangle grip = new Rectangle();
        grip.width = 6;
        grip.height = 6;
        for (int i = 0; i < 8; ++i) {
            if (!this.findCursor(cursor, grip, flags[i], selectedRe)) continue;
            return true;
        }
        return false;
    }

    private boolean isMouseInLeftTopBlock(Rectangle cursor, ReportElement selectedRe) {
        Rectangle grip = new Rectangle();
        grip.width = 6;
        grip.height = 6;
        grip.x = selectedRe.getPosition().x;
        grip.y = selectedRe.getPosition().y;
        Point pt = selectedRe.getCorrespondTopPos();
        grip.translate(pt.x + this.getPageOffsetX() - 3, pt.y + this.getPageOffsetY() - 3);
        return cursor.intersects(grip);
    }

    private boolean isMouseAtTableAdjust(ReportElement selectedRe, MouseEvent evt) {
        if (selectedRe instanceof Table && selectedRe == this.getSelectedElements().get(0)) {
            Table tb = (Table)selectedRe;
            this.originMouse.x = evt.getX();
            this.originMouse.y = evt.getY();
            int tableCursorFlag = tb.getTableCursorFlag(evt.getX() - this.getPageOffsetX(), evt.getY() - this.getPageOffsetY());
            switch (tableCursorFlag) {
                case 1: {
                    if (tb.isSamedWidth()) break;
                    this.pageContainerPanel.setCursor(vsplit);
                    this.transformation_type = -1;
                    return true;
                }
                case 2: {
                    if (tb.isSamedHeight()) break;
                    this.pageContainerPanel.setCursor(hsplit);
                    this.transformation_type = -1;
                    return true;
                }
            }
        }
        return false;
    }

    private void actionMouseDragged(MouseEvent evt) {
        this.isDragEndAtRelease = true;
        if (this.mouse == null) {
            this.mouse = new Point();
        }
        if (this.table_adjusting) {
            this.adjustingTableColRow(evt);
        } else if (this.drag_selection_mode) {
            this.dragSelectModing(evt);
        } else {
            if (this.bCreating && this.newObjectOrigin != null) {
                Graphics gg = this.pageContainerPanel.getGraphics();
                Graphics2D g2d = (Graphics2D)gg;
                Stroke oldStroke = g2d.getStroke();
                g2d.setStroke(m_DragDash);
                gg.setXORMode(new Color(171, 175, 183));
                if (this.defaultContainer instanceof Table) {
                    Table tb = (Table)this.defaultContainer;
                    Point ptCurrentCol = tb.getNearColRowCross(evt.getX() - 10 + this.horizontalScrollBar.getValue(), evt.getY() - 10 + this.verticalScrollBar.getValue());
                    if (ptCurrentCol.x <= this.newObjectOrigin.x) {
                        ptCurrentCol.x = this.newObjectOrigin.x + 1;
                    }
                    if (ptCurrentCol.y <= this.newObjectOrigin.y) {
                        ptCurrentCol.y = this.newObjectOrigin.y + 1;
                    }
                    if (ptCurrentCol.equals(this.mouse)) {
                        return;
                    }
                    Point ptCurrent = tb.getPointbyColRow(ptCurrentCol.x, ptCurrentCol.y);
                    ptCurrent.translate(10 - this.horizontalScrollBar.getValue(), 10 - this.verticalScrollBar.getValue());
                    Point ptOrigin = tb.getPointbyColRow(this.newObjectOrigin.x, this.newObjectOrigin.y);
                    ptOrigin.translate(10 - this.horizontalScrollBar.getValue(), 10 - this.verticalScrollBar.getValue());
                    if (!this.firstXORDraw) {
                        Point ptOld = tb.getPointbyColRow(this.mouse.x, this.mouse.y);
                        ptOld.translate(10 - this.horizontalScrollBar.getValue(), 10 - this.verticalScrollBar.getValue());
                        gg.drawRect(ptOrigin.x, ptOrigin.y, Math.abs(ptOld.x - ptOrigin.x), Math.abs(ptOld.y - ptOrigin.y));
                    }
                    gg.drawRect(ptOrigin.x, ptOrigin.y, Math.abs(ptCurrent.x - ptOrigin.x), Math.abs(ptCurrent.y - ptOrigin.y));
                    this.mouse.x = ptCurrentCol.x;
                    this.mouse.y = ptCurrentCol.y;
                    this.showStatusMouse(0, this.newObjectOrigin.x + 1, this.newObjectOrigin.y + 1, false);
                    this.showStatusMouse(1, ptCurrentCol.x - this.newObjectOrigin.x, ptCurrentCol.y - this.newObjectOrigin.y, false);
                    return;
                }
                int delta_x = 0;
                int delta_y = 0;
                if (this.newObjectType != 5 && !this.firstXORDraw) {
                    delta_x = this.mouse.x - this.newObjectOrigin.x;
                    delta_y = this.mouse.y - this.newObjectOrigin.y;
                    delta_x = delta_x < 0 ? delta_x : 0;
                    delta_y = delta_y < 0 ? delta_y : 0;
                }
                int delta_w = 0;
                int delta_h = 0;
                if (!this.firstXORDraw) {
                    delta_w = this.gridMultiple(this.mouse.x - this.newObjectOrigin.x);
                    delta_h = this.gridMultiple(this.mouse.y - this.newObjectOrigin.y);
                    delta_x = delta_w < 0 ? delta_w : 0;
                    int n = delta_y = delta_h < 0 ? delta_h : 0;
                }
                if (this.newObjectType == 5) {
                    if (!this.firstXORDraw) {
                        gg.drawLine(this.newObjectOrigin.x, this.newObjectOrigin.y, this.newObjectOrigin.x + delta_w, this.newObjectOrigin.y + delta_h);
                    }
                    delta_w = this.gridMultiple(evt.getX() - this.newObjectOrigin.x);
                    delta_h = this.gridMultiple(evt.getY() - this.newObjectOrigin.y);
                    gg.drawLine(this.newObjectOrigin.x, this.newObjectOrigin.y, this.newObjectOrigin.x + delta_w, this.newObjectOrigin.y + delta_h);
                    this.showStatusMouse(1, delta_w, delta_h, true);
                } else {
                    Rectangle bounds;
                    if (!this.firstXORDraw) {
                        bounds = new Rectangle(this.newObjectOrigin.x + delta_x, this.snapToGridVertically(this.newObjectOrigin.y + delta_y), Math.abs(delta_w), Math.abs(delta_h));
                        this.ensureInParent(this.defaultContainer, bounds);
                        gg.drawRect(bounds.x, bounds.y, bounds.width, bounds.height);
                    }
                    delta_w = this.gridMultiple(evt.getX() - this.newObjectOrigin.x);
                    delta_h = this.gridMultiple(evt.getY() - this.newObjectOrigin.y);
                    delta_x = delta_w < 0 ? delta_w : 0;
                    delta_y = delta_h < 0 ? delta_h : 0;
                    bounds = new Rectangle(this.newObjectOrigin.x + delta_x, this.snapToGridVertically(this.newObjectOrigin.y + delta_y), Math.abs(delta_w), Math.abs(delta_h));
                    this.ensureInParent(this.defaultContainer, bounds);
                    gg.drawRect(bounds.x, bounds.y, bounds.width, bounds.height);
                    this.showStatusMouse(1, bounds.width, bounds.height, true);
                }
                g2d.setStroke(oldStroke);
                this.firstXORDraw = false;
                gg.setPaintMode();
            }
            if (this.getSelectedElements().size() > 0 && this.newObjectType == -1) {
                if (((ReportElement)this.getSelectedElements().get(0)).getParent() instanceof Table) {
                    this.adjustingElementInTable(evt);
                    return;
                }
                this.adjustingElement(evt);
            }
        }
        this.mouse.x = evt.getX();
        this.mouse.y = evt.getY();
    }

    private void adjustingElementInTable(MouseEvent evt) {
        if (this.transformation_type >= 0 && this.trasforming) {
            int newheight;
            int newwidth;
            int y_delta;
            ReportElement re = (ReportElement)this.getSelectedElements().get(0);
            this.defaultContainer = re.getParent();
            Graphics gg = this.pageContainerPanel.getGraphics();
            gg.setXORMode(new Color(171, 175, 183));
            Graphics2D g2d = (Graphics2D)gg;
            Stroke oldStroke = g2d.getStroke();
            g2d.setStroke(m_DragDash);
            if (this.transformation_type == 0) {
                this.transformation_origin_end = ((Table)this.defaultContainer).getNearColRowCell(evt.getX() - 10 + this.horizontalScrollBar.getValue(), evt.getY() - 10 + this.verticalScrollBar.getValue());
                this.transformation_origin_end = this.calculateTranslateValue(re, this.transformation_origin, this.transformation_origin_end);
            } else {
                this.transformation_origin_end = ((Table)this.defaultContainer).getNearColRowCross(evt.getX() - 10 + this.horizontalScrollBar.getValue(), evt.getY() - 10 + this.verticalScrollBar.getValue());
            }
            if (this.transformation_origin_end.equals(this.mouse)) {
                return;
            }
            Rectangle rc = new Rectangle(0, 0, 0, 0);
            if (!this.firstXORDrawTransforming) {
                int x_delta;
                if (this.transformation_type == 0) {
                    rc = re.getTableLocation().getBounds();
                    rc.translate(this.mouse.x - this.transformation_origin.x, this.mouse.y - this.transformation_origin.y);
                } else if (this.transformation_type == 6 || this.transformation_type == 4 || this.transformation_type == 2) {
                    x_delta = this.transformation_type == 6 || this.transformation_type == 2 ? this.mouse.x - this.transformation_origin.x : 0;
                    y_delta = this.transformation_type == 6 || this.transformation_type == 4 ? this.mouse.y - this.transformation_origin.y : 0;
                    rc = re.getTableLocation().getBounds();
                    newwidth = rc.width + x_delta > 0 ? rc.width + x_delta : 1;
                    newheight = rc.height + y_delta > 0 ? rc.height + y_delta : 1;
                    rc.setSize(newwidth, newheight);
                } else if (this.transformation_type == 9 || this.transformation_type == 1 || this.transformation_type == 8) {
                    x_delta = this.transformation_type == 9 || this.transformation_type == 8 ? this.mouse.x - this.transformation_origin.x : 0;
                    y_delta = this.transformation_type == 9 || this.transformation_type == 1 ? this.mouse.y - this.transformation_origin.y : 0;
                    rc = re.getTableLocation().getBounds();
                    if (rc.width - x_delta < 1) {
                        x_delta = rc.width - 1;
                    }
                    if (rc.height - y_delta < 1) {
                        y_delta = rc.height - 1;
                    }
                    rc.x += x_delta;
                    rc.y += y_delta;
                    rc.setSize(rc.width - x_delta, rc.height - y_delta);
                } else if (this.transformation_type == 3) {
                    x_delta = this.mouse.x - this.transformation_origin.x;
                    y_delta = this.mouse.y - this.transformation_origin.y;
                    rc = re.getTableLocation().getBounds();
                    if (rc.height - y_delta < 1) {
                        y_delta = rc.height - 1;
                    }
                    if (rc.width + x_delta < 1) {
                        x_delta = 1 - rc.width;
                    }
                    rc.y += y_delta;
                    rc.setSize(rc.width + x_delta, rc.height - y_delta);
                } else if (this.transformation_type == 12) {
                    x_delta = this.mouse.x - this.transformation_origin.x;
                    y_delta = this.mouse.y - this.transformation_origin.y;
                    rc = re.getTableLocation().getBounds();
                    if (rc.height + y_delta < 1) {
                        y_delta = 1 - rc.height;
                    }
                    if (rc.width - x_delta < 1) {
                        x_delta = rc.width - 1;
                    }
                    rc.x += x_delta;
                    rc.setSize(rc.width - x_delta, rc.height + y_delta);
                }
                if (rc.x >= 0 && rc.y >= 0 && rc.x + rc.width <= ((Table)this.defaultContainer).getColumnCount() && rc.y + rc.height <= ((Table)this.defaultContainer).getRowCount()) {
                    Rectangle rangrc = ((Table)this.defaultContainer).getRangle(rc.x, rc.y, rc.x + rc.width, rc.y + rc.height);
                    rangrc.translate(10 - this.horizontalScrollBar.getValue(), 10 - this.verticalScrollBar.getValue());
                    gg.drawRect(rangrc.x, rangrc.y, rangrc.width, rangrc.height);
                }
            }
            if (this.transformation_type == 0) {
                rc = re.getTableLocation().getBounds();
                rc.translate(this.transformation_origin_end.x - this.transformation_origin.x, this.transformation_origin_end.y - this.transformation_origin.y);
                this.showStatusMouse(0, rc.x + 1, rc.y + 1, false);
            } else {
                if (this.transformation_type == 6 || this.transformation_type == 4 || this.transformation_type == 2) {
                    int x_delta = this.transformation_type == 6 || this.transformation_type == 2 ? this.transformation_origin_end.x - this.transformation_origin.x : 0;
                    y_delta = this.transformation_type == 6 || this.transformation_type == 4 ? this.transformation_origin_end.y - this.transformation_origin.y : 0;
                    rc = re.getTableLocation().getBounds();
                    newwidth = rc.width + x_delta > 0 ? rc.width + x_delta : 1;
                    newheight = rc.height + y_delta > 0 ? rc.height + y_delta : 1;
                    rc.setSize(newwidth, newheight);
                } else if (this.transformation_type == 9 || this.transformation_type == 1 || this.transformation_type == 8) {
                    int x_delta = this.transformation_type == 9 || this.transformation_type == 8 ? this.transformation_origin_end.x - this.transformation_origin.x : 0;
                    y_delta = this.transformation_type == 9 || this.transformation_type == 1 ? this.transformation_origin_end.y - this.transformation_origin.y : 0;
                    rc = re.getTableLocation().getBounds();
                    if (rc.width - x_delta < 1) {
                        x_delta = rc.width - 1;
                    }
                    if (rc.height - y_delta < 1) {
                        y_delta = rc.height - 1;
                    }
                    rc.x += x_delta;
                    rc.y += y_delta;
                    rc.setSize(rc.width - x_delta, rc.height - y_delta);
                } else if (this.transformation_type == 3) {
                    int x_delta = this.transformation_origin_end.x - this.transformation_origin.x;
                    y_delta = this.transformation_origin_end.y - this.transformation_origin.y;
                    rc = re.getTableLocation().getBounds();
                    if (rc.height - y_delta < 1) {
                        y_delta = rc.height - 1;
                    }
                    if (rc.width + x_delta < 1) {
                        x_delta = 1 - rc.width;
                    }
                    rc.y += y_delta;
                    rc.setSize(rc.width + x_delta, rc.height - y_delta);
                } else if (this.transformation_type == 12) {
                    int x_delta = this.transformation_origin_end.x - this.transformation_origin.x;
                    y_delta = this.transformation_origin_end.y - this.transformation_origin.y;
                    rc = re.getTableLocation().getBounds();
                    if (rc.height + y_delta < 1) {
                        y_delta = 1 - rc.height;
                    }
                    if (rc.width - x_delta < 1) {
                        x_delta = rc.width - 1;
                    }
                    rc.x += x_delta;
                    rc.setSize(rc.width - x_delta, rc.height + y_delta);
                }
                this.showStatusMouse(0, rc.x + 1, rc.y + 1, false);
                this.showStatusMouse(1, rc.width, rc.height, false);
            }
            if (rc.x >= 0 && rc.y >= 0 && rc.x + rc.width <= ((Table)this.defaultContainer).getColumnCount() && rc.y + rc.height <= ((Table)this.defaultContainer).getRowCount()) {
                Rectangle rangrc = ((Table)this.defaultContainer).getRangle(rc.x, rc.y, rc.x + rc.width, rc.y + rc.height);
                rangrc.translate(10 - this.horizontalScrollBar.getValue(), 10 - this.verticalScrollBar.getValue());
                gg.drawRect(rangrc.x, rangrc.y, rangrc.width, rangrc.height);
            }
            this.mouse.x = this.transformation_origin_end.x;
            this.mouse.y = this.transformation_origin_end.y;
            g2d.setStroke(oldStroke);
            this.firstXORDrawTransforming = false;
            gg.setPaintMode();
            return;
        }
    }

    private Point calculateTranslateValue(ReportElement re, Point start, Point end) {
        TableLocation tl = re.getTableLocation();
        int translateX = end.x - start.x;
        int translateY = end.y - start.y;
        int tableEndCol = ((Table)re.getParent()).getColumnCount();
        int tableEndRow = ((Table)re.getParent()).getRowCount();
        if (tl.getStartCol() + translateX < 0) {
            translateX = -tl.getStartCol();
        } else if (tl.getEndCol() + translateX > tableEndCol) {
            translateX = tableEndCol - tl.getEndCol();
        }
        if (tl.getStartRow() + translateY < 0) {
            translateY = -tl.getStartRow();
        } else if (tl.getEndRow() + translateY > tableEndRow) {
            translateY = tableEndRow - tl.getEndRow();
        }
        return new Point(translateX + start.x, translateY + start.y);
    }

    private void dragSelectModing(MouseEvent evt) {
        Rectangle bounds;
        Graphics2D gg = (Graphics2D)this.pageContainerPanel.getGraphics();
        gg.setXORMode(Color.WHITE);
        Stroke oldstroke = gg.getStroke();
        gg.setStroke(m_SelectedDash);
        if (!this.firstXORDrawTransforming) {
            bounds = this.getNormalRectangle(this.transformation_origin_end, this.transformation_origin);
            this.ensureInParent(this.currentpage, bounds);
            gg.drawRect(bounds.x, bounds.y, bounds.width, bounds.height);
        }
        this.transformation_origin_end.x = this.getLimitValue(true, evt.getX());
        this.transformation_origin_end.y = this.getLimitValue(false, evt.getY());
        bounds = this.getNormalRectangle(this.transformation_origin_end, this.transformation_origin);
        gg.drawRect(bounds.x, bounds.y, bounds.width, bounds.height);
        this.firstXORDrawTransforming = false;
        gg.setPaintMode();
        gg.setStroke(oldstroke);
        this.mouse.x = evt.getX();
        this.mouse.y = evt.getY();
        this.showStatusMouse(1, bounds.width, bounds.height, true);
    }

    private Rectangle getNormalRectangle(Point pt1, Point pt2) {
        Rectangle rc = new Rectangle();
        if (pt1.x <= pt2.x) {
            if (pt1.y < pt2.y) {
                rc.x = pt1.x;
                rc.y = pt1.y;
                rc.width = pt2.x - pt1.x;
                rc.height = pt2.y - pt1.y;
            } else {
                rc.x = pt1.x;
                rc.y = pt2.y;
                rc.width = pt2.x - pt1.x;
                rc.height = pt1.y - pt2.y;
            }
        } else {
            return this.getNormalRectangle(pt2, pt1);
        }
        return rc;
    }

    private void movingElement(Graphics2D g2d) {
        Point pt;
        Rectangle bounds;
        Point maxMove = new Point(this.transformation_origin_end.x - this.transformation_origin.x, this.transformation_origin_end.y - this.transformation_origin.y);
        Line[] lines = StickUtil.moveStickTo((IElement)this.getSelectedElements().get(0), maxMove);
        this.drawLines(g2d, lines);
        for (ReportElement re : this.getSelectedElements()) {
            if (re.isLocked()) continue;
            this.defaultContainer = re.getParent();
            bounds = new Rectangle(this.getZoomedDim(re.getPosition().x), this.getZoomedDim(re.getPosition().y), this.getZoomedDim(re.getWidth()), this.getZoomedDim(re.getHeight()));
            pt = re.getCorrespondTopPos();
            bounds.translate(pt.x, pt.y);
            bounds.translate(maxMove.x, maxMove.y);
            this.ensureMovingInParent(re.getParent(), bounds, maxMove);
        }
        for (ReportElement re : this.getSelectedElements()) {
            if (re.isLocked()) continue;
            this.defaultContainer = re.getParent();
            bounds = new Rectangle(this.getZoomedDim(re.getPosition().x), this.getZoomedDim(re.getPosition().y), this.getZoomedDim(re.getWidth()), this.getZoomedDim(re.getHeight()));
            pt = re.getCorrespondTopPos();
            bounds.translate(pt.x, pt.y);
            bounds.translate(maxMove.x, maxMove.y);
            this.drawRect(g2d, bounds);
        }
    }

    private Rectangle resizingElement(Graphics2D g2d) {
        ReportElement re = (ReportElement)this.getSelectedElements().get(0);
        this.defaultContainer = re.getParent();
        Rectangle bounds = new Rectangle(this.getZoomedDim(re.getPosition().x), this.getZoomedDim(re.getPosition().y), this.getZoomedDim(re.getWidth()), this.getZoomedDim(re.getHeight()));
        Point pt = re.getCorrespondTopPos();
        bounds.translate(pt.x, pt.y);
        if (this.transformation_type == 6 || this.transformation_type == 4 || this.transformation_type == 2) {
            int x_delta = this.transformation_type == 6 || this.transformation_type == 2 ? this.transformation_origin_end.x - this.transformation_origin.x : 0;
            int y_delta = this.transformation_type == 6 || this.transformation_type == 4 ? this.transformation_origin_end.y - this.transformation_origin.y : 0;
            bounds.setSize(Math.max(0, bounds.width + x_delta), Math.max(0, bounds.height + y_delta));
            this.ensureResizingInParent(re.getParent(), bounds);
            Line[] lines = StickUtil.resizeStickTo(re, bounds, 0, this.transformation_origin_end, this.transformation_type);
            this.drawLines(g2d, lines);
            this.drawRect(g2d, bounds);
        } else if (this.transformation_type == 9 || this.transformation_type == 1 || this.transformation_type == 8) {
            int x_delta = this.transformation_type == 9 || this.transformation_type == 8 ? this.transformation_origin_end.x - this.transformation_origin.x : 0;
            int y_delta = this.transformation_type == 9 || this.transformation_type == 1 ? this.transformation_origin_end.y - this.transformation_origin.y : 0;
            int height_grow = Math.min(y_delta, bounds.height);
            int width_grow = Math.min(x_delta, bounds.width);
            bounds.translate(width_grow, height_grow);
            bounds.setSize(bounds.width - width_grow, bounds.height - height_grow);
            this.ensureResizingInParent(re.getParent(), bounds);
            Line[] lines = StickUtil.resizeStickTo(re, bounds, 0, this.transformation_origin_end, this.transformation_type);
            this.drawLines(g2d, lines);
            this.drawRect(g2d, bounds);
        } else if (this.transformation_type == 3) {
            int x_delta = Math.max(-bounds.width, this.transformation_origin_end.x - this.transformation_origin.x);
            int y_delta = Math.min(bounds.height, this.transformation_origin_end.y - this.transformation_origin.y);
            bounds.y += y_delta;
            bounds.height -= y_delta;
            bounds.width += x_delta;
            this.ensureResizingInParent(re.getParent(), bounds);
            Line[] lines = StickUtil.resizeStickTo(re, bounds, 0, this.transformation_origin_end, this.transformation_type);
            this.drawLines(g2d, lines);
            this.drawRect(g2d, bounds);
        } else if (this.transformation_type == 12) {
            int x_delta = Math.min(bounds.width, this.transformation_origin_end.x - this.transformation_origin.x);
            int y_delta = Math.max(-bounds.height, this.transformation_origin_end.y - this.transformation_origin.y);
            bounds.x += x_delta;
            bounds.width -= x_delta;
            bounds.height += y_delta;
            this.ensureResizingInParent(re.getParent(), bounds);
            Line[] lines = StickUtil.resizeStickTo(re, bounds, 0, this.transformation_origin_end, this.transformation_type);
            this.drawLines(g2d, lines);
            this.drawRect(g2d, bounds);
        }
        return bounds;
    }

    private void adjustingElement(MouseEvent evt) {
        if (this.transformation_type == -1 || !this.trasforming) {
            return;
        }
        Graphics gg = this.pageContainerPanel.getGraphics();
        gg.setXORMode(new Color(171, 175, 183));
        Graphics2D g2d = (Graphics2D)gg;
        Stroke oldStroke = g2d.getStroke();
        g2d.setStroke(m_DragDash);
        if (!this.firstXORDrawTransforming && this.getSelectedElements().size() > 0) {
            if (this.transformation_type == 0) {
                this.movingElement(g2d);
            } else {
                this.resizingElement(g2d);
            }
        }
        this.transformation_origin_end.x = evt.getX();
        this.transformation_origin_end.y = evt.getY();
        if (this.getSelectedElements().size() > 0) {
            if (this.transformation_type == 0) {
                this.movingElement(g2d);
                this.showStatusMouse(0, this.transformation_origin_end.x - this.getPageOffsetX(), this.transformation_origin_end.y - this.getPageOffsetY(), true);
            } else {
                Rectangle bounds = this.resizingElement(g2d);
                this.getMainFrame().showStatusMousePosition("");
                this.showStatusMouse(1, bounds.width, bounds.height, true);
            }
        }
        g2d.setStroke(oldStroke);
        this.firstXORDrawTransforming = false;
        gg.setPaintMode();
    }

    private int getLimitValue(boolean bhorize, int pos) {
        Rectangle bounds = new Rectangle(this.getZoomedDim(this.defaultContainer.getPosition().x) + 10 - this.horizontalScrollBar.getValue(), this.getZoomedDim(this.defaultContainer.getPosition().y) + 10 - this.verticalScrollBar.getValue(), this.getZoomedDim(this.defaultContainer.getWidth()), this.getZoomedDim(this.defaultContainer.getHeight()));
        if (bhorize) {
            if (pos < bounds.x) {
                pos = bounds.x;
            }
            if (pos > bounds.x + bounds.width) {
                pos = bounds.x + bounds.width;
            }
        } else {
            if (pos < bounds.y) {
                pos = bounds.y;
            }
            if (pos > bounds.y + bounds.height) {
                pos = bounds.y + bounds.height;
            }
        }
        return pos;
    }

    private void ensureMovingInParent(IContainer parent, Rectangle rc, Point maxMove) {
        Rectangle parentrc = new Rectangle(parent.getPosition().x, parent.getPosition().y, parent.getWidth(), parent.getHeight());
        Point offsetpt = ((ReportElement)((Object)parent)).getCorrespondTopPos();
        parentrc.translate(offsetpt.x, offsetpt.y);
        if (!parentrc.contains(rc)) {
            if (parentrc.x > rc.x) {
                maxMove.x += parentrc.x - rc.x;
                rc.translate(parentrc.x - rc.x, 0);
            }
            if ((double)parentrc.x + parentrc.getWidth() < (double)rc.x + rc.getWidth()) {
                maxMove.x = (int)((double)maxMove.x + ((double)parentrc.x + parentrc.getWidth() - (double)rc.x - rc.getWidth()));
                rc.translate((int)((double)parentrc.x + parentrc.getWidth() - (double)rc.x - rc.getWidth()), 0);
            }
            if (parentrc.y > rc.y) {
                maxMove.y += parentrc.y - rc.y;
                rc.translate(0, parentrc.y - rc.y);
            }
            if ((double)parentrc.y + parentrc.getHeight() < (double)rc.y + rc.getHeight()) {
                maxMove.y = (int)((double)maxMove.y + ((double)parentrc.y + parentrc.getHeight() - (double)rc.y - rc.getHeight()));
                rc.translate(0, (int)((double)parentrc.y + parentrc.getHeight() - (double)rc.y - rc.getHeight()));
            }
        }
    }

    private void ensureInParent(IContainer parent, Rectangle rc) {
        Rectangle parentrc = new Rectangle(parent.getPosition().x, parent.getPosition().y, parent.getWidth(), parent.getHeight());
        parentrc.translate(this.getPageOffsetX(), this.getPageOffsetY());
        Point offsetpt = ((ReportElement)((Object)parent)).getCorrespondTopPos();
        parentrc.translate(offsetpt.x, offsetpt.y);
        if (!parentrc.contains(rc)) {
            if (parentrc.x > rc.x) {
                rc.translate(parentrc.x - rc.x, 0);
            }
            if ((double)parentrc.x + parentrc.getWidth() < (double)rc.x + rc.getWidth()) {
                rc.translate((int)((double)parentrc.x + parentrc.getWidth() - (double)rc.x - rc.getWidth()), 0);
            }
            if (parentrc.y > rc.y) {
                rc.translate(0, parentrc.y - rc.y);
            }
            if ((double)parentrc.y + parentrc.getHeight() < (double)rc.y + rc.getHeight()) {
                rc.translate(0, (int)((double)parentrc.y + parentrc.getHeight() - (double)rc.y - rc.getHeight()));
            }
        }
    }

    private void ensureResizingInParent(IContainer parent, Rectangle rc) {
        Rectangle parentrc = new Rectangle(parent.getPosition().x, parent.getPosition().y, parent.getWidth(), parent.getHeight());
        Point offsetpt = ((ReportElement)((Object)parent)).getCorrespondTopPos();
        parentrc.translate(offsetpt.x, offsetpt.y);
        if (!parentrc.contains(rc)) {
            Rectangle interRc = parentrc.intersection(rc);
            rc.setBounds(interRc.x, interRc.y, interRc.width, interRc.height);
        }
    }

    public void addSelectedElement(ReportElement el) {
        if (!this.getSelectedElements().contains(el)) {
            this.getSelectedElements().add(0, el);
            this.refreshHierarchy(el, false);
            this.pageContainerPanel.repaint();
            ReportElementsSelectionEvent rece = new ReportElementsSelectionEvent(this, this.getSelectedElements());
            this.fireReportListenerReportElementsSelectionChanged(rece);
            if (this.getMainFrame().getElementPropertiesDialog().isVisible()) {
                this.getMainFrame().getElementPropertiesDialog().updateSelection(this.isHeadFooter());
            }
            this.getMainFrame().updateCutPasteMenuEnabled(this);
        }
    }

    public void removeSelectedElement(ReportElement el) {
        if (this.getSelectedElements().contains(el)) {
            this.getSelectedElements().remove(el);
            this.refreshHierarchy(el, true);
            this.pageContainerPanel.repaint();
            ReportElementsSelectionEvent rece = new ReportElementsSelectionEvent(this, this.getSelectedElements());
            this.fireReportListenerReportElementsSelectionChanged(rece);
            if (this.getMainFrame().getElementPropertiesDialog().isVisible()) {
                this.getMainFrame().getElementPropertiesDialog().updateSelection(this.isHeadFooter());
            }
            this.getMainFrame().updateCutPasteMenuEnabled(this);
        }
    }

    private void refreshHierarchy(ReportElement el, boolean isRemove) {
        IContainer parent = el.getParent();
        boolean last = false;
        if (parent != null) {
            ReportElement tempel = el;
            do {
                if (parent instanceof Page) {
                    last = true;
                }
                Iterator it = parent.getChildren().iterator();
                int childrenCount = parent.getChildren().size();
                while (it.hasNext()) {
                    if (it.next() != tempel) continue;
                    it.remove();
                    if (isRemove) {
                        int selCount = this.getSelectedElements().size();
                        parent.getChildren().add(childrenCount - selCount - 1, tempel);
                        isRemove = false;
                        break;
                    }
                    parent.addElement(tempel);
                    break;
                }
                tempel = (ReportElement)((Object)parent);
                parent = parent.getParent();
            } while (!last);
        }
    }

    public void refreshHierarchy() {
        for (ReportElement re : this.getSelectedElements()) {
            this.refreshHierarchy(re, false);
        }
        this.pageContainerPanel.repaint();
    }

    public void setSelectedElement(ReportElement el) {
        boolean makerefreshAll = false;
        makerefreshAll = true;
        this.getSelectedElements().clear();
        if (el != null) {
            this.addSelectedElement(el);
        }
        this.getMainFrame().updateCutPasteMenuEnabled(this);
        if (makerefreshAll) {
            this.pageContainerPanel.repaint();
        }
        ReportElementsSelectionEvent rece = null;
        if (el != null) {
            rece = new ReportElementsSelectionEvent(this, this.getSelectedElements());
        } else {
            ArrayList<Page> array = new ArrayList<Page>();
            array.add(this.currentpage);
            rece = new ReportElementsSelectionEvent(this, array);
        }
        this.fireReportListenerReportElementsSelectionChanged(rece);
        if (this.getMainFrame().getElementPropertiesDialog().isVisible()) {
            this.getMainFrame().getElementPropertiesDialog().updateSelection(this.isHeadFooter());
            this.requestFocusInWindow();
        }
    }

    private void actionPerformedLock(boolean isLock) {
        Iterator it = this.getSelectedElements().iterator();
        while (it.hasNext()) {
            ((ReportElement)it.next()).setLocked(isLock);
        }
        this.repaint();
    }

    private void actionPerformedPopupMenuCut(ActionEvent evt) {
        this.cut();
    }

    private void actionPerformedPopupMenuCopy(ActionEvent evt) {
        this.copy();
    }

    private void actionPerformedPopupMenuPaste(ActionEvent evt) {
        this.paste();
    }

    private void actionPerformedPopupMenuDelete(ActionEvent evt) {
        this.deleteSelectedElements();
    }

    private void actionPerformedPopupMenuProperties(ActionEvent evt) {
        this.openElementPropertiesDialog();
    }

    public void actionPerformedPopupMenuCopyStyle() {
        ReportElement re = this.getSelectedElements().size() > 0 ? (ReportElement)this.getSelectedElements().get(0) : this.getCurrentPage();
        this.getMainFrame().getStyleClipboard().styleCopy(re);
    }

    public void actionPerformedPopupMenuPasteStyle() {
        if (this.getMainFrame().getStyleClipboard().isClipboardEmpty()) {
            return;
        }
        if (this.getSelectedElements().size() == 0) {
            this.getMainFrame().getStyleClipboard().stylePaste(this.getCurrentPage());
        } else {
            Iterator it = this.getSelectedElements().iterator();
            this.getMainFrame().getStyleClipboard().stylePaste(it);
        }
        this.repaint();
        if (this.getMainFrame().getElementPropertiesDialog().isVisible()) {
            this.getMainFrame().getElementPropertiesDialog().updateSelection(this.isHeadFooter());
        }
    }

    public void openElementPropertiesDialog() {
        if (!this.getMainFrame().getElementPropertiesDialog().isVisible()) {
            this.getMainFrame().getElementPropertiesDialog().updateSelection(this.isHeadFooter());
            this.getMainFrame().getElementPropertiesDialog().setVisible(true);
        }
    }

    public ArrayList getSelectedElements() {
        if (this.currentpage == null) {
            return new ArrayList();
        }
        return this.currentpage.getSelectedElements();
    }

    public boolean isHeadFooter() {
        if (this.currentpage != null) {
            return this.currentpage.getEleType() == 16;
        }
        return false;
    }

    public boolean saveToFile(boolean showFileChooser) {
        boolean isNoFileName = StringUtil.isEmptyString((String)this.getReport().getFilename());
        if (showFileChooser || isNoFileName) {
            KDFileChooser jfc = new KDFileChooser(System.getProperty("KDF.dir"));
            jfc.setDialogTitle(KDFFrame.getMLS("savingTitle", "\u53e6\u5b58\u4e3a"));
            jfc.setFileFilter(new FileFilter(){

                @Override
                public boolean accept(File file) {
                    String filename = file.getName();
                    if (file.isDirectory()) {
                        return true;
                    }
                    if (filename.length() > 10) {
                        String ext = filename.substring(filename.length() - 10);
                        return ext.equalsIgnoreCase(".kdrs-form");
                    }
                    return false;
                }

                @Override
                public String getDescription() {
                    return KDFFrame.getMLS("savefilter", "\u91d1\u8776\u62a5\u8868 *.kdf");
                }
            });
            jfc.setMultiSelectionEnabled(false);
            jfc.setDialogType(1);
            if (isNoFileName) {
                jfc.setSelectedFile(new File(this.getReport().getName()));
            } else {
                jfc.setSelectedFile(new File(this.getReport().getFilename()));
            }
            String newfileName = "";
            boolean toChoose = true;
            while (toChoose) {
                File file;
                if (jfc.showSaveDialog((Component)((Object)this.getMainFrame())) != 0) {
                    return false;
                }
                newfileName = jfc.getSelectedFile().getPath();
                int filenameLength = newfileName.length();
                if (filenameLength <= 10 || !newfileName.substring(filenameLength - 10).equalsIgnoreCase(".kdrs-form")) {
                    newfileName = newfileName + ".kdrs-form";
                }
                if ((file = new File(newfileName)).exists()) {
                    String title = KDFFrame.getMLS("dlgTitle", "\u8868\u5355\u8bbe\u8ba1\u5668");
                    String prompt = KDFFrame.getMLS("savingDlgPrompt", "\u6587\u4ef6\u5df2\u5b58\u5728\uff0c\u662f\u5426\u8986\u76d6\uff1f");
                    if (MsgBox.show((Component)((Object)this.getMainFrame()), prompt, title, 68) == 0) {
                        toChoose = false;
                        continue;
                    }
                    toChoose = true;
                    continue;
                }
                toChoose = false;
            }
            this.getReport().setFilename(newfileName);
            System.setProperty("KDF.dir", jfc.getCurrentDirectory().toString());
        }
        this.getReport().saveKdfFile();
        this.afterSave();
        this.getMainFrame().addRecentFile(1, this.getReport().getFilename());
        return true;
    }

    public void afterSave() {
        this.promptInvalidGroups();
        this.getReport().setDirty(false);
        this.updateTitle();
        this.getMainFrame().showStatusProgress();
    }

    public boolean save() {
        return this.fileSaver.save(this);
    }

    public void promptInvalidGroups() {
        ArrayList invalidGroups = this.getReport().getInvalidGroups();
        if (invalidGroups.size() > 0) {
            String prompt = KDFFrame.getMLS("invalidGroupsPompt", "\u4ee5\u4e0b\u5206\u7ec4\u6216\u8868\u683c\u6ca1\u6709\u8bbe\u7f6e\u6570\u636e\u6e90\uff0c\u5c06\u4e0d\u80fd\u6b63\u5e38\u6253\u5370\u3002");
            Iterator it = invalidGroups.iterator();
            while (it.hasNext()) {
                prompt = prompt + "\n  " + it.next().toString();
            }
            MsgBox.show((Component)((Object)this.getMainFrame()), prompt, KDFFrame.getMLS("warning", "\u91d1\u8776\u63d0\u793a"), 129);
        }
    }

    public void setDefaultContainer(IContainer container) {
        this.defaultContainer = container;
    }

    private static String getMLS(String key, String defaultValue) {
        return LanguageManager.getLangMessage((String)key, (String)res, (String)defaultValue);
    }

    private void showStatusMouse(int type, int x, int y, boolean isPixelToLom) {
        int showY;
        int showX;
        if (isPixelToLom) {
            showX = (int)StyleUtil.pixelToLom((long)x);
            showY = (int)StyleUtil.pixelToLom((long)y);
        } else {
            showX = x;
            showY = y;
        }
        if (type == 0) {
            this.getMainFrame().showStatusMousePosition(showX + "," + showY);
        } else if (type == 1) {
            this.getMainFrame().showStatusDeltaMouse(showX + "x" + showY);
        }
    }

    private boolean isHorizontalAbsoluteLocation(Iterator it) {
        boolean isAbs = true;
        String nameWhoIsNotAbs = "";
        while (it.hasNext()) {
            ReportElement re = (ReportElement)it.next();
            if (re.isHorizontalAbsoluteLocation()) continue;
            if (!isAbs) {
                nameWhoIsNotAbs = nameWhoIsNotAbs + ", ";
            }
            nameWhoIsNotAbs = nameWhoIsNotAbs + re.getAliasName();
            isAbs = false;
        }
        if (!isAbs) {
            MsgBox.show((Component)((Object)this.getMainFrame()), KDFFrame.getMLS("promptHNotAbsLoc", "\u4ee5\u4e0b\u5bf9\u8c61\u5728\u6c34\u5e73\u65b9\u5411\u4e0a\u975e\u7edd\u5bf9\u5b9a\u4f4d\uff0c\u4e0d\u80fd\u8fdb\u884c\u6b64\u64cd\u4f5c\u3002\r\n") + nameWhoIsNotAbs, KDFFrame.getMLS("warning", "\u91d1\u8776\u63d0\u793a"), 129);
        }
        return isAbs;
    }

    private boolean isVerticalAbsoluteLocation(Iterator it) {
        boolean isAbs = true;
        String nameWhoIsNotAbs = "";
        while (it.hasNext()) {
            ReportElement re = (ReportElement)it.next();
            if (re.isVerticalAbsoluteLocation()) continue;
            if (!isAbs) {
                nameWhoIsNotAbs = nameWhoIsNotAbs + ", ";
            }
            nameWhoIsNotAbs = nameWhoIsNotAbs + re.getAliasName();
            isAbs = false;
        }
        if (!isAbs) {
            MsgBox.show((Component)((Object)this.getMainFrame()), KDFFrame.getMLS("promptVNotAbsLoc", "\u4ee5\u4e0b\u5bf9\u8c61\u5728\u5782\u76f4\u65b9\u5411\u4e0a\u975e\u7edd\u5bf9\u5b9a\u4f4d\uff0c\u4e0d\u80fd\u8fdb\u884c\u6b64\u64cd\u4f5c\u3002\r\n") + nameWhoIsNotAbs, KDFFrame.getMLS("warning", "\u91d1\u8776\u63d0\u793a"), 129);
        }
        return isAbs;
    }

    public void assEditAlignLeft() {
        if (this.getSelectedElements().size() < 2) {
            return;
        }
        if (!this.isHorizontalAbsoluteLocation(this.getSelectedElements().iterator())) {
            return;
        }
        ReportElement standardRE = (ReportElement)this.getSelectedElements().get(0);
        Iterator it = this.getSelectedElements().iterator();
        it.next();
        int newValue = standardRE.getLocation().getSideLocation(0).getValue();
        while (it.hasNext()) {
            ReportElement re = (ReportElement)it.next();
            if (newValue + re.getWidthLom() > re.getParent().getWidthLom()) {
                int newWidth = re.getParent().getWidthLom() - newValue;
                re.setWidthLom(newWidth);
                re.getLocation().getSideLocation(1).setValue(newWidth);
            }
            re.getLocation().getSideLocation(0).setValue(newValue);
            re.addRelationQuean(re.getTopContainer().getDeps());
        }
        standardRE.getTopContainer().recalcAllPos();
        this.repaint();
    }

    public void assEditAlignRight() {
        if (this.getSelectedElements().size() < 2) {
            return;
        }
        if (!this.isHorizontalAbsoluteLocation(this.getSelectedElements().iterator())) {
            return;
        }
        ReportElement standardRE = (ReportElement)this.getSelectedElements().get(0);
        Iterator it = this.getSelectedElements().iterator();
        it.next();
        int rightValue = standardRE.getLocation().getSideLocation(0).getValue() + standardRE.getLocation().getSideLocation(1).getValue();
        while (it.hasNext()) {
            ReportElement re = (ReportElement)it.next();
            if (rightValue - re.getWidthLom() < 0) {
                re.setWidthLom(rightValue);
                re.getLocation().getSideLocation(1).setValue(rightValue);
                re.getLocation().getSideLocation(0).setValue(0);
            } else {
                re.getLocation().getSideLocation(0).setValue(rightValue - re.getWidthLom());
            }
            re.addRelationQuean(re.getTopContainer().getDeps());
        }
        standardRE.getTopContainer().recalcAllPos();
        this.repaint();
    }

    public void assEditAlignCenter() {
        if (this.getSelectedElements().size() < 2) {
            return;
        }
        if (!this.isHorizontalAbsoluteLocation(this.getSelectedElements().iterator())) {
            return;
        }
        ReportElement standardRE = (ReportElement)this.getSelectedElements().get(0);
        Iterator it = this.getSelectedElements().iterator();
        it.next();
        int midValue = standardRE.getLocation().getSideLocation(0).getValue() + standardRE.getLocation().getSideLocation(1).getValue() / 2;
        while (it.hasNext()) {
            int newWidth;
            ReportElement re = (ReportElement)it.next();
            int newLeft = midValue - re.getWidthLom() / 2;
            int newRight = midValue + re.getWidthLom() / 2;
            if (newLeft < 0) {
                newWidth = re.getWidthLom() + 2 * newLeft;
                re.setWidthLom(newWidth);
                re.getLocation().getSideLocation(1).setValue(newWidth);
                re.getLocation().getSideLocation(0).setValue(0);
            } else if (newRight > re.getParent().getWidthLom()) {
                newWidth = re.getWidthLom() - 2 * (newRight - re.getParent().getWidthLom());
                re.setWidthLom(newWidth);
                re.getLocation().getSideLocation(1).setValue(newWidth);
                re.getLocation().getSideLocation(0).setValue(re.getParent().getWidthLom() - newWidth);
            } else {
                re.getLocation().getSideLocation(0).setValue(newLeft);
            }
            re.addRelationQuean(re.getTopContainer().getDeps());
        }
        standardRE.getTopContainer().recalcAllPos();
        this.repaint();
    }

    public void assEditAlignHArray() {
        int i;
        if (this.getSelectedElements().size() < 2) {
            return;
        }
        if (!this.isHorizontalAbsoluteLocation(this.getSelectedElements().iterator())) {
            return;
        }
        Object[] allRE = this.getSelectedElements().toArray();
        for (int i2 = 0; i2 < allRE.length - 1; ++i2) {
            ReportElement rei = (ReportElement)allRE[i2];
            for (int j = i2 + 1; j < allRE.length; ++j) {
                ReportElement rej = (ReportElement)allRE[j];
                if (rei.getPosLom().x >= rej.getPosLom().x) continue;
                ReportElement temp = rei;
                allRE[i2] = rej;
                allRE[j] = temp;
                rei = (ReportElement)allRE[i2];
            }
        }
        ReportElement reFirst = (ReportElement)allRE[allRE.length - 1];
        int x = reFirst.getPosLom().x;
        for (i = allRE.length - 1; i >= 0; --i) {
            x += ((ReportElement)allRE[i]).getWidthLom();
        }
        if (x > reFirst.getParent().getWidthLom()) {
            MsgBox.show((Component)((Object)this.getMainFrame()), KDFFrame.getMLS("promptArrayFail", "\u8be5\u64cd\u4f5c\u5c06\u5bfc\u81f4\u5bf9\u8c61\u8d85\u51fa\u5bb9\u5668\uff0c\u6392\u5217\u5931\u8d25\u3002\r\n\u53ef\u8c03\u6574\u5bf9\u8c61\u4f4d\u7f6e\u6216\u5927\u5c0f\uff0c\u91cd\u65b0\u6392\u5217\u3002"), KDFFrame.getMLS("warning", "\u91d1\u8776\u63d0\u793a"), 129);
            return;
        }
        x = reFirst.getPosLom().x + reFirst.getWidthLom();
        for (i = allRE.length - 2; i >= 0; --i) {
            ReportElement rei = (ReportElement)allRE[i];
            rei.getLocation().getSideLocation(0).setValue(x);
            x += rei.getWidthLom();
            rei.addRelationQuean(rei.getTopContainer().getDeps());
        }
        reFirst.getTopContainer().recalcAllPos();
        this.repaint();
    }

    public void assEditAlignTop() {
        if (this.getSelectedElements().size() < 2) {
            return;
        }
        if (!this.isVerticalAbsoluteLocation(this.getSelectedElements().iterator())) {
            return;
        }
        ReportElement standardRE = (ReportElement)this.getSelectedElements().get(0);
        Iterator it = this.getSelectedElements().iterator();
        it.next();
        int newValue = standardRE.getLocation().getSideLocation(2).getValue();
        while (it.hasNext()) {
            ReportElement re = (ReportElement)it.next();
            if (newValue + re.getHeightLom() > re.getParent().getHeightLom()) {
                int newHeight = re.getParent().getHeightLom() - newValue;
                re.setHeightLom(newHeight);
                re.getLocation().getSideLocation(3).setValue(newHeight);
            }
            re.getLocation().getSideLocation(2).setValue(newValue);
            re.addRelationQuean(re.getTopContainer().getDeps());
        }
        standardRE.getTopContainer().recalcAllPos();
        this.repaint();
    }

    public void assEditAlignBottom() {
        if (this.getSelectedElements().size() < 2) {
            return;
        }
        if (!this.isVerticalAbsoluteLocation(this.getSelectedElements().iterator())) {
            return;
        }
        ReportElement standardRE = (ReportElement)this.getSelectedElements().get(0);
        Iterator it = this.getSelectedElements().iterator();
        it.next();
        int bottomValue = standardRE.getLocation().getSideLocation(2).getValue() + standardRE.getLocation().getSideLocation(3).getValue();
        while (it.hasNext()) {
            ReportElement re = (ReportElement)it.next();
            if (bottomValue - re.getHeightLom() < 0) {
                re.setHeightLom(bottomValue);
                re.getLocation().getSideLocation(3).setValue(bottomValue);
                re.getLocation().getSideLocation(2).setValue(0);
            } else {
                re.getLocation().getSideLocation(2).setValue(bottomValue - re.getHeightLom());
            }
            re.addRelationQuean(re.getTopContainer().getDeps());
        }
        standardRE.getTopContainer().recalcAllPos();
        this.repaint();
    }

    public void assEditAlignMiddle() {
        if (this.getSelectedElements().size() < 2) {
            return;
        }
        if (!this.isVerticalAbsoluteLocation(this.getSelectedElements().iterator())) {
            return;
        }
        ReportElement standardRE = (ReportElement)this.getSelectedElements().get(0);
        Iterator it = this.getSelectedElements().iterator();
        it.next();
        int midValue = standardRE.getLocation().getSideLocation(2).getValue() + standardRE.getLocation().getSideLocation(3).getValue() / 2;
        while (it.hasNext()) {
            int newHeight;
            ReportElement re = (ReportElement)it.next();
            int newTop = midValue - re.getHeightLom() / 2;
            int newBottom = midValue + re.getHeightLom() / 2;
            if (newTop < 0) {
                newHeight = re.getHeightLom() + 2 * newTop;
                re.setHeightLom(newHeight);
                re.getLocation().getSideLocation(3).setValue(newHeight);
                re.getLocation().getSideLocation(2).setValue(0);
            } else if (newBottom > re.getParent().getHeightLom()) {
                newHeight = re.getHeightLom() - 2 * (newBottom - re.getParent().getHeightLom());
                re.setHeightLom(newHeight);
                re.getLocation().getSideLocation(3).setValue(newHeight);
                re.getLocation().getSideLocation(2).setValue(re.getParent().getHeightLom() - newHeight);
            } else {
                re.getLocation().getSideLocation(2).setValue(newTop);
            }
            re.addRelationQuean(re.getTopContainer().getDeps());
        }
        standardRE.getTopContainer().recalcAllPos();
        this.repaint();
    }

    public void assEditAlignVArray() {
        int i;
        if (this.getSelectedElements().size() < 2) {
            return;
        }
        if (!this.isVerticalAbsoluteLocation(this.getSelectedElements().iterator())) {
            return;
        }
        Object[] allRE = this.getSelectedElements().toArray();
        for (int i2 = 0; i2 < allRE.length - 1; ++i2) {
            ReportElement rei = (ReportElement)allRE[i2];
            for (int j = i2 + 1; j < allRE.length; ++j) {
                ReportElement rej = (ReportElement)allRE[j];
                if (rei.getPosLom().y >= rej.getPosLom().y) continue;
                ReportElement temp = rei;
                allRE[i2] = rej;
                allRE[j] = temp;
                rei = (ReportElement)allRE[i2];
            }
        }
        ReportElement reFirst = (ReportElement)allRE[allRE.length - 1];
        int y = reFirst.getPosLom().y;
        for (i = allRE.length - 1; i >= 0; --i) {
            y += ((ReportElement)allRE[i]).getHeightLom();
        }
        if (y > reFirst.getParent().getHeightLom()) {
            MsgBox.show((Component)((Object)this.getMainFrame()), KDFFrame.getMLS("promptArrayFail", "\u8be5\u64cd\u4f5c\u5c06\u5bfc\u81f4\u5bf9\u8c61\u8d85\u51fa\u5bb9\u5668\uff0c\u6392\u5217\u5931\u8d25\u3002\r\n\u53ef\u8c03\u6574\u5bf9\u8c61\u4f4d\u7f6e\u6216\u5927\u5c0f\uff0c\u91cd\u65b0\u6392\u5217\u3002"), KDFFrame.getMLS("warning", "\u91d1\u8776\u63d0\u793a"), 129);
            return;
        }
        y = reFirst.getPosLom().y + reFirst.getHeightLom();
        for (i = allRE.length - 2; i >= 0; --i) {
            ReportElement rei = (ReportElement)allRE[i];
            rei.getLocation().getSideLocation(2).setValue(y);
            y += rei.getHeightLom();
            rei.addRelationQuean(rei.getTopContainer().getDeps());
        }
        reFirst.getTopContainer().recalcAllPos();
        this.repaint();
    }

    public boolean isAssEditAlignEnabled() {
        return this.getSelectedElements().size() >= 2 && !(((ReportElement)this.getSelectedElements().get(0)).getParent() instanceof Table);
    }

    public boolean isAssEditSizeEnabled() {
        return this.isAssEditAlignEnabled();
    }

    public boolean isAssEditPositionEnabled() {
        return this.getSelectedElements().size() > 0 && !(((ReportElement)this.getSelectedElements().get(0)).getParent() instanceof Table);
    }

    public void assEditSameHeight() {
        if (this.getSelectedElements().size() < 2) {
            return;
        }
        if (!this.isVerticalAbsoluteLocation(this.getSelectedElements().iterator())) {
            return;
        }
        this.makeSameHeight();
    }

    private void makeSameHeight() {
        ReportElement standardRE = (ReportElement)this.getSelectedElements().get(0);
        Iterator it = this.getSelectedElements().iterator();
        it.next();
        int value = standardRE.getHeightLom();
        while (it.hasNext()) {
            ReportElement re = (ReportElement)it.next();
            if (re.getPosLom().y + value > re.getParent().getHeightLom()) {
                re.getLocation().getSideLocation(2).setValue(re.getParent().getHeightLom() - value);
            }
            re.getLocation().getSideLocation(3).setValue(value);
            re.addRelationQuean(re.getTopContainer().getDeps());
        }
        standardRE.getTopContainer().recalcAllPos();
        this.repaint();
    }

    public void assEditSameWidth() {
        if (this.getSelectedElements().size() < 2) {
            return;
        }
        if (!this.isHorizontalAbsoluteLocation(this.getSelectedElements().iterator())) {
            return;
        }
        this.makeSameWidth();
    }

    private void makeSameWidth() {
        ReportElement standardRE = (ReportElement)this.getSelectedElements().get(0);
        Iterator it = this.getSelectedElements().iterator();
        it.next();
        int value = standardRE.getWidthLom();
        while (it.hasNext()) {
            ReportElement re = (ReportElement)it.next();
            if (re.getPosLom().x + value > re.getParent().getWidthLom()) {
                re.getLocation().getSideLocation(0).setValue(re.getParent().getWidthLom() - value);
            }
            re.getLocation().getSideLocation(1).setValue(value);
            re.addRelationQuean(re.getTopContainer().getDeps());
        }
        standardRE.getTopContainer().recalcAllPos();
        this.repaint();
    }

    public void assEditSameSize() {
        if (this.getSelectedElements().size() < 2) {
            return;
        }
        if (!this.isVerticalAbsoluteLocation(this.getSelectedElements().iterator()) || !this.isHorizontalAbsoluteLocation(this.getSelectedElements().iterator())) {
            return;
        }
        this.makeSameHeight();
        this.makeSameWidth();
    }

    public void assEditPositionCenter() {
        if (this.getSelectedElements().size() == 0) {
            return;
        }
        if (!this.isHorizontalAbsoluteLocation(this.getSelectedElements().iterator())) {
            return;
        }
        IContainer parent = ((ReportElement)this.getSelectedElements().get(0)).getParent();
        int min = -1;
        int max = -1;
        for (ReportElement re : this.getSelectedElements()) {
            if (min == -1 || min > re.getPosLom().x) {
                min = re.getPosLom().x;
            }
            if (max != -1 && max >= re.getPosLom().x + re.getWidthLom()) continue;
            max = re.getPosLom().x + re.getWidthLom();
        }
        int newMin = parent.getWidthLom() / 2 - (max - min) / 2;
        int offs = newMin - min;
        for (ReportElement re : this.getSelectedElements()) {
            SideLocation left = re.getLocation().getSideLocation(0);
            left.setValue(left.getValue() + offs);
            re.addRelationQuean(re.getTopContainer().getDeps());
        }
        ((ReportElement)this.getSelectedElements().get(0)).getTopContainer().recalcAllPos();
        this.repaint();
    }

    public void assEditPositionMiddle() {
        if (this.getSelectedElements().size() == 0) {
            return;
        }
        if (!this.isVerticalAbsoluteLocation(this.getSelectedElements().iterator())) {
            return;
        }
        IContainer parent = ((ReportElement)this.getSelectedElements().get(0)).getParent();
        int min = -1;
        int max = -1;
        for (ReportElement re : this.getSelectedElements()) {
            if (min == -1 || min > re.getPosLom().y) {
                min = re.getPosLom().y;
            }
            if (max != -1 && max >= re.getPosLom().y + re.getHeightLom()) continue;
            max = re.getPosLom().y + re.getHeightLom();
        }
        int newMin = parent.getHeightLom() / 2 - (max - min) / 2;
        int offs = newMin - min;
        for (ReportElement re : this.getSelectedElements()) {
            SideLocation top = re.getLocation().getSideLocation(2);
            top.setValue(top.getValue() + offs);
            re.addRelationQuean(re.getTopContainer().getDeps());
        }
        ((ReportElement)this.getSelectedElements().get(0)).getTopContainer().recalcAllPos();
        this.repaint();
    }

    public void scrollRectToVisible(int x, int y, int width, int height) {
        int dx = 0;
        int dy = 0;
        dx = this.positionAdjustment(this.getWidth() - 30, width, x - this.horizontalScrollBar.getValue());
        dy = this.positionAdjustment(this.getHeight() - 30, height, y - this.verticalScrollBar.getValue());
        if (dx != 0) {
            this.horizontalScrollBar.setValue(this.horizontalScrollBar.getValue() - dx);
        }
        if (dy != 0) {
            this.verticalScrollBar.setValue(this.verticalScrollBar.getValue() - dy);
        }
    }

    private int positionAdjustment(int parentWidth, int childWidth, int childAt) {
        if (childAt >= 0 && childWidth + childAt <= parentWidth) {
            return 0;
        }
        if (childAt <= 0 && childWidth + childAt >= parentWidth) {
            return -childAt;
        }
        if (childAt > 0 && childWidth <= parentWidth) {
            return -childAt + parentWidth - childWidth;
        }
        if (childAt >= 0 && childWidth >= parentWidth) {
            return -childAt;
        }
        if (childAt <= 0 && childWidth <= parentWidth) {
            return -childAt;
        }
        if (childAt < 0 && childWidth >= parentWidth) {
            return -childAt;
        }
        return 0;
    }

    public void setFileSaver(IFileSaver fileSaver) {
        this.fileSaver = fileSaver;
    }

    private int getPageOffsetX() {
        return this.pageContainerPanel.getPagePos().x - this.horizontalScrollBar.getValue();
    }

    private int getPageOffsetY() {
        return this.pageContainerPanel.getPagePos().y - this.verticalScrollBar.getValue();
    }

    private void drawLine(Graphics g, int x1, int y1, int x2, int y2) {
        g.drawLine(x1 + this.getPageOffsetX(), y1 + this.getPageOffsetY(), x2 + this.getPageOffsetX(), y2 + this.getPageOffsetY());
    }

    private void drawLine(Graphics g, Line line) {
        if (line != null) {
            this.drawLine(g, line.getX1(), line.getY1(), line.getX2(), line.getY2());
        }
    }

    private void drawLines(Graphics2D g2d, Line[] lines) {
        if (lines == null) {
            return;
        }
        Color color = g2d.getColor();
        Stroke stk = g2d.getStroke();
        g2d.setColor(Color.BLUE);
        g2d.setStroke(PenStyle.PS_DASHDOTDOT.getBaseStroke());
        for (int i = 0; i < lines.length; ++i) {
            this.drawLine(g2d, lines[i]);
        }
        g2d.setStroke(stk);
        g2d.setColor(color);
    }

    private void drawRect(Graphics2D g2d, int x, int y, int w, int h) {
        g2d.drawRect(x + this.getPageOffsetX(), y + this.getPageOffsetY(), w, h);
    }

    private void drawRect(Graphics2D g2d, Rectangle rect) {
        this.drawRect(g2d, rect.x, rect.y, rect.width, rect.height);
    }

    private void showSelectParentMenu(boolean isShow, Point xy, ReportElement selected) {
        if (this.mnuSelectParent == null) {
            this.mnuSelectParent = new KDPopupMenu();
        }
        if (isShow && !this.mnuSelectParent.isShowing()) {
            this.mnuSelectParent.removeAll();
            ReportElement re = selected;
            while (!(re instanceof Page)) {
                re = (ReportElement)((Object)re.getParent());
                KDMenuItem mi = new KDMenuItem(re.getAliasName());
                mi.setIcon(ReportElementFactory.createIcon(re));
                mi.setUserObject((Object)re);
                if (this.selectParentHandler == null) {
                    this.selectParentHandler = new SelectParentHandler();
                }
                mi.addActionListener((ActionListener)this.selectParentHandler);
                this.mnuSelectParent.insert((Component)mi, 0);
            }
            int x = xy.x + 3;
            int y = xy.y - this.mnuSelectParent.getPreferredSize().height;
            y = y < 0 ? 0 : y;
            this.mnuSelectParent.show((Component)((Object)this), x, y);
        } else if (!isShow && this.mnuSelectParent.isShowing()) {
            this.mnuSelectParent.setVisible(false);
        }
    }

    static {
        float[] fArray = new float[]{2.0f, 2.0f};
        m_Dashed3 = new BasicStroke(1.0f, 2, 2, 1.0f, fArray, 0.0f);
        float[] fArray2 = new float[]{2.0f, 2.0f};
        m_SelectedDash = new BasicStroke(1.0f, 0, 0, 4.0f, fArray2, 0.0f);
        m_DragDash = new BasicStroke(2.0f);
        res = CtrlClassUtil.getPackageName(KDFFrame.class) + ".gui";
    }

    private class SelectParentHandler
    implements ActionListener {
        private SelectParentHandler() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            KDMenuItem mi = (KDMenuItem)e.getSource();
            ReportElement parent = (ReportElement)mi.getUserObject();
            if (parent instanceof Page) {
                KDFFrame.this.setSelectedElement(null);
            } else {
                KDFFrame.this.setSelectedElement(parent);
            }
        }
    }

    private class KDFFListener
    implements ActionListener {
        private KDFFListener() {
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            Object source = evt.getSource();
            if (source == KDFFrame.this.popupChkItemLock) {
                KDFFrame.this.actionPerformedLock(KDFFrame.this.popupChkItemLock.isSelected());
                return;
            }
            if (source == KDFFrame.this.popupItemCut) {
                KDFFrame.this.actionPerformedPopupMenuCut(evt);
                return;
            }
            if (source == KDFFrame.this.popupItemCopy) {
                KDFFrame.this.actionPerformedPopupMenuCopy(evt);
                return;
            }
            if (source == KDFFrame.this.popupItemPaste) {
                KDFFrame.this.actionPerformedPopupMenuPaste(evt);
                return;
            }
            if (source == KDFFrame.this.popupItemDelete) {
                KDFFrame.this.actionPerformedPopupMenuDelete(evt);
                return;
            }
            if (source == KDFFrame.this.popupItemCopyStyle) {
                KDFFrame.this.actionPerformedPopupMenuCopyStyle();
                return;
            }
            if (source == KDFFrame.this.popupItemPasteStyle) {
                KDFFrame.this.actionPerformedPopupMenuPasteStyle();
                return;
            }
            if (source == KDFFrame.this.popupItemAlignLeft) {
                KDFFrame.this.assEditAlignLeft();
                return;
            }
            if (source == KDFFrame.this.popupItemAlignCenter) {
                KDFFrame.this.assEditAlignCenter();
                return;
            }
            if (source == KDFFrame.this.popupItemAlignRight) {
                KDFFrame.this.assEditAlignRight();
                return;
            }
            if (source == KDFFrame.this.popupItemAlignHArray) {
                KDFFrame.this.assEditAlignHArray();
                return;
            }
            if (source == KDFFrame.this.popupItemAlignTop) {
                KDFFrame.this.assEditAlignTop();
                return;
            }
            if (source == KDFFrame.this.popupItemAlignMiddle) {
                KDFFrame.this.assEditAlignMiddle();
                return;
            }
            if (source == KDFFrame.this.popupItemAlignBottom) {
                KDFFrame.this.assEditAlignBottom();
                return;
            }
            if (source == KDFFrame.this.popupItemAlignVArray) {
                KDFFrame.this.assEditAlignVArray();
                return;
            }
            if (source == KDFFrame.this.popupItemSameHeight) {
                KDFFrame.this.assEditSameHeight();
                return;
            }
            if (source == KDFFrame.this.popupItemSameWidth) {
                KDFFrame.this.assEditSameWidth();
                return;
            }
            if (source == KDFFrame.this.popupItemSameSize) {
                KDFFrame.this.assEditSameSize();
                return;
            }
            if (source == KDFFrame.this.popupItemPositionCenter) {
                KDFFrame.this.assEditPositionCenter();
                return;
            }
            if (source == KDFFrame.this.popupItemPositionMiddle) {
                KDFFrame.this.assEditPositionMiddle();
                return;
            }
            if (source == KDFFrame.this.popupItemProperties) {
                KDFFrame.this.actionPerformedPopupMenuProperties(evt);
                return;
            }
            if (source == KDFFrame.this.popupItemInsertLoopArea) {
                KDFFrame.this.insertReportElement(null, 11, -1, -1);
                return;
            }
            if (source == KDFFrame.this.popupItemInsertGroup) {
                KDFFrame.this.insertReportElement(null, 12, -1, -1);
                return;
            }
            if (source == KDFFrame.this.popupItemInsertTable) {
                KDFFrame.this.insertReportElement(null, 10, -1, -1);
                return;
            }
            if (source == KDFFrame.this.popupItemInsertText) {
                KDFFrame.this.insertReportElement(null, 3, -1, -1);
                return;
            }
            if (source == KDFFrame.this.popupItemInsertFiled) {
                KDFFrame.this.insertReportElement(null, 4, -1, -1);
                return;
            }
            if (source == KDFFrame.this.popupItemInsertVariant) {
                KDFFrame.this.insertReportElement(null, 14, -1, -1);
                return;
            }
            if (source == KDFFrame.this.popupItemInsertFormula) {
                KDFFrame.this.insertReportElement(null, 13, -1, -1);
                return;
            }
            if (source == KDFFrame.this.popupItemInsertLine) {
                KDFFrame.this.insertReportElement(null, 5, -1, -1);
                return;
            }
            if (source == KDFFrame.this.popupItemInsertImage) {
                KDFFrame.this.insertReportElement(null, 2, -1, -1);
                return;
            }
            if (source == KDFFrame.this.popupItemInsertChart) {
                KDFFrame.this.insertReportElement(null, 9, -1, -1);
                return;
            }
        }
    }

    private class InternalFrameHandler
    extends InternalFrameAdapter {
        private InternalFrameHandler() {
        }

        @Override
        public void internalFrameClosing(InternalFrameEvent evt) {
            if (KDFFrame.this.getReport().isDirty()) {
                String title = KDFFrame.getMLS("dlgTitle", "\u8868\u5355\u8bbe\u8ba1\u5668");
                String prompt1 = KDFFrame.getMLS("closingDlgPrompt1", "\u662f\u5426\u4fdd\u5b58\u5bf9");
                String prompt2 = KDFFrame.getMLS("closingDlgPrompt2", "\u7684\u4fee\u6539\uff1f");
                switch (MsgBox.show((Component)((Object)KDFFrame.this.getMainFrame()), prompt1 + " " + KDFFrame.this.getReport().getName() + " " + prompt2, title, 136)) {
                    case 0: {
                        KDFFrame.this.save();
                        this.formInternalFrameClosing();
                        break;
                    }
                    case 1: {
                        this.formInternalFrameClosing();
                        break;
                    }
                }
            } else {
                this.formInternalFrameClosing();
            }
        }

        private void formInternalFrameClosing() {
            if (KDFFrame.this.getDesktopPane() instanceof MDIDesktopPane) {
                ((MDIDesktopPane)KDFFrame.this.getDesktopPane()).internalFrameClosed(KDFFrame.this);
            }
            KDFFrame.this.setDefaultCloseOperation(2);
        }

        @Override
        public void internalFrameClosed(InternalFrameEvent e) {
            KDFFrame.this.getMainFrame().updateMenuWindowEnabled();
        }
    }

    private class ArrowPressHandler
    extends AbstractAction {
        private int keyCode;

        public ArrowPressHandler(int keyCode) {
            this.keyCode = keyCode;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ArrayList listSelected = KDFFrame.this.getSelectedElements();
            if (listSelected.size() == 0) {
                return;
            }
            ReportElement reSelected = (ReportElement)listSelected.get(0);
            if (reSelected.getParent() instanceof Table) {
                return;
            }
            KDFFrame.this.transformation_type = 0;
            int x = 0;
            int y = 0;
            if (this.keyCode == 38) {
                x = 0;
                y = -1;
                if (e.getModifiers() == 1) {
                    KDFFrame.this.transformation_type = 4;
                }
            } else if (this.keyCode == 40) {
                x = 0;
                y = 1;
                if (e.getModifiers() == 1) {
                    KDFFrame.this.transformation_type = 4;
                }
            } else if (this.keyCode == 37) {
                x = -1;
                y = 0;
                if (e.getModifiers() == 1) {
                    KDFFrame.this.transformation_type = 2;
                }
            } else if (this.keyCode == 39) {
                x = 1;
                y = 0;
                if (e.getModifiers() == 1) {
                    KDFFrame.this.transformation_type = 2;
                }
            }
            KDFFrame.this.adjustElementEnd(new Point(x, y), false);
        }
    }

    private class CtrlF4CloseHandler
    extends AbstractAction {
        private CtrlF4CloseHandler() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int frames = KDFFrame.this.getDesktopPane().getAllFrames().length;
            KDFFrame.this.doDefaultCloseAction();
            if (KDFFrame.this.isClosed() && frames <= 1) {
                KDFFrame.this.getMenu().removeFrameButtons();
            }
        }
    }
}

