/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.kdf.fd2.gui.data;

import com.kingdee.bos.ctrl.common.layout.table.Cell;
import com.kingdee.bos.ctrl.common.layout.table.Table;
import com.kingdee.bos.ctrl.common.ui.MultiLangUI;
import com.kingdee.bos.ctrl.common.ui.TypicalDialog;
import com.kingdee.bos.ctrl.common.ui.WindowUtil;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.data.modal.query.QueryType;
import com.kingdee.bos.ctrl.data.wizard.WizardResource;
import com.kingdee.bos.ctrl.data.wizard.util.WizardUtil;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDMultiLangBox;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.ctrl.swing.util.CtrlSwingUtilities;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.util.EventListener;
import java.util.EventObject;
import java.util.HashMap;
import javax.swing.JComponent;
import javax.swing.event.EventListenerList;

public class NewSchemaDialog
extends TypicalDialog {
    private KDTextField txtName;
    private KDMultiLangBox mlbAlias;
    private KDMultiLangBox mlbDesc;
    private KDComboBox cmbType;
    private boolean isNew;
    private String oldID;
    private EventListenerList listenerList;

    public NewSchemaDialog() {
    }

    public NewSchemaDialog(Frame frame) {
        super(frame);
    }

    public NewSchemaDialog(Dialog dialog) {
        super(dialog);
    }

    protected void todoInit() {
        this.setSize(400, 180);
        this.txtName = new KDTextField();
        this.mlbAlias = MultiLangUI.newKDMultiLangBox();
        this.mlbDesc = MultiLangUI.newKDMultiLangBox();
        this.cmbType = new KDComboBox();
        this.installListener();
    }

    private void installListener() {
    }

    protected void todoAddControls(Container parent, Cell thisCell) {
        Table layout = thisCell.split(5, 1);
        for (int i = 0; i < 4; ++i) {
            layout.rowStyle(i).setHeight(19);
            layout.rowStyle(i).setMarginBottom(3);
        }
        layout.rowStyle(4).setPriY(1);
        parent.add((Component)CtrlSwingUtilities.createLabelContainer((JComponent)this.txtName, (String)WizardResource.getString((String)"res_6"), (int)80), layout.cell(0));
        parent.add((Component)CtrlSwingUtilities.createLabelContainer((JComponent)this.mlbAlias, (String)WizardResource.getString((String)"res_7"), (int)80), layout.cell(1));
        parent.add((Component)CtrlSwingUtilities.createLabelContainer((JComponent)this.mlbDesc, (String)WizardResource.getString((String)"res_8"), (int)80), layout.cell(2));
        parent.add((Component)CtrlSwingUtilities.createLabelContainer((JComponent)this.cmbType, (String)WizardResource.getString((String)"res_9"), (int)80), layout.cell(3));
    }

    protected void todoActionPerformed(ActionEvent e) {
    }

    protected void todoKeyAction(int keyCode) {
    }

    public void setNewMode(boolean isNew) {
        this.isNew = isNew;
        this.cmbType.setEnabled(isNew);
    }

    protected void onOk() {
        if (StringUtil.isEmptyString((String)this.getID())) {
            WindowUtil.msgboxError((Object)WizardResource.getString((String)"res_10"), (String)this.getTitle(), (Component)((Object)this));
            return;
        }
        if (!WizardUtil.isValidString((String)this.getID())) {
            WindowUtil.msgboxError((Object)(WizardResource.getString((String)"res_11") + "\r\n" + "\\/:*?\"<>|"), (String)this.getTitle(), (Component)((Object)this));
            return;
        }
        if (this.fireVerifEvent((Object)this, this.isNew, this.getID(), this.getNewAlias())) {
            super.onOk();
        }
    }

    public void addVerifyListener(VerifyListener l) {
        this.getListenerList().add(VerifyListener.class, l);
    }

    public void removeVerifyListener(VerifyListener l) {
        this.getListenerList().remove(VerifyListener.class, l);
    }

    protected boolean fireVerifEvent(Object source, boolean isNew, String id, HashMap alias) {
        Object[] listeners = this.getListenerList().getListenerList();
        VerifyEvent evt = null;
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != VerifyListener.class) continue;
            if (evt == null) {
                evt = new VerifyEvent(source, isNew, id, alias);
            }
            return ((VerifyListener)listeners[i + 1]).isOK(evt);
        }
        return true;
    }

    public String getID() {
        return this.txtName.getText();
    }

    public void setID(String name) {
        this.oldID = name;
        this.txtName.setText(name);
    }

    public String getOldID() {
        return this.oldID;
    }

    public void setOldAlias(HashMap alias) {
        MultiLangUI.toKDMultiLangBox((KDMultiLangBox)this.mlbAlias, (HashMap)alias);
    }

    public HashMap getNewAlias() {
        return MultiLangUI.fromKDMultiLangBox((KDMultiLangBox)this.mlbAlias);
    }

    public void setOldDesc(HashMap desc) {
        MultiLangUI.toKDMultiLangBox((KDMultiLangBox)this.mlbDesc, (HashMap)desc);
    }

    public HashMap getNewDesc() {
        return MultiLangUI.fromKDMultiLangBox((KDMultiLangBox)this.mlbDesc);
    }

    public void setModifyMode(boolean isModify) {
        this.cmbType.setEnabled(!isModify);
    }

    private EventListenerList getListenerList() {
        if (this.listenerList == null) {
            this.listenerList = new EventListenerList();
        }
        return this.listenerList;
    }

    public void setDSType(String type) {
        this.cmbType.removeAllItems();
        this.cmbType.setEnabled(false);
        this.cmbType.addItem((Object)QueryType.BOS_QUERY);
    }

    public QueryType getQueryType() {
        Object obj = this.cmbType.getSelectedItem();
        if (obj instanceof QueryType) {
            return (QueryType)obj;
        }
        return null;
    }

    public void setQueryType(QueryType type) {
        if (type == null) {
            this.cmbType.setSelectedIndex(0);
        } else {
            this.cmbType.setSelectedItem((Object)type);
        }
    }

    public static class VerifyEvent
    extends EventObject {
        private boolean isNew;
        private HashMap alias;
        private String id;

        public VerifyEvent(Object source, boolean isNew, String id, HashMap alias) {
            super(source);
            this.isNew = isNew;
            this.id = id;
        }

        public boolean getNewMode() {
            return this.isNew;
        }

        public String getId() {
            return this.id;
        }

        public HashMap getAlias() {
            return this.alias;
        }
    }

    public static interface VerifyListener
    extends EventListener {
        public boolean isOK(VerifyEvent var1);
    }
}

