/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.kdf.fd2.gui.util;

import com.kingdee.bos.ctrl.kdf.fd2.gui.event.ValueChangedEvent;
import com.kingdee.bos.ctrl.kdf.fd2.gui.event.ValueChangedListener;
import com.kingdee.bos.ctrl.kdf.fd2.gui.util.NumberEntry;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.text.NumberFormat;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.event.EventListenerList;

public class NumberComboBox
extends KDComboBox
implements KeyListener,
ActionListener,
FocusListener {
    private NumberFormat numberFormat = null;
    private Vector entries = new Vector();
    private double value;
    private double minValue;
    private double maxValue;
    private EventListenerList listenerList = null;
    private String postfix = "";

    public NumberComboBox() {
        this.setFocusCycleRoot(false);
        this.numberFormat = NumberFormat.getNumberInstance();
        this.numberFormat.setMinimumFractionDigits(0);
        this.numberFormat.setMaximumFractionDigits(2);
        this.setEditable(true);
        for (int i = 0; i < this.getComponentCount(); ++i) {
            this.getComponent(i).addFocusListener(this);
        }
        this.addFocusListener(this);
        this.addKeyListener(this);
        this.addActionListener(this);
    }

    public void addEntry(String name, double value) {
        Enumeration enum1 = this.entries.elements();
        while (enum1.hasMoreElements()) {
            NumberEntry ne = (NumberEntry)enum1.nextElement();
            if (!ne.name.equals(name)) continue;
            ne.value = value;
            return;
        }
        NumberEntry entry = new NumberEntry(name, value);
        this.addItem(entry);
        this.entries.addElement(entry);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        super.actionPerformed(e);
        int selectedIndex = this.getSelectedIndex();
        if (selectedIndex > -1) {
            if (((NumberEntry)this.getSelectedItem()).value != this.value) {
                double oldValue = this.value;
                this.value = ((NumberEntry)this.getSelectedItem()).value;
                this.fireValueChangedListenerValueChanged(new ValueChangedEvent((JComponent)((Object)this), oldValue, this.value));
            }
            this.setSelectedItem(this.numberFormat.format(this.value) + this.getPostfix());
        }
    }

    @Override
    public void keyPressed(KeyEvent e) {
        if (e.getKeyCode() == 10) {
            // empty if block
        }
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    @Override
    public void focusGained(FocusEvent e) {
    }

    @Override
    public void focusLost(FocusEvent e) {
        try {
            Number num = this.numberFormat.parse("" + this.getSelectedItem());
            if (num.doubleValue() != this.value) {
                double oldValue = this.value;
                this.value = num.doubleValue();
                this.fireValueChangedListenerValueChanged(new ValueChangedEvent((JComponent)((Object)this), oldValue, this.value));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.setSelectedItem(this.numberFormat.format(this.value) + this.getPostfix());
    }

    public double getMinValue() {
        return this.minValue;
    }

    public void setMinValue(double minValue) {
        this.minValue = minValue;
    }

    public double getMaxValue() {
        return this.maxValue;
    }

    public void setMaxValue(double maxValue) {
        this.maxValue = maxValue;
    }

    public double getValue() {
        return this.value;
    }

    public void setValue(double value) {
        if (this.value != value) {
            double oldValue = this.value;
            this.value = value;
            this.fireValueChangedListenerValueChanged(new ValueChangedEvent((JComponent)((Object)this), oldValue, this.value));
        }
        this.setSelectedItem(this.numberFormat.format(this.value) + this.getPostfix());
    }

    public synchronized void addValueChangedListener(ValueChangedListener listener) {
        if (this.listenerList == null) {
            this.listenerList = new EventListenerList();
        }
        this.listenerList.add(ValueChangedListener.class, listener);
    }

    public synchronized void removeValueChangedListener(ValueChangedListener listener) {
        this.listenerList.remove(ValueChangedListener.class, listener);
    }

    private synchronized void fireValueChangedListenerValueChanged(ValueChangedEvent event) {
        if (this.listenerList == null) {
            return;
        }
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != ValueChangedListener.class) continue;
            ((ValueChangedListener)listeners[i + 1]).valueChanged(event);
        }
    }

    public String getPostfix() {
        return this.postfix;
    }

    public void setPostfix(String postfix) {
        this.postfix = postfix;
    }
}

