/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.freechart.data.category;

import com.kingdee.bos.ctrl.freechart.data.category.CategoryDataset;
import com.kingdee.bos.ctrl.freechart.data.general.AbstractDataset;
import com.kingdee.bos.ctrl.freechart.data.general.DatasetChangeEvent;
import com.kingdee.bos.ctrl.freechart.data.general.DatasetChangeListener;
import com.kingdee.bos.ctrl.freechart.util.TableOrder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class IntervalSubCategoryDataset
extends AbstractDataset
implements CategoryDataset,
DatasetChangeListener {
    private static final long serialVersionUID = -7531718336328287533L;
    private CategoryDataset source;
    private int[] indexes;
    private boolean except;
    private HashMap originToIndex;
    private HashMap indexToOrigin;

    public IntervalSubCategoryDataset(CategoryDataset source, int[] indexes, boolean except) {
        this.source = source;
        if (this.source != null) {
            this.source.addChangeListener(this);
        }
        this.except = except;
        this.indexes = except ? this.except(indexes) : indexes;
        this.originToIndex = new HashMap(indexes.length);
        this.indexToOrigin = new HashMap(indexes.length);
        int count = indexes.length;
        for (int i = 0; i < count; ++i) {
            this.originToIndex.put(new Integer(this.indexes[i]), new Integer(i));
            this.indexToOrigin.put(new Integer(i), new Integer(this.indexes[i]));
        }
    }

    private int[] except(int[] a) {
        int i;
        int count = this.source.getRowCount();
        int[] ret = new int[count - a.length];
        ArrayList<Integer> list = new ArrayList<Integer>();
        ArrayList<Integer> alist = new ArrayList<Integer>();
        for (i = 0; i < a.length; ++i) {
            alist.add(new Integer(a[i]));
        }
        for (i = 0; i < count; ++i) {
            Integer I = new Integer(i);
            if (alist.contains(I)) continue;
            list.add(I);
        }
        for (i = 0; i < list.size(); ++i) {
            ret[i] = (Integer)list.get(i);
        }
        return ret;
    }

    public CategoryDataset getUnderlyingDataset() {
        return this.source;
    }

    public TableOrder getExtractType() {
        return TableOrder.BY_ROW;
    }

    @Override
    public void datasetChanged(DatasetChangeEvent event) {
        this.fireDatasetChanged();
    }

    @Override
    public int getColumnIndex(Comparable key) {
        int index = this.source.getColumnIndex(key);
        return index;
    }

    @Override
    public Comparable getColumnKey(int column) {
        return this.source.getColumnKey(column);
    }

    @Override
    public List getColumnKeys() {
        return this.source.getColumnKeys();
    }

    @Override
    public int getRowIndex(Comparable key) {
        int index = this.source.getRowIndex(key);
        index = (Integer)this.originToIndex.get(new Integer(index));
        return this.source.getRowIndex(key);
    }

    @Override
    public Comparable getRowKey(int row) {
        row = (Integer)this.indexToOrigin.get(new Integer(row));
        return this.source.getRowKey(row);
    }

    @Override
    public List getRowKeys() {
        ArrayList<Comparable> list = new ArrayList<Comparable>();
        for (int i = 0; i < this.indexes.length; ++i) {
            list.add(this.getRowKey(i));
        }
        return list;
    }

    @Override
    public Number getValue(Comparable rowKey, Comparable columnKey) {
        return this.source.getValue(rowKey, columnKey);
    }

    @Override
    public int getColumnCount() {
        return this.source.getColumnCount();
    }

    @Override
    public int getRowCount() {
        return this.indexes.length;
    }

    @Override
    public Number getValue(int row, int column) {
        row = (Integer)this.indexToOrigin.get(new Integer(row));
        return this.source.getValue(row, column);
    }
}

