/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.jcr;

import com.kingdee.bos.ctrl.jcr.Explorer;
import com.kingdee.bos.ctrl.jcr.NamespaceUtil;
import com.kingdee.bos.ctrl.jcr.PathUtil;
import com.kingdee.bos.ctrl.jcr.SMFolder;
import com.kingdee.bos.ctrl.jcr.exception.SMException;
import com.kingdee.bos.ctrl.jcr.exception.SMExistException;
import com.kingdee.bos.ctrl.jcr.exception.SMNameValidException;
import com.kingdee.bos.ctrl.jcr.exception.SMRuntimeException;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.jcr.ItemNotFoundException;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.Property;
import javax.jcr.PropertyIterator;
import javax.jcr.RepositoryException;

public abstract class SMResource {
    public static final int ResType_Folder = 1;
    public static final int ResType_File = 16;
    public static final String Attr_Content = "content";
    public static final String Attr_Created = "created";
    public static final String Attr_LastModified = "lastModified";
    protected Explorer _explorer;
    private Node _node;

    protected SMResource(Explorer explorer, Node node) {
        this._explorer = explorer;
        this._node = node;
    }

    protected Node getNode() {
        if (this._node == null) {
            throw new SMRuntimeException("This resource has been deleted.");
        }
        return this._node;
    }

    public Explorer getExplorer() {
        return this._explorer;
    }

    public String getName() throws SMException {
        try {
            return NamespaceUtil.cut(this.getNode().getName());
        }
        catch (RepositoryException e) {
            throw SMException.makeException(e);
        }
    }

    public String getPath() throws SMException {
        try {
            return PathUtil.cutNamespace(this.getNode().getPath());
        }
        catch (RepositoryException e) {
            throw SMException.makeException(e);
        }
    }

    public boolean isFile() {
        throw new SMRuntimeException("\u5b50\u7c7b\u5b9e\u73b0");
    }

    public boolean isRoot() throws SMException {
        try {
            return this._node.getDepth() == 0;
        }
        catch (RepositoryException e) {
            throw SMException.makeException(e);
        }
    }

    public Map getProperties() throws SMException {
        HashMap<String, String> map = new HashMap<String, String>();
        try {
            PropertyIterator proIt = this.getNode().getProperties("ctrl:*");
            while (proIt.hasNext()) {
                Property property = proIt.nextProperty();
                String key = NamespaceUtil.cut(property.getName());
                if (this.isBuiltInKey(key)) continue;
                map.put(key, property.getString());
            }
        }
        catch (RepositoryException e) {
            throw SMException.makeException(e);
        }
        return map;
    }

    public String getProperty(String key) throws SMException {
        String tiedKey = NamespaceUtil.tie(key);
        try {
            Property property = this.getNode().getProperty(tiedKey);
            if (property == null) {
                return null;
            }
            return property.getString();
        }
        catch (PathNotFoundException e) {
            throw new SMExistException("Property '" + key + "' not exist.");
        }
        catch (RepositoryException e) {
            throw SMException.makeException(e);
        }
    }

    public void setProperty(String key, String value) throws SMException {
        if (this.isBuiltInKey(key)) {
            throw new SMException(key + " is a built-in property key.");
        }
        String tiedKey = NamespaceUtil.tie(key);
        try {
            if (this.getNode().hasProperty(tiedKey)) {
                this.getNode().getProperty(tiedKey).setValue(value);
            } else {
                this.getNode().setProperty(tiedKey, value);
            }
            this.updateLastModified();
        }
        catch (RepositoryException e) {
            SMException.makeException(e);
        }
    }

    protected boolean isBuiltInKey(String key) {
        return Attr_Created.equalsIgnoreCase(key) || Attr_LastModified.equalsIgnoreCase(key) || Attr_Content.equalsIgnoreCase(key);
    }

    public Calendar getCreated() throws SMException {
        try {
            return this.getNode().getProperty(NamespaceUtil.Created).getDate();
        }
        catch (RepositoryException e) {
            throw SMException.makeException(e);
        }
    }

    public Calendar getLastModified() throws SMException {
        try {
            return this.getNode().getProperty(NamespaceUtil.LastModified).getDate();
        }
        catch (RepositoryException e) {
            throw SMException.makeException(e);
        }
    }

    protected void updateLastModified() throws SMException {
        Calendar currentTime = Calendar.getInstance();
        currentTime.setTime(new Date(System.currentTimeMillis()));
        try {
            this.getNode().setProperty(NamespaceUtil.LastModified, currentTime);
        }
        catch (RepositoryException e) {
            throw SMException.makeException(e);
        }
        this._explorer.innerSave();
    }

    public SMFolder getParent() throws SMException {
        Node pn;
        try {
            pn = this.getNode().getParent();
        }
        catch (ItemNotFoundException e) {
            return null;
        }
        catch (RepositoryException e) {
            throw SMException.makeException(e);
        }
        return (SMFolder)this._explorer.wrapResource(pn, false);
    }

    public void delete() throws SMException {
        if (this.isRoot()) {
            throw new SMRuntimeException("Cannot delete root.");
        }
        SMResource.innerDelete(this.getNode());
        this._explorer.innerSave();
        this._node = null;
    }

    static void innerDelete(Node node) throws SMException {
        try {
            node.remove();
        }
        catch (RepositoryException e) {
            throw SMException.makeException(e);
        }
    }

    public void rename(String newName) throws SMException {
        try {
            if (!PathUtil.isNameValid(newName)) {
                throw new SMNameValidException(newName);
            }
            String tiedName = NamespaceUtil.tie(newName);
            String tiedPath = this.getNode().getPath();
            String absNewTiedPath = PathUtil.makeSiblingPath(tiedPath, tiedName);
            String relNewTiedPath = absNewTiedPath.substring(1);
            if (this.getExplorer().getRoot().hasNode(relNewTiedPath)) {
                throw new SMExistException(newName + " exist.");
            }
            this.getExplorer().getSession().getWorkspace().move(tiedPath, absNewTiedPath);
            this._node = this.getExplorer().getRoot().getNode(relNewTiedPath);
            this.updateLastModified();
        }
        catch (RepositoryException e) {
            throw SMException.makeException(e);
        }
    }

    public SMResource copyTo(SMFolder dest) throws SMException {
        try {
            String srcAbsTiedPath = this.getNode().getPath();
            String destAbsTiedPath = PathUtil.makeChildPath(dest.getNode().getPath(), this.getNode().getName());
            if (this.getExplorer().getRoot().hasNode(destAbsTiedPath.substring(1))) {
                throw new SMExistException(PathUtil.cutNamespace(destAbsTiedPath) + " exist.");
            }
            this.getExplorer().getSession().getWorkspace().copy(srcAbsTiedPath, destAbsTiedPath);
            Node node = this.getExplorer().getRoot().getNode(destAbsTiedPath.substring(1));
            return this._explorer.wrapResource(node);
        }
        catch (RepositoryException e) {
            throw SMException.makeException(e);
        }
    }

    public void moveTo(SMFolder dest) throws SMException {
        try {
            String srcAbsTiedPath = this.getNode().getPath();
            String destAbsTiedPath = PathUtil.makeChildPath(dest.getNode().getPath(), this.getNode().getName());
            if (this.getExplorer().getRoot().hasNode(destAbsTiedPath.substring(1))) {
                throw new SMExistException(PathUtil.cutNamespace(destAbsTiedPath) + " exist.");
            }
            this.getExplorer().getSession().getWorkspace().move(srcAbsTiedPath, destAbsTiedPath);
            this._node = this.getExplorer().getRoot().getNode(destAbsTiedPath.substring(1));
            this.updateLastModified();
        }
        catch (RepositoryException e) {
            throw SMException.makeException(e);
        }
    }

    public String toString() {
        try {
            return this.getPath();
        }
        catch (SMException e) {
            return super.toString();
        }
    }
}

