/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.lucene.analysis;

import com.kingdee.bos.ctrl.lucene.analysis.Token;
import com.kingdee.bos.ctrl.lucene.analysis.TokenFilter;
import com.kingdee.bos.ctrl.lucene.analysis.TokenStream;
import java.io.IOException;

public final class LengthFilter
extends TokenFilter {
    final int min;
    final int max;

    public LengthFilter(TokenStream in, int min, int max) {
        super(in);
        this.min = min;
        this.max = max;
    }

    @Override
    public final Token next() throws IOException {
        Token token = this.input.next();
        while (token != null) {
            int len = token.termText().length();
            if (len >= this.min && len <= this.max) {
                return token;
            }
            token = this.input.next();
        }
        return null;
    }
}

