/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.lucene.analysis;

import com.kingdee.bos.ctrl.lucene.analysis.Analyzer;
import com.kingdee.bos.ctrl.lucene.analysis.TokenStream;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;

public class PerFieldAnalyzerWrapper
extends Analyzer {
    private Analyzer defaultAnalyzer;
    private Map analyzerMap = new HashMap();

    public PerFieldAnalyzerWrapper(Analyzer defaultAnalyzer) {
        this.defaultAnalyzer = defaultAnalyzer;
    }

    public void addAnalyzer(String fieldName, Analyzer analyzer) {
        this.analyzerMap.put(fieldName, analyzer);
    }

    @Override
    public TokenStream tokenStream(String fieldName, Reader reader) {
        Analyzer analyzer = (Analyzer)this.analyzerMap.get(fieldName);
        if (analyzer == null) {
            analyzer = this.defaultAnalyzer;
        }
        return analyzer.tokenStream(fieldName, reader);
    }

    @Override
    public int getPositionIncrementGap(String fieldName) {
        Analyzer analyzer = (Analyzer)this.analyzerMap.get(fieldName);
        if (analyzer == null) {
            analyzer = this.defaultAnalyzer;
        }
        return analyzer.getPositionIncrementGap(fieldName);
    }

    public String toString() {
        return "PerFieldAnalyzerWrapper(" + this.analyzerMap + ", default=" + this.defaultAnalyzer + ")";
    }
}

