/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.lucene.analysis;

import com.kingdee.bos.ctrl.lucene.analysis.Analyzer;
import com.kingdee.bos.ctrl.lucene.analysis.LowerCaseTokenizer;
import com.kingdee.bos.ctrl.lucene.analysis.StopFilter;
import com.kingdee.bos.ctrl.lucene.analysis.TokenStream;
import com.kingdee.bos.ctrl.lucene.analysis.WordlistLoader;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.util.Set;

public final class StopAnalyzer
extends Analyzer {
    private Set stopWords;
    public static final String[] ENGLISH_STOP_WORDS = new String[]{"a", "an", "and", "are", "as", "at", "be", "but", "by", "for", "if", "in", "into", "is", "it", "no", "not", "of", "on", "or", "such", "that", "the", "their", "then", "there", "these", "they", "this", "to", "was", "will", "with"};

    public StopAnalyzer() {
        this.stopWords = StopFilter.makeStopSet(ENGLISH_STOP_WORDS);
    }

    public StopAnalyzer(Set stopWords) {
        this.stopWords = stopWords;
    }

    public StopAnalyzer(String[] stopWords) {
        this.stopWords = StopFilter.makeStopSet(stopWords);
    }

    public StopAnalyzer(File stopwordsFile) throws IOException {
        this.stopWords = WordlistLoader.getWordSet(stopwordsFile);
    }

    public StopAnalyzer(Reader stopwords) throws IOException {
        this.stopWords = WordlistLoader.getWordSet(stopwords);
    }

    @Override
    public TokenStream tokenStream(String fieldName, Reader reader) {
        return new StopFilter((TokenStream)new LowerCaseTokenizer(reader), this.stopWords);
    }
}

