/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.lucene.search;

import com.kingdee.bos.ctrl.lucene.index.IndexReader;
import com.kingdee.bos.ctrl.lucene.search.Explanation;
import com.kingdee.bos.ctrl.lucene.search.Filter;
import com.kingdee.bos.ctrl.lucene.search.Query;
import com.kingdee.bos.ctrl.lucene.search.Scorer;
import com.kingdee.bos.ctrl.lucene.search.Searcher;
import com.kingdee.bos.ctrl.lucene.search.Similarity;
import com.kingdee.bos.ctrl.lucene.search.Weight;
import com.kingdee.bos.ctrl.lucene.util.ToStringUtils;
import java.io.IOException;
import java.util.BitSet;
import java.util.Set;

public class FilteredQuery
extends Query {
    Query query;
    Filter filter;

    public FilteredQuery(Query query, Filter filter) {
        this.query = query;
        this.filter = filter;
    }

    @Override
    protected Weight createWeight(Searcher searcher) throws IOException {
        final Weight weight = this.query.createWeight(searcher);
        final Similarity similarity = this.query.getSimilarity(searcher);
        return new Weight(){
            private float value;

            @Override
            public float getValue() {
                return this.value;
            }

            @Override
            public float sumOfSquaredWeights() throws IOException {
                return weight.sumOfSquaredWeights() * FilteredQuery.this.getBoost() * FilteredQuery.this.getBoost();
            }

            @Override
            public void normalize(float v) {
                weight.normalize(v);
                this.value = weight.getValue() * FilteredQuery.this.getBoost();
            }

            @Override
            public Explanation explain(IndexReader ir, int i) throws IOException {
                Filter f;
                BitSet matches;
                Explanation inner = weight.explain(ir, i);
                if (FilteredQuery.this.getBoost() != 1.0f) {
                    Explanation preBoost = inner;
                    inner = new Explanation(inner.getValue() * FilteredQuery.this.getBoost(), "product of:");
                    inner.addDetail(new Explanation(FilteredQuery.this.getBoost(), "boost"));
                    inner.addDetail(preBoost);
                }
                if ((matches = (f = FilteredQuery.this.filter).bits(ir)).get(i)) {
                    return inner;
                }
                Explanation result = new Explanation(0.0f, "failure to match filter: " + f.toString());
                result.addDetail(inner);
                return result;
            }

            @Override
            public Query getQuery() {
                return FilteredQuery.this;
            }

            @Override
            public Scorer scorer(IndexReader indexReader) throws IOException {
                final Scorer scorer = weight.scorer(indexReader);
                final BitSet bitset = FilteredQuery.this.filter.bits(indexReader);
                return new Scorer(similarity){

                    @Override
                    public boolean next() throws IOException {
                        do {
                            if (scorer.next()) continue;
                            return false;
                        } while (!bitset.get(scorer.doc()));
                        return true;
                    }

                    @Override
                    public int doc() {
                        return scorer.doc();
                    }

                    @Override
                    public boolean skipTo(int i) throws IOException {
                        if (!scorer.skipTo(i)) {
                            return false;
                        }
                        while (!bitset.get(scorer.doc())) {
                            int nextFiltered = bitset.nextSetBit(scorer.doc() + 1);
                            if (nextFiltered == -1) {
                                return false;
                            }
                            if (scorer.skipTo(nextFiltered)) continue;
                            return false;
                        }
                        return true;
                    }

                    @Override
                    public float score() throws IOException {
                        return FilteredQuery.this.getBoost() * scorer.score();
                    }

                    @Override
                    public Explanation explain(int i) throws IOException {
                        Explanation exp = scorer.explain(i);
                        exp.setValue(FilteredQuery.this.getBoost() * exp.getValue());
                        if (bitset.get(i)) {
                            exp.setDescription("allowed by filter: " + exp.getDescription());
                        } else {
                            exp.setDescription("removed by filter: " + exp.getDescription());
                        }
                        return exp;
                    }
                };
            }
        };
    }

    @Override
    public Query rewrite(IndexReader reader) throws IOException {
        Query rewritten = this.query.rewrite(reader);
        if (rewritten != this.query) {
            FilteredQuery clone = (FilteredQuery)this.clone();
            clone.query = rewritten;
            return clone;
        }
        return this;
    }

    public Query getQuery() {
        return this.query;
    }

    public Filter getFilter() {
        return this.filter;
    }

    @Override
    public void extractTerms(Set terms) {
        this.getQuery().extractTerms(terms);
    }

    @Override
    public String toString(String s) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("filtered(");
        buffer.append(this.query.toString(s));
        buffer.append(")->");
        buffer.append(this.filter);
        buffer.append(ToStringUtils.boost(this.getBoost()));
        return buffer.toString();
    }

    public boolean equals(Object o) {
        if (o instanceof FilteredQuery) {
            FilteredQuery fq = (FilteredQuery)o;
            return this.query.equals(fq.query) && this.filter.equals(fq.filter) && this.getBoost() == fq.getBoost();
        }
        return false;
    }

    public int hashCode() {
        return this.query.hashCode() ^ this.filter.hashCode() + Float.floatToRawIntBits(this.getBoost());
    }
}

