/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.lucene.search;

import com.kingdee.bos.ctrl.lucene.document.Document;
import com.kingdee.bos.ctrl.lucene.index.CorruptIndexException;
import com.kingdee.bos.ctrl.lucene.search.Hits;
import java.io.IOException;
import java.io.Serializable;

public class Hit
implements Serializable {
    private Document doc = null;
    private boolean resolved = false;
    private Hits hits = null;
    private int hitNumber;

    Hit(Hits hits, int hitNumber) {
        this.hits = hits;
        this.hitNumber = hitNumber;
    }

    public Document getDocument() throws CorruptIndexException, IOException {
        if (!this.resolved) {
            this.fetchTheHit();
        }
        return this.doc;
    }

    public float getScore() throws IOException {
        return this.hits.score(this.hitNumber);
    }

    public int getId() throws IOException {
        return this.hits.id(this.hitNumber);
    }

    private void fetchTheHit() throws CorruptIndexException, IOException {
        this.doc = this.hits.doc(this.hitNumber);
        this.resolved = true;
    }

    public float getBoost() throws CorruptIndexException, IOException {
        return this.getDocument().getBoost();
    }

    public String get(String name) throws CorruptIndexException, IOException {
        return this.getDocument().get(name);
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("Hit<");
        buffer.append(this.hits.toString());
        buffer.append(" [");
        buffer.append(this.hitNumber);
        buffer.append("] ");
        if (this.resolved) {
            buffer.append("resolved");
        } else {
            buffer.append("unresolved");
        }
        buffer.append(">");
        return buffer.toString();
    }
}

