/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.lucene.search;

import com.kingdee.bos.ctrl.lucene.document.Document;
import com.kingdee.bos.ctrl.lucene.document.FieldSelector;
import com.kingdee.bos.ctrl.lucene.index.CorruptIndexException;
import com.kingdee.bos.ctrl.lucene.index.IndexReader;
import com.kingdee.bos.ctrl.lucene.index.Term;
import com.kingdee.bos.ctrl.lucene.search.Explanation;
import com.kingdee.bos.ctrl.lucene.search.Filter;
import com.kingdee.bos.ctrl.lucene.search.HitCollector;
import com.kingdee.bos.ctrl.lucene.search.Query;
import com.kingdee.bos.ctrl.lucene.search.Scorer;
import com.kingdee.bos.ctrl.lucene.search.Searcher;
import com.kingdee.bos.ctrl.lucene.search.Sort;
import com.kingdee.bos.ctrl.lucene.search.TopDocCollector;
import com.kingdee.bos.ctrl.lucene.search.TopDocs;
import com.kingdee.bos.ctrl.lucene.search.TopFieldDocCollector;
import com.kingdee.bos.ctrl.lucene.search.TopFieldDocs;
import com.kingdee.bos.ctrl.lucene.search.Weight;
import com.kingdee.bos.ctrl.lucene.store.Directory;
import java.io.IOException;
import java.util.BitSet;

public class IndexSearcher
extends Searcher {
    IndexReader reader;
    private boolean closeReader;

    public IndexSearcher(String path) throws CorruptIndexException, IOException {
        this(IndexReader.open(path), true);
    }

    public IndexSearcher(Directory directory) throws CorruptIndexException, IOException {
        this(IndexReader.open(directory), true);
    }

    public IndexSearcher(IndexReader r) {
        this(r, false);
    }

    private IndexSearcher(IndexReader r, boolean closeReader) {
        this.reader = r;
        this.closeReader = closeReader;
    }

    public IndexReader getIndexReader() {
        return this.reader;
    }

    @Override
    public void close() throws IOException {
        if (this.closeReader) {
            this.reader.close();
        }
    }

    @Override
    public int docFreq(Term term) throws IOException {
        return this.reader.docFreq(term);
    }

    @Override
    public Document doc(int i) throws CorruptIndexException, IOException {
        return this.reader.document(i);
    }

    @Override
    public Document doc(int i, FieldSelector fieldSelector) throws CorruptIndexException, IOException {
        return this.reader.document(i, fieldSelector);
    }

    @Override
    public int maxDoc() throws IOException {
        return this.reader.maxDoc();
    }

    @Override
    public TopDocs search(Weight weight, Filter filter, int nDocs) throws IOException {
        if (nDocs <= 0) {
            throw new IllegalArgumentException("nDocs must be > 0");
        }
        TopDocCollector collector = new TopDocCollector(nDocs);
        this.search(weight, filter, (HitCollector)collector);
        return collector.topDocs();
    }

    @Override
    public TopFieldDocs search(Weight weight, Filter filter, int nDocs, Sort sort) throws IOException {
        TopFieldDocCollector collector = new TopFieldDocCollector(this.reader, sort, nDocs);
        this.search(weight, filter, (HitCollector)collector);
        return (TopFieldDocs)collector.topDocs();
    }

    @Override
    public void search(Weight weight, Filter filter, final HitCollector results) throws IOException {
        Scorer scorer;
        HitCollector collector = results;
        if (filter != null) {
            final BitSet bits = filter.bits(this.reader);
            collector = new HitCollector(){

                @Override
                public final void collect(int doc, float score) {
                    if (bits.get(doc)) {
                        results.collect(doc, score);
                    }
                }
            };
        }
        if ((scorer = weight.scorer(this.reader)) == null) {
            return;
        }
        scorer.score(collector);
    }

    @Override
    public Query rewrite(Query original) throws IOException {
        Query query = original;
        Query rewrittenQuery = query.rewrite(this.reader);
        while (rewrittenQuery != query) {
            query = rewrittenQuery;
            rewrittenQuery = query.rewrite(this.reader);
        }
        return query;
    }

    @Override
    public Explanation explain(Weight weight, int doc) throws IOException {
        return weight.explain(this.reader, doc);
    }
}

