/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.lucene.search;

import com.kingdee.bos.ctrl.lucene.analysis.Analyzer;
import com.kingdee.bos.ctrl.lucene.analysis.Token;
import com.kingdee.bos.ctrl.lucene.analysis.TokenStream;
import com.kingdee.bos.ctrl.lucene.index.TermFreqVector;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;

public class QueryTermVector
implements TermFreqVector {
    private String[] terms = new String[0];
    private int[] termFreqs = new int[0];

    @Override
    public String getField() {
        return null;
    }

    public QueryTermVector(String[] queryTerms) {
        this.processTerms(queryTerms);
    }

    public QueryTermVector(String queryString, Analyzer analyzer) {
        TokenStream stream;
        if (analyzer != null && (stream = analyzer.tokenStream("", new StringReader(queryString))) != null) {
            Token next = null;
            ArrayList<String> terms = new ArrayList<String>();
            try {
                while ((next = stream.next()) != null) {
                    terms.add(next.termText());
                }
                this.processTerms(terms.toArray(new String[terms.size()]));
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private void processTerms(String[] queryTerms) {
        if (queryTerms != null) {
            int i;
            Arrays.sort(queryTerms);
            HashMap<String, Integer> tmpSet = new HashMap<String, Integer>(queryTerms.length);
            ArrayList<String> tmpList = new ArrayList<String>(queryTerms.length);
            ArrayList<Integer> tmpFreqs = new ArrayList<Integer>(queryTerms.length);
            int j = 0;
            for (i = 0; i < queryTerms.length; ++i) {
                String term = queryTerms[i];
                Integer position = (Integer)tmpSet.get(term);
                if (position == null) {
                    tmpSet.put(term, new Integer(j++));
                    tmpList.add(term);
                    tmpFreqs.add(new Integer(1));
                    continue;
                }
                Integer integer = (Integer)tmpFreqs.get(position);
                tmpFreqs.set(position, new Integer(integer + 1));
            }
            this.terms = tmpList.toArray(this.terms);
            this.termFreqs = new int[tmpFreqs.size()];
            i = 0;
            for (Integer integer : tmpFreqs) {
                this.termFreqs[i++] = integer;
            }
        }
    }

    public final String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append('{');
        for (int i = 0; i < this.terms.length; ++i) {
            if (i > 0) {
                sb.append(", ");
            }
            sb.append(this.terms[i]).append('/').append(this.termFreqs[i]);
        }
        sb.append('}');
        return sb.toString();
    }

    @Override
    public int size() {
        return this.terms.length;
    }

    @Override
    public String[] getTerms() {
        return this.terms;
    }

    @Override
    public int[] getTermFrequencies() {
        return this.termFreqs;
    }

    @Override
    public int indexOf(String term) {
        int res = Arrays.binarySearch(this.terms, term);
        return res >= 0 ? res : -1;
    }

    @Override
    public int[] indexesOf(String[] terms, int start, int len) {
        int[] res = new int[len];
        for (int i = 0; i < len; ++i) {
            res[i] = this.indexOf(terms[i]);
        }
        return res;
    }
}

