/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.lucene.search.function;

import com.kingdee.bos.ctrl.lucene.index.IndexReader;
import com.kingdee.bos.ctrl.lucene.search.ComplexExplanation;
import com.kingdee.bos.ctrl.lucene.search.Explanation;
import com.kingdee.bos.ctrl.lucene.search.Query;
import com.kingdee.bos.ctrl.lucene.search.Scorer;
import com.kingdee.bos.ctrl.lucene.search.Searcher;
import com.kingdee.bos.ctrl.lucene.search.Similarity;
import com.kingdee.bos.ctrl.lucene.search.Weight;
import com.kingdee.bos.ctrl.lucene.search.function.DocValues;
import com.kingdee.bos.ctrl.lucene.search.function.ValueSource;
import com.kingdee.bos.ctrl.lucene.util.ToStringUtils;
import java.io.IOException;
import java.util.Set;

public class ValueSourceQuery
extends Query {
    ValueSource valSrc;

    public ValueSourceQuery(ValueSource valSrc) {
        this.valSrc = valSrc;
    }

    @Override
    public Query rewrite(IndexReader reader) throws IOException {
        return this;
    }

    @Override
    public void extractTerms(Set terms) {
    }

    @Override
    protected Weight createWeight(Searcher searcher) {
        return new ValueSourceWeight(searcher);
    }

    @Override
    public String toString(String field) {
        return this.valSrc.toString() + ToStringUtils.boost(this.getBoost());
    }

    public boolean equals(Object o) {
        if (this.getClass() != o.getClass()) {
            return false;
        }
        ValueSourceQuery other = (ValueSourceQuery)o;
        return this.getBoost() == other.getBoost() && this.valSrc.equals(other.valSrc);
    }

    public int hashCode() {
        return this.getClass().hashCode() + this.valSrc.hashCode() ^ Float.floatToIntBits(this.getBoost());
    }

    private class ValueSourceScorer
    extends Scorer {
        private final IndexReader reader;
        private final ValueSourceWeight weight;
        private final int maxDoc;
        private final float qWeight;
        private int doc;
        private final DocValues vals;

        private ValueSourceScorer(Similarity similarity, IndexReader reader, ValueSourceWeight w) throws IOException {
            super(similarity);
            this.doc = -1;
            this.weight = w;
            this.qWeight = w.getValue();
            this.reader = reader;
            this.maxDoc = reader.maxDoc();
            this.vals = ValueSourceQuery.this.valSrc.getValues(reader);
        }

        @Override
        public boolean next() throws IOException {
            do {
                ++this.doc;
                if (this.doc < this.maxDoc) continue;
                return false;
            } while (this.reader.isDeleted(this.doc));
            return true;
        }

        @Override
        public int doc() {
            return this.doc;
        }

        @Override
        public float score() throws IOException {
            return this.qWeight * this.vals.floatVal(this.doc);
        }

        @Override
        public boolean skipTo(int target) throws IOException {
            this.doc = target - 1;
            return this.next();
        }

        @Override
        public Explanation explain(int doc) throws IOException {
            float sc = this.qWeight * this.vals.floatVal(doc);
            ComplexExplanation result = new ComplexExplanation(true, sc, ValueSourceQuery.this.toString() + ", product of:");
            result.addDetail(this.vals.explain(doc));
            result.addDetail(new Explanation(ValueSourceQuery.this.getBoost(), "boost"));
            result.addDetail(new Explanation(this.weight.queryNorm, "queryNorm"));
            return result;
        }
    }

    private class ValueSourceWeight
    implements Weight {
        Searcher searcher;
        float queryNorm;
        float queryWeight;

        public ValueSourceWeight(Searcher searcher) {
            this.searcher = searcher;
        }

        @Override
        public Query getQuery() {
            return ValueSourceQuery.this;
        }

        @Override
        public float getValue() {
            return this.queryWeight;
        }

        @Override
        public float sumOfSquaredWeights() throws IOException {
            this.queryWeight = ValueSourceQuery.this.getBoost();
            return this.queryWeight * this.queryWeight;
        }

        @Override
        public void normalize(float norm) {
            this.queryNorm = norm;
            this.queryWeight *= this.queryNorm;
        }

        @Override
        public Scorer scorer(IndexReader reader) throws IOException {
            return new ValueSourceScorer(ValueSourceQuery.this.getSimilarity(this.searcher), reader, this);
        }

        @Override
        public Explanation explain(IndexReader reader, int doc) throws IOException {
            return this.scorer(reader).explain(doc);
        }
    }
}

