/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.lucene.search.spans;

import com.kingdee.bos.ctrl.lucene.index.IndexReader;
import com.kingdee.bos.ctrl.lucene.search.Query;
import com.kingdee.bos.ctrl.lucene.search.spans.NearSpansOrdered;
import com.kingdee.bos.ctrl.lucene.search.spans.NearSpansUnordered;
import com.kingdee.bos.ctrl.lucene.search.spans.SpanOrQuery;
import com.kingdee.bos.ctrl.lucene.search.spans.SpanQuery;
import com.kingdee.bos.ctrl.lucene.search.spans.Spans;
import com.kingdee.bos.ctrl.lucene.util.ToStringUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class SpanNearQuery
extends SpanQuery {
    private List clauses;
    private int slop;
    private boolean inOrder;
    private String field;

    public SpanNearQuery(SpanQuery[] clauses, int slop, boolean inOrder) {
        this.clauses = new ArrayList(clauses.length);
        for (int i = 0; i < clauses.length; ++i) {
            SpanQuery clause = clauses[i];
            if (i == 0) {
                this.field = clause.getField();
            } else if (!clause.getField().equals(this.field)) {
                throw new IllegalArgumentException("Clauses must have same field.");
            }
            this.clauses.add(clause);
        }
        this.slop = slop;
        this.inOrder = inOrder;
    }

    public SpanQuery[] getClauses() {
        return this.clauses.toArray(new SpanQuery[this.clauses.size()]);
    }

    public int getSlop() {
        return this.slop;
    }

    public boolean isInOrder() {
        return this.inOrder;
    }

    @Override
    public String getField() {
        return this.field;
    }

    @Override
    public Collection getTerms() {
        ArrayList terms = new ArrayList();
        for (SpanQuery clause : this.clauses) {
            terms.addAll(clause.getTerms());
        }
        return terms;
    }

    @Override
    public void extractTerms(Set terms) {
        for (SpanQuery clause : this.clauses) {
            clause.extractTerms(terms);
        }
    }

    @Override
    public String toString(String field) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("spanNear([");
        Iterator i = this.clauses.iterator();
        while (i.hasNext()) {
            SpanQuery clause = (SpanQuery)i.next();
            buffer.append(clause.toString(field));
            if (!i.hasNext()) continue;
            buffer.append(", ");
        }
        buffer.append("], ");
        buffer.append(this.slop);
        buffer.append(", ");
        buffer.append(this.inOrder);
        buffer.append(")");
        buffer.append(ToStringUtils.boost(this.getBoost()));
        return buffer.toString();
    }

    @Override
    public Spans getSpans(IndexReader reader) throws IOException {
        if (this.clauses.size() == 0) {
            return new SpanOrQuery(this.getClauses()).getSpans(reader);
        }
        if (this.clauses.size() == 1) {
            return ((SpanQuery)this.clauses.get(0)).getSpans(reader);
        }
        return this.inOrder ? new NearSpansOrdered(this, reader) : new NearSpansUnordered(this, reader);
    }

    @Override
    public Query rewrite(IndexReader reader) throws IOException {
        SpanNearQuery clone = null;
        for (int i = 0; i < this.clauses.size(); ++i) {
            SpanQuery c = (SpanQuery)this.clauses.get(i);
            SpanQuery query = (SpanQuery)c.rewrite(reader);
            if (query == c) continue;
            if (clone == null) {
                clone = (SpanNearQuery)this.clone();
            }
            clone.clauses.set(i, query);
        }
        if (clone != null) {
            return clone;
        }
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SpanNearQuery)) {
            return false;
        }
        SpanNearQuery spanNearQuery = (SpanNearQuery)o;
        if (this.inOrder != spanNearQuery.inOrder) {
            return false;
        }
        if (this.slop != spanNearQuery.slop) {
            return false;
        }
        if (!this.clauses.equals(spanNearQuery.clauses)) {
            return false;
        }
        return this.getBoost() == spanNearQuery.getBoost();
    }

    public int hashCode() {
        int result = this.clauses.hashCode();
        result ^= result << 14 | result >>> 19;
        result += Float.floatToRawIntBits(this.getBoost());
        result += this.slop;
        return result ^= this.inOrder ? -1716530243 : 0;
    }
}

