/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.lucene.search.spans;

import com.kingdee.bos.ctrl.lucene.search.Explanation;
import com.kingdee.bos.ctrl.lucene.search.Scorer;
import com.kingdee.bos.ctrl.lucene.search.Similarity;
import com.kingdee.bos.ctrl.lucene.search.Weight;
import com.kingdee.bos.ctrl.lucene.search.spans.Spans;
import java.io.IOException;

public class SpanScorer
extends Scorer {
    protected Spans spans;
    protected Weight weight;
    protected byte[] norms;
    protected float value;
    protected boolean firstTime = true;
    protected boolean more = true;
    protected int doc;
    protected float freq;

    protected SpanScorer(Spans spans, Weight weight, Similarity similarity, byte[] norms) throws IOException {
        super(similarity);
        this.spans = spans;
        this.norms = norms;
        this.weight = weight;
        this.value = weight.getValue();
        this.doc = -1;
    }

    @Override
    public boolean next() throws IOException {
        if (this.firstTime) {
            this.more = this.spans.next();
            this.firstTime = false;
        }
        return this.setFreqCurrentDoc();
    }

    @Override
    public boolean skipTo(int target) throws IOException {
        if (this.firstTime) {
            this.more = this.spans.skipTo(target);
            this.firstTime = false;
        }
        if (!this.more) {
            return false;
        }
        if (this.spans.doc() < target) {
            this.more = this.spans.skipTo(target);
        }
        return this.setFreqCurrentDoc();
    }

    protected boolean setFreqCurrentDoc() throws IOException {
        if (!this.more) {
            return false;
        }
        this.doc = this.spans.doc();
        this.freq = 0.0f;
        while (this.more && this.doc == this.spans.doc()) {
            int matchLength = this.spans.end() - this.spans.start();
            this.freq += this.getSimilarity().sloppyFreq(matchLength);
            this.more = this.spans.next();
        }
        return this.more || this.freq != 0.0f;
    }

    @Override
    public int doc() {
        return this.doc;
    }

    @Override
    public float score() throws IOException {
        float raw = this.getSimilarity().tf(this.freq) * this.value;
        return raw * Similarity.decodeNorm(this.norms[this.doc]);
    }

    @Override
    public Explanation explain(int doc) throws IOException {
        Explanation tfExplanation = new Explanation();
        this.skipTo(doc);
        float phraseFreq = this.doc() == doc ? this.freq : 0.0f;
        tfExplanation.setValue(this.getSimilarity().tf(phraseFreq));
        tfExplanation.setDescription("tf(phraseFreq=" + phraseFreq + ")");
        return tfExplanation;
    }
}

