/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.lucene.search.spans;

import com.kingdee.bos.ctrl.lucene.index.IndexReader;
import com.kingdee.bos.ctrl.lucene.index.Term;
import com.kingdee.bos.ctrl.lucene.search.ComplexExplanation;
import com.kingdee.bos.ctrl.lucene.search.Explanation;
import com.kingdee.bos.ctrl.lucene.search.Query;
import com.kingdee.bos.ctrl.lucene.search.Scorer;
import com.kingdee.bos.ctrl.lucene.search.Searcher;
import com.kingdee.bos.ctrl.lucene.search.Similarity;
import com.kingdee.bos.ctrl.lucene.search.Weight;
import com.kingdee.bos.ctrl.lucene.search.spans.SpanQuery;
import com.kingdee.bos.ctrl.lucene.search.spans.SpanScorer;
import java.io.IOException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class SpanWeight
implements Weight {
    protected Similarity similarity;
    protected float value;
    protected float idf;
    protected float queryNorm;
    protected float queryWeight;
    protected Set terms;
    protected SpanQuery query;

    public SpanWeight(SpanQuery query, Searcher searcher) throws IOException {
        this.similarity = query.getSimilarity(searcher);
        this.query = query;
        this.terms = new HashSet();
        query.extractTerms(this.terms);
        this.idf = this.query.getSimilarity(searcher).idf(this.terms, searcher);
    }

    @Override
    public Query getQuery() {
        return this.query;
    }

    @Override
    public float getValue() {
        return this.value;
    }

    @Override
    public float sumOfSquaredWeights() throws IOException {
        this.queryWeight = this.idf * this.query.getBoost();
        return this.queryWeight * this.queryWeight;
    }

    @Override
    public void normalize(float queryNorm) {
        this.queryNorm = queryNorm;
        this.queryWeight *= queryNorm;
        this.value = this.queryWeight * this.idf;
    }

    @Override
    public Scorer scorer(IndexReader reader) throws IOException {
        return new SpanScorer(this.query.getSpans(reader), this, this.similarity, reader.norms(this.query.getField()));
    }

    @Override
    public Explanation explain(IndexReader reader, int doc) throws IOException {
        ComplexExplanation result = new ComplexExplanation();
        result.setDescription("weight(" + this.getQuery() + " in " + doc + "), product of:");
        String field = ((SpanQuery)this.getQuery()).getField();
        StringBuffer docFreqs = new StringBuffer();
        Iterator i = this.terms.iterator();
        while (i.hasNext()) {
            Term term = (Term)i.next();
            docFreqs.append(term.text());
            docFreqs.append("=");
            docFreqs.append(reader.docFreq(term));
            if (!i.hasNext()) continue;
            docFreqs.append(" ");
        }
        Explanation idfExpl = new Explanation(this.idf, "idf(" + field + ": " + docFreqs + ")");
        Explanation queryExpl = new Explanation();
        queryExpl.setDescription("queryWeight(" + this.getQuery() + "), product of:");
        Explanation boostExpl = new Explanation(this.getQuery().getBoost(), "boost");
        if (this.getQuery().getBoost() != 1.0f) {
            queryExpl.addDetail(boostExpl);
        }
        queryExpl.addDetail(idfExpl);
        Explanation queryNormExpl = new Explanation(this.queryNorm, "queryNorm");
        queryExpl.addDetail(queryNormExpl);
        queryExpl.setValue(boostExpl.getValue() * idfExpl.getValue() * queryNormExpl.getValue());
        result.addDetail(queryExpl);
        ComplexExplanation fieldExpl = new ComplexExplanation();
        fieldExpl.setDescription("fieldWeight(" + field + ":" + this.query.toString(field) + " in " + doc + "), product of:");
        Explanation tfExpl = this.scorer(reader).explain(doc);
        fieldExpl.addDetail(tfExpl);
        fieldExpl.addDetail(idfExpl);
        Explanation fieldNormExpl = new Explanation();
        byte[] fieldNorms = reader.norms(field);
        float fieldNorm = fieldNorms != null ? Similarity.decodeNorm(fieldNorms[doc]) : 0.0f;
        fieldNormExpl.setValue(fieldNorm);
        fieldNormExpl.setDescription("fieldNorm(field=" + field + ", doc=" + doc + ")");
        fieldExpl.addDetail(fieldNormExpl);
        fieldExpl.setMatch(tfExpl.isMatch());
        fieldExpl.setValue(tfExpl.getValue() * idfExpl.getValue() * fieldNormExpl.getValue());
        result.addDetail(fieldExpl);
        result.setMatch(fieldExpl.getMatch());
        result.setValue(queryExpl.getValue() * fieldExpl.getValue());
        if (queryExpl.getValue() == 1.0f) {
            return fieldExpl;
        }
        return result;
    }
}

