/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.lucene.search.spans;

import com.kingdee.bos.ctrl.lucene.index.Term;
import com.kingdee.bos.ctrl.lucene.index.TermPositions;
import com.kingdee.bos.ctrl.lucene.search.spans.Spans;
import java.io.IOException;

public class TermSpans
implements Spans {
    protected TermPositions positions;
    protected Term term;
    protected int doc;
    protected int freq;
    protected int count;
    protected int position;

    public TermSpans(TermPositions positions, Term term) throws IOException {
        this.positions = positions;
        this.term = term;
        this.doc = -1;
    }

    @Override
    public boolean next() throws IOException {
        if (this.count == this.freq) {
            if (!this.positions.next()) {
                this.doc = Integer.MAX_VALUE;
                return false;
            }
            this.doc = this.positions.doc();
            this.freq = this.positions.freq();
            this.count = 0;
        }
        this.position = this.positions.nextPosition();
        ++this.count;
        return true;
    }

    @Override
    public boolean skipTo(int target) throws IOException {
        if (this.doc >= target) {
            return true;
        }
        if (!this.positions.skipTo(target)) {
            this.doc = Integer.MAX_VALUE;
            return false;
        }
        this.doc = this.positions.doc();
        this.freq = this.positions.freq();
        this.count = 0;
        this.position = this.positions.nextPosition();
        ++this.count;
        return true;
    }

    @Override
    public int doc() {
        return this.doc;
    }

    @Override
    public int start() {
        return this.position;
    }

    @Override
    public int end() {
        return this.position + 1;
    }

    public String toString() {
        return "spans(" + this.term.toString() + ")@" + (this.doc == -1 ? "START" : (this.doc == Integer.MAX_VALUE ? "END" : this.doc + "-" + this.position));
    }

    public TermPositions getPositions() {
        return this.positions;
    }
}

