/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.lucene.store;

import com.kingdee.bos.ctrl.lucene.store.AlreadyClosedException;
import com.kingdee.bos.ctrl.lucene.store.Directory;
import com.kingdee.bos.ctrl.lucene.store.FSDirectory;
import com.kingdee.bos.ctrl.lucene.store.IndexInput;
import com.kingdee.bos.ctrl.lucene.store.IndexOutput;
import com.kingdee.bos.ctrl.lucene.store.RAMFile;
import com.kingdee.bos.ctrl.lucene.store.RAMInputStream;
import com.kingdee.bos.ctrl.lucene.store.RAMOutputStream;
import com.kingdee.bos.ctrl.lucene.store.SingleInstanceLockFactory;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;

public class RAMDirectory
extends Directory
implements Serializable {
    private static final long serialVersionUID = 1L;
    HashMap fileMap = new HashMap();
    long sizeInBytes = 0L;

    public RAMDirectory() {
        this.setLockFactory(new SingleInstanceLockFactory());
    }

    public RAMDirectory(Directory dir) throws IOException {
        this(dir, false);
    }

    private RAMDirectory(Directory dir, boolean closeDir) throws IOException {
        this();
        Directory.copy(dir, this, closeDir);
    }

    public RAMDirectory(File dir) throws IOException {
        this(FSDirectory.getDirectory(dir), true);
    }

    public RAMDirectory(String dir) throws IOException {
        this(FSDirectory.getDirectory(dir), true);
    }

    @Override
    public final synchronized String[] list() {
        this.ensureOpen();
        Set fileNames = this.fileMap.keySet();
        String[] result = new String[fileNames.size()];
        int i = 0;
        Iterator it = fileNames.iterator();
        while (it.hasNext()) {
            result[i++] = (String)it.next();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean fileExists(String name) {
        RAMFile file;
        this.ensureOpen();
        RAMDirectory rAMDirectory = this;
        synchronized (rAMDirectory) {
            file = (RAMFile)this.fileMap.get(name);
        }
        return file != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final long fileModified(String name) throws IOException {
        RAMFile file;
        this.ensureOpen();
        RAMDirectory rAMDirectory = this;
        synchronized (rAMDirectory) {
            file = (RAMFile)this.fileMap.get(name);
        }
        if (file == null) {
            throw new FileNotFoundException(name);
        }
        return file.getLastModified();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void touchFile(String name) throws IOException {
        long ts2;
        RAMFile file;
        this.ensureOpen();
        RAMDirectory rAMDirectory = this;
        synchronized (rAMDirectory) {
            file = (RAMFile)this.fileMap.get(name);
        }
        if (file == null) {
            throw new FileNotFoundException(name);
        }
        long ts1 = System.currentTimeMillis();
        do {
            try {
                Thread.sleep(0L, 1);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        } while (ts1 == (ts2 = System.currentTimeMillis()));
        file.setLastModified(ts2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final long fileLength(String name) throws IOException {
        RAMFile file;
        this.ensureOpen();
        RAMDirectory rAMDirectory = this;
        synchronized (rAMDirectory) {
            file = (RAMFile)this.fileMap.get(name);
        }
        if (file == null) {
            throw new FileNotFoundException(name);
        }
        return file.getLength();
    }

    public final synchronized long sizeInBytes() {
        this.ensureOpen();
        return this.sizeInBytes;
    }

    @Override
    public synchronized void deleteFile(String name) throws IOException {
        this.ensureOpen();
        RAMFile file = (RAMFile)this.fileMap.get(name);
        if (file != null) {
            this.fileMap.remove(name);
            file.directory = null;
            this.sizeInBytes -= file.sizeInBytes;
        } else {
            throw new FileNotFoundException(name);
        }
    }

    @Override
    public final synchronized void renameFile(String from, String to) throws IOException {
        this.ensureOpen();
        RAMFile fromFile = (RAMFile)this.fileMap.get(from);
        if (fromFile == null) {
            throw new FileNotFoundException(from);
        }
        RAMFile toFile = (RAMFile)this.fileMap.get(to);
        if (toFile != null) {
            this.sizeInBytes -= toFile.sizeInBytes;
            toFile.directory = null;
        }
        this.fileMap.remove(from);
        this.fileMap.put(to, fromFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IndexOutput createOutput(String name) {
        this.ensureOpen();
        RAMFile file = new RAMFile(this);
        RAMDirectory rAMDirectory = this;
        synchronized (rAMDirectory) {
            RAMFile existing = (RAMFile)this.fileMap.get(name);
            if (existing != null) {
                this.sizeInBytes -= existing.sizeInBytes;
                existing.directory = null;
            }
            this.fileMap.put(name, file);
        }
        return new RAMOutputStream(file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IndexInput openInput(String name) throws IOException {
        RAMFile file;
        this.ensureOpen();
        RAMDirectory rAMDirectory = this;
        synchronized (rAMDirectory) {
            file = (RAMFile)this.fileMap.get(name);
        }
        if (file == null) {
            throw new FileNotFoundException(name);
        }
        return new RAMInputStream(file);
    }

    @Override
    public void close() {
        this.fileMap = null;
    }

    protected final void ensureOpen() throws AlreadyClosedException {
        if (this.fileMap == null) {
            throw new AlreadyClosedException("this RAMDirectory is closed");
        }
    }
}

