/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.data;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.ref.WeakReference;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.WeakHashMap;
import org.apache.jackrabbit.core.data.DataIdentifier;
import org.apache.jackrabbit.core.data.DataRecord;
import org.apache.jackrabbit.core.data.DataStore;
import org.apache.jackrabbit.core.data.DataStoreException;
import org.apache.jackrabbit.core.data.FileDataRecord;

public class FileDataStore
implements DataStore {
    private static final String DIGEST = "SHA-1";
    private static final int DEFAULT_MIN_RECORD_LENGTH = 100;
    private static final String TMP = "tmp";
    private long minModifiedDate;
    private File directory;
    private String path;
    private int minRecordLength = 100;
    private WeakHashMap inUse = new WeakHashMap();

    @Override
    public void init(String homeDir) {
        if (this.path == null) {
            this.path = homeDir + "/repository/datastore";
        }
        this.directory = new File(this.path);
        this.directory.mkdirs();
    }

    @Override
    public DataRecord getRecord(DataIdentifier identifier) {
        File file = this.getFile(identifier);
        if (this.minModifiedDate != 0L && file.exists() && file.canWrite() && file.lastModified() < this.minModifiedDate) {
            file.setLastModified(System.currentTimeMillis());
        }
        this.usesIdentifier(identifier);
        return new FileDataRecord(identifier, file);
    }

    private void usesIdentifier(DataIdentifier identifier) {
        this.inUse.put(identifier, new WeakReference<DataIdentifier>(identifier));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DataRecord addRecord(InputStream input) throws DataStoreException {
        File temporary = null;
        try {
            temporary = this.newTemporaryFile();
            long length = 0L;
            MessageDigest digest = MessageDigest.getInstance(DIGEST);
            try (FileOutputStream output = new FileOutputStream(temporary);){
                byte[] b = new byte[4096];
                int n = input.read(b);
                while (n != -1) {
                    ((OutputStream)output).write(b, 0, n);
                    digest.update(b, 0, n);
                    length += (long)n;
                    n = input.read(b);
                }
            }
            DataIdentifier identifier = new DataIdentifier(digest.digest());
            this.usesIdentifier(identifier);
            File file = this.getFile(identifier);
            File parent = file.getParentFile();
            if (!parent.isDirectory()) {
                parent.mkdirs();
            }
            if (!file.exists()) {
                temporary.renameTo(file);
                if (!file.exists()) {
                    throw new IOException("Can not rename " + temporary.getAbsolutePath() + " to " + file.getAbsolutePath() + " (media read only?)");
                }
            } else {
                long now = System.currentTimeMillis();
                if (file.lastModified() < now) {
                    file.setLastModified(now);
                }
            }
            if (!file.isFile()) {
                throw new IOException("Not a file: " + file);
            }
            if (file.length() != length) {
                throw new IOException("SHA-1 collision: " + file);
            }
            FileDataRecord fileDataRecord = new FileDataRecord(identifier, file);
            return fileDataRecord;
        }
        catch (NoSuchAlgorithmException e) {
            throw new DataStoreException("SHA-1 not available", e);
        }
        catch (IOException e) {
            throw new DataStoreException("Could not add record", e);
        }
        finally {
            if (temporary != null) {
                temporary.delete();
            }
        }
    }

    private File getFile(DataIdentifier identifier) {
        this.usesIdentifier(identifier);
        String string = identifier.toString();
        File file = this.directory;
        file = new File(file, string.substring(0, 2));
        file = new File(file, string.substring(2, 4));
        file = new File(file, string.substring(4, 6));
        return new File(file, string);
    }

    private File newTemporaryFile() throws IOException {
        if (!this.directory.isDirectory()) {
            this.directory.mkdirs();
        }
        return File.createTempFile(TMP, null, this.directory);
    }

    @Override
    public void updateModifiedDateOnAccess(long before) {
        this.minModifiedDate = before;
    }

    @Override
    public int deleteAllOlderThan(long min) {
        return this.deleteOlderRecursive(this.directory, min);
    }

    private int deleteOlderRecursive(File file, long min) {
        int count = 0;
        if (file.isFile() && file.exists() && file.canWrite()) {
            DataIdentifier id;
            if (file.lastModified() < min && !this.inUse.containsKey(id = new DataIdentifier(file.getName()))) {
                file.delete();
                ++count;
            }
        } else if (file.isDirectory()) {
            File[] list = file.listFiles();
            for (int i = 0; i < list.length; ++i) {
                count += this.deleteOlderRecursive(list[i], min);
            }
        }
        return count;
    }

    private void listRecursive(List list, File file) {
        File[] l = file.listFiles();
        for (int i = 0; l != null && i < l.length; ++i) {
            File f = l[i];
            if (f.isDirectory()) {
                this.listRecursive(list, f);
                continue;
            }
            list.add(f);
        }
    }

    @Override
    public Iterator getAllIdentifiers() {
        ArrayList files = new ArrayList();
        this.listRecursive(files, this.directory);
        ArrayList<DataIdentifier> identifiers = new ArrayList<DataIdentifier>();
        for (int i = 0; i < files.size(); ++i) {
            File f = (File)files.get(i);
            String name = f.getName();
            if (name.startsWith(TMP)) continue;
            DataIdentifier id = new DataIdentifier(name);
            identifiers.add(id);
        }
        return identifiers.iterator();
    }

    @Override
    public void clearInUse() {
        this.inUse.clear();
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String directoryName) {
        this.path = directoryName;
    }

    @Override
    public int getMinRecordLength() {
        return this.minRecordLength;
    }

    public void setMinRecordLength(int minRecordLength) {
        this.minRecordLength = minRecordLength;
    }

    @Override
    public void close() {
    }
}

