/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.fs.mem;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.jackrabbit.core.fs.FileSystem;
import org.apache.jackrabbit.core.fs.FileSystemException;
import org.apache.jackrabbit.core.fs.RandomAccessOutputStream;
import org.apache.jackrabbit.core.fs.mem.MemoryFile;
import org.apache.jackrabbit.core.fs.mem.MemoryFileSystemEntry;
import org.apache.jackrabbit.core.fs.mem.MemoryFolder;

public class MemoryFileSystem
implements FileSystem {
    private Map entries = new HashMap();

    @Override
    public void close() {
    }

    @Override
    public void copy(String srcPath, String destPath) throws FileSystemException {
        this.assertExistence(srcPath);
        MemoryFile srcFile = this.getFile(srcPath);
        OutputStream destinationOutputStream = this.getOutputStream(destPath);
        try {
            destinationOutputStream.write(srcFile.getData());
        }
        catch (IOException e) {
            throw new FileSystemException(e.getMessage(), e);
        }
        finally {
            try {
                destinationOutputStream.close();
            }
            catch (IOException iOException) {}
        }
    }

    private MemoryFile getFile(String filePath) throws FileSystemException {
        MemoryFileSystemEntry entry = this.getEntry(filePath);
        this.assertIsFile(filePath);
        return (MemoryFile)entry;
    }

    @Override
    public void createFolder(String folderPath) throws FileSystemException {
        if (this.exists(folderPath)) {
            throw new FileSystemException("Folder or file " + folderPath + " already exists");
        }
        if (!this.exists("/")) {
            this.createFolderInternal("/");
        }
        String relativePath = folderPath.substring(1);
        String[] pathElements = relativePath.split("/");
        String currentFolderPath = "";
        for (int i = 0; i < pathElements.length; ++i) {
            String pathElement = pathElements[i];
            currentFolderPath = currentFolderPath + "/" + pathElement;
            this.createFolderInternal(currentFolderPath);
        }
    }

    private void createFolderInternal(String folderPath) {
        MemoryFolder folder = new MemoryFolder();
        this.entries.put(folderPath, folder);
    }

    @Override
    public void deleteFile(String filePath) throws FileSystemException {
        this.assertExistence(filePath);
        this.entries.remove(filePath);
    }

    @Override
    public void deleteFolder(String folderPath) throws FileSystemException {
        this.assertIsFolder(folderPath);
        Set allNames = this.entries.keySet();
        HashSet<String> selectedNames = new HashSet<String>();
        for (String name : allNames) {
            if (!name.startsWith(folderPath)) continue;
            selectedNames.add(name);
        }
        for (String name : selectedNames) {
            this.entries.remove(name);
        }
    }

    @Override
    public boolean exists(String path) throws FileSystemException {
        return this.entries.containsKey(path);
    }

    @Override
    public InputStream getInputStream(String filePath) throws FileSystemException {
        this.assertExistence(filePath);
        this.assertIsFile(filePath);
        MemoryFile file = this.getFile(filePath);
        return new ByteArrayInputStream(file.getData());
    }

    private void assertIsFolder(String folderPath) throws FileSystemException {
        this.assertExistence(folderPath);
        if (!this.getEntry(folderPath).isFolder()) {
            throw new FileSystemException("Folder " + folderPath + " does not exist");
        }
    }

    private void assertIsFile(String filePath) throws FileSystemException {
        if (!this.isFile(filePath)) {
            throw new FileSystemException(filePath + " is a folder");
        }
    }

    @Override
    public OutputStream getOutputStream(String filePath) throws FileSystemException {
        String folderPath = filePath;
        folderPath = filePath.lastIndexOf("/") > 0 ? filePath.substring(0, filePath.lastIndexOf("/")) : "/";
        this.assertIsFolder(folderPath);
        final MemoryFile file = new MemoryFile();
        this.entries.put(filePath, file);
        return new FilterOutputStream(new ByteArrayOutputStream()){

            @Override
            public void close() throws IOException {
                this.out.close();
                file.setData(((ByteArrayOutputStream)this.out).toByteArray());
            }
        };
    }

    @Override
    public RandomAccessOutputStream getRandomAccessOutputStream(String filePath) throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Random access is not implemented for the memory file system");
    }

    @Override
    public boolean hasChildren(String path) throws FileSystemException {
        this.assertIsFolder(path);
        return this.list(path).length > 0;
    }

    @Override
    public void init() {
        this.createFolderInternal("/");
    }

    @Override
    public boolean isFile(String path) throws FileSystemException {
        return this.exists(path) && !this.getEntry(path).isFolder();
    }

    private MemoryFileSystemEntry getEntry(String path) {
        return (MemoryFileSystemEntry)this.entries.get(path);
    }

    private void assertExistence(String path) throws FileSystemException {
        if (!this.exists(path)) {
            throw new FileSystemException("no such file " + path);
        }
    }

    @Override
    public boolean isFolder(String path) throws FileSystemException {
        if (path.equals("/")) {
            return true;
        }
        return this.exists(path) && this.getEntry(path).isFolder();
    }

    @Override
    public long lastModified(String path) throws FileSystemException {
        this.assertExistence(path);
        return this.getEntry(path).getLastModified();
    }

    @Override
    public long length(String filePath) throws FileSystemException {
        this.assertIsFile(filePath);
        return this.getFile(filePath).getData().length;
    }

    @Override
    public String[] list(String folderPath) {
        if (folderPath.equals("/")) {
            folderPath = "";
        }
        Set allNames = this.entries.keySet();
        HashSet<String> selectedNames = new HashSet<String>();
        for (String name : allNames) {
            if (!name.matches(folderPath + "/[^/]*") || name.equals("/")) continue;
            selectedNames.add(name.substring(folderPath.length() + 1));
        }
        return selectedNames.toArray(new String[0]);
    }

    @Override
    public String[] listFiles(String folderPath) {
        return this.listInternal(folderPath, false);
    }

    @Override
    public String[] listFolders(String folderPath) {
        return this.listInternal(folderPath, true);
    }

    private String[] listInternal(String folderPath, boolean isFolder) {
        String[] names = this.list(folderPath);
        if (folderPath.equals("/")) {
            folderPath = "";
        }
        HashSet<String> result = new HashSet<String>();
        for (int i = 0; i < names.length; ++i) {
            if (this.getEntry(folderPath + "/" + names[i]).isFolder() != isFolder) continue;
            result.add(names[i]);
        }
        return result.toArray(new String[0]);
    }

    @Override
    public void move(String srcPath, String destPath) throws FileSystemException {
        this.assertExistence(srcPath);
        if (this.exists(destPath)) {
            throw new FileSystemException("Destination exists: " + destPath);
        }
        HashMap<String, String> moves = new HashMap<String, String>();
        moves.put(srcPath, destPath);
        if (this.getEntry(srcPath).isFolder()) {
            srcPath = srcPath + "/";
            for (String name : this.entries.keySet()) {
                if (!name.startsWith(srcPath)) continue;
                moves.put(name, destPath + "/" + name.substring(srcPath.length()));
            }
        }
        for (Map.Entry entry : moves.entrySet()) {
            this.entries.put(entry.getValue(), this.entries.remove(entry.getKey()));
        }
    }

    @Override
    public void touch(String filePath) throws FileSystemException {
        this.assertIsFile(filePath);
        this.getEntry(filePath).touch();
    }
}

