/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.jndi;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import javax.jcr.Credentials;
import javax.jcr.LoginException;
import javax.jcr.NoSuchWorkspaceException;
import javax.jcr.Repository;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.naming.Reference;
import javax.naming.Referenceable;
import javax.naming.StringRefAddr;
import org.apache.jackrabbit.core.RepositoryImpl;
import org.apache.jackrabbit.core.config.ConfigurationException;
import org.apache.jackrabbit.core.config.RepositoryConfig;
import org.apache.jackrabbit.core.jndi.BindableRepositoryFactory;

public class BindableRepository
implements Repository,
Referenceable,
Serializable {
    static final long serialVersionUID = -2298220550793843166L;
    private final String configFilePath;
    private final String repHomeDir;
    public static final String CONFIGFILEPATH_ADDRTYPE = "configFilePath";
    public static final String REPHOMEDIR_ADDRTYPE = "repHomeDir";
    protected transient Repository delegatee;
    private transient Thread hook;

    protected BindableRepository(String configFilePath, String repHomeDir) {
        this.configFilePath = configFilePath;
        this.repHomeDir = repHomeDir;
        this.delegatee = null;
    }

    static BindableRepository create(String configFilePath, String repHomeDir) throws RepositoryException {
        BindableRepository rep = new BindableRepository(configFilePath, repHomeDir);
        rep.init();
        return rep;
    }

    protected void init() throws RepositoryException {
        RepositoryConfig config = this.createRepositoryConfig(this.configFilePath, this.repHomeDir);
        this.delegatee = this.createRepository(config);
        this.hook = new Thread(){

            @Override
            public void run() {
                BindableRepository.this.shutdown();
            }
        };
        Runtime.getRuntime().addShutdownHook(this.hook);
    }

    protected RepositoryConfig createRepositoryConfig(String configFilePath, String repHomeDir) throws ConfigurationException {
        return RepositoryConfig.create(configFilePath, repHomeDir);
    }

    protected Repository createRepository(RepositoryConfig config) throws RepositoryException {
        return RepositoryImpl.create(config);
    }

    public Session login(Credentials credentials, String workspaceName) throws LoginException, NoSuchWorkspaceException, RepositoryException {
        return this.delegatee.login(credentials, workspaceName);
    }

    public Session login(String workspaceName) throws LoginException, NoSuchWorkspaceException, RepositoryException {
        return this.delegatee.login(workspaceName);
    }

    public Session login() throws LoginException, RepositoryException {
        return this.delegatee.login();
    }

    public Session login(Credentials credentials) throws LoginException, RepositoryException {
        return this.delegatee.login(credentials);
    }

    public String getDescriptor(String key) {
        return this.delegatee.getDescriptor(key);
    }

    public String[] getDescriptorKeys() {
        return this.delegatee.getDescriptorKeys();
    }

    @Override
    public Reference getReference() {
        Reference ref = new Reference(BindableRepository.class.getName(), BindableRepositoryFactory.class.getName(), null);
        ref.add(new StringRefAddr(CONFIGFILEPATH_ADDRTYPE, this.configFilePath));
        ref.add(new StringRefAddr(REPHOMEDIR_ADDRTYPE, this.repHomeDir));
        return ref;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        try {
            this.init();
        }
        catch (RepositoryException re) {
            throw new IOException(re.getMessage());
        }
    }

    void shutdown() {
        ((RepositoryImpl)this.delegatee).shutdown();
        try {
            Runtime.getRuntime().removeShutdownHook(this.hook);
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }
}

