/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.journal;

import EDU.oswego.cs.dl.util.concurrent.ReadWriteLock;
import EDU.oswego.cs.dl.util.concurrent.ReentrantWriterPreferenceReadWriteLock;
import com.kingdee.bos.ctrl.common.util.CommonSLF4JLogger;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import org.apache.jackrabbit.core.journal.AppendRecord;
import org.apache.jackrabbit.core.journal.DefaultRecordProducer;
import org.apache.jackrabbit.core.journal.Journal;
import org.apache.jackrabbit.core.journal.JournalException;
import org.apache.jackrabbit.core.journal.Record;
import org.apache.jackrabbit.core.journal.RecordConsumer;
import org.apache.jackrabbit.core.journal.RecordIterator;
import org.apache.jackrabbit.core.journal.RecordProducer;
import org.apache.jackrabbit.spi.commons.conversion.DefaultNamePathResolver;
import org.apache.jackrabbit.spi.commons.conversion.NamePathResolver;
import org.apache.jackrabbit.spi.commons.namespace.NamespaceResolver;
import org.slf4j.Logger;

public abstract class AbstractJournal
implements Journal {
    private static Logger log = CommonSLF4JLogger.getLogger(AbstractJournal.class);
    private String id;
    private NamespaceResolver resolver;
    private NamePathResolver npResolver;
    private final Map consumers = new HashMap();
    private final Map producers = new HashMap();
    private final ReadWriteLock rwLock = new ReentrantWriterPreferenceReadWriteLock();

    @Override
    public void init(String id, NamespaceResolver resolver) throws JournalException {
        this.id = id;
        this.resolver = resolver;
        this.npResolver = new DefaultNamePathResolver(resolver, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void register(RecordConsumer consumer) throws JournalException {
        Map map = this.consumers;
        synchronized (map) {
            String consumerId = consumer.getId();
            if (this.consumers.containsKey(consumerId)) {
                String msg = "Record consumer with identifier '" + consumerId + "' already registered.";
                throw new JournalException(msg);
            }
            this.consumers.put(consumerId, consumer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean unregister(RecordConsumer consumer) {
        Map map = this.consumers;
        synchronized (map) {
            String consumerId = consumer.getId();
            return this.consumers.remove(consumerId) != null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RecordConsumer getConsumer(String identifier) {
        Map map = this.consumers;
        synchronized (map) {
            return (RecordConsumer)this.consumers.get(identifier);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RecordProducer getProducer(String identifier) {
        Map map = this.producers;
        synchronized (map) {
            RecordProducer producer = (RecordProducer)this.producers.get(identifier);
            if (producer == null) {
                producer = this.createProducer(identifier);
                this.producers.put(identifier, producer);
            }
            return producer;
        }
    }

    protected RecordProducer createProducer(String identifier) {
        return new DefaultRecordProducer(this, identifier);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long getMinimalRevision() {
        long minimalRevision = Long.MAX_VALUE;
        Map map = this.consumers;
        synchronized (map) {
            for (RecordConsumer consumer : this.consumers.values()) {
                if (consumer.getRevision() >= minimalRevision) continue;
                minimalRevision = consumer.getRevision();
            }
        }
        return minimalRevision;
    }

    @Override
    public void sync() throws JournalException {
        try {
            this.rwLock.readLock().acquire();
        }
        catch (InterruptedException e) {
            String msg = "Unable to acquire read lock.";
            throw new JournalException(msg, e);
        }
        try {
            this.doSync(this.getMinimalRevision());
        }
        finally {
            this.rwLock.readLock().release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doSync(long startRevision) throws JournalException {
        long stopRevision = Long.MIN_VALUE;
        try (RecordIterator iterator = this.getRecords(startRevision);){
            while (iterator.hasNext()) {
                Record record = iterator.nextRecord();
                if (record.getJournalId().equals(this.id)) {
                    log.info("Record with revision '" + record.getRevision() + "' created by this journal, skipped.");
                } else {
                    RecordConsumer consumer = this.getConsumer(record.getProducerId());
                    if (consumer != null) {
                        consumer.consume(record);
                    }
                }
                stopRevision = record.getRevision();
            }
        }
        if (stopRevision > 0L) {
            for (RecordConsumer consumer : this.consumers.values()) {
                consumer.setRevision(stopRevision);
            }
            log.info("Synchronized to revision: " + stopRevision);
        }
    }

    protected abstract RecordIterator getRecords(long var1) throws JournalException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void lockAndSync() throws JournalException {
        try {
            this.rwLock.writeLock().acquire();
        }
        catch (InterruptedException e) {
            String msg = "Unable to acquire write lock.";
            throw new JournalException(msg, e);
        }
        boolean succeeded = false;
        try {
            this.doLock();
            try {
                this.doSync(this.getMinimalRevision());
                succeeded = true;
            }
            finally {
                if (!succeeded) {
                    this.doUnlock(false);
                }
            }
        }
        finally {
            if (!succeeded) {
                this.rwLock.writeLock().release();
            }
        }
    }

    public void unlock(boolean successful) {
        this.doUnlock(successful);
        this.rwLock.writeLock().release();
    }

    protected abstract void doLock() throws JournalException;

    protected void appending(AppendRecord record) {
    }

    protected abstract void append(AppendRecord var1, InputStream var2, int var3) throws JournalException;

    protected abstract void doUnlock(boolean var1);

    public String getId() {
        return this.id;
    }

    public NamespaceResolver getResolver() {
        return this.resolver;
    }

    public NamePathResolver getNamePathResolver() {
        return this.npResolver;
    }
}

