/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.nodetype;

import javax.jcr.NamespaceException;
import javax.jcr.PropertyType;
import javax.jcr.RepositoryException;
import javax.jcr.nodetype.ConstraintViolationException;
import org.apache.jackrabbit.core.nodetype.InvalidConstraintException;
import org.apache.jackrabbit.core.nodetype.ValueConstraint;
import org.apache.jackrabbit.core.value.InternalValue;
import org.apache.jackrabbit.spi.Name;
import org.apache.jackrabbit.spi.commons.conversion.NameException;
import org.apache.jackrabbit.spi.commons.conversion.NamePathResolver;

class NameConstraint
extends ValueConstraint {
    final Name name;

    NameConstraint(String definition, NamePathResolver resolver) throws InvalidConstraintException {
        super(definition);
        try {
            this.name = resolver.getQName(definition);
        }
        catch (NameException e) {
            String msg = "invalid name specified as value constraint: " + definition;
            log.debug(msg);
            throw new InvalidConstraintException(msg, (Throwable)((Object)e));
        }
        catch (NamespaceException e) {
            String msg = "invalid name specified as value constraint: " + definition;
            log.debug(msg);
            throw new InvalidConstraintException(msg, e);
        }
    }

    @Override
    public String getDefinition(NamePathResolver resolver) {
        try {
            return resolver.getJCRName(this.name);
        }
        catch (NamespaceException e) {
            return this.definition;
        }
    }

    @Override
    void check(InternalValue value) throws ConstraintViolationException, RepositoryException {
        if (value == null) {
            throw new ConstraintViolationException("null value does not satisfy the constraint '" + this.definition + "'");
        }
        switch (value.getType()) {
            case 7: {
                Name n = value.getQName();
                if (!this.name.equals(n)) {
                    throw new ConstraintViolationException(n + " does not satisfy the constraint '" + this.definition + "'");
                }
                return;
            }
        }
        String msg = "NAME constraint can not be applied to value of type: " + PropertyType.nameFromValue((int)value.getType());
        log.debug(msg);
        throw new RepositoryException(msg);
    }
}

