/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.nodetype;

import java.io.Serializable;
import java.util.Arrays;
import org.apache.jackrabbit.core.nodetype.NodeDef;

public class NodeDefId
implements Serializable {
    static final long serialVersionUID = 7020286139887664713L;
    private final int id;

    NodeDefId(NodeDef def) {
        if (def == null) {
            throw new IllegalArgumentException("NodeDef argument can not be null");
        }
        StringBuffer sb = new StringBuffer();
        sb.append(def.getDeclaringNodeType().toString());
        sb.append('/');
        if (def.definesResidual()) {
            sb.append('*');
        } else {
            sb.append(def.getName().toString());
        }
        sb.append('/');
        Object[] names = def.getRequiredPrimaryTypes();
        Arrays.sort(names);
        sb.append('[');
        for (int i = 0; i < names.length; ++i) {
            if (i > 0) {
                sb.append(", ");
            }
            sb.append(names[i]);
        }
        sb.append(']');
        this.id = sb.toString().hashCode();
    }

    private NodeDefId(int id) {
        this.id = id;
    }

    public static NodeDefId valueOf(String s) throws IllegalArgumentException {
        if (s == null) {
            throw new IllegalArgumentException("invalid NodeDefId literal");
        }
        return new NodeDefId(Integer.parseInt(s));
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof NodeDefId) {
            NodeDefId other = (NodeDefId)obj;
            return this.id == other.id;
        }
        return false;
    }

    public String toString() {
        return Integer.toString(this.id);
    }

    public int hashCode() {
        return this.id;
    }
}

