/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.persistence.bundle;

import com.kingdee.bos.ctrl.common.util.CommonSLF4JLogger;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.Statement;
import javax.jcr.RepositoryException;
import org.apache.jackrabbit.core.persistence.PMContext;
import org.apache.jackrabbit.core.persistence.bundle.BundleDbPersistenceManager;
import org.slf4j.Logger;

public class DerbyPersistenceManager
extends BundleDbPersistenceManager {
    static final String CVS_ID = "$URL: http://svn.apache.org/repos/asf/jackrabbit/tags/1.4/jackrabbit-core/src/main/java/org/apache/jackrabbit/core/persistence/bundle/DerbyPersistenceManager.java $ $Rev: 575734 $ $Date: 2007-09-14 19:04:19 +0300 (Fri, 14 Sep 2007) $";
    public static final String DERBY_EMBEDDED_DRIVER = "org.apache.derby.jdbc.EmbeddedDriver";
    private static Logger log = CommonSLF4JLogger.getLogger(DerbyPersistenceManager.class);
    private int derbyStorageInitialPages = 16;
    private int derbyStorageMinimumRecordSize = 512;
    private int derbyStoragePageCacheSize = 1024;
    private int derbyStoragePageReservedSpace = 20;
    private int derbyStoragePageSize = 16384;

    public String getDerbyStorageInitialPages() {
        return String.valueOf(this.derbyStorageInitialPages);
    }

    public void setDerbyStorageInitialPages(String derbyStorageInitialPages) {
        this.derbyStorageInitialPages = Integer.decode(derbyStorageInitialPages);
    }

    public String getDerbyStorageMinimumRecordSize() {
        return String.valueOf(this.derbyStorageMinimumRecordSize);
    }

    public void setDerbyStorageMinimumRecordSize(String derbyStorageMinimumRecordSize) {
        this.derbyStorageMinimumRecordSize = Integer.decode(derbyStorageMinimumRecordSize);
    }

    public String getDerbyStoragePageCacheSize() {
        return String.valueOf(this.derbyStoragePageCacheSize);
    }

    public void setDerbyStoragePageCacheSize(String derbyStoragePageCacheSize) {
        this.derbyStoragePageCacheSize = Integer.decode(derbyStoragePageCacheSize);
    }

    public String getDerbyStoragePageReservedSpace() {
        return String.valueOf(this.derbyStoragePageReservedSpace);
    }

    public void setDerbyStoragePageReservedSpace(String derbyStoragePageReservedSpace) {
        this.derbyStoragePageReservedSpace = Integer.decode(derbyStoragePageReservedSpace);
    }

    public String getDerbyStoragePageSize() {
        return String.valueOf(this.derbyStoragePageSize);
    }

    public void setDerbyStoragePageSize(String derbyStoragePageSize) {
        this.derbyStoragePageSize = Integer.decode(derbyStoragePageSize);
    }

    @Override
    public void init(PMContext context) throws Exception {
        if (this.getDriver() == null) {
            this.setDriver(DERBY_EMBEDDED_DRIVER);
        }
        if (this.getSchema() == null) {
            this.setSchema("derby");
        }
        if (this.getUrl() == null) {
            this.setUrl("jdbc:derby:" + context.getHomeDir().getPath() + "/db/itemState;create=true");
        }
        if (this.getUser() == null) {
            this.setUser("");
        }
        if (this.getPassword() == null) {
            this.setPassword("");
        }
        if (this.getSchemaObjectPrefix() == null) {
            this.setSchemaObjectPrefix("");
        }
        super.init(context);
    }

    @Override
    protected void checkSchema() throws SQLException, RepositoryException {
        if (DERBY_EMBEDDED_DRIVER.equals(this.getDriver())) {
            try (Statement stmt = this.connectionManager.getConnection().createStatement();){
                stmt.execute("CALL SYSCS_UTIL.SYSCS_SET_DATABASE_PROPERTY ('derby.storage.initialPages', '" + this.derbyStorageInitialPages + "')");
                stmt.execute("CALL SYSCS_UTIL.SYSCS_SET_DATABASE_PROPERTY ('derby.storage.minimumRecordSize', '" + this.derbyStorageMinimumRecordSize + "')");
                stmt.execute("CALL SYSCS_UTIL.SYSCS_SET_DATABASE_PROPERTY ('derby.storage.pageCacheSize', '" + this.derbyStoragePageCacheSize + "')");
                stmt.execute("CALL SYSCS_UTIL.SYSCS_SET_DATABASE_PROPERTY ('derby.storage.pageReservedSpace', '" + this.derbyStoragePageReservedSpace + "')");
                stmt.execute("CALL SYSCS_UTIL.SYSCS_SET_DATABASE_PROPERTY ('derby.storage.pageSize', '" + this.derbyStoragePageSize + "')");
            }
        }
        super.checkSchema();
    }

    @Override
    public int getStorageModel() {
        return 2;
    }

    @Override
    public void close() throws Exception {
        if (!DERBY_EMBEDDED_DRIVER.equals(this.getDriver())) {
            return;
        }
        String url = this.connectionManager.getConnection().getMetaData().getURL();
        int pos = url.lastIndexOf(59);
        if (pos != -1) {
            url = url.substring(0, pos);
        }
        url = url + ";shutdown=true";
        this.connectionManager.getConnection().setAutoCommit(true);
        try {
            DriverManager.getConnection(url);
        }
        catch (SQLException e) {
            log.info(e.getMessage());
        }
        super.close();
    }
}

