/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.persistence.bundle.util;

import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.jackrabbit.core.persistence.bundle.util.ConnectionRecoveryManager;
import org.apache.jackrabbit.core.persistence.bundle.util.DbNameIndex;

public class NGKDbNameIndex
extends DbNameIndex {
    static final String CVS_ID = "$URL: http://svn.apache.org/repos/asf/jackrabbit/tags/1.4/jackrabbit-core/src/main/java/org/apache/jackrabbit/core/persistence/bundle/util/NGKDbNameIndex.java $ $Rev: 575734 $ $Date: 2007-09-14 19:04:19 +0300 (Fri, 14 Sep 2007) $";

    public NGKDbNameIndex(ConnectionRecoveryManager conMgr, String schemaObjectPrefix) throws SQLException {
        super(conMgr, schemaObjectPrefix);
    }

    @Override
    protected void init(String schemaObjectPrefix) throws SQLException {
        this.nameSelectSQL = "select NAME from " + schemaObjectPrefix + "NAMES where ID = ?";
        this.indexSelectSQL = "select ID from " + schemaObjectPrefix + "NAMES where NAME = ?";
        this.nameInsertSQL = "insert into " + schemaObjectPrefix + "NAMES (NAME) values (?)";
    }

    @Override
    protected int insertString(String string) {
        ResultSet rs = null;
        try {
            this.connectionManager.executeStmt(this.nameInsertSQL, new Object[]{string});
            int n = this.getIndex(string);
            return n;
        }
        catch (Exception e) {
            throw new IllegalStateException("Unable to insert index: " + e);
        }
        finally {
            this.closeResultSet(rs);
        }
    }
}

