/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.query.lucene;

import com.kingdee.bos.ctrl.lucene.index.IndexReader;
import com.kingdee.bos.ctrl.lucene.index.Term;
import com.kingdee.bos.ctrl.lucene.index.TermEnum;
import com.kingdee.bos.ctrl.lucene.search.FilteredTermEnum;
import com.kingdee.bos.ctrl.lucene.search.MultiTermQuery;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import org.apache.jackrabbit.core.query.lucene.FieldNames;
import org.apache.jackrabbit.core.query.lucene.OffsetCharSequence;
import org.apache.jackrabbit.core.query.lucene.RangeScan;
import org.apache.jackrabbit.core.query.lucene.TransformConstants;

abstract class CaseTermQuery
extends MultiTermQuery
implements TransformConstants {
    protected final int transform;

    CaseTermQuery(Term term, int transform) {
        super(term);
        this.transform = transform;
    }

    @Override
    protected FilteredTermEnum getEnum(IndexReader reader) throws IOException {
        return new CaseTermEnum(reader);
    }

    private final class CaseTermEnum
    extends FilteredTermEnum {
        private final int nameLength;
        private final OffsetCharSequence termText;
        private final OffsetCharSequence currentTerm;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        CaseTermEnum(IndexReader reader) throws IOException {
            final LinkedHashMap<Term, Integer> orderedTerms = new LinkedHashMap<Term, Integer>();
            Term term = CaseTermQuery.this.getTerm();
            ArrayList<RangeScan> rangeScans = new ArrayList<RangeScan>(2);
            this.nameLength = FieldNames.getNameLength(term.text());
            String propName = term.text().substring(0, this.nameLength);
            this.termText = new OffsetCharSequence(this.nameLength, term.text());
            this.currentTerm = new OffsetCharSequence(this.nameLength, term.text(), CaseTermQuery.this.transform);
            try {
                if (term.text().length() > this.nameLength) {
                    StringBuffer lowerLimit = new StringBuffer(propName);
                    lowerLimit.append(this.termText.toString().toUpperCase());
                    lowerLimit.setCharAt(this.nameLength, Character.toLowerCase(lowerLimit.charAt(this.nameLength)));
                    StringBuffer stringBuffer = new StringBuffer(propName);
                    stringBuffer.append(this.termText.toString().toLowerCase());
                    rangeScans.add(new RangeScan(reader, new Term(term.field(), lowerLimit.toString()), new Term(term.field(), stringBuffer.toString())));
                    lowerLimit = new StringBuffer(propName);
                    lowerLimit.append(this.termText.toString().toUpperCase());
                    StringBuffer stringBuffer2 = new StringBuffer(propName);
                    stringBuffer2.append(this.termText.toString().toLowerCase());
                    stringBuffer2.setCharAt(this.nameLength, Character.toUpperCase(stringBuffer2.charAt(this.nameLength)));
                    rangeScans.add(new RangeScan(reader, new Term(term.field(), lowerLimit.toString()), new Term(term.field(), stringBuffer2.toString())));
                } else {
                    rangeScans.add(new RangeScan(reader, term, term));
                }
                block7: for (TermEnum termEnum : rangeScans) {
                    Term t;
                    while ((t = termEnum.term()) != null) {
                        this.currentTerm.setBase(t.text());
                        int compare = this.currentTerm.compareTo(this.termText);
                        if (compare == 0) {
                            orderedTerms.put(t, new Integer(termEnum.docFreq()));
                        } else if (compare < 0) {
                            // empty if block
                        }
                        if (termEnum.next()) continue;
                        continue block7;
                    }
                }
            }
            finally {
                for (TermEnum termEnum : rangeScans) {
                    try {
                        termEnum.close();
                    }
                    catch (IOException iOException) {}
                }
            }
            final Iterator<Object> it = orderedTerms.keySet().iterator();
            this.setEnum(new TermEnum(){
                private Term current;
                {
                    this.getNext();
                }

                @Override
                public boolean next() {
                    this.getNext();
                    return this.current != null;
                }

                @Override
                public Term term() {
                    return this.current;
                }

                @Override
                public int docFreq() {
                    Integer docFreq = (Integer)orderedTerms.get(this.current);
                    return docFreq != null ? docFreq : 0;
                }

                @Override
                public void close() {
                }

                private void getNext() {
                    this.current = it.hasNext() ? (Term)it.next() : null;
                }
            });
        }

        @Override
        protected boolean termCompare(Term term) {
            return true;
        }

        @Override
        public float difference() {
            return 1.0f;
        }

        @Override
        protected boolean endEnum() {
            return false;
        }
    }

    static final class Lower
    extends CaseTermQuery {
        Lower(Term term) {
            super(term, 1);
        }
    }

    static final class Upper
    extends CaseTermQuery {
        Upper(Term term) {
            super(term, 2);
        }
    }
}

