/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.query.lucene;

import java.io.IOException;
import java.util.BitSet;
import org.apache.jackrabbit.core.query.lucene.ForeignSegmentDocId;
import org.apache.jackrabbit.core.query.lucene.MultiIndexReader;
import org.apache.jackrabbit.uuid.UUID;

abstract class DocId {
    static final DocId NULL = new DocId(){

        @Override
        final int getDocumentNumber(MultiIndexReader reader) {
            return -1;
        }

        @Override
        final DocId applyOffset(int offset) {
            return this;
        }

        @Override
        final boolean isValid(BitSet deleted) {
            return true;
        }
    };

    DocId() {
    }

    abstract int getDocumentNumber(MultiIndexReader var1) throws IOException;

    abstract DocId applyOffset(int var1);

    abstract boolean isValid(BitSet var1);

    static DocId create(int docNumber) {
        return new PlainDocId(docNumber);
    }

    static DocId create(String uuid) {
        return new UUIDDocId(uuid);
    }

    private static final class UUIDDocId
    extends DocId {
        private final long lsb;
        private final long msb;
        private ForeignSegmentDocId doc;

        UUIDDocId(String uuid) {
            UUID tmp = UUID.fromString(uuid);
            this.lsb = tmp.getLeastSignificantBits();
            this.msb = tmp.getMostSignificantBits();
        }

        @Override
        int getDocumentNumber(MultiIndexReader reader) throws IOException {
            int realDoc = -1;
            ForeignSegmentDocId segDocId = this.doc;
            if (segDocId != null) {
                realDoc = reader.getDocumentNumber(segDocId);
            }
            if (realDoc == -1 && (segDocId = reader.createDocId(new UUID(this.msb, this.lsb))) != null) {
                realDoc = reader.getDocumentNumber(segDocId);
                this.doc = segDocId;
            }
            return realDoc;
        }

        @Override
        DocId applyOffset(int offset) {
            return this;
        }

        @Override
        boolean isValid(BitSet deleted) {
            return true;
        }

        public String toString() {
            return "UUIDDocId(" + new UUID(this.msb, this.lsb) + ")";
        }
    }

    private static final class PlainDocId
    extends DocId {
        private final int docNumber;

        PlainDocId(int docNumber) {
            this.docNumber = docNumber;
        }

        @Override
        int getDocumentNumber(MultiIndexReader reader) {
            return this.docNumber;
        }

        @Override
        DocId applyOffset(int offset) {
            return new PlainDocId(this.docNumber + offset);
        }

        @Override
        boolean isValid(BitSet deleted) {
            return !deleted.get(this.docNumber);
        }

        public String toString() {
            return "PlainDocId(" + this.docNumber + ")";
        }
    }
}

