/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.query.lucene;

import com.kingdee.bos.ctrl.common.util.CommonSLF4JLogger;
import com.kingdee.bos.ctrl.lucene.analysis.Analyzer;
import com.kingdee.bos.ctrl.lucene.index.Term;
import com.kingdee.bos.ctrl.lucene.search.BooleanClause;
import com.kingdee.bos.ctrl.lucene.search.BooleanQuery;
import com.kingdee.bos.ctrl.lucene.search.Query;
import com.kingdee.bos.ctrl.lucene.search.TermQuery;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Iterator;
import java.util.List;
import javax.jcr.NamespaceException;
import javax.jcr.RepositoryException;
import javax.jcr.nodetype.NodeType;
import javax.jcr.nodetype.NodeTypeIterator;
import javax.jcr.nodetype.NodeTypeManager;
import javax.jcr.query.InvalidQueryException;
import org.apache.jackrabbit.core.HierarchyManager;
import org.apache.jackrabbit.core.HierarchyManagerImpl;
import org.apache.jackrabbit.core.NodeId;
import org.apache.jackrabbit.core.NodeImpl;
import org.apache.jackrabbit.core.SessionImpl;
import org.apache.jackrabbit.core.query.AndQueryNode;
import org.apache.jackrabbit.core.query.DefaultQueryNodeVisitor;
import org.apache.jackrabbit.core.query.DerefQueryNode;
import org.apache.jackrabbit.core.query.ExactQueryNode;
import org.apache.jackrabbit.core.query.LocationStepQueryNode;
import org.apache.jackrabbit.core.query.NodeTypeQueryNode;
import org.apache.jackrabbit.core.query.NotQueryNode;
import org.apache.jackrabbit.core.query.OrQueryNode;
import org.apache.jackrabbit.core.query.OrderQueryNode;
import org.apache.jackrabbit.core.query.PathQueryNode;
import org.apache.jackrabbit.core.query.PropertyFunctionQueryNode;
import org.apache.jackrabbit.core.query.PropertyTypeRegistry;
import org.apache.jackrabbit.core.query.QueryNode;
import org.apache.jackrabbit.core.query.QueryNodeVisitor;
import org.apache.jackrabbit.core.query.QueryRootNode;
import org.apache.jackrabbit.core.query.RelationQueryNode;
import org.apache.jackrabbit.core.query.TextsearchQueryNode;
import org.apache.jackrabbit.core.query.lucene.CaseTermQuery;
import org.apache.jackrabbit.core.query.lucene.ChildAxisQuery;
import org.apache.jackrabbit.core.query.lucene.DateField;
import org.apache.jackrabbit.core.query.lucene.DerefQuery;
import org.apache.jackrabbit.core.query.lucene.DescendantSelfAxisQuery;
import org.apache.jackrabbit.core.query.lucene.DoubleField;
import org.apache.jackrabbit.core.query.lucene.FieldNames;
import org.apache.jackrabbit.core.query.lucene.IndexFormatVersion;
import org.apache.jackrabbit.core.query.lucene.LongField;
import org.apache.jackrabbit.core.query.lucene.MatchAllQuery;
import org.apache.jackrabbit.core.query.lucene.NamePathResolverImpl;
import org.apache.jackrabbit.core.query.lucene.NamespaceMappings;
import org.apache.jackrabbit.core.query.lucene.NotQuery;
import org.apache.jackrabbit.core.query.lucene.ParentAxisQuery;
import org.apache.jackrabbit.core.query.lucene.RangeQuery;
import org.apache.jackrabbit.core.query.lucene.SimilarityQuery;
import org.apache.jackrabbit.core.query.lucene.SynonymProvider;
import org.apache.jackrabbit.core.query.lucene.WildcardQuery;
import org.apache.jackrabbit.core.query.lucene.fulltext.ParseException;
import org.apache.jackrabbit.core.query.lucene.fulltext.QueryParser;
import org.apache.jackrabbit.core.state.ItemStateManager;
import org.apache.jackrabbit.spi.Name;
import org.apache.jackrabbit.spi.Path;
import org.apache.jackrabbit.spi.commons.conversion.MalformedPathException;
import org.apache.jackrabbit.spi.commons.conversion.NameException;
import org.apache.jackrabbit.spi.commons.conversion.NamePathResolver;
import org.apache.jackrabbit.spi.commons.name.NameConstants;
import org.apache.jackrabbit.spi.commons.name.PathBuilder;
import org.apache.jackrabbit.util.ISO8601;
import org.apache.jackrabbit.util.ISO9075;
import org.apache.jackrabbit.util.XMLChar;
import org.slf4j.Logger;

public class LuceneQueryBuilder
implements QueryNodeVisitor {
    private static final Logger log = CommonSLF4JLogger.getLogger(LuceneQueryBuilder.class);
    private QueryRootNode root;
    private SessionImpl session;
    private ItemStateManager sharedItemMgr;
    private HierarchyManager hmgr;
    private NamespaceMappings nsMappings;
    private NamePathResolver resolver;
    private Analyzer analyzer;
    private PropertyTypeRegistry propRegistry;
    private SynonymProvider synonymProvider;
    private IndexFormatVersion indexFormatVersion;
    private List exceptions = new ArrayList();

    private LuceneQueryBuilder(QueryRootNode root, SessionImpl session, ItemStateManager sharedItemMgr, HierarchyManager hmgr, NamespaceMappings nsMappings, Analyzer analyzer, PropertyTypeRegistry propReg, SynonymProvider synonymProvider, IndexFormatVersion indexFormatVersion) {
        this.root = root;
        this.session = session;
        this.sharedItemMgr = sharedItemMgr;
        this.hmgr = hmgr;
        this.nsMappings = nsMappings;
        this.analyzer = analyzer;
        this.propRegistry = propReg;
        this.synonymProvider = synonymProvider;
        this.indexFormatVersion = indexFormatVersion;
        this.resolver = NamePathResolverImpl.create(nsMappings);
    }

    public static Query createQuery(QueryRootNode root, SessionImpl session, ItemStateManager sharedItemMgr, NamespaceMappings nsMappings, Analyzer analyzer, PropertyTypeRegistry propReg, SynonymProvider synonymProvider, IndexFormatVersion indexFormatVersion) throws RepositoryException {
        NodeId id = ((NodeImpl)session.getRootNode()).getNodeId();
        HierarchyManagerImpl hmgr = new HierarchyManagerImpl(id, sharedItemMgr, session);
        LuceneQueryBuilder builder = new LuceneQueryBuilder(root, session, sharedItemMgr, hmgr, nsMappings, analyzer, propReg, synonymProvider, indexFormatVersion);
        Query q = builder.createLuceneQuery();
        if (builder.exceptions.size() > 0) {
            StringBuffer msg = new StringBuffer();
            Iterator it = builder.exceptions.iterator();
            while (it.hasNext()) {
                msg.append(it.next().toString()).append('\n');
            }
            throw new RepositoryException("Exception building query: " + msg.toString());
        }
        return q;
    }

    private Query createLuceneQuery() {
        return (Query)this.root.accept(this, null);
    }

    @Override
    public Object visit(QueryRootNode node, Object data) {
        BooleanQuery root;
        Query wrapped = root = new BooleanQuery();
        if (node.getLocationNode() != null) {
            wrapped = (Query)node.getLocationNode().accept(this, root);
        }
        return wrapped;
    }

    @Override
    public Object visit(OrQueryNode node, Object data) {
        BooleanQuery orQuery = new BooleanQuery();
        Object[] result = node.acceptOperands(this, null);
        for (int i = 0; i < result.length; ++i) {
            Query operand = (Query)result[i];
            orQuery.add(operand, BooleanClause.Occur.SHOULD);
        }
        return orQuery;
    }

    @Override
    public Object visit(AndQueryNode node, Object data) {
        Object[] result = node.acceptOperands(this, null);
        if (result.length == 0) {
            return null;
        }
        BooleanQuery andQuery = new BooleanQuery();
        for (int i = 0; i < result.length; ++i) {
            Query operand = (Query)result[i];
            andQuery.add(operand, BooleanClause.Occur.MUST);
        }
        return andQuery;
    }

    @Override
    public Object visit(NotQueryNode node, Object data) {
        Object[] result = node.acceptOperands(this, null);
        if (result.length == 0) {
            return data;
        }
        BooleanQuery b = new BooleanQuery();
        for (int i = 0; i < result.length; ++i) {
            b.add((Query)result[i], BooleanClause.Occur.SHOULD);
        }
        return new NotQuery(b);
    }

    @Override
    public Object visit(ExactQueryNode node, Object data) {
        String field = "";
        String value = "";
        try {
            field = this.resolver.getJCRName(node.getPropertyName());
            value = this.resolver.getJCRName(node.getValue());
        }
        catch (NamespaceException namespaceException) {
            // empty catch block
        }
        return new TermQuery(new Term(FieldNames.PROPERTIES, FieldNames.createNamedValue(field, value)));
    }

    @Override
    public Object visit(NodeTypeQueryNode node, Object data) {
        ArrayList<Term> terms = new ArrayList<Term>();
        try {
            Term t;
            String mixinTypesField = this.resolver.getJCRName(NameConstants.JCR_MIXINTYPES);
            String primaryTypeField = this.resolver.getJCRName(NameConstants.JCR_PRIMARYTYPE);
            NodeTypeManager ntMgr = this.session.getWorkspace().getNodeTypeManager();
            NodeType base = ntMgr.getNodeType(this.session.getJCRName(node.getValue()));
            if (base.isMixin()) {
                t = new Term(FieldNames.PROPERTIES, FieldNames.createNamedValue(mixinTypesField, this.resolver.getJCRName(node.getValue())));
                terms.add(t);
            } else {
                t = new Term(FieldNames.PROPERTIES, FieldNames.createNamedValue(primaryTypeField, this.resolver.getJCRName(node.getValue())));
                terms.add(t);
            }
            NodeTypeIterator allTypes = ntMgr.getAllNodeTypes();
            while (allTypes.hasNext()) {
                NodeType nt = allTypes.nextNodeType();
                NodeType[] superTypes = nt.getSupertypes();
                if (!Arrays.asList(superTypes).contains(base)) continue;
                Name n = this.session.getQName(nt.getName());
                String ntName = this.nsMappings.translatePropertyName(n);
                Term t2 = nt.isMixin() ? new Term(FieldNames.PROPERTIES, FieldNames.createNamedValue(mixinTypesField, ntName)) : new Term(FieldNames.PROPERTIES, FieldNames.createNamedValue(primaryTypeField, ntName));
                terms.add(t2);
            }
        }
        catch (NameException e) {
            this.exceptions.add(e);
        }
        catch (RepositoryException e) {
            this.exceptions.add(e);
        }
        if (terms.size() == 0) {
            return new BooleanQuery();
        }
        if (terms.size() == 1) {
            return new TermQuery((Term)terms.get(0));
        }
        BooleanQuery b = new BooleanQuery();
        Iterator it = terms.iterator();
        while (it.hasNext()) {
            b.add(new TermQuery((Term)it.next()), BooleanClause.Occur.SHOULD);
        }
        return b;
    }

    @Override
    public Object visit(TextsearchQueryNode node, Object data) {
        try {
            String fieldname;
            Path relPath = node.getRelativePath();
            if (relPath == null || !node.getReferencesProperty()) {
                fieldname = FieldNames.FULLTEXT;
            } else {
                Name propName = relPath.getNameElement().getName();
                StringBuffer tmp = new StringBuffer();
                tmp.append(this.nsMappings.getPrefix(propName.getNamespaceURI()));
                tmp.append(":").append("FULL:");
                tmp.append(propName.getLocalName());
                fieldname = tmp.toString();
            }
            QueryParser parser = new QueryParser(fieldname, this.analyzer, this.synonymProvider);
            parser.setOperator(1);
            StringBuffer query = new StringBuffer();
            String textsearch = node.getQuery();
            textsearch = textsearch.replaceAll("AND", "and");
            textsearch = textsearch.replaceAll("NOT", "not");
            boolean escaped = false;
            for (int i = 0; i < textsearch.length(); ++i) {
                if (textsearch.charAt(i) == '\\') {
                    if (escaped) {
                        query.append("\\\\");
                        escaped = false;
                        continue;
                    }
                    escaped = true;
                    continue;
                }
                if (textsearch.charAt(i) == '\'') {
                    if (escaped) {
                        escaped = false;
                    }
                    query.append(textsearch.charAt(i));
                    continue;
                }
                if (escaped) {
                    query.append('\\');
                    escaped = false;
                }
                query.append(textsearch.charAt(i));
            }
            Query context = parser.parse(query.toString());
            if (!(relPath == null || node.getReferencesProperty() && relPath.getLength() <= 1)) {
                Path.Element[] elements = relPath.getElements();
                for (int i = elements.length - 1; i >= 0; --i) {
                    String name = null;
                    if (!elements[i].getName().equals(RelationQueryNode.STAR_NAME_TEST)) {
                        name = this.resolver.getJCRName(elements[i].getName());
                    }
                    if (name != null && (node.getReferencesProperty() && i == elements.length - 2 || !node.getReferencesProperty() && i == elements.length - 1)) {
                        TermQuery q = new TermQuery(new Term(FieldNames.LABEL, name));
                        BooleanQuery and = new BooleanQuery();
                        and.add(q, BooleanClause.Occur.MUST);
                        and.add(context, BooleanClause.Occur.MUST);
                        context = and;
                        continue;
                    }
                    if ((!node.getReferencesProperty() || i >= elements.length - 2) && (node.getReferencesProperty() || i >= elements.length - 1)) continue;
                    context = new ParentAxisQuery(context, name);
                }
                context = new ParentAxisQuery(context, null);
            }
            return context;
        }
        catch (NamespaceException e) {
            this.exceptions.add(e);
        }
        catch (ParseException e) {
            this.exceptions.add(e);
        }
        return null;
    }

    @Override
    public Object visit(PathQueryNode node, Object data) {
        BooleanQuery constraint;
        Query context = null;
        LocationStepQueryNode[] steps = node.getPathSteps();
        if (steps.length > 0) {
            if (node.isAbsolute() && !steps[0].getIncludeDescendants()) {
                Name nameTest = steps[0].getNameTest();
                if (nameTest == null) {
                    context = new TermQuery(new Term(FieldNames.PARENT, ""));
                } else if (nameTest.getLocalName().length() == 0) {
                    context = new TermQuery(new Term(FieldNames.PARENT, ""));
                } else {
                    String name = "";
                    try {
                        name = this.resolver.getJCRName(nameTest);
                    }
                    catch (NamespaceException e) {
                        this.exceptions.add(e);
                    }
                    BooleanQuery and = new BooleanQuery();
                    and.add(new TermQuery(new Term(FieldNames.PARENT, "")), BooleanClause.Occur.MUST);
                    and.add(new TermQuery(new Term(FieldNames.LABEL, name)), BooleanClause.Occur.MUST);
                    context = and;
                }
                LocationStepQueryNode[] tmp = new LocationStepQueryNode[steps.length - 1];
                System.arraycopy(steps, 1, tmp, 0, steps.length - 1);
                steps = tmp;
            } else {
                context = new TermQuery(new Term(FieldNames.PARENT, ""));
            }
        } else {
            this.exceptions.add(new InvalidQueryException("Number of location steps must be > 0"));
        }
        for (int i = 0; i < steps.length; ++i) {
            context = (Query)steps[i].accept(this, context);
        }
        if (data instanceof BooleanQuery && (constraint = (BooleanQuery)data).getClauses().length > 0) {
            constraint.add(context, BooleanClause.Occur.MUST);
            context = constraint;
        }
        return context;
    }

    @Override
    public Object visit(LocationStepQueryNode node, Object data) {
        Query context = (Query)data;
        BooleanQuery andQuery = new BooleanQuery();
        if (context == null) {
            this.exceptions.add(new IllegalArgumentException("Unsupported query"));
        }
        Object[] predicates = node.acceptOperands(this, data);
        for (int i = 0; i < predicates.length; ++i) {
            andQuery.add((Query)predicates[i], BooleanClause.Occur.MUST);
        }
        QueryNode[] pred = node.getPredicates();
        for (int i = 0; i < pred.length; ++i) {
            RelationQueryNode pos;
            if (pred[i].getType() != 2 || (pos = (RelationQueryNode)pred[i]).getValueType() != 6) continue;
            node.setIndex(pos.getPositionValue());
        }
        TermQuery nameTest = null;
        if (node.getNameTest() != null) {
            try {
                String internalName = this.resolver.getJCRName(node.getNameTest());
                nameTest = new TermQuery(new Term(FieldNames.LABEL, internalName));
            }
            catch (NamespaceException e) {
                this.exceptions.add(e);
            }
        }
        if (node.getIncludeDescendants()) {
            if (nameTest != null) {
                andQuery.add(new DescendantSelfAxisQuery(context, nameTest), BooleanClause.Occur.MUST);
            } else if (predicates.length > 0) {
                PathQueryNode pathNode = (PathQueryNode)node.getParent();
                if (pathNode.getPathSteps()[0] != node) {
                    DescendantSelfAxisQuery subQuery2 = new DescendantSelfAxisQuery(context, andQuery, false);
                    andQuery = new BooleanQuery();
                    andQuery.add(subQuery2, BooleanClause.Occur.MUST);
                }
            } else {
                Query subQuery = null;
                try {
                    subQuery = this.createMatchAllQuery(this.resolver.getJCRName(NameConstants.JCR_PRIMARYTYPE));
                }
                catch (NamespaceException subQuery2) {
                    // empty catch block
                }
                PathQueryNode pathNode = (PathQueryNode)node.getParent();
                if (pathNode.getPathSteps()[0] != node) {
                    context = new DescendantSelfAxisQuery(context, subQuery);
                    andQuery.add(new ChildAxisQuery(this.sharedItemMgr, context, null, node.getIndex()), BooleanClause.Occur.MUST);
                } else {
                    andQuery.add(subQuery, BooleanClause.Occur.MUST);
                }
            }
        } else if (nameTest != null) {
            andQuery.add(new ChildAxisQuery(this.sharedItemMgr, context, nameTest.getTerm().text(), node.getIndex()), BooleanClause.Occur.MUST);
        } else {
            andQuery.add(new ChildAxisQuery(this.sharedItemMgr, context, null, node.getIndex()), BooleanClause.Occur.MUST);
        }
        return andQuery;
    }

    @Override
    public Object visit(DerefQueryNode node, Object data) {
        Query context = (Query)data;
        if (context == null) {
            this.exceptions.add(new IllegalArgumentException("Unsupported query"));
        }
        try {
            String refProperty = this.resolver.getJCRName(node.getRefProperty());
            String nameTest = null;
            if (node.getNameTest() != null) {
                nameTest = this.resolver.getJCRName(node.getNameTest());
            }
            if (node.getIncludeDescendants()) {
                Query refPropQuery = this.createMatchAllQuery(refProperty);
                context = new DescendantSelfAxisQuery(context, refPropQuery, false);
            }
            context = new DerefQuery(context, refProperty, nameTest);
            Object[] predicates = node.acceptOperands(this, data);
            if (predicates.length > 0) {
                BooleanQuery andQuery = new BooleanQuery();
                for (int i = 0; i < predicates.length; ++i) {
                    andQuery.add((Query)predicates[i], BooleanClause.Occur.MUST);
                }
                andQuery.add(context, BooleanClause.Occur.MUST);
                context = andQuery;
            }
        }
        catch (NamespaceException e) {
            this.exceptions.add(e);
        }
        return context;
    }

    @Override
    public Object visit(RelationQueryNode node, Object data) {
        Query query;
        String[] stringValues = new String[1];
        switch (node.getValueType()) {
            case 0: {
                break;
            }
            case 4: {
                stringValues[0] = DateField.dateToString(node.getDateValue());
                break;
            }
            case 2: {
                stringValues[0] = DoubleField.doubleToString(node.getDoubleValue());
                break;
            }
            case 1: {
                stringValues[0] = LongField.longToString(node.getLongValue());
                break;
            }
            case 3: {
                if (node.getOperation() == 12 || node.getOperation() == 11 || node.getOperation() == 14 || node.getOperation() == 13) {
                    Name propertyName = node.getRelativePath().getNameElement().getName();
                    stringValues = this.getStringValues(propertyName, node.getStringValue());
                    break;
                }
                stringValues[0] = node.getStringValue();
                break;
            }
            case 6: {
                return null;
            }
            default: {
                throw new IllegalArgumentException("Unknown relation type: " + node.getValueType());
            }
        }
        if (node.getRelativePath() == null && node.getOperation() != 28 && node.getOperation() != 29) {
            this.exceptions.add(new InvalidQueryException("@* not supported in predicate"));
            return data;
        }
        final int[] transform = new int[]{0};
        node.acceptOperands(new DefaultQueryNodeVisitor(){

            @Override
            public Object visit(PropertyFunctionQueryNode node, Object data) {
                if (node.getFunctionName().equals("lower-case")) {
                    transform[0] = 1;
                } else if (node.getFunctionName().equals("upper-case")) {
                    transform[0] = 2;
                }
                return data;
            }
        }, null);
        Path relPath = node.getRelativePath();
        if (node.getOperation() == 28) {
            PathBuilder builder = relPath == null ? new PathBuilder() : new PathBuilder(relPath);
            builder.addLast(NameConstants.JCR_PRIMARYTYPE);
            try {
                relPath = builder.getPath();
            }
            catch (MalformedPathException malformedPathException) {
                // empty catch block
            }
        }
        String field = "";
        try {
            field = this.resolver.getJCRName(relPath.getNameElement().getName());
        }
        catch (NamespaceException e) {
            this.exceptions.add(e);
        }
        Name propName = relPath.getNameElement().getName();
        if (propName.getNamespaceURI().equals("http://www.w3.org/2005/xpath-functions") && propName.getLocalName().equals("name()")) {
            if (node.getValueType() != 3) {
                this.exceptions.add(new InvalidQueryException("Name function can only be used in conjunction with a string literal"));
                return data;
            }
            if (node.getOperation() != 11 && node.getOperation() != 12) {
                this.exceptions.add(new InvalidQueryException("Name function can only be used in conjunction with an equals operator"));
                return data;
            }
            if (XMLChar.isValidName(node.getStringValue())) {
                try {
                    Name n = this.session.getQName(ISO9075.decode(node.getStringValue()));
                    String translatedQName = this.nsMappings.translatePropertyName(n);
                    Term t = new Term(FieldNames.LABEL, translatedQName);
                    query = new TermQuery(t);
                }
                catch (NameException e) {
                    this.exceptions.add(e);
                    return data;
                }
                catch (NamespaceException e) {
                    this.exceptions.add(e);
                    return data;
                }
            } else {
                query = new TermQuery(new Term(FieldNames.UUID, "x"));
            }
        } else {
            switch (node.getOperation()) {
                case 11: 
                case 12: {
                    BooleanQuery or = new BooleanQuery();
                    for (int i = 0; i < stringValues.length; ++i) {
                        Term t = new Term(FieldNames.PROPERTIES, FieldNames.createNamedValue(field, stringValues[i]));
                        Query q = transform[0] == 2 ? new CaseTermQuery.Upper(t) : (transform[0] == 1 ? new CaseTermQuery.Lower(t) : new TermQuery(t));
                        or.add(q, BooleanClause.Occur.SHOULD);
                    }
                    query = or;
                    if (node.getOperation() != 11) break;
                    query = this.createSingleValueConstraint(or, field);
                    break;
                }
                case 19: 
                case 20: {
                    Term upper;
                    BooleanQuery or = new BooleanQuery();
                    for (int i = 0; i < stringValues.length; ++i) {
                        Term lower = new Term(FieldNames.PROPERTIES, FieldNames.createNamedValue(field, stringValues[i]));
                        upper = new Term(FieldNames.PROPERTIES, FieldNames.createNamedValue(field, "\uffff"));
                        or.add(new RangeQuery(lower, upper, true, transform[0]), BooleanClause.Occur.SHOULD);
                    }
                    query = or;
                    if (node.getOperation() != 19) break;
                    query = this.createSingleValueConstraint(or, field);
                    break;
                }
                case 17: 
                case 18: {
                    Term upper;
                    BooleanQuery or = new BooleanQuery();
                    for (int i = 0; i < stringValues.length; ++i) {
                        Term lower = new Term(FieldNames.PROPERTIES, FieldNames.createNamedValue(field, stringValues[i]));
                        upper = new Term(FieldNames.PROPERTIES, FieldNames.createNamedValue(field, "\uffff"));
                        or.add(new RangeQuery(lower, upper, false, transform[0]), BooleanClause.Occur.SHOULD);
                    }
                    query = or;
                    if (node.getOperation() != 17) break;
                    query = this.createSingleValueConstraint(or, field);
                    break;
                }
                case 21: 
                case 22: {
                    Term upper;
                    BooleanQuery or = new BooleanQuery();
                    for (int i = 0; i < stringValues.length; ++i) {
                        Term lower = new Term(FieldNames.PROPERTIES, FieldNames.createNamedValue(field, ""));
                        upper = new Term(FieldNames.PROPERTIES, FieldNames.createNamedValue(field, stringValues[i]));
                        or.add(new RangeQuery(lower, upper, true, transform[0]), BooleanClause.Occur.SHOULD);
                    }
                    query = or;
                    if (node.getOperation() != 21) break;
                    query = this.createSingleValueConstraint(query, field);
                    break;
                }
                case 23: {
                    if (stringValues[0].equals("%")) {
                        query = this.createMatchAllQuery(field);
                        break;
                    }
                    query = new WildcardQuery(FieldNames.PROPERTIES, field, stringValues[0], transform[0]);
                    break;
                }
                case 15: 
                case 16: {
                    Term upper;
                    BooleanQuery or = new BooleanQuery();
                    for (int i = 0; i < stringValues.length; ++i) {
                        Term lower = new Term(FieldNames.PROPERTIES, FieldNames.createNamedValue(field, ""));
                        upper = new Term(FieldNames.PROPERTIES, FieldNames.createNamedValue(field, stringValues[i]));
                        or.add(new RangeQuery(lower, upper, false, transform[0]), BooleanClause.Occur.SHOULD);
                    }
                    query = or;
                    if (node.getOperation() != 15) break;
                    query = this.createSingleValueConstraint(or, field);
                    break;
                }
                case 13: {
                    Term t;
                    BooleanQuery notQuery = new BooleanQuery();
                    notQuery.add(this.createMatchAllQuery(field), BooleanClause.Occur.SHOULD);
                    for (int i = 0; i < stringValues.length; ++i) {
                        t = new Term(FieldNames.PROPERTIES, FieldNames.createNamedValue(field, stringValues[i]));
                        Query q = transform[0] == 2 ? new CaseTermQuery.Upper(t) : (transform[0] == 1 ? new CaseTermQuery.Lower(t) : new TermQuery(t));
                        notQuery.add(q, BooleanClause.Occur.MUST_NOT);
                    }
                    notQuery.add(new TermQuery(new Term(FieldNames.MVP, field)), BooleanClause.Occur.MUST_NOT);
                    query = notQuery;
                    break;
                }
                case 14: {
                    Term t;
                    BooleanQuery notQuery = new BooleanQuery();
                    notQuery.add(this.createMatchAllQuery(field), BooleanClause.Occur.SHOULD);
                    for (int i = 0; i < stringValues.length; ++i) {
                        t = new Term(FieldNames.PROPERTIES, FieldNames.createNamedValue(field, stringValues[i]));
                        NotQuery svp = new NotQuery(new TermQuery(new Term(FieldNames.MVP, field)));
                        BooleanQuery and = new BooleanQuery();
                        Query q = transform[0] == 2 ? new CaseTermQuery.Upper(t) : (transform[0] == 1 ? new CaseTermQuery.Lower(t) : new TermQuery(t));
                        and.add(q, BooleanClause.Occur.MUST);
                        and.add(svp, BooleanClause.Occur.MUST);
                        notQuery.add(and, BooleanClause.Occur.MUST_NOT);
                    }
                    query = notQuery;
                    break;
                }
                case 26: {
                    query = new NotQuery(this.createMatchAllQuery(field));
                    break;
                }
                case 28: {
                    String uuid = "x";
                    try {
                        NodeId id = this.hmgr.resolveNodePath(this.session.getQPath(node.getStringValue()));
                        if (id != null) {
                            uuid = id.getUUID().toString();
                        }
                    }
                    catch (Exception e) {
                        this.exceptions.add(e);
                    }
                    query = new SimilarityQuery(uuid, this.analyzer);
                    break;
                }
                case 27: {
                    query = this.createMatchAllQuery(field);
                    break;
                }
                case 29: {
                    query = this.createMatchAllQuery(field);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown relation operation: " + node.getOperation());
                }
            }
        }
        if (relPath.getLength() > 1) {
            try {
                Path.Element[] elements = relPath.getElements();
                for (int i = elements.length - 2; i >= 0; --i) {
                    String name = null;
                    if (!elements[i].getName().equals(RelationQueryNode.STAR_NAME_TEST)) {
                        name = this.resolver.getJCRName(elements[i].getName());
                    }
                    if (i == elements.length - 2) {
                        if (name == null) continue;
                        TermQuery nameTest = new TermQuery(new Term(FieldNames.LABEL, name));
                        BooleanQuery and = new BooleanQuery();
                        and.add(query, BooleanClause.Occur.MUST);
                        and.add(nameTest, BooleanClause.Occur.MUST);
                        query = and;
                        continue;
                    }
                    query = new ParentAxisQuery(query, name);
                }
            }
            catch (NamespaceException e) {
                this.exceptions.add(e);
            }
            query = new ParentAxisQuery(query, null);
        }
        return query;
    }

    @Override
    public Object visit(OrderQueryNode node, Object data) {
        return data;
    }

    @Override
    public Object visit(PropertyFunctionQueryNode node, Object data) {
        return data;
    }

    private Query createSingleValueConstraint(Query q, String propName) {
        TermQuery mvp = new TermQuery(new Term(FieldNames.MVP, propName));
        NotQuery svp = new NotQuery(mvp);
        BooleanQuery and = new BooleanQuery();
        and.add(q, BooleanClause.Occur.MUST);
        and.add(svp, BooleanClause.Occur.MUST);
        return and;
    }

    private String[] getStringValues(Name propertyName, String literal) {
        PropertyTypeRegistry.TypeMapping[] types = this.propRegistry.getPropertyTypes(propertyName);
        ArrayList<String> values = new ArrayList<String>();
        block26: for (int i = 0; i < types.length; ++i) {
            switch (types[i].type) {
                case 7: {
                    try {
                        Name n = this.session.getQName(literal);
                        values.add(this.nsMappings.translatePropertyName(n));
                        log.debug("Coerced " + literal + " into NAME.");
                    }
                    catch (NameException e) {
                        log.warn("Unable to coerce '" + literal + "' into a NAME: " + e.toString());
                    }
                    catch (NamespaceException e) {
                        log.warn("Unable to coerce '" + literal + "' into a NAME: " + e.toString());
                    }
                    continue block26;
                }
                case 8: {
                    try {
                        Path p = this.session.getQPath(literal);
                        values.add(this.resolver.getJCRPath(p));
                        log.debug("Coerced " + literal + " into PATH.");
                    }
                    catch (NameException e) {
                        log.warn("Unable to coerce '" + literal + "' into a PATH: " + e.toString());
                    }
                    catch (NamespaceException e) {
                        log.warn("Unable to coerce '" + literal + "' into a PATH: " + e.toString());
                    }
                    continue block26;
                }
                case 5: {
                    Calendar c = ISO8601.parse(literal);
                    if (c != null) {
                        values.add(DateField.timeToString(c.getTimeInMillis()));
                        log.debug("Coerced " + literal + " into DATE.");
                        continue block26;
                    }
                    log.warn("Unable to coerce '" + literal + "' into a DATE.");
                    continue block26;
                }
                case 4: {
                    try {
                        double d = Double.parseDouble(literal);
                        values.add(DoubleField.doubleToString(d));
                        log.debug("Coerced " + literal + " into DOUBLE.");
                    }
                    catch (NumberFormatException e) {
                        log.warn("Unable to coerce '" + literal + "' into a DOUBLE: " + e.toString());
                    }
                    continue block26;
                }
                case 3: {
                    try {
                        long l = Long.parseLong(literal);
                        values.add(LongField.longToString(l));
                        log.debug("Coerced " + literal + " into LONG.");
                    }
                    catch (NumberFormatException e) {
                        log.warn("Unable to coerce '" + literal + "' into a LONG: " + e.toString());
                    }
                    continue block26;
                }
                case 1: {
                    values.add(literal);
                    log.debug("Using literal " + literal + " as is.");
                }
            }
        }
        if (values.size() == 0) {
            values.add(literal);
            if (literal.indexOf(47) > -1) {
                try {
                    values.add(this.resolver.getJCRPath(this.session.getQPath(literal)));
                    log.debug("Coerced " + literal + " into PATH.");
                }
                catch (Exception i) {
                    // empty catch block
                }
            }
            if (XMLChar.isValidName(literal)) {
                try {
                    Name n = this.session.getQName(literal);
                    values.add(this.nsMappings.translatePropertyName(n));
                    log.debug("Coerced " + literal + " into NAME.");
                }
                catch (Exception n) {
                    // empty catch block
                }
            }
            if (literal.indexOf(58) > -1) {
                Calendar c = ISO8601.parse(literal);
                if (c != null) {
                    values.add(DateField.timeToString(c.getTimeInMillis()));
                    log.debug("Coerced " + literal + " into DATE.");
                }
            } else {
                try {
                    values.add(LongField.longToString(Long.parseLong(literal)));
                    log.debug("Coerced " + literal + " into LONG.");
                }
                catch (NumberFormatException e) {
                    try {
                        values.add(DoubleField.doubleToString(Double.parseDouble(literal)));
                        log.debug("Coerced " + literal + " into DOUBLE.");
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
            }
        }
        if (values.size() == 0) {
            values.add(literal);
            log.debug("Using literal " + literal + " as is.");
        }
        return values.toArray(new String[values.size()]);
    }

    private final Query createMatchAllQuery(String field) {
        if (this.indexFormatVersion.getVersion() >= IndexFormatVersion.V2.getVersion()) {
            return new TermQuery(new Term(FieldNames.PROPERTIES_SET, field));
        }
        return new MatchAllQuery(field);
    }
}

