/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.query.lucene;

import com.kingdee.bos.ctrl.lucene.analysis.Analyzer;
import com.kingdee.bos.ctrl.lucene.index.IndexReader;
import com.kingdee.bos.ctrl.lucene.index.Term;
import com.kingdee.bos.ctrl.lucene.index.TermDocs;
import com.kingdee.bos.ctrl.lucene.search.Query;
import com.kingdee.bos.ctrl.lucene.search.TermQuery;
import java.io.IOException;
import org.apache.jackrabbit.core.query.lucene.FieldNames;
import org.apache.jackrabbit.core.query.lucene.MoreLikeThis;

public class SimilarityQuery
extends Query {
    private final String uuid;
    private final Analyzer analyzer;

    public SimilarityQuery(String uuid, Analyzer analyzer) {
        this.uuid = uuid;
        this.analyzer = analyzer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Query rewrite(IndexReader reader) throws IOException {
        MoreLikeThis more = new MoreLikeThis(reader);
        more.setAnalyzer(this.analyzer);
        more.setFieldNames(new String[]{FieldNames.FULLTEXT});
        more.setMinWordLen(4);
        Query similarityQuery = null;
        try (TermDocs td = reader.termDocs(new Term(FieldNames.UUID, this.uuid));){
            if (td.next()) {
                similarityQuery = more.like(td.doc());
            }
        }
        if (similarityQuery != null) {
            return similarityQuery.rewrite(reader);
        }
        return new TermQuery(new Term(FieldNames.UUID, "x"));
    }

    @Override
    public String toString(String field) {
        return "rep:similar(" + this.uuid + ")";
    }
}

