/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.query.lucene;

import com.kingdee.bos.ctrl.common.util.CommonSLF4JLogger;
import com.kingdee.bos.ctrl.lucene.index.IndexReader;
import com.kingdee.bos.ctrl.lucene.index.Term;
import com.kingdee.bos.ctrl.lucene.index.TermDocs;
import com.kingdee.bos.ctrl.lucene.index.TermEnum;
import com.kingdee.bos.ctrl.lucene.search.BooleanQuery;
import com.kingdee.bos.ctrl.lucene.search.Explanation;
import com.kingdee.bos.ctrl.lucene.search.FilteredTermEnum;
import com.kingdee.bos.ctrl.lucene.search.MultiTermQuery;
import com.kingdee.bos.ctrl.lucene.search.Query;
import com.kingdee.bos.ctrl.lucene.search.Scorer;
import com.kingdee.bos.ctrl.lucene.search.Searcher;
import com.kingdee.bos.ctrl.lucene.search.Similarity;
import com.kingdee.bos.ctrl.lucene.search.Weight;
import java.io.IOException;
import java.util.BitSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.jackrabbit.core.query.lucene.AbstractWeight;
import org.apache.jackrabbit.core.query.lucene.FieldNames;
import org.apache.jackrabbit.core.query.lucene.PerQueryCache;
import org.apache.jackrabbit.core.query.lucene.Transformable;
import org.apache.jackrabbit.core.query.lucene.WildcardTermEnum;
import org.slf4j.Logger;

public class WildcardQuery
extends Query
implements Transformable {
    private static final Logger log = CommonSLF4JLogger.getLogger(WildcardQuery.class);
    private final String field;
    private final String propName;
    private final String pattern;
    private int transform = 0;
    private Query multiTermQuery;

    public WildcardQuery(String field, String propName, String pattern, int transform) {
        this.field = field.intern();
        this.propName = propName;
        this.pattern = pattern;
        this.transform = transform;
    }

    public WildcardQuery(String field, String propName, String pattern) {
        this(field, propName, pattern, 0);
    }

    @Override
    public void setTransformation(int transformation) {
        this.transform = transformation;
    }

    @Override
    public Query rewrite(IndexReader reader) throws IOException {
        MultiTermQuery stdWildcardQuery = new MultiTermQuery(new Term(FieldNames.PROPERTIES, this.pattern)){

            @Override
            protected FilteredTermEnum getEnum(IndexReader reader) throws IOException {
                return new WildcardTermEnum(reader, WildcardQuery.this.field, WildcardQuery.this.propName, WildcardQuery.this.pattern, WildcardQuery.this.transform);
            }
        };
        try {
            this.multiTermQuery = ((Query)stdWildcardQuery).rewrite(reader);
            return this.multiTermQuery;
        }
        catch (BooleanQuery.TooManyClauses e) {
            log.debug("Too many terms to enumerate, using custom WildcardQuery.");
            return this;
        }
    }

    @Override
    protected Weight createWeight(Searcher searcher) {
        return new WildcardQueryWeight(searcher);
    }

    @Override
    public String toString(String field) {
        return this.propName + ":" + this.pattern;
    }

    @Override
    public void extractTerms(Set terms) {
        if (this.multiTermQuery != null) {
            this.multiTermQuery.extractTerms(terms);
        }
    }

    private final class WildcardQueryScorer
    extends Scorer {
        private final IndexReader reader;
        private final BitSet hits;
        private boolean hitsCalculated;
        private int nextDoc;
        private final String cacheKey;
        private final Map resultMap;

        WildcardQueryScorer(Similarity similarity, IndexReader reader) {
            super(similarity);
            this.hitsCalculated = false;
            this.nextDoc = -1;
            this.reader = reader;
            this.cacheKey = WildcardQuery.this.field + '\uffff' + WildcardQuery.this.propName + '\uffff' + WildcardQuery.this.transform + '\uffff' + WildcardQuery.this.pattern;
            PerQueryCache cache = PerQueryCache.getInstance();
            HashMap m = (HashMap)cache.get(WildcardQueryScorer.class, reader);
            if (m == null) {
                m = new HashMap();
                cache.put(WildcardQueryScorer.class, reader, m);
            }
            this.resultMap = m;
            BitSet result = (BitSet)this.resultMap.get(this.cacheKey);
            if (result == null) {
                result = new BitSet(reader.maxDoc());
            } else {
                this.hitsCalculated = true;
            }
            this.hits = result;
        }

        @Override
        public boolean next() throws IOException {
            this.calculateHits();
            this.nextDoc = this.hits.nextSetBit(this.nextDoc + 1);
            return this.nextDoc > -1;
        }

        @Override
        public int doc() {
            return this.nextDoc;
        }

        @Override
        public float score() {
            return 1.0f;
        }

        @Override
        public boolean skipTo(int target) throws IOException {
            this.calculateHits();
            this.nextDoc = this.hits.nextSetBit(target);
            return this.nextDoc > -1;
        }

        @Override
        public Explanation explain(int doc) {
            return new Explanation();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void calculateHits() throws IOException {
            if (this.hitsCalculated) {
                return;
            }
            try (WildcardTermEnum terms = new WildcardTermEnum(this.reader, WildcardQuery.this.field, WildcardQuery.this.propName, WildcardQuery.this.pattern, WildcardQuery.this.transform);
                 TermDocs docs = this.reader.termDocs();){
                while (((TermEnum)terms).term() != null) {
                    docs.seek(terms);
                    while (docs.next()) {
                        this.hits.set(docs.doc());
                    }
                    if (((TermEnum)terms).next()) continue;
                    break;
                }
            }
            this.hitsCalculated = true;
            this.resultMap.put(this.cacheKey, this.hits);
        }
    }

    private class WildcardQueryWeight
    extends AbstractWeight {
        public WildcardQueryWeight(Searcher searcher) {
            super(searcher);
        }

        @Override
        protected Scorer createScorer(IndexReader reader) {
            return new WildcardQueryScorer(this.searcher.getSimilarity(), reader);
        }

        @Override
        public Query getQuery() {
            return WildcardQuery.this;
        }

        @Override
        public float getValue() {
            return 1.0f;
        }

        @Override
        public float sumOfSquaredWeights() throws IOException {
            return 1.0f;
        }

        @Override
        public void normalize(float norm) {
        }

        @Override
        public Explanation explain(IndexReader reader, int doc) throws IOException {
            return new Explanation();
        }
    }
}

