/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.name;

import javax.jcr.NamespaceException;
import org.apache.jackrabbit.name.MalformedPathException;
import org.apache.jackrabbit.name.NameException;
import org.apache.jackrabbit.name.NameResolver;
import org.apache.jackrabbit.name.Path;
import org.apache.jackrabbit.name.PathResolver;
import org.apache.jackrabbit.name.QName;

public class ParsingPathResolver
implements PathResolver {
    private final NameResolver resolver;

    public ParsingPathResolver(NameResolver resolver) {
        this.resolver = resolver;
    }

    private Path.PathElement getElement(String path, int begin, int end) throws NameException, NamespaceException {
        if (begin == end) {
            throw new MalformedPathException("Empty path element: " + path);
        }
        if (begin + 1 == end && path.charAt(begin) == '.') {
            return Path.CURRENT_ELEMENT;
        }
        if (begin + 2 == end && path.charAt(begin) == '.' && path.charAt(begin + 1) == '.') {
            return Path.PARENT_ELEMENT;
        }
        if (begin + 3 < end && path.charAt(end - 1) == ']') {
            int index = 0;
            int factor = 1;
            char ch = path.charAt(end -= 2);
            while (begin < end && '0' <= ch && ch <= '9') {
                index += factor * (ch - 48);
                factor *= 10;
                ch = path.charAt(--end);
            }
            if (index == 0 || ch != '[') {
                throw new MalformedPathException("Invalid path index: " + path);
            }
            QName qname = this.resolver.getQName(path.substring(begin, end));
            return Path.PathElement.create(qname, index);
        }
        QName qname = this.resolver.getQName(path.substring(begin, end));
        return Path.PathElement.create(qname);
    }

    @Override
    public Path getQPath(String path) throws NameException, NamespaceException {
        Path.PathBuilder builder = new Path.PathBuilder();
        int length = path.length();
        int position = 0;
        int slash = path.indexOf(47);
        if (slash == 0) {
            builder.addRoot();
            if (length == 1) {
                return builder.getPath();
            }
            position = 1;
            slash = path.indexOf(47, 1);
        }
        while (slash != -1) {
            builder.addLast(this.getElement(path, position, slash));
            position = slash + 1;
            slash = path.indexOf(47, position);
        }
        builder.addLast(this.getElement(path, position, length));
        return builder.getPath();
    }

    @Override
    public String getJCRPath(Path path) throws NamespaceException {
        StringBuffer buffer = new StringBuffer();
        Path.PathElement[] elements = path.getElements();
        for (int i = 0; i < elements.length; ++i) {
            if (i > 0) {
                buffer.append('/');
            }
            if (i == 0 && elements.length == 1 && elements[i].denotesRoot()) {
                buffer.append('/');
                continue;
            }
            if (elements[i].denotesCurrent()) {
                buffer.append('.');
                continue;
            }
            if (elements[i].denotesParent()) {
                buffer.append("..");
                continue;
            }
            buffer.append(this.resolver.getJCRName(elements[i].getName()));
            if (elements[i].getIndex() <= 1) continue;
            buffer.append('[');
            buffer.append(elements[i].getIndex());
            buffer.append(']');
        }
        return buffer.toString();
    }
}

