/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.kdf.form;

import com.kingdee.bos.ctrl.kdf.expr.Variant;
import com.kingdee.bos.ctrl.kdf.form.Area;
import com.kingdee.bos.ctrl.kdf.form.BaseFormBuilder;
import com.kingdee.bos.ctrl.kdf.form.Cell;
import com.kingdee.bos.ctrl.kdf.form.ChartData;
import com.kingdee.bos.ctrl.kdf.form.Column;
import com.kingdee.bos.ctrl.kdf.form.Container;
import com.kingdee.bos.ctrl.kdf.form.Form;
import com.kingdee.bos.ctrl.kdf.form.Layer;
import com.kingdee.bos.ctrl.kdf.form.Page;
import com.kingdee.bos.ctrl.kdf.form.Panel;
import com.kingdee.bos.ctrl.kdf.form.Property;
import com.kingdee.bos.ctrl.kdf.form.Row;
import com.kingdee.bos.ctrl.kdf.form.RuntimeStyleService;
import com.kingdee.bos.ctrl.kdf.form.Table;
import com.kingdee.bos.ctrl.kdf.form2.ui.DivideCharacter;
import com.kingdee.bos.ctrl.kdf.util.Base64;
import com.kingdee.bos.ctrl.kdf.util.file.IXmlTrans;
import com.kingdee.bos.ctrl.kdf.util.file.KDF;
import com.kingdee.bos.ctrl.kdf.util.file.KDFXmlReader;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import java.util.Iterator;
import java.util.List;
import org.jdom2.Content;
import org.jdom2.Element;
import org.jdom2.Namespace;

public final class FormXmlTrans
implements IXmlTrans {
    private static float version = 3.1f;
    private RuntimeStyleService stsvs;
    private boolean snapMode = false;
    private boolean designMode = false;
    private static final byte[] ZEROBYTE = new byte[0];

    @Override
    public Element writeToNode(Object obj, KDF kdf) {
        return this.writeToNode((Form)obj, (RuntimeStyleService)kdf);
    }

    public Element writeToCustomNode(String name, Namespace ns, Container cont, RuntimeStyleService stsvs) {
        if (cont != null) {
            this.stsvs = stsvs;
            Element elem = this.innerWriteToNode(cont);
            if (name != null) {
                elem.setName(name);
            }
            if (ns != null) {
                elem.setNamespace(ns);
            }
            return elem;
        }
        return null;
    }

    public Element writeToNode(Container cont, RuntimeStyleService stsvs) {
        if (cont != null) {
            this.stsvs = stsvs;
            Element elem = this.innerWriteToNode(cont);
            return elem;
        }
        return null;
    }

    protected Element writeToNode(Form fom, RuntimeStyleService stsvs) {
        if (fom != null) {
            Form fm = fom;
            this.stsvs = stsvs;
            Element efm = new Element("Form");
            efm.setAttribute("id", fm.getId());
            if (fm.getUserAlias() != null) {
                efm.setAttribute("alias", fm.getUserAlias());
            }
            if (fm.getHeaderID() != null) {
                efm.setAttribute("headerID", fm.getHeaderID());
            }
            if (fm.getFooterID() != null) {
                efm.setAttribute("footerID", fm.getFooterID());
            }
            efm.setAttribute("version", Float.toString(version));
            if (fm.getUserObject() instanceof Element) {
                efm.addContent((Content)((Element)fm.getUserObject()).clone());
            }
            if (fm.getProperties().size() > 0) {
                Element eprops = new Element("Properties", KDFXmlReader.NS_FORM);
                efm.addContent((Content)eprops);
                for (Property prop : fm.getProperties()) {
                    Element eprop = new Element("Property", KDFXmlReader.NS_FORM);
                    eprop.setAttribute("name", prop.getName());
                    if (prop.getType() != null) {
                        eprop.setAttribute("type", prop.getType());
                    }
                    eprop.setText(prop.getFormat());
                    eprops.addContent((Content)eprop);
                }
            }
            if (fm.getLayers().size() > 0) {
                Element elays = new Element("Layers", KDFXmlReader.NS_FORM);
                efm.addContent((Content)elays);
                for (Layer lay : fm.getLayers()) {
                    if (lay.getId() == null) continue;
                    Element elay = new Element("Layer", KDFXmlReader.NS_FORM);
                    elay.setAttribute("id", lay.getId());
                    if (lay.getAlias() != null) {
                        elay.setAttribute("alias", lay.getAlias());
                    }
                    if (lay.getCategory() != null) {
                        elay.setAttribute("category", lay.getCategory());
                    }
                    if (lay.getStyleID() != null) {
                        elay.setAttribute("styleID", lay.getStyleID());
                    }
                    elays.addContent((Content)elay);
                }
            }
            for (Page pg : fm.getPages()) {
                Element epg = this.innerWriteToNode(pg);
                efm.addContent((Content)epg);
            }
            return efm;
        }
        return null;
    }

    private Element innerWriteToNode(Container cont) {
        String ss = cont.getClass().getName();
        int dot = ss.lastIndexOf(46);
        if (dot > -1) {
            ss = ss.substring(dot + 1);
        }
        Element ele = new Element(ss, KDFXmlReader.NS_FORM);
        if (cont.getId() != null) {
            ele.setAttribute("id", cont.getId());
        }
        if (cont.getUserAlias() != null) {
            ele.setAttribute("alias", cont.getUserAlias());
        }
        if (cont.getUserObject() instanceof Element) {
            ele.addContent((Content)((Element)cont.getUserObject()).clone());
        }
        if (!cont.getStyles().equals((Object)Styles.getEmptySSA()) && this.stsvs != null) {
            ele.setAttribute("styleID", this.stsvs.addStyleAttributes(cont.getStyles()));
        }
        if (cont.getLeft().getOriginString() != null) {
            ele.setAttribute("left", cont.getLeft().getOriginString());
        }
        if (cont.getRight().getOriginString() != null) {
            ele.setAttribute("right", cont.getRight().getOriginString());
        }
        if (cont.getTop().getOriginString() != null) {
            ele.setAttribute("top", cont.getTop().getOriginString());
        }
        if (cont.getBottom().getOriginString() != null) {
            ele.setAttribute("bottom", cont.getBottom().getOriginString());
        }
        if (cont.getLayer() != null) {
            ele.setAttribute("layerID", cont.getLayer());
        }
        if (cont.getVisibility().getOriginString() != null) {
            ele.setAttribute("visible", cont.getVisibility().getOriginString());
        }
        if (cont.getHoldPlace().getOriginString() != null) {
            ele.setAttribute("holdPlace", cont.getHoldPlace().getOriginString());
        }
        if (cont.getPreSteps() != null) {
            ele.setAttribute("preMacro", cont.getPreSteps());
        }
        if (cont.getPostSteps() != null) {
            ele.setAttribute("postMacro", cont.getPostSteps());
        }
        if (cont.getAnchor() != null) {
            ele.setAttribute("anchor", cont.getAnchor());
        }
        if (cont.getHint() != null) {
            ele.setAttribute("hint", cont.getHint());
        }
        if (cont.getPriority() != 0) {
            ele.setAttribute("priority", String.valueOf(cont.getPriority()));
        }
        if (cont.getProperties().size() > 0 || cont.getCustomStyles().size() > 0) {
            Element eprop;
            Element eprops = new Element("Properties", KDFXmlReader.NS_FORM);
            ele.addContent((Content)eprops);
            for (Property prop : cont.getProperties()) {
                eprop = new Element("Property", KDFXmlReader.NS_FORM);
                eprop.setAttribute("name", prop.getName());
                if (prop.getType() != null) {
                    eprop.setAttribute("type", prop.getType());
                }
                eprop.setText(prop.getFormat());
                eprops.addContent((Content)eprop);
            }
            for (Property prop : cont.getCustomStyles()) {
                eprop = new Element("Property", KDFXmlReader.NS_FORM);
                eprop.setAttribute("name", prop.getName());
                eprop.setAttribute("type", "style");
                eprop.setText(prop.getFormat());
                eprops.addContent((Content)eprop);
            }
        }
        if (cont instanceof Page) {
            if (((Page)cont).getRepeat() != 1) {
                ele.setAttribute("repeat", String.valueOf(((Page)cont).getRepeat()));
            }
            if (cont.group().getDataSource() != null) {
                ele.setAttribute("dataSourceID", cont.group().getDataSource());
            }
            if (cont.group().getField() != null) {
                ele.setAttribute("groupField", cont.group().getField());
            }
        } else if (cont instanceof Area) {
            Area ara = (Area)cont;
            if (ara.getMinLoopCount() != 0) {
                ele.setAttribute("minLoopCount", String.valueOf(ara.getMinLoopCount()));
            }
            if (ara.getMaxLoopCount() != -1) {
                ele.setAttribute("maxLoopCount", String.valueOf(ara.getMaxLoopCount()));
            }
            if (ara.getVerticalSpacing() != null && !ara.getVerticalSpacing().equals("0")) {
                ele.setAttribute("verticalSpacing", ara.getVerticalSpacing());
            }
            if (ara.getHorizontalSpacing() != null && !ara.getHorizontalSpacing().equals("0")) {
                ele.setAttribute("horizontalSpacing", ara.getHorizontalSpacing());
            }
            if (ara.getNext() != null) {
                ele.setAttribute("nextAreaID", ara.getNext().getFullName());
            }
        } else if (cont instanceof Panel) {
            if (cont.group().getDataSource() != null) {
                ele.setAttribute("dataSourceID", cont.group().getDataSource());
            }
            if (cont.group().getField() != null) {
                ele.setAttribute("groupField", cont.group().getField());
            }
        } else {
            if (cont instanceof Table) {
                Table tab;
                if (cont.group().getDataSource() != null) {
                    ele.setAttribute("dataSourceID", cont.group().getDataSource());
                }
                if (cont.group().getField() != null) {
                    ele.setAttribute("groupField", cont.group().getField());
                }
                if ((tab = (Table)cont).getLayoutMode() != 0) {
                    ele.setAttribute("layout", String.valueOf(tab.getLayoutMode()));
                }
                Element rge = new Element("Rows", KDFXmlReader.NS_FORM);
                for (Row row : tab.getRows()) {
                    Element re = new Element("Row", KDFXmlReader.NS_FORM);
                    if (tab.getLayoutMode() != 0 && row.getHeight().getOriginString() != null) {
                        re.setAttribute("height", row.getHeight().getOriginString());
                    }
                    if (!row.getStyles().equals((Object)Styles.getEmptySSA()) && this.stsvs != null) {
                        re.setAttribute("styleID", this.stsvs.addStyleAttributes(row.getStyles()));
                    }
                    rge.addContent((Content)re);
                }
                ele.addContent((Content)rge);
                Element cge = new Element("Columns", KDFXmlReader.NS_FORM);
                for (Column col : tab.getCols()) {
                    Element ce = new Element("Column", KDFXmlReader.NS_FORM);
                    if (tab.getLayoutMode() != 0 && col.getWidth().getOriginString() != null) {
                        ce.setAttribute("width", col.getWidth().getOriginString());
                    }
                    if (!col.getStyles().equals((Object)Styles.getEmptySSA()) && this.stsvs != null) {
                        ce.setAttribute("styleID", this.stsvs.addStyleAttributes(col.getStyles()));
                    }
                    cge.addContent((Content)ce);
                }
                ele.addContent((Content)cge);
                Element be = new Element("Body", KDFXmlReader.NS_FORM);
                Iterator bitr = tab.iterator();
                while (bitr.hasNext()) {
                    Container tcont = (Container)bitr.next();
                    Element te = this.innerWriteToNode(tcont);
                    be.addContent((Content)te);
                }
                ele.addContent((Content)be);
                return ele;
            }
            if (cont instanceof Cell) {
                DivideCharacter dc;
                Cell cel = (Cell)cont;
                ele.setAttribute("type", cel.getType());
                if (cel.getClipContent() != null) {
                    ele.setAttribute("clip", cel.getClipContent());
                }
                if (cel.getDataFormat() != null && cel.getDataFormat().length() > 0) {
                    ele.setAttribute("format", cel.getDataFormat());
                }
                if (cel.getData() != null) {
                    Element de = new Element("Data", KDFXmlReader.NS_FORM);
                    if ("image".equals(cel.getData().getType())) {
                        byte[] imageData;
                        Element eps = ele.getChild("Properties", KDFXmlReader.NS_FORM);
                        if (eps != null) {
                            List epl = eps.getChildren("Property", KDFXmlReader.NS_FORM);
                            boolean fd = false;
                            for (Element ep : epl) {
                                if (!"contentType".equals(ep.getAttribute("name"))) continue;
                                ep.setText("embeddedImage");
                                fd = true;
                                break;
                            }
                            if (!fd) {
                                Element ep;
                                ep = new Element("Property", KDFXmlReader.NS_FORM);
                                ep.setAttribute("name", "contentType");
                                ep.setText("embeddedImage");
                                eps.addContent((Content)ep);
                            }
                        }
                        if ((imageData = (byte[])((Variant)cel.getData().getValue()).getValue()) != null) {
                            de.setAttribute("type", "embeddedImage");
                            de.setText(Base64.encodeBytes((byte[])imageData));
                        } else {
                            de.setAttribute("type", "embeddedImage");
                            de.setText(Base64.encodeBytes((byte[])ZEROBYTE));
                        }
                    } else if ("chart".equals(cel.getData().getType())) {
                        ChartData cd = (ChartData)((Variant)cel.getData().getValue()).getValue();
                        if (cd != null) {
                            de.setAttribute("type", "chart");
                            de.setText(cd.toString());
                        } else {
                            de.setAttribute("type", "string");
                            de.setText("");
                        }
                    } else {
                        de.setAttribute("type", cel.getData().getType());
                        de.setText(cel.getData().getFormat());
                    }
                    ele.addContent((Content)de);
                }
                if ((dc = cel.getDivideCharacter()) != null) {
                    DivideCharacter.save(ele, dc);
                }
            }
        }
        Iterator itr = cont.iterator();
        while (itr.hasNext()) {
            Container tcont = (Container)itr.next();
            Element el = this.innerWriteToNode(tcont);
            ele.addContent((Content)el);
        }
        return ele;
    }

    @Override
    public Object readFromNode(Element ele, KDF kdf) {
        BaseFormBuilder builder = new BaseFormBuilder();
        builder.setSnapMode(this.snapMode);
        builder.setDesignMode(this.designMode);
        return builder.createForm(kdf, ele);
    }

    public Container readFromNode(Element ele, RuntimeStyleService rss) {
        BaseFormBuilder builder = new BaseFormBuilder();
        builder.setSnapMode(this.snapMode);
        builder.setDesignMode(this.designMode);
        return builder.createContainer(rss, ele);
    }

    public void setSnapMode(boolean snapMode) {
        this.snapMode = snapMode;
    }

    public void setDesignMode(boolean designMode) {
        this.designMode = designMode;
    }
}

