/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.kdf.form;

import com.kingdee.bos.ctrl.kdf.form.Area;
import com.kingdee.bos.ctrl.kdf.form.BaseGroup;
import com.kingdee.bos.ctrl.kdf.form.Column;
import com.kingdee.bos.ctrl.kdf.form.ColumnCollection;
import com.kingdee.bos.ctrl.kdf.form.Container;
import com.kingdee.bos.ctrl.kdf.form.ContainerCollection;
import com.kingdee.bos.ctrl.kdf.form.Group;
import com.kingdee.bos.ctrl.kdf.form.NameHelper;
import com.kingdee.bos.ctrl.kdf.form.Row;
import com.kingdee.bos.ctrl.kdf.form.RowCollection;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.regex.Pattern;

public final class Table
extends Container {
    private static final long serialVersionUID = 5591083211495038589L;
    private ContainerCollection children;
    private BaseGroup bgrp = new BaseGroup();
    private ColumnCollection columns;
    private RowCollection rows;
    private int layoutMode = 0;
    public static final int LAYOUT_AUTO_MODE = 0;
    public static final int LAYOUT_FIXED_MODE = 1;

    public Table() {
        this.children = new ContainerCollection();
        this.columns = new ColumnCollection();
        this.rows = new RowCollection();
    }

    @Override
    public boolean addChild(Container child) {
        return this.children.add(child);
    }

    @Override
    public boolean deleteChild(Container child) {
        return this.children.remove(child);
    }

    @Override
    public Iterator iterator() {
        return this.children.iterator();
    }

    @Override
    public Group group() {
        return this.bgrp;
    }

    public ColumnCollection getCols() {
        return this.columns;
    }

    public void setCols(ColumnCollection cols) {
        this.columns = cols;
    }

    public RowCollection getRows() {
        return this.rows;
    }

    public void setRows(RowCollection rows) {
        this.rows = rows;
    }

    @Override
    public Container nextCopy() {
        Table tab = new Table();
        tab.setId(NameHelper.getUniqueName());
        tab.setUserAlias(this.getUserAlias());
        tab.setParent(this.getParent());
        tab.setAliasName(this.getAliasName());
        tab.setLayoutMode(this.getLayoutMode());
        tab.setLayer(this.getLayer());
        tab.setAnchor(this.getAnchor());
        tab.setHint(this.getHint());
        tab.setSource(this.getSource());
        tab.setStyles(this.getStyles());
        tab.copyCustomStyles(this.getCustomStyles());
        tab.copyProperties(this.getProperties());
        tab.setVisibility(this.getVisibility());
        tab.setHoldPlace(this.getHoldPlace());
        tab.setPreSteps(this.getPreSteps());
        tab.setPostSteps(this.getPostSteps());
        tab.copyOriginString(this);
        String spacing = this.parent != null && this.parent instanceof Area ? ((Area)this.parent).getVerticalSpacing() : "0";
        tab.getTop().setString("(" + this.getBottom().getString() + ")+(" + spacing + ")");
        tab.getBottom().setString(String.valueOf(2 * this.getBottom().getInteger() - this.getTop().getInteger()) + "+(" + spacing + ")");
        tab.setLeft(this.getLeft());
        tab.setRight(this.getRight());
        tab.group().copy(this.group());
        tab.children = this.children.copyTo(tab, false);
        tab.columns = this.columns.copy();
        tab.rows = this.rows.copy();
        return tab;
    }

    @Override
    public void restoreOriginString() {
        for (Row row : this.rows) {
            row.getHeight().setString(row.getHeight().getOriginString());
            row.getHeight().setInteger(0);
        }
        for (Column col : this.columns) {
            col.getWidth().setString(col.getWidth().getOriginString());
            col.getWidth().setInteger(0);
        }
        super.restoreOriginString();
    }

    @Override
    public Container copyTo(Container parent, boolean copyEdge) {
        Table tab = new Table();
        tab.setId(NameHelper.getUniqueName());
        tab.setUserAlias(this.getUserAlias());
        tab.setParent(parent);
        tab.setAliasName(this.getAliasName());
        tab.setLayoutMode(this.getLayoutMode());
        tab.setLayer(this.getLayer());
        tab.setAnchor(this.getAnchor());
        tab.setHint(this.getHint());
        tab.setSource(this.getSource());
        tab.setStyles(this.getStyles());
        tab.copyCustomStyles(this.getCustomStyles());
        tab.copyProperties(this.getProperties());
        tab.setVisibility(this.getVisibility());
        tab.setHoldPlace(this.getHoldPlace());
        tab.setPreSteps(this.getPreSteps());
        tab.setPostSteps(this.getPostSteps());
        if (copyEdge) {
            tab.setLeft(this.getLeft());
            tab.setRight(this.getRight());
            tab.setTop(this.getTop());
            tab.setBottom(this.getBottom());
        } else {
            tab.copyOriginString(this);
        }
        if (this.parent != null) {
            String oname = "(?:\\[\\s*)" + this.parent.getId() + "\\.";
            String nname = "[" + parent.getId() + ".";
            String oname2 = "(?:\\[\\s*)" + this.getId() + "\\.";
            String nname2 = "[" + tab.getId() + ".";
            Pattern p1 = Pattern.compile(oname);
            Pattern p2 = Pattern.compile(oname2);
            if (tab.getLeft().getString() != null) {
                tab.getLeft().setString(p1.matcher(tab.getLeft().getString()).replaceAll(nname));
                tab.getLeft().setString(p2.matcher(tab.getLeft().getString()).replaceAll(nname2));
            }
            if (tab.getRight().getString() != null) {
                tab.getRight().setString(p1.matcher(tab.getRight().getString()).replaceAll(nname));
                tab.getRight().setString(p2.matcher(tab.getRight().getString()).replaceAll(nname2));
            }
            if (tab.getTop().getString() != null) {
                tab.getTop().setString(p1.matcher(tab.getTop().getString()).replaceAll(nname));
                tab.getTop().setString(p2.matcher(tab.getTop().getString()).replaceAll(nname2));
            }
            if (tab.getBottom().getString() != null) {
                tab.getBottom().setString(p1.matcher(tab.getBottom().getString()).replaceAll(nname));
                tab.getBottom().setString(p2.matcher(tab.getBottom().getString()).replaceAll(nname2));
            }
        }
        tab.group().copy(this.group());
        tab.children = this.children.copyTo(tab, copyEdge);
        tab.columns = this.columns.copy();
        tab.rows = this.rows.copy();
        if (!copyEdge) {
            tab.syncOriginString();
        }
        return tab;
    }

    @Override
    public Container copy(boolean copyEdge) {
        Table tab = (Table)this.copyTo(this.parent, copyEdge);
        return tab;
    }

    public int getLayoutMode() {
        return this.layoutMode;
    }

    public void setLayoutMode(int i) {
        this.layoutMode = i;
    }

    @Override
    protected ArrayList innerList() {
        return this.children.innerList();
    }

    @Override
    public String toString() {
        return "Table  " + super.toString();
    }
}

