/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.kdf.form2.ui;

import com.kingdee.bos.ctrl.common.LanguageManager;
import com.kingdee.bos.ctrl.common.util.CommonLogger;
import com.kingdee.bos.ctrl.common.util.CtrlClassUtil;
import com.kingdee.bos.ctrl.kdf.form2.ui.INotePrintHelper;
import com.kingdee.bos.ctrl.print.IConfigChangeListener;
import com.kingdee.bos.ctrl.print.KDPrinter;
import com.kingdee.bos.ctrl.print.config.ui.PageSetupUIForForm;
import com.kingdee.bos.ctrl.print.io.IOManager;
import com.kingdee.bos.ctrl.print.preview.ButtonItem;
import com.kingdee.bos.ctrl.print.preview.PreviewBody;
import com.kingdee.bos.ctrl.print.preview.event.ButtonItemEvent;
import com.kingdee.bos.ctrl.print.preview.event.ButtonItemListener;
import com.kingdee.bos.ctrl.print.resource.Resources;
import com.kingdee.bos.ctrl.print.ui.IPaintFilter;
import com.kingdee.bos.ctrl.print.util.KDPrintUtil;
import com.kingdee.bos.ctrl.swing.KDFileChooser;
import com.kingdee.bos.ctrl.swing.KDToggleButton;
import com.kingdee.bos.ctrl.swing.KDWorkButton;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.KeyStroke;
import org.apache.log4j.Logger;

public class NotePrinter {
    private Logger logger = CommonLogger.getLogger(NotePrinter.class);
    private KDPrinter ctrlPrint;
    private INotePrintHelper.StateListener noteStateListener;
    private ButtonItem biBackground;
    private KDToggleButton btnBackground;
    private ButtonItem exportExcel;
    private KDWorkButton btnExportExcel;
    private IConfigChangeListener configChangeListener;
    private boolean _isR1Preview;

    public KDPrinter getPrinter() {
        if (this.ctrlPrint == null) {
            this.ctrlPrint = new KDPrinter();
            HiddenLayerFilter filter = new HiddenLayerFilter();
            filter.setApply(true);
            filter.setPreviewApply(false);
            this.ctrlPrint.setPaintFilter((IPaintFilter)filter);
            ButtonItem bi = this.getButtonItemBackground();
            HideBackgroundListener listener = new HideBackgroundListener(bi, this.ctrlPrint);
            this.ctrlPrint.getPrintPreview().getPreviewBar().addButtonItem(bi, 3);
            this.ctrlPrint.getPrintPreview().getPreviewBar().addButtonItemListener((ButtonItemListener)listener);
            this.ctrlPrint.unRegisterConfigUI(Resources.getMsg((String)"tree.page"));
            this.ctrlPrint.registerConfigUI(Resources.getMsg((String)"tree.page"), PageSetupUIForForm.class, 0);
            final AbstractAction exportExcelAction = new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (!NotePrinter.this.checkR1Preview()) {
                        return;
                    }
                    KDFileChooser chooser = new KDFileChooser();
                    PreviewBody r1xlsparent = NotePrinter.this.ctrlPrint.getPrintPreview().getPreviewBody();
                    int result = chooser.showSaveDialog((Component)r1xlsparent);
                    if (result == 0) {
                        File file = chooser.getSelectedFile();
                        new IOManager(NotePrinter.this.getPrinter()).exportToXls2(file.getAbsolutePath(), (Component)r1xlsparent);
                    }
                }
            };
            boolean isShow = KDPrintUtil.isShowExcelButton();
            if (isShow) {
                this.getBtnExportExcel().addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        exportExcelAction.actionPerformed(e);
                    }
                });
                ButtonItem exportExcel = this.getExportExcel();
                this.ctrlPrint.getPrintPreview().getPreviewBar().addButtonItem(exportExcel, 3);
            }
            KeyStroke keyStroke = KeyStroke.getKeyStroke(69, 640);
            this.addKeyboardEvent(keyStroke, exportExcelAction);
        }
        return this.ctrlPrint;
    }

    public void addKeyboardEvent(KeyStroke ks, Action ac) {
        PreviewBody pb = this.getPrinter().getPrintPreview().getPreviewBody();
        InputMap inputMap = pb.getInputMap(2);
        inputMap.put(ks, ks);
        pb.getActionMap().put(ks, ac);
    }

    public void setCongifChangeListener(IConfigChangeListener ccl) {
        if (ccl != null && ccl != this.configChangeListener) {
            if (this.configChangeListener != null) {
                this.getPrinter().removeConfigChangeListener(this.configChangeListener);
            }
            this.getPrinter().addConfigChangeListener(ccl);
            this.configChangeListener = ccl;
        }
    }

    public INotePrintHelper.StateListener getNoteStateListener() {
        if (this.noteStateListener == null) {
            this.noteStateListener = new NoteStateListener();
        }
        return this.noteStateListener;
    }

    private void setButtonBackgroundVisible(boolean isVisible) {
        this.getButtonItemBackground().setVisible(isVisible);
    }

    private void setButtonBackgroundSelected(boolean isSelected) {
        this.getBtnBackground().setSelected(isSelected);
    }

    private ButtonItem getButtonItemBackground() {
        if (this.biBackground == null) {
            this.biBackground = new ButtonItem((JComponent)this.getBtnBackground(), 100);
        }
        return this.biBackground;
    }

    private ButtonItem getExportExcel() {
        if (this.exportExcel == null) {
            this.exportExcel = new ButtonItem((JComponent)this.getBtnExportExcel(), 100);
        }
        return this.exportExcel;
    }

    private KDToggleButton getBtnBackground() {
        if (this.btnBackground == null) {
            this.btnBackground = new KDToggleButton(NotePrinter.getMLS("showBackground", "\u663e\u793a\u80cc\u666f"));
            this.btnBackground.setToolTipText(NotePrinter.getMLS("backgroundTooltip", "\u80cc\u666f\u56fe\u7247\u53ea\u9884\u89c8\uff0c\u4e0d\u6253\u5370\u3002"));
        }
        return this.btnBackground;
    }

    private KDWorkButton getBtnExportExcel() {
        if (this.btnExportExcel == null) {
            this.btnExportExcel = new KDWorkButton(NotePrinter.getMLS("exportExcel", "\u5bfc\u51faExcel"));
            this.btnExportExcel.setToolTipText(NotePrinter.getMLS("exportExcelTooltip", "\u5c06\u5957\u6253\u7ed3\u679c\u5bfc\u51fa\u5230Excel\u3002"));
        }
        return this.btnExportExcel;
    }

    public void setExportXlsPermission(boolean canExport) {
        this._isR1Preview = canExport;
    }

    private boolean checkR1Preview() {
        return this._isR1Preview;
    }

    private static String getMLS(String key, String defaultValue) {
        String res = CtrlClassUtil.getPackageName(NotePrinter.class) + ".ui";
        return LanguageManager.getLangMessage((String)key, (String)res, (String)defaultValue);
    }

    private class NoteStateListener
    implements INotePrintHelper.StateListener {
        private NoteStateListener() {
        }

        @Override
        public void notifyState(int key, Object value) {
            if (key == 1) {
                NotePrinter.this.setButtonBackgroundVisible((Boolean)value);
            } else if (key == 2) {
                NotePrinter.this.setButtonBackgroundSelected((Boolean)value);
            }
        }
    }

    private static class HideBackgroundListener
    implements ButtonItemListener {
        private ButtonItem targetItem;
        private KDPrinter printer;

        public HideBackgroundListener(ButtonItem bi, KDPrinter prt) {
            this.targetItem = bi;
            this.printer = prt;
        }

        public void handleButtonItem(ButtonItemEvent event) {
            IPaintFilter filter;
            if (event.getButtonItem() == this.targetItem && (filter = this.printer.getPaintFilter()) instanceof HiddenLayerFilter) {
                HiddenLayerFilter hlf;
                hlf.setPreviewApply(!(hlf = (HiddenLayerFilter)filter).isPreviewApply());
            }
            this.printer.getPrintPreview().getPreviewBody().repaint();
        }
    }

    private static class HiddenLayerFilter
    implements IPaintFilter {
        private boolean isApply = true;
        private boolean isPreviewApply;

        private HiddenLayerFilter() {
        }

        public boolean accept(Integer layer, boolean isPreviewing) {
            if (layer == 1) {
                if (isPreviewing) {
                    return !this.isPreviewApply();
                }
                return false;
            }
            return true;
        }

        public void setApply(boolean isApply) {
            this.isApply = isApply;
        }

        public boolean isApply() {
            return this.isApply;
        }

        public boolean isPreviewApply() {
            return this.isPreviewApply;
        }

        public void setPreviewApply(boolean isPreviewApply) {
            this.isPreviewApply = isPreviewApply;
        }
    }
}

