/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.kdf.formbrowser2.actions;

import com.kingdee.bos.ctrl.common.ui.WindowUtil;
import com.kingdee.bos.ctrl.common.util.LogUtil;
import com.kingdee.bos.ctrl.kdf.formbrowser2.actions.BrowserInitializableAction;
import com.kingdee.bos.ctrl.kdf.formbrowser2.clientcore.ClientCore;
import com.kingdee.bos.ctrl.kdf.formbrowser2.clientcore.ContextOfBrowser;
import com.kingdee.bos.ctrl.kdf.formbrowser2.clientcore.UIDelegate;
import com.kingdee.bos.ctrl.kdf.formbrowser2.resources.Resources;
import com.kingdee.bos.ctrl.kdf.printprovider.PrintCompContainer;
import com.kingdee.bos.ctrl.kdf.printprovider.actions.CompositableAction;
import com.kingdee.bos.ctrl.kdf.printprovider.util.ExtensionFilter;
import com.kingdee.bos.ctrl.kdf.util.CloseUtil;
import com.kingdee.bos.ctrl.kdf.util.KDRFile2KDFObj;
import com.kingdee.bos.ctrl.kdf.util.NDFFile2KDFObj;
import com.kingdee.bos.ctrl.kdf.util.file.KDF;
import com.kingdee.bos.ctrl.swing.KDFileChooser;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.util.Locale;
import javax.swing.AbstractAction;
import javax.swing.filechooser.FileFilter;
import org.apache.log4j.Logger;

public class OpenKDFAction
extends AbstractAction
implements CompositableAction,
BrowserInitializableAction {
    private static final long serialVersionUID = -4582875247939949745L;
    private static Logger logger = LogUtil.getPackageLogger(OpenKDFAction.class);
    private transient UIDelegate uidelegate;
    private transient ContextOfBrowser context;
    private transient ClientCore clientCore;

    public OpenKDFAction() {
        this.putValue("Name", Resources.theRes.getString("action.openfile.name"));
        this.putValue("ShortDescription", Resources.theRes.getString("action.openfile.description"));
        this.putValue("MnemonicKey", Resources.theRes.getObject("action.openfile.mnemonic"));
        this.putValue("ICON24", Resources.theRes.getObject("action.openfile.icon"));
        this.putValue("DEFAULT_ENABLE", true);
        this.putValue("ENABLE_UNTIL_DATACOMPLETED", true);
    }

    @Override
    public void setClientCore(ClientCore clientCore) {
        this.context = clientCore.getContextOfBrowser();
        this.uidelegate = clientCore.getUiDelegate();
        this.clientCore = clientCore;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void actionPerformed(ActionEvent event) {
        try {
            String path = this.getOpenPath();
            if (path == null) return;
            logger.info((Object)("open " + path + " ..."));
            if (path.toUpperCase(Locale.CHINA).endsWith(".NDF")) {
                NDFFile2KDFObj ndf2kdf = new NDFFile2KDFObj(path);
                ndf2kdf.setDEBUG(true);
                ndf2kdf.translate();
                KDF kdf = ndf2kdf.getKdf();
                this.context.closeDocument();
                this.clientCore.getFormPageRetriver().clear();
                ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
                kdf.save(outputStream);
                this.clientCore.getFormPageRetriver().RequestRawPagesAsync(new ByteArrayInputStream(outputStream.toByteArray()));
                return;
            }
            if (path.toUpperCase(Locale.CHINA).endsWith(".KDR")) {
                KDRFile2KDFObj kdr2kdf = new KDRFile2KDFObj(path);
                kdr2kdf.translate();
                KDF kdf = kdr2kdf.getKdf();
                this.context.closeDocument();
                this.clientCore.getFormPageRetriver().clear();
                ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
                kdf.save(outputStream);
                this.clientCore.getFormPageRetriver().RequestRawPagesAsync(new ByteArrayInputStream(outputStream.toByteArray()));
                return;
            }
            this.context.closeDocument();
            this.clientCore.getFormPageRetriver().clear();
            FileInputStream is = null;
            try {
                is = new FileInputStream(path);
                this.clientCore.getFormPageRetriver().RequestRawPagesAsync(is);
            }
            catch (Throwable throwable) {
                CloseUtil.close((Closeable[])new Closeable[]{is});
                throw throwable;
            }
            CloseUtil.close((Closeable[])new Closeable[]{is});
            return;
        }
        catch (FileNotFoundException e) {
            logger.error((Object)"Exception occurred.", (Throwable)e);
            WindowUtil.msgboxInfo((Object)"\u6587\u4ef6\u4e0d\u5b58\u5728", (String)"\u8868\u5355\u6d4f\u89c8", null);
        }
    }

    private String getOpenPath() {
        String subfix = ".kdf";
        String[] filter = new String[]{Resources.LOCAL_STR("kdf-file-filter", "KDF (*.kdf)"), Resources.LOCAL_STR("ndf-file-filter", "NDF (*.ndf)"), Resources.LOCAL_STR("kdr-file-filter", "KDR (*.kdr)")};
        KDFileChooser chooser = new KDFileChooser();
        chooser.setDialogTitle(Resources.LOCAL_STR("open-file-name", "Open File"));
        FileFilter[] filters = new FileFilter[]{new ExtensionFilter(filter[0], new String[]{subfix, ".KDF"}), new ExtensionFilter(filter[1], new String[]{".ndf", ".NDF"}), new ExtensionFilter(filter[2], new String[]{".kdr", ".KDR"})};
        chooser.setFileFilter(filters[0]);
        chooser.setFileFilter(filters[1]);
        chooser.setFileFilter(filters[2]);
        chooser.setFileFilter(filters[0]);
        Component comp = this.uidelegate.getBaseComponent();
        if (comp == null) {
            return null;
        }
        if (this.clientCore.getLastDir() != null) {
            chooser.setCurrentDirectory(new File(this.clientCore.getLastDir()));
        }
        chooser.showOpenDialog(comp);
        File selectedFile = chooser.getSelectedFile();
        if (selectedFile != null) {
            this.clientCore.setLastDir(chooser.getCurrentDirectory().getPath());
            String path = selectedFile.getPath();
            if (path != null) {
                if (path.toUpperCase(Locale.CHINA).endsWith(".NDF") || path.toUpperCase(Locale.CHINA).endsWith(".KDR")) {
                    return path;
                }
                char[] last4 = new char[4];
                path.getChars(path.length() - 4, path.length(), last4, 0);
                if (!subfix.equalsIgnoreCase(new String(last4))) {
                    path = path + subfix;
                }
                return path;
            }
        }
        return null;
    }

    @Override
    public void setCompContainer(PrintCompContainer container) {
    }
}

